/*
 * Header file for SunOS 4.0 streams SLIP module
 *
 * Copyright 1988 by Rayan Zachariassen
 *
 * You may do anything with this file except put your own
 * copyright on it or change or remove this copyright notice.
 */
/*
 * Copyright (c) 1992 Purdue University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Purdue University.  The name of the University may not be used
 * to endorse or promote products derived * from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Note: this copyright applies to portions of this software developed
 * at Purdue beyond the software covered by the original copyright.
 */

#ifndef	_sys_slip_h
#define	_sys_slip_h

/*
 * To compensate for lack of M_HANGUP on dialout lines, we use M_UNHANGUP
 * as symptom of a possible carrier change, and generate a signal whenever
 * an M_UNHANGUP passes by so the application can check for DCD.  This is
 * a workaround that should go away when M_HANGUP is generated on dialouts.
 */

#include <sys/signal.h>

/* signal to send application on stream device non-hangup DCD change */
#define	SIGDCD		SIGUSR1


#define	SLIPIFNAME	"slip"		/* base name of network interface */

#define	SLIOGUNIT	_IOR(t, 62, int)		/* get SLIP unit no. */
#define	SLIOGSTATS	_IOR(t, 63, struct slipstat)	/* get statistics */
#define	SLIOSFLAGS	_IOW(t, 64, int)		/* set flags */

struct slipstat {
	u_int		sl_ibytes;	/* total number of data bytes in */
	u_int		sl_ipackets;	/* total number of data packets in */
	u_int		sl_ierrors;	/* total number of input errors */
	u_int		sl_obytes;	/* total number of data bytes out */
	u_int		sl_opackets;	/* total number of data packets out */
	u_int		sl_oerrors;	/* total number of output errors */
};

/* end of what the user-level process should care about */

/* See RFC1055 for the origin of the following magic numbers */

#define SLIPMAX		1006	/* this is the largest packet we'll accept */
#define SLIPMTU		552	/* this is the largest packet we'll send
				 * (the IP-level MTU) */

#define	END	0300		/* a frame just finished */
#define	ESC	0333		/* introduces an escape sequence */
#define	ESC_END	0334		/* the data contained an END */
#define	ESC_ESC	0335		/* the data contained an ESC */

#endif	/* !_sys_slip_h */
