/* Sample NEWSCLIP program that shows what you can do */

/* Please folks, this is not the newsclip program that I use, and I
   don't advocate all the different filtering things here.  I am
   just using them as examples of how to do certain things net people
   have suggested they wanted done. */

	/* You can include pre-defined header lines */
	extern userid From;			/* the From: line */
	extern newsgroup array newsgroups;	/* the Newsgroups: line */
	extern int distribution_level;		/* max distr of article */
	extern string array references;		/* parent articles */
	extern string Subject;			/* subject line */
	extern int followup;			/* is it a followup? */
	extern int lines;			/* header variable */
	/* or define your own header lines */
	header string mess_id : "message-id";
	/* declare variables */
	int counter;
	/* some databases I will look things up in */
	database badmessages;			/* message-ids I don't want
						to see followsup to */
	database hated_users;			/* users I don't want to
						   see articles from */
	database my_articles;			/* message-ids that I
						want to see ALL followups to */
	/* declare external C functions from the Newsclip library or your
	   own C libraries */
	extern int strlen( string );

	/* you can define procedures and functions */

int
nice_group( newsgroup n )
{
	extern string left( string, int );
	/* you like all sci newsgroups and rec.humor.funny */
	return n == #rec.humor.funny || left(n,1) == "sci";
}

procedure
INIT() {
	extern procedure set_include_prefix(string);
	/* this code gets run when the program starts */
	set_include_prefix( "[:>]" );
	hated_users = read_database( "~./hatedusers" );
	my_articles = read_database( "~./myarticles" );
}

procedure
STARTGROUP() {
	/* This gets called when we begin to scan a new newsgroup */
	/* read in the database of bad message-ids for this group */
	badmessages = read_database( "~./kill/~n/killdb" );
}

procedure
ENDGROUP() {
	/* this gets called to end the newsgroup */
	extern datetime time_now;

	/* write out the bad message database, delete all entries that
	  are older than one month */
	write_database( badmessages, "~./kill/~n/killdb", time_now - month );
	free_database( badmessages );
}

	/* here is the main part.  The code that is executed for every
	   article to accept or reject it */

procedure
ARTICLE() {
	newsgroup n;
	extern string domain( string );
	extern string right( string, int );
	extern int dlevel( newsgroup );
	extern string my_domain;
	extern string my_mail_address;
	
	/* show me everything written by people at my own site */
	if( domain(From) == my_domain ) {
		/* Note my own articles in a database of good ones */
		if( From == my_mail_address )
			my_articles[mess_id] = true;
		accept;
		}
	 else if( domain(From) == "hated.domain.com" )
		reject;		/* never show me anything from THAT site */
	/* also show me anything posted only for citywide distribution */
	accept if distribution_level <= dlevel(#city);

	reject if count(newsgroups) > 6;	/* I hate crossposting */

	/* See if it's a followup to one of MY messages */
	accept if References in my_articles;

	/* See if any of the messages this is a followup of are in
	   our database of bad messages.  If so, reject it */
	reject if References in badmessages;

	/* and of course, kill the bad guys */
	reject if From in hated_users;

	/* Now do the newsgroup specific code */
	for( n in newsgroups ) switch( n ) {
		case #rec.humor:
			/* adjust the score of messages that are crossposted
				to groups you don't like */
			if( is talk.bizzare || is alt.flame )
				adjust -10;
			/* but I like local humour */
			accept if distribution_level <= dlevel(#country);
			break;

		case #news.groups:
			/* If you really don't like a user in a group,
			   arrange to store the message id of every
			   message he posts in your bad message database.
			   You won't even see the followups, and it
			   will be as though he didn't exist on the net. */
			if( From == "karl@ddsw1.mcs.com" ) {
				badmessages[mess_id] = true;
				reject;
				}
			break;
		case #sci.physics:
			/* I only want to see messages that are crossposted
			   to both sci.physics AND sci.astro, not just one
			   of them */
			reject if !is sci.astro;
			break;
		case #rec.arts.comics:
			/* I only want articles that mention watchmen in
				the subject */
			if( subject has "watchmen" )
				accept;
			 else
				reject;
		case #news.admin:
			/* bump the score of any article that mentions
			   my name */
			if( text has "brad.*templeton" || subject has "brad" )
				adjust 1000;
			break;
		case #talk.politics.misc:
			/* I hate long rebuttals.  If the article is mostly
			   lines that are included from another, then can it */
			if( followup && lines / (1+line_count(included)) < 2 )
				reject;
			/* I hate long signatures on short articles! */
			if( lines < 25 && line_count(signature) > 7 )
				reject;
			break;
		case #talk.politics.theory:
			/* search for libertarian only in non-included text */
			if( newtext has "libertarian" || newtext has "ncp" )
				accept;
			 else
				reject;
		case #comp.risks:
		case #rec.arts.sf-lovers:
			/* my favourite groups */
			adjust 20;
			break;
		default:
			if( nice_group(n) )
				adjust 15;
			break;
		
		}
	if( is alt.flame )
		adjust -5;		/* I would rather not see these */
	/* default is a score of 1, which means accept */
	/* here at the end, we accept if the score is greater than 0, or
	   if there was an explicit accept, of course */

}


procedure
TERMINATE() {
	extern datetime time_now;
	/* The program is done.  Write out global databases */
	write_database( my_articles, "~./my_articles", time_now - 3 * week );
}

