

#include "nl.h"

/* The main entry point of the user's newsclip program. */
 /*
  * Newsclip(TM) Library Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip library for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed.
  * Use of this code for a short term evaluation of the product, as defined
  * in the associated file, 'Licence', is permitted.
  */


/* Some useful variables */
#include <sys/timeb.h>


char *uopts[MAX_OPTS];			/* command line options for user prog */
int opt_count = 0;			/* number of such options */

int io_mode = MODE_NONE;		/* article list source */
bool list_always = FALSE;		/* always list articles to stdout */
bool out_newsrc = FALSE;		/* do we write out a .newsrc file? */
bool cnews_listing = TRUE;		/* add size to file list for C news */
bool only_las = FALSE;			/* only do groups in .las file */
bool allow_unsub = FALSE;		/* allow unsubscribed groups */
bool newsrc_allread = FALSE;		/* mark .newsrc as entirely read */
bool rnlock_present = FALSE;		/* is a .rnlock file there? */
bool do_debug = FALSE;			/* various debugging flags */
char *proc_mode = 0;			/* processing mode name */

#ifndef PAID			/* do not define until copy is registered */
static datehold fct =
#include "cdate.h"
;
#endif

main( argc, argv )
int argc;	/* If you don't know what these are, why are you reading */
char **argv;	/* C source code?   Ok, they're the argument vector & count*/
{
	int argnum;			/* arg scan loop control variable */
	char *strchr();
	extern long time();		/* no C */
	extern char *my_mail_address;	/* user's From: line address */
	extern char *newsrcname;	/* location of .newsrc file */
	extern char *lasname;		/* name of last art seen file */
	extern bool normal_newsrc;	/* default .newsrc file? */
	extern bool needs_stat;		/* needs to do fstat on article */
	extern char *news_spool_dir;	/* to set different spool dir */
	extern char *news_lib_dir;	/* and library dir */
	extern char *dotdir;
	extern int warning_level;	/* what warnings to give */

	for( argnum = 1; argnum < argc; argnum++ ) {
		char *argline;		/* whole argument */
		char *argstr;		/* argument string */
		int argval;		/* for decimal options */
		int isplus;		/* boolean tells +arg vs -arg */

		argline = argv[argnum];

		if (argstr = strchr(argline, '=')) {
			argstr++;
			argval = atoi(argstr);
			switch( argline[0] ) {
				case 'm':
					switch( argstr[0] ) {
						case 'n':
							/* newsrc to newsrc */
							io_mode = MODE_NEWSRC;
							out_newsrc = TRUE;
							list_always = FALSE;
							newsrc_allread = FALSE;
							proc_mode = "newsrc";
							/* debug */
							break;
						case 'f':
							/* list to list */
							io_mode = MODE_FLIST;
							proc_mode = "filter";
							break;
						case 'p':
							io_mode = MODE_PIPE;
							proc_mode = "pipe";
							break;
						case 'b':
							/* newsrc to both */
							io_mode = MODE_NEWSRC;
							out_newsrc = TRUE;
							newsrc_allread = TRUE;
							list_always = TRUE;
							proc_mode = "batch";
							break;
						case 'l':
							/* newsrc to list */
							io_mode = MODE_NEWSRC;
							out_newsrc = FALSE;
							list_always = TRUE;
							newsrc_allread = FALSE;
							proc_mode = "list";
							break;
						case 'd': /* debug rc output*/
							io_mode = MODE_NEWSRC;
							out_newsrc = TRUE;
							list_always = TRUE;
							newsrc_allread = FALSE;
							proc_mode = "debug";
							break;
						default:
							error( "Unknown mode %s\n", argstr );
							break;
							}
					break;
				case 'o':	/* option for program */
					if( opt_count < MAX_OPTS )
						uopts[opt_count++] = argstr;
					 else
						error( "Too many user options\n");
					break;
				case 'd':
					dotdir = argstr;
					break;
				case 'n':
					newsrcname = argstr;
					break;
				case 'l':
					lasname = argstr;
					break;
				case 'L':
					news_lib_dir = argstr;
					break;
				case 'S':
					news_spool_dir = argstr;
					break;
				case 'w':
					warning_level = argval;
					break;
				default:
					error( "Bad Option %s\n", argline );
				}
			}
		else if( (isplus = argline[0] == '+') || argline[0] == '-' ) {
			switch( argline[1] ) {
				case 'o':
					only_las = isplus;
					break;
				case 'u':
					allow_unsub = isplus;
					break;
				case 'd':
					do_debug = isplus;
					break;
				case 'c':
					cnews_listing = isplus;
					needs_stat |= isplus;
					break;
				default:
					error( "Bad Option %s\n", argline );
				}
			}
		else {
			/* code for untagged option */
			;
			}
		}
	if( io_mode == MODE_NONE ) {
		fprintf( stderr, "NewsClip News Filtering Program, V1.01:\n" );
#ifndef PAID
		fprintf( stderr, "\t\t***   EVALUATION COPY  ***\n\n" );
#endif
		fprintf( stderr, "\tLibrary Copyright (c) 1989 Looking Glass Software Limited.\n\n" );
		fprintf( stderr, "Usage: %s mode=<mode> [options]\n", argv[0] );
		fprintf( stderr, "You must specify a mode of operation.  To work on your .newsrc, use:\n" );
		fprintf( stderr, "\t%s mode=newsrc\n", argv[0] );
		fprintf( stderr, "For other options see the manual page for 'nclip' or your manual.\n" );
		exit(1);
		}

	/* record the time of day */
	init_time();
#ifndef PAID			/* do not define until copy is registered */
	checkpaid();
#endif
	init_whoami();
	lowercase( my_mail_address );
	/* what about full name? */

	/* if we plan to write out the newsrc, make sure rn isn't using it */
	if( io_mode == MODE_NEWSRC && out_newsrc && normal_newsrc )
		do_rnlock();

	/* build the user 'options' array */

	prep_uopts();

	/* compile regular expressions */

	init_patterns();

	/* initialize temporary memory allocator */

	init_tempalloc();

	switch( io_mode ) {
		case MODE_FLIST:
			do_file_list();
			break;
		case MODE_NEWSRC:
			process_newsrc();
			break;
		case MODE_PIPE:
			pipe_loop();
			break;
		}
	wrapup();
	exit(0);
}

/* Issue an error message, do any wrapup, and abort */

error( form, a, b, c, d, e, f, g, h )
char *form;
{
	fprintf( stderr, form, a,b,c,d,e,f,g,h );
	wrapup();
	exit(1);
}

/* do any wrapup needed before terminating */

wrapup()
{
	if( rnlock_present ) {
		chdir( dotdir );
		unlink( ".rnlock" );
		rnlock_present = FALSE;
		}
}


#include <signal.h>

/*
 * Check for a .rnlock file, and create one if not present
 *
 * RN stops two 'rn' processes from going at the same .newsrc by placing
 * the .rnlock file in the "dot" directory while it is running.  This file
 * has the process id of the newsreader, so that if another program finds
 * the file, it can check (via a pre-arranged signal) if that other
 * newsreader is still running, or has died.
 */

do_rnlock()
{
	FILE *rnlock;			/* descriptor for rnlock locking file */
	extern char *dotdir;
	int pid;			/* process id of other newsreader */
	int scanres;

	rnlock = dfopen( dotdir, ".rnlock", "r" );
	if( rnlock ) {
		scanres = fscanf( rnlock, "%d", &pid );
		fprintf( stderr, "A news reader is/was running, process %d\n", pid );
		if( scanres != 1 || kill( pid, SIGEMT ) ) 
			fprintf( stderr, "But it died, so we will proceed.\n" );
		else
			error( "You can't run this program in 'newsrc' mode while another program is\nusing that file." );
		fclose( rnlock );
		}
	rnlock = dfopen( dotdir, ".rnlock", "w" );
	if( !rnlock )
		error( "Could not create .rnlock file.\n" );
	rnlock_present = TRUE;
	fprintf( rnlock, "%d\n", getpid() );
	fclose( rnlock );
	/* set up to ignore that signal so we can be tested */
	signal( SIGEMT, SIG_IGN );
}

#ifndef PAID			/* do not define until copy is registered */
	/* This program is EVALU-Ware.  That means that you get to try
	   out this full working copy for a couple of weeks.  After that
	   you must decide to either pay for a licence or stop using the
	   program.   This code reminds you of this.   Nothing but your
	   own honesty (and copyright law) stops you from removing this code.

	   Please do not remove this code unless you have actually paid for
	   a registration.  You can send a P.O. or pay by major credit card
	   by phoning 519-884-7473, or in some areas, 800-265-2782.  See the
	   file 'licence' for full details.   Many of you will be tempted
	   to remove this code, saying, "I'll get around to paying eventually."

	   Our experience shows that even highly honest people who say this
	   often don't pay.  Not through dishonesty, but lack of time.  This
	   filtering language can save you a lot of valuable time when reading
	   news, and a lot of money and/or bandwidth if you filter news sent
	   over network connections or long distance phone lines.  As such,
	   we have set what we believe to be a fair price for ongoing use of
	   this system.  Thank you for respecting that wish.
	 */

checkpaid()
{
	extern datehold time_now;	
	if( time_now - fct > 3600L*24*23 ) {
		fprintf( stderr, "You are using an evaluation copy of the NewsClip language.\n\n" );
		fprintf( stderr, "We would like to remind you that the 20 day evaluation period is now over.\n" );
		fprintf( stderr, "If you wish to continue using this system, you should purchase a licence.\n" );
		fprintf( stderr, "You may phone 519-884-7473 to do so, or mail to 'newsclip@clarinet.com'" );
		fprintf( stderr, "for more details.   Major credit cards and P.O.s are accpted.\n" );
		fprintf( stderr, "See the file 'Licence' in the NewsClip source distribution for full\n" );
		fprintf( stderr, "information.\n" );

		if( time_now - fct > 3600L*24*31 )
			fprintf( stderr, "\nYour evaluation period is now long over.  Please register.\n" );
		}
}

#endif
/* prepare user options */


array *options;

/* prepare the 'options' variable for the user program */

prep_uopts()
{
	int i;

	options = (array*)perm_alloc(sizeof(array)+(opt_count-1)*sizeof(datau));
	options->arsize = opt_count;
	options->artype = T_STRING;
	/* copy in each option */
	for( i = 0; i < opt_count; i++ )
		options->vals[i].ustring = uopts[i];
}

