.nr Ej 1
.nr Hb 4
.nr Hs 3
.ds HP +4 +2 +1 +0 +0 +0 +0
.de xd
.sp 1V
.br
\\$1 \s+2\fB\\$2\fP\s-2
.sp 0.7V
..
.de Bb
.sp 0.5V
.in 0.4in
.nf
..
.de Be
.sp 0.5V
.in -0.4in
.fi
..
.de St
.sp 0.8V
.in 0.4in
\\$1
.in -0.4in
.sp 0.8V
..
.HM A



.H 1 "Statement Reference"
.P
A NewsClip program consists of a list of declarations, functions
and procedures.

.H 2 "Lexical Structure"
.P
Lexical tokens include keywords, symbols, quoted
strings, integer constants, character constants, newsgroup names and
identifiers.
.P
Identifiers start with a letter and consist of alphanumerics and/or the
underscore
character.  There is no limit on the length, although system resident
C compilers and linkers may impose one.  Identifiers are case-insensitive.
.P
Comments that begin with \fB/*\fP and end with \fB*/\fP may be placed
between any two tokens.
.P
C Preprocessor directives may be included at any line.  These begin with
a \fB#\fP in column 0 and are documented in the C preprocessor manual.
.P
The following are reserved keywords.  They may be written in either
upper, lower or mixed case:

.in 0.3in
.ll -0.3in
.P
\fBaccept, adjust, array, break, case, continue, database, datetime,
default, else, extern, for, forward, goto,
has, header, if, in, int, is,
newsgroup, parse, procedure, reject, return, string,
switch, userid, while\fP
.in -0.3in
.ll +0.3in
.P
Numbers are integers.  They consist of digits and may be preceded by
a minus sign.  Character constants consist of a single character in
single quotes.  Escape sequences, using a backslash, may be used.  A
single quote may be escaped to generate that constant.
.P
String constants are bound in double quotes.  Escape sequences start
with a backslash.  These are:  \fB\\n\fP - newline, \fB\\r\fP - carriage
return, \fB\\t\fP - tab, \fB\\f\fP - form feed, \fB\\"\fP - double quote,
\fB\\\\ \fP - backslash, \fB\\ \fP \fIoctal num\fP -- arbitrary ascii
character.
.P
Newsgroup constants consist of a \fB#\fP followed by a string of
alphanumerics, underscores, plus signs, dashes or dots.  \fBIs\fP tokens
consist of the string ``is'' followed by a space and a newsgroup constant
without the \fB#\fP prefix character.
.P
Other escape sequences generate a backslash and the non-special ``escaped''
character.

.H 2 "Declarations"
.P
Declarations may appear at the global level or at the local level, ie. inside
a subroutine.   Global declarations last for the entire program.  Local
declarations may hide global declarations, but are only valid within the
function or procedure in which they are found.
.P
All declarations involve types:

.H 3 types
.P
The following are valid types:
.sp 0.5V
.in 0.4in

.sp 0.7V
.ti -0.4in
int
.P
An integer.  Size is machine dependent.  Usually 16 or 32 bits.
The integer type is also used for boolean (conditional) expression values,
with 1 or non-zero representing true, and 0 representing false.
.sp 0.7V
.ti -0.4in
datetime
.P
An integer large enough to hold a date/time number.  Such numbers are
the number of seconds since midnight, GMT, Jan 1, 1970.
.sp 0.7V
.ti -0.4in
string
.P
A character string.
.sp 0.7V
.ti -0.4in
userid
.P
A USENET style \fBFrom:\fP line userid.  Normally this is the character
string of the mail address.   The ``real name'' comment can also be
extracted.
.sp 0.7V
.ti -0.4in
newsgroup
.P
A number which represents a newsgroup.  May be used as a string
in any expression, wherein the string with the name of the newsgroup is
provided.  Numbers which represent newsgroups named in the NewsClip
program will be unique.   Others may be re-used on a per-article basis.
.sp 0.7V
.ti -0.4in
\fIsimple-type\fP array
.P
An array of any of the above types.  (The above types are known as
simple types.) Such variables may be indexed by
integers using 
square brackets, and their size may be queried.  Array variables and values
are really pointers to arrays.
.sp 0.7V
.ti -0.4in
database
.P
A special type that can be indexed with square brackets using string value
indices.  The elements are integers.
.in -0.4in

.H 3 "Compatible Types"
.P
The types \fBnewsgroup\fP, \fBuserid\fP and \fB\fP string are known
as string-like types.  Expressions of these three types can be used in an
expression wherever a string is required.
.P
The \fBint\fP and \fBdatetime\fP types can be mixed in expressions, the
result is a \fBdatetime\fP.
.P
Types are assignment compatible if they are the same type, or if a string-like
type is being assigned to a string, or if an \fBint\fP or \fBdatetime\fP
type is being assigned to an \fBint\fP or \fBdatetime\fP.
.P
A \fBnewsgroup\fP expression can be assigned to an \fBint\fP.  The \fBint\fP
variable or argument gets the newsgroup number.  The reverse assignment is not
allowed.
.P
Arrays of assignment compatible types are not necessarily assignment
compatible.  Arrays of string-like types, however, can be used with \fBin\fP
and \fBhas\fP operators where an array of strings is required.

.H 3 "Variable Declarations"

.Bb
\fItype\fP \fIvariable-identifier\fP;
extern \fItype\fP \fIvariable-identifier\fP;
.Be
The first form declares a variable of the specified type.  The second form
imports a variable from outside the program.  You may not make an external
declaration for one of your own variables.  Predefined header variables
may only be imported at the global level, not within a procedure or function.
.H 3 "Header Variables"

.Bb
header \fIsimple-type\fP \fIvariable-identifier\fP : \fIfieldname\fP;
header \fIsimple-type\fP array \fIvariable-identifier\fP : \fIfieldname\fP, \fIdelims\fP;
.Be
These forms declare variables that are initialized for each article from
the appropriate header line in the article.  The header line is selected
from the \fIfieldname\fP string.
.P
In the second form, an array is declared.  The array will be parsed using
the delimiter string provided.  Any span of characters from the delimiter
set counts asnd one delimiter.  Thus with ``;:,'' \fB\:\:;:\fP counts as
one delimiter.
.P
If the field name begins with a lower case letter, the header field will
be lower cased before being parsed into the header variable.
.P
If the delimiter list starts with a capital \fBS,\fP then the S will not
be a delimiter, but rather indicates that white space should be stripped
from the front and back of all array elements.  (Naturally, this is only
useful when space itself is not a delimiter.)  Spaces in the middle of
elements will not be removed.  The \fBKeywords\fP line is delimited with
``S,''
.P
Header declarations may only appear at the global level, outside procedures
or functions.

.H 3 "External & Forward Subroutines"

.Bb
extern \fItype\fP \fIfuncname\fP ( \fItypelist\fP );
forward \fItype\fP \fIfuncname\fP ( \fItypelist\fP );
extern procedure \fIfuncname\fP ( \fItypelist\fP );
forward procedure \fIfuncname\fP ( \fItypelist\fP );
.Be
.P
These two forms declare a procedure or function.  The \fBextern\fP forms
import the routine from outside the program.  The \fBforward\fP form
declares a routine that will be defined later in the program.
.P
The \fItypelist\fP is a comma delimited list of argument types.  It may
be null.
.P
\fBForward\fP declarations may only appear at the global level, not inside
subroutines.

.H 3 "Externals"
.P
There are two types of externals.  NewsClip defined externals are
part of the language.  They must be imported with exactly the right
type and form.  It is an error otherwise.  It is also possible to import
arbitrary symbols, which must be present in modules linked with the program.
.P
There are two kinds of NewsClip externals, header variables and
others.  It is an error to include an \fBextern\fP for a header variable
within a procedure or function.

.H 2 "Subroutines"
.P
Procedures:
.Bb
procedure
\fIprocname\fP( \fIarglist\fP )
{
	\fIlocal-declaration-list\fP
	\fIstatement-list\fP
}
.Be
.P
Functions:
.Bb
\fItype\fP
\fIfuncname\fP( \fIarglist\fP )
{
	\fIlocal-declaration-list\fP
	\fIstatement-list\fP
}
.Be
.P
Procedures and functions may only be declared at the global level.
A \fIprocname\fP or \fIfuncname\fP is a unique global identifier.
An \fIarglist\fP is a list of argument declarations, which take the
form \fItype\fP \fIarg-identifier\fP.
.P
Arguments act as local variables.   The argument list and type of a
procedure or function must match any \fBforward\fP declaration for it.
.P
The \fIlocal-declaration-list\fP is a list of semicolon terminated local
declarations.  The \fIstatement-list\fP is a series of semicolon terminated
statements to execute when the routine is called.
.P
The \fBaccept\fP and \fBreject\fP statments may only be used in procedures.
In procedures, \fBreturn\fP must have no arguments, in functions, an argument
matching the \fItype\fP must be given on a \fBreturn\fP statement.

.H 2 "Statements"
.P
Any statement may be labeled.  To do so, proceed the statement with
an identifier (label) and a colon.

.H 3 "Compound Statement"
.P
A compound statement may be used whenever a single statement is required.
It consists of an open brace, a list of zero or more semicolon-terminated
statements, and closing brace.  Declarations may not be included within the
compound statement.

.H 3 "Procedure Call"

.St "\fIprocname\fP( \fIarglist\fP )"
.P
The named procedure is called.  The \fIarglist\fP is a comma delimited list
of expressions, or nul.  The count of arguments must match the declaration
for the procedure, and each argument must be assignment compatible with the
formal parameter declared for the procedure.
.P
If, after the procedure returns, the magnitude of the score is greater than
or equal to 30,000, the calling procedure terminates.   (Note that outside
of this context scores that go too high can become negative.)

.H 2 "Assignment Statements"

.H 3 "Assignment"

.St "\fIvariable\fP = \fIexpr\fP"
.P
The value of the expression is assigned to the variable.  The types must
be assignment compatible.

.St "\fIvariable\fP++"

.St "++\fIvariable\fP"
.P
The integer variable is incremented.  Remember, this is a statement, not
an operator.

.St "\fIvariable\fP-\-"

.St "-\-\fIvariable\fP"
.P
The integer variable is decremented.

.H 3 "Adjust"

.St "adjust \fIexpr\fP"
.P
The integer expression is added to the article \fBscore\fP.

.H 3 "Parsed Assignment"

.St "parse \fIvariable\fP = \fIstring-expr\fP"
.P
The simple type variable is assigned the value parsed from the string
argument and converted to the proper type.

.St "parse \fIarvariable\fP = \fIstring-expr\fP, \fIdelims\fP"
.P
The variable becomes a newly created array parsed from the string, with
elements delimited by spans of characters from the delimiter string.
If the delimiter string starts with \fBS\fP, then S is not used as a
delimiter, but white space is stripped from front and end of all elements.

.H 3 "Array Create"

.St "\fIarrayvar\fP = array \fIexpr\fP"
.P
The array variable becomes a fresh, empty array of size dictated by the
integer expression.  The indices will range from 0 to the size-1.

.H 2 "Conditional Statements"

.H 3 "If"

.Bb
if( \fIexpr\fP )
	\fIstatement\fP
.Be
If the value of the integer expression is non-zero, the \fIstatement\fP is
executed.  Otherwise, nothing is done.
.Bb
if( \fIexpr\fP )
	\fItrue-statement\fP;
 else
	\fIfalse-statement\fP
.Be
If the value of the integer expression is non-zero, the \fItrue-statement\fP is
executed.  Otherwise, the \fIfalse-statement\fP is executed.
.P
An \fBelse\fP clause binds to the most recent \fBIf\fP statement.

.H 3 "switch"

.Bb
switch( \fIexpr\fP )
	\fIcompound-statement\fP
.Be
.P
The compound statement will include case labels, and optionally a
\fBdefault\fP label.  A case label is placed on a statement by prefacing
it with:
.St "case \fIconst\fP :"
.P
where the constant should match the type of the \fBswitch\fP expression.
Each constant should be unique within the \fBswitch\fP.  One \fBdefault\fP
label may be present as well.
.P
Upon execution, the expression is evaluted.  If a case label exists for
the resulting value, control transfers there.  If not, and a default label
exists, control transfers to the default statement.  If no default exists,
control transfers to after the \fBswitch\fP statement.

.H 2 "Loop Statements"

.H 3 "for"

.Bb
for( \fIinit-assignment\fP; \fIcondition-expr\fP; \fIassignment\fP )
	\fIstatement\fP
.Be
.P
The \fIinit-assignment\fP is executed.  Then the integer \fIcondition-expr\fP is
evaluated.  If it is non-zero, the \fIstatement\fP and second \fIassignment\fP
are executed.  Control then transfers back to the above evaluation of
the \fIcondition-expr\fP.
.P
The assignment statements may be null.  The condition may also be null
in which case it always evaluates as true.

.Bb
for( \fIscalarvar\fP in \fIarray/database\fP )
	\fIstatement\fP
.Be
A loop is executed once for every element in the array or database.
The scalar variable must be of the constituent type of the array in the
array case, or of string type in the database case.

.H 3 "while"

.Bb
while( \fIexpr\fP )
	\fIstatement\fP
.Be
.P
If the integer \fIexpr\fP is non-zero, the \fIstatement\fP is executed.
This is repeated as long as the \fIexpr\fP is non-zero.

.H 2 "Transfer Statements"

.H 3 "goto"

.St "goto label"
.P
Control transfers to the statement within the current subroutine that
has the named label.

.H 3 "continue"

.St "continue"
.P
Control transfers to the evaluation of the test condition of the
current \fBwhile\fP or \fBfor\fP statement, or to the next entry in the
\fBfor .. in\fP format.

.H 3 "break"

.St "break"
.P
Control transfers out of the enclosing \fBswitch\fP, \fBfor\fP or
\fBwhile\fP statement, terminating the latter two.

.H 3 "return"

.St "return"
.P
The current procedure is terminated.

.St "return \fIexpr\fP"
.P
The current function is terminated and returns the value of the \fIexpr\fP.
The expression must be assignment compatible with the declared function
return type.

.H 3 "accept"

.St "accept"
.P
The \fBscore\fP is set to a high positive number and the procedure terminates.

.H 3 "reject"

.St "reject"
.P
The \fBscore\fP is set to a low negative number and the procedure terminates.

.H 3 "accept if"

.St "accept if \fIexpr\fP"
.P
If the integer expression is non-zero, an \fBaccept\fP is done.

.H 3 "reject if"

.St "reject if \fIexpr\fP"
.P
If the integer expression is non-zero, a \fBreject\fP is done.

.H 2 "Variable"
.P
A variable is either a declared variable identifier, or a declared
array or database variable identifier followed by an open square bracket,
an index expression and a closing square bracket.
.H 3 "Array Index"
.P
An element (index on) an array variable has the same type as the component
type of the array.  The index must be an integer.  Indices range from
0 to the size of the array, less one.
.P
Indexing on a database variable results in a variable of integer type.
The index must
be a string expression.   When used on the left side of an assignment,
the specified index will be created with a value of 0 if it does not
already exist in the array.   When such an index is used elsewhere,
the index will not be defined within the database and the value 0 will
be returned.
.P
Use of a defined database array index results in the update of the access
time for that index.

.H 2 "Function Call"

.St "\fIfuncname\fP( \fIexpr-list\fP )"
.P
The named function is called.  The \fIarglist\fP is a comma delimited list
of expressions, or nul.  The count of arguments must match the declaration
for the function, and each argument must be assignment compatible with the
formal parameter declared for the function.  The value returned is the
value given as an argument to a \fBreturn\fP statement in the function.

.H 2 "Expression Units"
.P
The basic units of expressions are variables, function calls, integers,
string constants, newsgroup constants, \fBis\fP primitives and expressions
in parentheses.  Integer expression units may be negated with a unary minus.
They may also be negated as boolean values with the not (\fB!\fP) operator,
which turns 0 to 1, and non-zero values to 0.

.H 2 "Dyadic Operators"
.P
Two-argument operators for integers include multiplication (\fB*\fP),
division (\fB/\fP),
modulus (\fB%\fP),
addition (\fB+\fP)
and subtraction (\fB-\fP)
.P
Comparison operators for integers include
less than (\fB<\fP),
less than or equal to (\fB<=\fP),
greater than (\fB>\fP) and
greater than or equal to (\fB>=\fP).
.P
String and integer values can be compared for equality (\fB==\fP) and
inequality (\fB!=\fP).  String comparison is exact.

.H 3 "IN"

.St "\fIelement\fP in \fIarray/database\fP"
.P
The in operator tests for the presence of a scalar, or any element from
an array in an array of a compatible type or a database.  Only
string compatible types can be searched for in a database.
.P
The operator returns 1 if the element is present, 0 if not.  The
\fB!in\fP operator returns the reverse.
.P
If a search is made in a database, the matched index gets its access date
updated.  If a search is made for an array in a database,
only one database index will get an updated access date, even if there
are several matches.

.H 3 "HAS"

.St "\fItext/database/str-array/string\fP has \fIdatabase/str-array/string\fP"
.P
This operator searches for the presence of a regular expression or series of
regular expressions in a string, array of strings, database or text region.
.P
The language of regular expressions is that taken by \fBegrep\fP, and is
described elsewhere.   If any of the regular expressions (strings are used
as regular expressions) from the pattern side matches any of the strings
on the string side or within the text region, 1 is returned.  0 is returned
otherwise.  The \fB!has\fP operator returns the reverse.
.P
When databases are involved, the indices are either searched or used as
patterns.  The integer values are not involved.  If a database of patterns
is used, the ``first'' (in hash-order, which is meaningless to the
user) pattern to match gets its access date updated.

.H 3 "Logical Operators"
.P
The \fB&\fP operator \fBand\fPs two integer operands together as bits.  The
\fB|\fP operator \fBor\fPs them.  Both operands are always calculated before
they are combined.   The \fB^\fP operator returns the integer that is
the result of exclusive \fBor\fPing the bits of the two operands.
.P
The \fB&&\fP operator returns 1 if both operands are true, 0 otherwise.
The \fB||\fP operator returns 0 if either of its operands is true, 0 if
both are false (zero).  In the case of \fB&&\fP, if the first operator
is false, the 2nd is not even evaluated.  With \fB||\fP, if the
first operand is true, the 2nd is not evaluated.

.H 3 "Query"

.St "\fIconditional-expr\fP ? \fItrue-expr\fP : \fIfalse-expr\fP"
.P
The integer conditional expression is evaluated.  If true, the \fItrue-expr\fP
is evaluated and returned.  If false, the \fIfalse-expr\fP is evaluated and
returned.

.H 2 "Operator Precedence"
.P
The operator precedence of NewsClip is the same as that of C, with
\fBhas\fP and \fBin\fP at the level of the equality operators.  Operators
at the same level of precedence bind left to right unless otherwise stated.
Here is the precedence table, from strongest to weakest:
.AL

.LI
\fB() []\fP \fIfunc\fP\fB()\fP
.LI
\fB- !\fP (unary, right to left)
.LI
\fB*  / %\fP
.LI
\fB+ -\fP
.LI
\fB< > <= >=\fP
.LI
\fB== != has !has in !in\fP
.LI
\fB&\fP
.LI
\fB^\fP
.LI
\fB|\fP
.LI
\fB&&\fP
.LI
\fB||\fP
.LI
\fB? :\fP (right to left)
.LE
.H 2 "Entry Points"
.P
Entry points are procedures that are called by the NewsClip library
when a program is linked with it.  They are essential to the language, but
are primarily part of the library.  The library supports several modes
of operation.  The \fInewsrc\fP mode is described here.
.P
Entry point procedures are all optional.  If the user does not provide
such procedures, a null routine is inserted.
.P
The program begins by calling \fBInit\fP.  Then for each newsgroup,
\fBstartgroup\fP is called, and a loop is done over the unread, unprocessed
articles, after which \fBendgroup\fP is called.  Finally, \fBterminate\fP
is called.
.P
In the loop, for each unread article the header is processed and the
various variables are initialized.  The \fBscore\fP is set to 1 (default
accept) and \fBarticle\fP is called.   Action is taken based on the
score at the end of \fBarticle\fP.
.P
The \fBcommand\fP entry point is called, with a string argument, whenever
a command is passed down in \fIpipe\fP mode.  The procedure is expected to
act on the command and issue a \fBaccept\fP, or issue a \fBreject\fP.



.H 1 "Contrast with C"
.P
The NewsClip language has been designed to be very similar to the
C language.  The general syntax, operators and flavour are the same.
It has, however, been stripped down quite a lot, and at the same time
a few news related extensions have been added.
.P
C programmers should fit right in, once they get past a few major
and minor differences.  These are:

.LI
.P
{bull}Assignment is quite different.  There is only one assignment operator,
namely \fB=\fP, although there are also increment \fB++\fP and
decrement \fB-\-\fP operators.   Assignment operators, including
increment/decrement, can \fBnot\fP be used in the middle of expressions.
They can only be used in statements on their own.
.LI
.P
{bull}There are only a few basic types, and you can't define your own types.
A couple of the basic types are structured, but structures are not
referenced in the C manner.
.LI
.P
{bull}There are no pointers in the conventional sense.  Pointer operators
like monadic \fB*\fP, \fB->\fP and \fB&\fP are not present.
.LI
.P
{bull}Bit shifting operators are not present.
.LI
.P
{bull}Case is ignored in symbol names such as variables.  This means
\fBHelloThere\fP is the same variable as \fBhelloTHERE\fP.
.LI
.P
{bull}Strings are a basic type, and chars are not.  You can't really manipulate
the individual characters in strings the way you can in C.  On the other
hand, operators such as \fB==\fP work on strings.
.LI
.P
{bull}There is a difference between procedures and functions.  Functions always
return results, procedures never do, and they are declared as procedures.
.LI
.P
{bull}The comma operator for multiple expressions is not present.
.LI
.P
{bull}Non integer values are not to be used in boolean expressions.  Instead,
you should compare string, array, database, userid and newsgroup values
with special defined ``nil'' constants.
.LI
.P
{bull}There is no casting, and there is no \fBsizeof\fP operator.
.LI
.P
{bull}You can't make declarations inside any compound statement \fB{ . . . }\fP,
only at the top of a routine.
.LI
.P
{bull}Declarations of parameter types for routines are done in a Pascal style,
with \fBint f( int a, string b )\fP and all external procedures and functions
must have their arguments declared, ANSI C style.
.LI
.P
{bull}You can't reference an undefined procedure or function, you must forward
declare it in the global declarations section.
.LI
.P
{bull}There are new operators -- \fBhas\fP and \fBin\fP, along with new
statements \fBaccept\fP, \fBreject\fP, \fBadjust\fP and a new variation
of the \fBfor\fP loop.
.LI
.P
{bull}Arrays are dynamic.  There are some special statements for dynamic arrays.
.LI
.P
{bull}There are no initializers for declared variables.  If you wish to
initialize, do it with code.  The standard default of 0 from C will be
the case for all user defined global variables.
.LI
.P
{bull}Memory for most user strings and arrays is allocated from a temporary pool
that is cleared with each new article.
.P
This may not seem a lot like C to you, but in fact you will find that for
the purpose of examining news articles, you will still be able to write the
code you want.  We have removed some of the problem-causing constructs
of C without removing the power needed to write good news filtering
programs.
.P
You may ask why we removed so much, when there was little work required
to leave it in.  In fact, if we wanted to, NewsClip could have been
implemented with a lexical preprocessor for C and lots of clever macros.
.P
Instead we have a compiler for a reduced language.  The reasons for this
are:
.AL

.LI
It allowed a nicer, easier-to-read syntax for language extensions, like
the \fBhas\fP operator.
.LI
We can fully error check the user program so that the C compilation stage
does not generate errors.
.LI
Later, we can implement an interpreter for the language so that it can
be run by people who do not have C compilers.  Allowing the full power
of C would have made this bulky with little gain.
.LE
.P
Finally, we have allowed the \fBextern\fP declaration to make external
references to C variables and functions found in the general C libraries or
written by the user and linked in with the newsclip library.  This allows
access to the full power of C (or other languages) to those with the skill.
.P
This power will not be available to users of the planned interpreter, but
we did not want to make such access impossible to customers who have the
tools.  Source code customers \fIcan\fP change the NewsClip compiler
source code and extend the language, but we would rather they simply
\fBextern\fP in their own routines, as needed.




.H 1 "Predefined Variables & Routines"

.H 2 "Predefined Header Variables"
.P
The following variables are special globals that refer to fields from the
header of a USENET article.  They must be declared with the types shown.
If you wish to parse header lines using other types, you can declare explicit
header lines as described in the section on header declarations.
.P
These globals are special.  Any reference to them causes the appropriate
header line to be searched for and parsed.  The more such variables you
refer to, the more involved header processing will be.  As such, do not
make external reference to any of these variables that you do not intend to
actually use.
.P
If a header line is not present, the associated variable will contain the
appropriate \fInil\fP value for its type.  Some variables refer to required
header items and will never be nil.  These are \fBfrom\fP, \fBmessage-id\fP
and \fBSubject\fP.  If a \fBNewsgroups:\fP line is missing, the article is
declared to be invalid and is rejected.
.P
A special set of variables beginning with the letter ``r'' exist.  These
are variables for which default values exist, based on required header lines.
With these variables, if the optional header field they refer to is not
present in the article, you will get the default required field.
.P
Assigning to predefined header variables is not advised, although it
is possible.
.P
All header variables are mapped to lower case, with the exception of
\fBxref\fP, \fBmessage\_id\fP and \fBreferences\fP.  This makes searching
easier.  This mapping can be turned of with explict header declarations
or by setting the \fBpreserve\_case\fP variable to TRUE.

.xd "userid" "approved"
.P
The article's \fBApproved:\fP header line, or \fBnilstring\fP if it was not
present.
.xd "string" "control"
.P
The article's \fBControl:\fP header line, or \fBnilstring\fP if it was not present.
.xd "datetime" "date"
.P
The posting date of the article, from the header \fBDate:\fP field.
.xd "newsgroup array" "distribution"
.P
The array of distributions from the \fBDistribution:\fP field, or \fBnilarray\fP
if that is not present.  Note that on USENET, distributions are specified with
newsgroup names, even if the values given, like \fBcomp\fP are newsgroup
hierarchies, rather than newsgroups.  Note as well that NewsClip provides some
facilities to compare and examine distributions in a quantitative way.
.xd "newsgroup array" "rdistribution"
.P
This will be the \fBDistribution\fP array if that header field is present.
Otherwise, it will be the \fBNewsgroups\fP array, which is always present
in a Usenet article.   This is the way distribution works on a Usenet
article -- if no explicit distribution is given, the distribution is defined
by the \fBNewsgroups:\fP line.
.xd "datetime" "expires"
.P
The date of expiry for the article, or 0 if no explicit expire date is given.
.xd "newsgroup array" "followup_to"
.P
The array of newsgroups to which followups to a given article should be posted,
or nilarray if no explicit list is given.
.xd "newsgroup array" "rfollowup_to"
.P
This array is the \fBfollowup_to\fP array if the \fBFollowup-to:\fP header line
is present, and is the \fBNewsgroups\fP array, otherwise.  As the latter is
always
present, this variable will never be nil.   On Usenet, if a user follows up
an article with no explicit \fBFollowup-to:\fP line, the followups go to the
groups on the \fBNewsgroups:\fP line.
.xd "userid" "from"
.P
The author of the article, from the \fBFrom:\fP line.  Under Usenet rules, this
field must always be defined.  If it is missing, a dummy userid will be
inserted.  This field will never be equal to \fBniluserid\fP.
.xd "string array" "keywords"
.P
Any keywords or phrases, delimited by commas, from a \fBKeywords:\fP header
line, are placed in this array.  If there are none, this is \fBnilarray\fP.
Spaces and tabs are removed from the front and end of any keywords or
phrases.
.xd "int" "lines"
.P
The number of lines in the body of the article, as given by the \fBLines:\fP
header item.  Please note that this value is often inaccurate.  If you wish
an exact count, you may use \fBlinecount(body)\fP which actually reads the
article body and counts the lines.   This number will be 0 if the field is
missing.
.xd "string" "message_id"
.P
The article's message-id.  Under USENET rules, this is a unique string that
no other message will use.  This field is required in all articles.  If it
is somehow missing, a dummy (non-unique) string will be provided, so that
you never have to worry about getting \fBnilstring\fP.
.P
The \fBmessage-id\fP string is not mapped to lower case.  All comparisons on
message-ids should be exact.
.xd "newsgroup array" "newsgroups"
.P
This gives the newsgroups from the article's \fBNewsgroups:\fP header line.
All articles must have such a line or they are rejected out of hand.
.P
This header variable is unlike all the others.  First of all, it need not
be declared as an external -- it is always present.  Furthermore, you
may not define your own header to parse the \fBNewsgroups:\fP line in
a different way.  It is always parsed as an array of newsgroups and
placed in this variable.
.xd "string" "organization"
.P
A free-format string describing the poster's location.  This is taken from
the \fBOrganization:\fP header line and is \fBnilstring\fP if that is not
present.
.xd "string array" "path"
.P
This array comes from the \fBPath:\fP header line, which should always be
present on a usenet article.  The array will be the list of sites that the
article passed through to get to you.   The last element in the array,
\fBpath[count(path)-1]\fP will not be a site name, but may instead by the
local userid of the poster on the posting site.   The array is parsed using
all the major network characters as delimiters, namely ``\fB!:@%\fP'' and comma.
.P
If the program is used in \fIbatch\fP mode to feed another site, you will
want to reject all articles that have the feed site's name in the
\fBpath\fP array.
.xd "string" "posting_version"
.P
This old header line is not used much any more.  If defined, it will be
a string describing the news posting program used to post the article.
.xd "string array" "references"
.P
This is an array of the message-ids of the articles to which this article
is a followup.   This is useful if you wish to kill off an entire discussion
rooted at a given message.  If you know the message-id of the original
message, you can search for all messages that refer to that in their
\fBreferences\fP array.
.P
The \fBreferences\fP array is not mapped to lower case.  All comparisons on
message-ids should be exact.   The boolean (an integer that is 0 or 1)
variable \fBfollowup\fP tells
whether \fBreferences\fP is defined or not.
.xd "userid" "reply_to"
.P
This is the requested reply address on the message.  Sometimes posters wish
replies to go to a different address from the one given on the \fBFrom:\fP
line.  If present, this userid variable gives that address.
.xd "userid" "rreply_to"
.P
This is the \fBreply_to\fP variable, or if that is not present, it is the
\fBfrom\fP variable.  The \fBFrom:\fP field is required on every usenet posting,
so this variable should never be \fBniluserid\fP.   This is the way replies
work on usenet -- if there is no \fBReply-to:\fP field, replies are to go to
the userid in the \fBFrom:\fP field.
.xd "userid" "sender"
.P
This is the userid from the \fBSender:\fP field, if present.  If a message
is actually posted by a person different from the one specified in the
\fBFrom:\fP field, this field will be present to specify who the real poster
was.
.xd "userid" "rsender"
.P
This is the \fBsender\fP variable, or if that is nil, the \fBfrom\fP variable.
This should always be defined in a usenet message, and defines the true
sender of the message.
.xd "string" "subject"
.P
This is the free format subject string.  All messages are required to have
a subject string, so this will never be nilstring.  The \fBsubject\fP string
will still have any ``Re:'' prefixes on it.  You should apply the
\fBdrop_re\fP function on it and store the result in your own variable if
you plan on working on the pure subject.
.xd "string" "summary"
.P
An optional free format string, from the \fBSummary:\fP line.  This is an
expanded subject.
.xd "string array" "xref"
.P
This is a special array generated by the local news processing program.  The
first element should be the name of your site.  Subsequent elements will consist
of newsgroup names, a colon, and local article numbers.  These indicate the
various places a cross-posted article is linked on the local machine.
.P
This field is not mapped to lower case.  If this field is imported,
it will be used by the various \fInewsrc\fP processing modes.   You don't
have to use it yourself.   The presence of a proper \fBXref:\fP line on
a rejected crossposted article will cause all the cross references to
also be rejected without being processed.
.P
If you do not wish this
to happen, then define your own special header definition for the \fBXref:\fP
line, and do not import this predefined one.
.H 2 "Distribution"
.P
The NewsClip language includes a facility to examine article distribution
on a quantitative level.
.P
Normally article distribution is expressed in terms of special distribution
keywords, which are actually strings from the newsgroup naming space.  To
the usenet software, for example, ``comp'' is treated like a newsgroup.
To the distributing software, it matches all newsgroups that begin with
``comp'' and a dot.
.P
Some distribution fields are newsgroup hierarchies, and others are names
which don't actually refer to a newsgroup and are used only for distribution.
These include things like local, regional, statewide and national
distributions like ``usa.''  (Many local regions keep their own newsgroup
hierarchy for strictly local groups, and thus use these strings both as
distributions and the root of a hierarchy.)
.P
Newsgroup distributions are roughly ordered, in that some are larger than
others.  Using NewsClip one can compare the size of distributions.  For
each newsgroup or distribution (they are really the same thing) you can
extract a distribution level with the \fBdlevel\fP function.
.P
The number you extract is arbitrary and defined by the person who installed
the newsclip system on your computer.  In general, it should correspond
roughly to the number of computers that are expected to get an article with
the specified distribution.  For example, for local articles, the level is 1.
For articles with the ``world'' distribution, it is currently around 12,000.
.P
In general, you should avoid using hard decimal constants, but instead
refer to defined distribution levels for predefined newsgroup constants
using the \fBdlevel\fP function.

.xd "int" "dlevel( newsgroup n )"
.P
Given a value of type newsgroup, this returns the distribution level
for that newsgroup.  This is the approximate number of sites the article
is expected to reach.
.P
This is a predeclared function.  You do not have to import it.
Be warned that \fBdlevel\fP does not work on unknown newsgroups (groups
that are not named in the program or the \fB.newsrc\fP or \fB.newsrclas\fP
files) unless \fBdistribution\_level\fP is also imported.  This is for
efficiency reasons.
.xd "int" "distribution_level"
.P
This variable gives the expected distribution level for the current
article.  This is calculated by first getting the maximum distribution
level from fields in the \fBDistribution:\fP header line as well as the
maximum distribution level from newsgroups in the \fBNewsgroups:\fP line.
The minimum of these two is then taken and assigned to the variable.
.P
On usenet, a \fBDistribution:\fP line only restricts the distribution of
an article.  It does not expand it.  Thus, the minimum of the two values
is taken.
.P
The following are predefined newsgroup name constants.  
(Newsgroup name constants are all prefaced by a # character in
NewsClip source code.)
They exist for the
sole purpose of having the \fBdlevel\fP function used on them.  This
returns the approximate number of sites in the given geographic region.
This allows expressions like \fBdistribution_level <= dlevel(#state)\fP
to test for articles of statewide or lower distribution.
.P
Your own local distributions should also have been defined by the
person who installed the NewsClip system.  If you are
in New Jersey, you can also thus check statewide distribution with
\fBdistribution_level <= dlevel(#nj)\fP.
.xd "" "#world"
.P
A predefined newsgroup constant with a \fBdlevel\fP equal to the estimated
total number of sites in the entire world.
.xd "" "#usenet"
.P
The typical number of sites for usenet articles.  Some usenet groups go
off of usenet into other networks, so this will be slightly less than
the dlevel for #world on some sites.
.xd "" "#continent"
.P
The size of the continental distribution applicable to the local site.
Regions like North America, Europe or Australia.
.xd "" "#country"
.P
The size of the local country distribution.
.xd "" "#state"
.P
The size of the local statewide distribution.  Should probably be the same
as #province, which is a synonym.
.xd "" "#province"
.P
The size of the local provincial distribution.  Should probably be the same
as #state, which is a synonym.
.xd "" "#region"
.P
The size for the local regional (county, multi-city area etc.) distribution.
.xd "" "#city"
.P
The size for a distribution within a city.
.xd "" "#organization"
.P
The distribution within your entire organization.  In some cases, like
``att'', this could actually be larger than a region or even a state.
.xd "" "#department"
.P
A departmental distribution, if you have one, otherwise the same as your
subnet or local computer.
.xd "" "#subnet"
.P
Any smaller distribution, otherwise the same as #department, #organization
or #local
.xd "" "#local"
.P
A predefined ``newsgroup'' with a \fBdlevel\fP of one.
.H 2 "Useful Variables"
.P
The following variables which you can import can all be useful.
.xd "newsgroup" "main_newsgroup"
.P
The ``current'' newsgroup.  This normally only has meaning when working
in \fIpipe\fP or \fInewsrc\fP type modes.  In \fIfilter\fP mode it will be set
to the first newsgroup in the \fBnewsgroups\fP array.
.xd "newsgroup" "dir_newsgroup"
.P
This special variable can be set so that the \fB~d\fP code in database
filenames will expand to the name of the chosen newsgroup, with dots
replaced with slashes.  See ``database routines'' for more details.
.xd "int" "followup"
.P
This is actually a boolean variable.  It is true if the current article
is a followup, which is to say if it contains a \fBReferences:\fP line.
It is false on independently generated articles.
.xd "int" "score"
.P
This is the running score that you control with \fBadjust\fP statements.
If you declare it on your own, you can reset it, adjust it yourself or
examine it.  In particular, you may wish to examine it in the post-article
routine, should you define one.
.xd "string" "article_filename"
.P
This is the name of the file containing the current article.  Be warned
that in some modes of operation, this will not be defined.  For example,
a filename will not be available when talking via PIPE to a newsreader
that reads articles using the NNTP protocol.
.P
The filename may also be the name of a temporary file, and thus not the
name of the permanent article spool at all.
.xd "int" "article_number"
.P
This is the article number of the article in the ``main newsgroup.''
This is only defined in processing modes that work on newsgroups, such
as the \fInewsrc\fP mode and the \fIpipe\fP mode.  This will not be defined
in the \fIfilter\fP mode of operation.
.xd "int" "article_bytes"
.P
This is the number of bytes in the entire article.  Under normal
circumstances, this is obtained from the operating system.  On Unix, it
is found in the \fIinode\fP.
.P
When in a processing mode where articles are not read from independent
files, reference to this function causes the entire article to be read
in so that the size may be calculated.
.P
Note that if the size of the article is larger than the largest integer,
the largest integer will be returned.
.xd "int" "num_links"
.P
On a Unix system, this gives the number of links to the file containing the article.
If there is no article file, this will be 1.
.xd "datetime" "write_time"
.P
This contains the date/time that the article file was last written to.
It is extracted from the operating system.  If this is not available, the
current time will be used.

.H 2 "Article Body Sections"
.P
Using the \fBhas\fP operator, one can search for text patterns in sections
of the article body.  The various sections of the body have predefined names.
You do not have to declare them.  Note that searching in these text regions
naturally requires reading in some or all of the article body,
which can add considerably to processing time.
.xd "" "body"
.P
The entire body of the article. (\fBPre-declared\fP)
.xd "" "text"
.P
The entire text of the article, but not the signature. (\fBPre-declared\fP)
.xd "" "signature"
.P
The signature section only.  The signature is delimited from the text by
the presence of a line that matches a certain pattern.
(See \fBset_signature_start(str)\fP) (\fBPre-declared\fP)
.xd "" "newtext"
.P
Only that portion of the text that is deemed to be ``new,'' as opposed to
included from a previous article.   May people write followup articles
which include the text of the parent article prefixed by some character,
usually a greater than sign.  With this variable, you can search only the
new contributions for key patterns. (\fBPre-declared\fP)
(See \fBset_include_prefix(str)\fP)
.xd "" "included"
.P
Only the sections of the text (and not the signature) that were included
from a previous article.  Included sections are defined as those that
start with a specified pattern.  (\fBPre-declared\fP)
(See \fBset_include_prefix(str)\fP)
.H 2 "Body Size Functions"
.P
The following functions return statistics about the size of various
regions within the article body.  Note that calling these functions
requires that the news filtering program read in the body of the article,
which can add considerably to processing time.
.xd "int" "byte_count( text_section )"
.P
Returns the number of bytes in the given text section.  If this number is
larger than the largest positive integer, that largest positive integer
is returned. (\fBPre-declared\fP)
.xd "int" "line_count( text_section )"
.P
Return the number of lines in the given text section. (\fBPre-declared\fP)
.xd "procedure" "set_include_prefix( string )"
.P
Sets the regular expression used to match lines which are to be considered
included from a previous article.  There is no need to place a ``\fB^\fP''
at the front of the pattern, as it will only be matched at the start of
the line.  Whitespace before the pattern is ignored.
The default is ``\fB[:>#%]\fP'' -- a set of possible prefix characters.
.xd "procedure" "set_signature_start( string )"
.P
Sets the regular expression used to match the line which is considered
to be the delimiter between the text of an article and the signature.
There is no official delimiter, but a common practice is a line with
just two dashes.  Many other methods exist, and no pattern will be
perfect.  The default is ``\fB^-\- *$\fP,'' which allows two dashes 
followed by any number (including zero) of spaces.
The \fB^\fP at the front is important in this case.
.H 2 "Control Variables"
.P
These variables control parameters of pattern searches in the article body
If you wish to set these, do so in your initialization section or at the
very start of article processing.  It does no good to set them once
any reference to the body of an article has been made.
.xd "int" "preserve_case"
.P
Normally all sections of the article body are mapped to lower case before
pattern matching, so that patterns will match upper, lower and mixed
case instances of the desired strings.  If you do not desire this, set this
variable to TRUE.
.P
Setting this flag true also stops the mapping of header sections to lower
case.  Most header sections, such as \fBsubject\fP and \fBfrom\fP are usually
mapped to lower case.
.xd "int" "paragraph_scan"
.P
Your program has the option of scanning the body as a series of paragraphs
rather than a series of lines.  If you set this variable to be true,
the body will be read in and lines will be grouped into paragraphs before
they are scanned.  Paragraph breaks are marked at blank lines, changes in
indentation or a switch from new text to included text.
.P
Paragraph scanning has one big advantage.  If you don't set it, and
you're searching for a
pattern like ``ronald reagan,'' then you won't find it if the text
looks like:
.in 0.5in

.nf
.P
And furthermore, I blame it all on Ronald
Reagan, who was President in 1987.
.fi
.in -0.5in
You will match such a pattern if the paragraph_scan flag is on.
.P
Paragraph scanning does consume extra time, of course, and should only
be used if you have multi-word patterns to search for.
.xd "int" "white_compress"
.P
Your program has the option of scanning the body in such a way that
all spans of ``white space,'' namely spaces, tabs, formfeeds, and (in
the case of paragraph_scan mode (see above)) line breaks are compressed
into a single space.   Set this variable to TRUE and this will be done
before any pattern matches on the article body.
.P
This does not apply to matches on the \fBsubject\fP or other normal
strings.
.H 2 "Global Control"
.P
You can set your program to do an automatic accept or reject on all articles
in a given newsgroups.  Set one of these variables to TRUE (in, for example,
your \fBSTARTGROUP\fP routine, and all further articles will be accepted
or rejected (according to the variable) until you reset the variable or
processing of the current newsgroup finishes.
.P
These variables should never be used in \fIfilter\fP mode.  These variables
provide a way to ``unsubscribe'' to a newsgroup entirely within the context
of the NewsClip language.
.xd "int" "accept_all"
.P
If true, accept all articles until this variable is cleared or processing
of the current newsgroup terminates.
.xd "int" "reject_all"
.P
If true, reject all articles until this variable is cleared or processing
of the current newsgroup terminates.
.xd "int" "named_group( newsgroup )"
.P
This returns true if the newsgroup is one of those named as a newsgroup
constant (\fB#comp.foo\fP) or inside an \fBis\fP operator within your
program.   It is false otherwise.
This is a quick way to tell if the group is one of the
ones you are interested in, ie. named somewhere in your program.
.xd "int" "newsrc_group( newsgroup )"
.P
Returns true if the group is one of those named in the \fB.newsrc\fP file.
This will only be true in a \fB.newsrc\fP processing mode, like \fInewsrc\fP
or \fIbatch\fP mode.  Unsubscribed groups are not included, unless the
\fI+unsubscribed\fP option has been used.   This can be useful in eliminating
crossposting.
.H 2 "Outside World"

.xd "string array" "options"
.P
This array contains all the command line options provided to the news
filtering program through use of the \fIo=\fP command line option.  It will
be empty if no options were provided.   The string ``o='' does not form
part of any of the option strings.
.xd "string" "my_domain"
.P
A string that contains the domain name of the host machine as used to
generate mail reply addresses in news articles.  This will only be valid
if the person who installed the NewsClip system on your machine defined
it, as there is no portable way of finding this out.
.P
If you're not sure, and you want to refer to the domain of your own
machine, just type it in yourself.  This variable exists only for those wishing
to write general newsclip programs that can move from machine to machine.
.xd "string" "my_mail_address"
.P
This gives the mail address of the user running the news filtering program.
It depends on \fBmy_domain\fP, so note the warnings given above.
.xd "datetime" "time_now"
.P
This gives the date/time that the newsclip program was invoked.  Note that
if the program somehow runs for hours, this variable will still always have
the same value -- the date/time at startup.
.H 2 "Handy Constants"

.xd "int" "true"
.P
The integer 1. (\fBPre-declared\fP)
.xd "int" "false"
.P
The integer 0. (\fBPre-declared\fP)
.xd "datetime" "day"
.P
The number of seconds in a day. (\fBPre-declared\fP)
.xd "datetime" "week"
.P
The number of seconds in a week. (\fBPre-declared\fP)
.xd "datetime" "month"
.P
The number of seconds in an ``average'' month. (\fBPre-declared\fP)
.xd "string" "nilstring"
.P
The value of string header variables that have no string assigned to them. (\fBPre-declared\fP)
.xd "userid" "niluserid"
.P
The value of userid header variables that have no userid assigned to them. (\fBPre-declared\fP)
.xd "database" "nildatabase"
.P
A nil database can be searched in (you will find nothing in it) but you can't
add items to it. (\fBPre-declared\fP)
.xd "newsgroup" "nilnewsgroup"
.P
A newsgroup number that corresponds to no actual newsgroup. (\fBPre-declared\fP)
.xd "array" "nilarray"
.P
The value of an array header variable that was not present.  Do not attempt
to index into such an array, as a \fBnilarray\fP is not the same as
an empty array. (\fBPre-declared\fP)
.H 2 "Special Predeclared Functions"

.xd "int" "count( array )"
.P
The number of elements in an array.  Do not use on a nil array. (\fBPre-declared\fP)
.xd "string" "realname( userid )"
.P
When applied to a variable of type userid, this function returns the
``full name,'' if any, that was associated with the userid.  For example,
if an article contains the line: \fBFrom: user@foo.bar (Joe User)\fP then
\fBfrom\fP will look like ``\fBuser@foo.bar\fP'' and \fBrealname(from)\fP will
be the string ``\fBjoe user\fP.'' (\fBPre-declared\fP)
.H 2 "Database Routines"
.P
The concept of the database is described elsewhere in the manual.  Databases
can be accessed through array indexing, as well as the \fBin\fP and
\fBhas\fP operators.  These routines are used to initialize, read and write
databases.
.P
Database read and write routines take strings for filenames.  These strings
can contain special escape codes, all starting with the character tilde.
These codes can be used to expand important information into the filename,
so that database filenames can be based on the current newsgroup, the user's
home directory, and other things.
.P
The escape codes are:

.P
   \fB~\fP     (followed by slash) User's home directory
   \fB~.\fP    User's ``dot'' (hidden file) directory (location of .newsrc)
   \fB~n\fP    current newsgroup name, with dots changed to slashes
   \fB~N\fP    current newsgroup name, mapped to a short single directory form.
   \fB~d\fP    newsgroup in \fBdir_newsgroup\fP with dots changed to slashes
   \fB~D\fP    newsgroup in \fBdir_newsgroup\fP mapped to short single directory form.
   \fB~s\fP    News spool directory (/usr/spool/news, usually)
   \fB~l\fP    News lib directory (/usr/lib/news, usually)
   \fB~~\fP    A real tilde in the filename
   \fB~u\fP    The userid of the person running the program
   \fB~u\fP    The decimal process id of the news clipping process.
.P
You can also build filenames on your own with the \fBconcat\fP function.
.P
The \fB~N\fP and \fB~D\fP escapes
can be used when you want a file name that does not take
up multiple directory levels.  You will get a name that does its best
to be unique in the length of a single filename -- 14 characters
on most Unix systems.  There may also be a check character present to
help, but the form may vary from system to system.
.P
This will normally be unique, but there is no guarantee of it.  As new
newsgroups are created, two might collide.  Use this form at your own
risk.

.xd "database" "read_database( string filename )"
.P
Reads in a database from the specified file.  The database can be one
written out with the \fBwrite_database\fP procedure, or it can be a
hand created one, or a combination of the two.  If the database file is
missing or empty, an empty (but not nil) database will be returned.
.P
Database records are lines in the database file.  Such lines normally
consist of a greater than sign (``>''), an integer field value, a comma,
a long integer ``last access'' time, another comma, and then the
database key string.  Lines that don't match this format are considered
to be just the database key string.  A default integer field of 1 and
last access time of \fBtime_now\fP will be provided.
.P
Database files may also start with a special record that indicates the
number of records in the database.  (This will only be created by
the NewsClip database writing procedure.)
.P
This function reads the entire database into memory, and returns a
fresh database descriptor.
(\fBPre-declared\fP)

.xd "procedure" "write_database( database d, string filename, datetime expire )"
.P
This procedure writes out an existing database to the specified file.
All records are written out in the proper format described above, and
a database size record is written first.
.P
If the database is nil or empty, and the specified file does not exist,
then the file will not be created.  This allows you to avoid creating large
numbers of empty files.
.P
Any records that have not been accessed since the specified expire date
will not be written out to the database file.  For example, to write out
all records that have been accessed or created in the last month, use
a time of \fBtime_now - month\fP.  To write out all records, use a time
of zero.
.P
The expiry feature lets you gradually eliminate all old, unused records
from database as time passes.
(\fBPre-declared\fP)
.xd "procedure" "db\_delete( database d, string index )"
.P
This procedure deletes an index from the database.  If the index was
not present, nothing happens.  (\fBPre-declared\fP)
.xd "procedure" "free_database( database d )"
.P
This frees up the memory associated with your database.  Once you have
written out a database, you should free it if you will no longer need it.
Be sure to nil out the database variables that refer to that database as
well.
.P
There is no real need to free databases if your program is just about
to terminate.
(\fBPre-declared\fP)
.xd "database" "fresh_database( int predicted_size )"
.P
This creates and returns a descriptor for a new empty database.  You should
provide an estimate of the eventual number of records that the database
might contain.  The estimate need not be right.  If it is too small, searches
will become slow.  If it is too large, memory will be wasted.
(\fBPre-declared\fP)
.xd "int" "exists( string filename )"
.P
This tests whether a file exists or not.  You may want to perform some
database operations only if certain files exist.
.H 2 "Useful Functions"

.xd "string" "getenv( string variable )"
.P
This is the standard C library routine to fetch the value of an environment
variable.  See the C library man page for more details.
.xd "int" "strlen( string s )"
.P
This is the standard C library routine to find out the number of characters
in a string.  Do not use it on \fBnilstring\fP.
.xd "int" "chindex( string s, int index )"
.P
This allows you to index a specific character in a string.  The character
is returned as an integer.  If you index one past the last character, you
will get a zero.  Beyond that, the result is undefined.
.P
The first character is index 0, the next is index 1, etc.  If there are
10 characters in the string, then index 10 will return the integer 0.
.P
You may only look at the characters, you may not change them.
.xd "string" "left( string s, int parts )"
.P
This parses a string delimited by dots, and returns
the leftmost \fIparts\fP parts of the string, not including the dot at the
end.  For example, in the string s = ``comp.sys.ibm.pc,''
\fBleft(s,2)\fP returns ``comp.sys'' and \fBleft(s,1)\fP returns ``comp''
with no dot on the end.
.xd "string" "right( string s, int parts )"
.P
This parses a string delimited by dots, and returns
the rightmost \fIparts\fP parts of the string, not including the dot at the
front.  For example, in the string s = ``iuvax.cs.indiana.edu,''
\fBright(s,2)\fP returns ``indiana.edu'' and \fBleft(s,1)\fP returns
``edu''
.P
If you ask for more parts than are there, you get the whole string.
.xd "string" "clipfront( string s, int num )"
.P
Returns a string with the frontmost \fInum\fP characters removed.
.xd "string" "leftmost( string s, int num )"
.P
Returns a string with only the frontmost (left) \fInum\fP characters.  The
resultant string thus has a maximum length of \fInum\fP.
.xd "string" "domain( string mailaddress )"
.P
This returns everything in a string after the first @-sign.  For example,
given ``fbaggins@bagend.shire.midearth,'' this returns just
``bagend.shire.midearth.''
.xd "string" "concat( string s1, string s2 )"
.P
This function returns a new string that is the concatenation of the two
argument strings. 
.xd "string" "drop_re( string subject )"
.P
This function returns the argument string with any spaces and ``Re:''
prefixes removed from the front.  It is meant to be applied to subject
lines to remove those ever present prefixes.  No matter how many there
are, it removes them all.
.xd "string" "literal\_pattern( string pat )"
.P
This function returns the argument string with any regular expression
``metacharacters'' escaped so that they will match only the literal
character they represent.   This allows the use of strings you import
from the outside to be used as patterns without worrying about
regular expression characters.
.xd "string" "permstring( string s )"
.P
Normally all strings and arrays created in the process of dealing with
an article are temporary.  They become undefined at the start of each
new article.  You can create a permanent string with the use of this
function.
.P
Beware that creating too many permanent strings can quickly waste memory.
.xd "string" "lower( string s )"
.P
Returns a string with
all upper case characters in the source string mapped to lower case.
.xd "procedure" "dprintf( string format, arg, ... )"
.P
This very special procedure can help you debug your NewsClip programs.
It performs a C style ``printf'' to the standard error.   It is only
for use by C programmers.
.P
Be warned that the automatic conversion of newsgroup and userid values to
strings does not apply here.  Newsgroup values will show up as integers,
and userid values will not work at all.  If you wish these as strings,
assign them to string variables before printing them.
(\fBPre-declared\fP)
.xd "procedure" "subscribe( string groupname )"
.P
This special procedure adds the argument string to the \fB.newsrc\fP
file as a subscribed group.  Naturally, this only works in the various
\fInewsrc\fP processing modes, it particular \fIbatch\fP mode.   The group
will be entered with no articles read.
.P
If the group was already a subscribed group, nothing is done.  If the
group was an unsubscribed group already present in the \fB.newsrc\fP,
and the \fI+unusubscribed\fP option has been used, the group will be
resubscribed to, with the list of seen articles intact.   If that option
is not used, the group name will be added to the end of the \fB.newsrc\fP
even though it already exists, making two entires, one subscribed and
one not subscribed.  This is not recommended.
.P
This procedure is primarily intended for programs that feed other sites.
In such cases, you will wish to scan the special \fBcontrol\fP newsgroup
for \fBnewgroup\fP control messages, subscribing the site to all new
groups that match the patterns desired.  You can also do this when
filtering in the stand-alone \fInewsrc\fP mode.
.P
See the sample feed program that comes with the system for an example of
use of this procedure.




.H 1 "Installation"
.P
If a site licence for the NewsClip system has been arranged, installation
should be performed by a system administrator, as it is a good idea to
install a couple of NewsClip's files into system directories.
.P
If you have a binary single-user licence, you need only create a
distribution list (and that only if you want to check article distribution
levels).  You may then place the \fBncc\fP compiler anywhere in your
command \fB$PATH\fP and compile, so long as the \fBnewsclip.a\fP and
\fBucode.h\fP files are in your current directory when you compile.
See below for more details.

.H 2 "Distribution"
.P
The program is usually distributed via uucp dialup.  A compressed
``tar'' file is provided.  Manuals are sent via normal means, although
an \fBn/troff\fP source for the manual is available to site licence
customers.
.P
Xenix customers can receive the distribution on floppy disk, in which case
the disk(s) will either be 360K regular floppies or 1.2 Megabyte high
density floppies.  They will be in ``tar'' format.
.P
If no other means is available, the distribution may also be had on
MS-DOS floppies, as many users have a means of copying up from an MS-DOS
machine to their Unix system.   Other forms of distribution can be
arranged upon customer request.

.H 2 "Source Code Installation"
.P
First create a directory for NewsClip source and unpack the source
distribution in it.  Usually, this comes as a ``tar'' file, so you issue
the command:
.Bb
tar xf newsclip.tar
.Be
in that directory.   If the package is compressed (the file is
\fBnewsclip.tar.Z\fP) you need to issue the command:
.Bb
uncompress newsclip.tar
.Be
first, or if you want to do it all at once:
.Bb
compress -d <newsclip.tar.Z | tar xf -
.Be
(The source code to a decompressing program is available upon request.)
.P
You will now have a directory full of NewsClip source, special files and
a subdirectory containing the NewsClip compiler.
.P
To begin, you must pick a definitions file for your variant of the Unix
operating system.   These files are of the form \fBsysdefs.\fP\fIOS\fP.
Copy the appropriate file to the file \fBsysdefs.h\fP.   The files you
may choose from are:
.sp 0.5V
.in 0.4in

.sp 0.7V
.ti -0.4in
\fBsysdefs.sysv\fP
.P
For System III or System V AT&T Unix systems, including Xenix/386
.sp 0.7V
.ti -0.4in
\fBsysdefs.bsd\fP
.P
For most recent BSD, Mach and SunOS systems.  This assumes that you
have the \fBgethostname()\fP system call, which some early BSD systems
do not have.  It also assumes you don't have the System V string library.
.sp 0.7V
.ti -0.4in
\fBsysdefs.x286\fP
.P
For Xenix/286, this arranges for large model operation.  Small model is
also possible, but can easily run out of memory.  Use \fBsysdefs.sysv\fP
if this is what you wish.  You will also have to alter the
\fBMakefile\fP to use the Xenix/286 \fBCFLAGS\fP and \fBLFLAGS\fP.
.sp 0.7V
.ti -0.4in
\fBsysdefs.v7\fP
.P
For older systems without the \fBgethostname\fP or \fBuname\fP system
calls.  If this is you, you should either create a file called
\fB/etc/systemid\fP that contains your UUCP site name,  or
edit \fBsysdefs.h\fP to include the file \fBwhoami.h\fP so that
the \fBsysname\fP symbol is defined to give that site name.
.in -0.4in
.P
After you have created \fBsysdefs.h\fP you should go through it with an
editor to make sure that everything is defined properly.  The comments
in that file should lead you through any changes.   Unless you are in the
``UUCP'' mail domain, you will definitely have to go in to define and
edit the \fBMAILDOMAIN\fP symbol.   If you keep your news spools or
news library in some place other than the standards (\fB/usr/spool/news\fP
and \fB/usr/lib/news\fP) you will have to edit defined symbols
\fBNEWSLIB\fP and \fBNEWSSPOOL\fP).
.P
Now you are almost ready to ``make.''  Edit the \fBMakefile\fP and make sure
everything is Ok.  In particular, if you are compiling for Xenix/286
with large model, edit the \fBCFLAGS\fP definition in the \fBMakefile\fP
appropriately -- comments will tell you what to do.   Also edit the
definition for \fBLIBDIR\fP if your news library is not \fB/usr/lib/news\fP.
.P
Edit the \fBCFLAGS\fP variable in \fBcomp/Makefile\fP as well.
.P
Edit the variable \fBCOMDIR\fP to name the local commands directory where
the \fBncc\fP compiler executable should go, and edit the variable
\fBMANDIR\fP to indicate where the \fBnroff\fP source for the man
pages should be placed.
.P
Now type:
.Bb
make all
.Be
and assuming all is well, the newsclip library \fBcliplib.a\fP will be
made.  Then the compiler \fBncc\fP will be made, and the \fB.newsrc\fP
generating program \fBmknewsrc\fP.
.P
You can test the compiler and almost all features of the system now by
performing compiles in the current directory.  Before installing, there
is one more task to perform.
.H 2 "Distribution List"
.P
The distribution level feature of NewsClip requires that you create
a file listing the sizes of the standard NewsClip distributions and
all USENET distributions that are visible on your machine.   A sample
file called \fBdistlist\fP exists, which you should use as the basis for
your file.   Copy the file to your news library directory, ie. to
\fB/usr/lib/news/distlist\fP.
.P
Now edit it.  The file consists of lines with a USENET distribution,
some whitespace, and an integer that estimates the number of sites in
that distribution.  The estimates don't have to be correct, but it is
important that they be ordered, so that larger distributions have larger
numbers.
.P
It is also important that the NewsClip special distributions have numbers
that exactly match their corresponding distribution at your site.  For
example, \fBcity\fP should match the number you give for your local
city-wide distribution.
.P
You can leave the numbers for the global distributions as they are, or
update them.  Don't ever use a number larger than an integer can hold.
You should delete the sample local distributions (\fBkw\fP, \fBuw\fP,
\fBont\fP, \fBcan\fP, \fBna\fP) unless they apply to you.
.P
If you can't install this file in the news library directory, install
it in the same directory as your \fB.newsrc\fP file.  In fact,
NewsClip programs look there first, so users can provide their own
distribution lists as desired.

.H 2 "Full Install"
.P
Once you are satisfied everything is working, become ``root'' and:
.Bb
make install
.Be
When you are done, you can:
.Bb
make clean
.Be
to remove generated object files and executables.

.H 2 "Modifying RN & Other Readers"
.P
With the distribution you will find a file called \fBrnpatches\fP which
lists the small set of changes you need to apply in the RN source
directory.   There are only half a dozen or so.
.P
You also have to copy the files \fBfiltpipe.c\fP and \fBpipemode.h\fP to the
RN source directory, so that they may be linked in with RN when you
compile it.
.P
Be sure to add the \fBNEWSFILTER\fP definition to ``config.h'' or
some other appropriate header file.  If you want ``real time''
(as you read) filtering, define \fBRTFILTER\fP there as well.  If
you don't, filtering will all be done at the start of each newsgroup,
much like the kill file.
.P
Compile and test your new RN, and when you are satisifed, install it
as the official version.
.P
Even single user licencees of NewsClip can modify their RN program,
even if the system administrator is not interested.  The RN program
is a ``freeware'' program -- anybody can get and compile the source
code.   Just ensure that you don't have 30 people on the same machine
who all have their own privately modified RN programs -- that would be
a large waste of your system's resources.

.H 2 "Single User"
.P
If you are not a system administrator or you don't have source code, you
will have to place NewsClip files within your own personal directory
structure.
.P
The easiest thing to do is just to keep all your files -- the compiler,
the library and other associated files -- in one directory, and do all
your compiling there.
.P
The file \fBcliplib.a\fP should either be in the current directory when
you compile, or its name can be specified as a command line argument to
the \fBncc\fP compiler.
.P
The file \fBucode.h\fP should also be in the current directory when
you compile, or the directory in which it is found should be specified
with the \fIInclude=dir\fP option to the \fBncc\fP compiler.
.P
When all else fails, you can always compile with the \fI-link\fP option
and perform the C compile on your own, for example in a \fBmake\fP file.
.P
The \fBdistlist\fP file should reside in the same directory as your
\fB.newsrc\fP file when you run your NewsClip programs.  This is
either your home directory, or the directory specified with the
\fBDOTDIR\fP environment variable or other means.  It can also reside
in the current directory when you run your news clipping program.
.P
You may keep your \fBncc\fP and other executable files in any suitable
place, such as a private directory listed in your \fBPATH\fP environment
variable.




.H 1 "RN"
.P
The most popular news reading program is probably the \fBRN\fP newsreader
by Larry Wall.   This is a highly interactive, screen oriented newsreader.
.P
We have provided an extra source file and a small set of source code
patches so that the RN newsreader can be adapted to talk to NewsClip
filter programs in the \fIpipe\fP mode.  This is the best way to
use NewsClip.
.P
Some machines don't have USENET news files on them, but they have access
to fast (usually ethernet) network connections to other machines that
do, usually using the ``TCP/IP'' network protocol.  If the machine with
the news files runs a special program called an ``NNTP server,'' then
users on the news-less machine can run a special variant of RN called
``RRN.''  The RRN program obtains all its news articles by asking the
NNTP server to provide them over a network connection.   It is possible
to use NewsClip with such systems in a more limited way.
.P
If you're a system administrator with access to the RN source, check
our special on-disk file for information on how to make a new version
of RN.
.P
There are other newsreaders that can use the special \fIpipe\fP mode
to talk to NewsClip programs.  One that is forthcoming is the
``TMN Netnews'' or ``News 3.0'' system by Eric Raymond.  Documentation on
how to talk to a filter program like NewsClip is provided in the manual
for TMN.

.H 2 "Basic Use"
.P
Write a NewsClip program that filters your news.  Compile it to an
executable called \fBnclip\fP, which is the default.
.Bb
ncc myprog.nc
.Be
.P
Now place the \fBnclip\fP program in the same directory as your
\fB.newsrc\fP file -- this is usually your home directory.  If you
don't want it there, you can also place it in any of the command search
directories specified in your \fBPATH\fP environment variable.  Finally,
you can make an environment variable called \fBNCLIP\fP which contains
the pathname of your news filtering program.
.P
Now run RN or RRN.   When you read in normal sequence, rejected
articles will be quickly skipped over.   The message,
``Filtering \fIarticle-num\fP'' will appear for each rejected article.
.P
This only works when you read in normal sequence.  If you read out
of sequence, by searching or deliberately typing in article numbers
or moving back and forth with RN commands like ``\fB-\fP,'' ``P'' etc.,
you will still be able to read articles that would otherwise be
rejected.

.H 3 "Two Adaptations"
.P
We have arranged NewsClip to filter as you read.  That means articles
are not rejected until you actually try to read them.  If you ask RN
for a subject list, (the ``='' command) you will see articles in the
list that might be rejected.   You won't see them when it comes
time to read them later.
.P
Our adaptations to RN can optionally be made to work like RN's
``kill'' files.  In this case, all articles in a group are filtered
when you enter it.  This takes time, but requires no processing as
you read.  It also means rejected articles won't show up in subject
lists.  In general, this fits in better with RN's way of doing things,
but it also involves an annoying delay every time you enter a group.
It is up to your system administrator to pick the adaptation desired.

.H 2 "NewsFilter Bugs"
.P
If your filtering program should crash for some reason -- perhaps you
indexed into an array beyond its bounds -- then RN will give up
talking to it and accept all articles.  You will get a brief message
indicating that the filter has shut down, but this can easily be lost
in RN's rapid screen updates.
.P
You should check your filter from time to time in \fIlist\fP mode to
ensure that it is working as you expect.

.H 2 "Sending Commands"
.P
There is a special entry point procedure called \fBcommand\fP which
you can define in your newsclip programs.  This gets a string
argument, which is intended to be a command from the newsreader.
.P
We have added an extra command to RN that works at the article
level.  It is ``\fBT\fP,'' because it ``talks'' to the news filter.
(Ok, so that's not a great mnemonic.  All the nice ones were taken.)
.P
If you type a command to RN that starts with a \fBT\fP, the entire string
of that command will be passed to your NewsClip \fBcommand\fP
procedure.   Try something simple like this:
.Bb
procedure
command( string com )
{
	dprintf( "The command was %s\\n", com );
	accept;		/* means this command was valid */
}
.Be
You will find that when you issue a \fBT\fP command, your news filtering
program prints it out.
.P
The trick is to interpret the string into commands for your newsfilter.
In general, these will be ``kill'' commands, requesting that your
filter update databases to accept or reject certain kinds of articles.
For example, \fBTKF <1234.123@foo.bar>\fP might be a request to kill
all followups to the article with message-id \fB<1234.123@foo.bar>\fP.
\fBTKU bad@worse.com (Evil Guy)\fP might be a request to kill all articles
by the specified user.
.P
It is entirely up to you to interpret such commands, and entirely up
to the RN user (usually that's you as well) to send them.

.H 2 "Interpreting Commands"
.P
Here's a sample procedure to interpret some commands like the ones
above.  We'll show you how to send them later.
.Bb
procedure
command( string com )
{
	userid fromwho;
	string arg;		/* argument to kill command */
	extern int chindex( string, int );
	extern string lower( string );
	extern string clipfront( string, int );
	string array artrefs;	/* passed references array */
	if( chindex( com,1 ) != 'K' )
		reject;
	arg = clipfront(com,4);
	switch( chindex( com,2 ) ) {
	  case 'F':	/* followups */
		badmes[arg] = true;
		accept;
	  case 'T':	/* all followups of top parent */
		parse artrefs = arg, " ";
		if( count(artrefs) > 0 )
			badmes[artrefs[0]] = true;
		 else
			reject;
		accept;
		
	  case 'U':	/* a user */
		parse fromwho = lower(arg);
		baduser[fromwho] = true;
		accept;
	  case 'S':	/* a subject with "re:" stripped off */
		badsubject[lower(arg)] = true;
		accept;
	  case 's':	/* subject pattern */
		killpatterns[lower(arg)] = true;
		accept;
	  }
	reject;		/* otherwise was an invalid command */
}
.Be
.P
First of all, we insist that the second letter of the command be
a ``K,'' as these are kill commands.  Then we switch on the 3rd letter
to decide what command it really is.  The command argument starts on the 5th
character (index 4), as the 4th will be a space.
.P
These commands update databases.  One, \fBbadmes\fP is a database of
the message-ids of articles we don't like.  Articles with references to
these IDs will be rejected in the \fBarticle\fP procedure.
.P
We also have a database called \fBbaduser\fP which lists users we don't
like the postings of.  All postings from those users will be rejected.
In addition, we put the message-ids of those rejected postings into
the \fBbadmes\fP database, so that we don't see the followups, either.
.H 3 "Kill Topic"
.P
The ``T'' command (kill a topic) is a variant of the ``F'' command, which
kills all followups.  This expects to get passed the entire
\fBReferences:\fP list for the article.  It will pick the first reference,
which is the oldest parent article (in theory the original) and put it
in the database.
.P
This causes not just the followups to our current article to be rejected,
but all the followups to the original article that started the discussion
which it is part of.   In theory, that eliminates an entire topic from
your reading.  Unfortunately, not all followups really contain a true
\fBReferences:\fP chain, so life isn't perfect.
.P
You could easily add your own commands to this list.  You might want
to mark good messages as well as bad ones, and good users.  You could
mark subject lines, manually entered killing patterns or any other
information you can store.   Usually you store these things in a
database which you will write out at the end of your session, and read
in at the beginning of the next one.
.P
You can also store information that only lasts for the duration
of the current session, of course.

.H 3 "Using the Databases"
.P
Of course, to use the databases defined above, you need to read and
write them:
.Bb
/* Header symbols */
extern string subject;
extern string message_id;
extern string array references;
extern userid from;
/* Databases */
database badmes;		/* bad message-ids */
database baduser;		/* users I don't like */
database gooduser;		/* users I do like */
database badsubject;		/* subject line database */
database killpatterns;		/* kill patterns for subject lines */
procedure init()
{
	badmes = read_database( "~/News/badmes" );
	baduser = read_database( "~/News/baduser" );
	gooduser = read_database( "~/News/gooduser" );
	badsubject = read_database( "~/News/badsubject" );
	killpatterns = read_database( "~/News/killpatterns" );
}
procedure terminate()
{
	extern datetime time_now;
	/* save out my updated databases */
	write_database( badmes, "~/News/badmes", time_now-2*week );
	write_database( baduser, "~/News/baduser", time_now-month );
	write_database( badsubject, "~/News/badsubject", time_now -
		2*week );
	write_database( killpatterns, "~/News/killpatterns", time_now -
		2*week );
	/* Gooduser gets updated by hand */
}
.Be
.P
and you also need an article routine to deal with them:
.Bb
procedure
article()
{
	extern string drop_re( string );
	/* accept articles from desired users immediately */
	accept if from in gooduser;
	/* is this a followup to a killed chain? */
	reject if references != nilarray && references in badmes;
	/* If from a hated user, reject and kill the chain too */
	if( from in baduser ) {
		/* reject all followups, too */
		badmes[message_id] = true;
		reject;
		}
	/* if the subject is explicitly a bad one, or a keyword from our
	   pattern list is found in it, reject */
	if( drop_re(subject) in badsubject || subject has killpatterns )
		reject;
}
.Be

.H 2 "Sending the Commands"
.P
You could send these commands yourself, by typing them in starting with
a \fBT\fP.  RN, however, has a powerful macro facility which you should
use to send your kill commands.   In RN, you place macros in a file
called \fB.rnmac\fP, in the same directory as the \fB.newsrc\fP file.
(Usually your home directory)
.P
For the full story on RN macros, see the RN manual.  In general, macro
definitions consist of a string that lists the key sequence required
to activate the macro, followed by white space and the key sequence
the macro expands to.   Type \fB&&\fP to RN to see your macros. 
.P
Let's say you want the \fBK\fP key to issue the Kill Topic command that
we have defined.  (Normally this causes RN to store the subject
of the current message in its ``kill'' file, but you probably won't be
using kill files much at this point.   Your macro might look like:
.Bb
K	TKT %R\\n
.Be
.P
This means that when you press ``K,'' RN acts like you typed the string
on the right.  In RN macros, a ``%'' indicates a special code is to
be expanded.  In this case, ``%R'' expands to a proper \fBReferences\fP
line for a followup to the current message.   Our ``TKT'' command takes
the first ID from this list, and puts it in the bad message database.
.P
Try this out.  Put a \fBdprintf\fP statement in your command processor
to make sure everything's happening as you like it.   A full set
of macros might look like this -- this time with 2 letter macros.
.Bb
# Kill all followups to current article
KF	TKF %i\\nn
# Kill all messages from poster of this article
KU	TKU %f\\n!mail '%f' <%p/killmessage\\nn
# Kill all followups to immediate parent article (cousins)
KC	TKF %r\\nn
# Kill all followups to the original parent of this discussion. (topic)
KT	TKT %R\\nn
# Kill all articles with exactly the same subject, and all followups
KS	TKS %s\\nTKF %i\\nn
# kill all articles with the user-provided pattern in the subject
Ks	TKs %"Kill Pattern? "\\n
.Be
.P
You might adapt these macros to add a regular ``k'' on the end, so that
RN performs its own local kill on all articles with the same subject
as your article when you issue the command.

.H 4 "Eliminating a User"
.P
The above sample ``KU'' command sends mail to the user whose postings you have
decided to no longer read.  We suggest you send a polite message of
the following form should you do this.  Put text like this in the
file \fBNews/killmessage\fP:  (\fBNews\fP is your private News directory.)
.in 0.5in
.P
This is an automatic message:
.P
I have decided, for various reasons, to filter out all USENET news
articles posted by you from now on.  This will be done by automatic
software.
.P
There are many reasons why I decide to no longer read the writings of
certain people from time to time.  The most common one is simply a lack
of time.  It may be as 'personal' as the decison to no longer pick up
a magazine one once read regularly.
.P
This message is being sent to you because you may or may not realize that
certain aspects of your writings are driving people away from them.
If this is the case, you may wish to reconsider your actions on USENET.
.P
Once again, this is an automatic message, and you need not reply unless
you are unsure what USENET activities you have done which would cause
me to choose to no longer read your writings.
.in -0.5in
You might also decide to prompt for a further reason and add that to
the text of the message.
.H 3 "Local vs. Global"
.P
This sample control program updates global databases, but it could
also be set up to update databases on a per-newsgroup basis.  You could
have different commands for local killing and global killing, as desired.

.H 2 "Other Ideas"
.P
You can do a great deal with this feature.  While normally you would use
it to reject articles, other things are possible.
Instead, you might decide, when you
see an article you like, to have a command that ensures you see all
the followups to that article.  Later, when you get bored, you could
have another message to cancel this request.
.P
You could set up your NewsClip program to read something like:
.Bb
/* accept original articles */
accept if references == nilarray;
/* accept followups to good articles */
accept if references in goodlist;
reject;
.Be
This would only show you original, non-followup articles, and articles
that are followups to originals that you liked.  You would then see only
a very short set of articles in your news reading sessions.  If you saw
one you were interested in, you would send a command down to your
newsfilter to put the message-id or subject of that article in your
database of good articles.
.P
You would then see that chain of articles
until you sent down a message to remove the article from your database.
.P
Because our normal configuration is to filter as you read, you would have
to make your decision the moment you saw the original article.  Because
of the immediate communication, the followups to that article would get
accepted right there in the same session, as you come to them.
This would not work if followups appear before their parent articles,
as sometimes happens due to funny news transmission problems.

.H 2 "Using \fInewsrc\fP Mode"
.P
While real-time filtering in partnership with RN is great, you may
also find use for automatic filtering in \fInewsrc\fP mode.
.P
For example, if you have groups where you filter almost all the
articles out, why wait to do this during your newsreading session?
.P
Instead, arrange to run your NewsClip program at night, perhaps every
night, and have it filter for you.  Just say:
.Bb
nclip mode=newsrc
.Be
and it will do the work.  You can't run RN while this is taking place.
.P
You may decide to only do night-time filtering of certain groups.  In
this case, create a special ``las'' file that lists those groups, and
use the command:
.Bb
nclip mode=newsrc las=lasfile +only
.Be
.P
You might even have a different program for night-time filtering than
you use for newsreading -- it's up to you.  You could use the same
program, and have it check command line options set with \fIoption=\fP.
You might want to use the special \fI+unsubscribed\fP option to scan
unsubscribed groups late at night.   You might arrange to only scan
the unsubscribed groups once a week, and scan the other groups more
frequently.
.P
Of course, if new articles arrive during your newsreading session, they
won't be scanned by your late night filter session, but rather will be
processed by your live filter.  This should not normally be a problem.

.H 3 "RRN"
.P
If you use RRN, and don't have news spool files on your machine, you
can't make use of \fInewsrc\fP mode.  Live filtering is the only option
available to you.

.H 2 "Kill Files"
.P
RN's ``Kill File'' facility has not been disabled by our adaptations.
You can use RN kill files in combination with NewsClip filtering.
In fact, you can filter some groups with kill files and other
groups with NewsClip, as you desire.
.P
RN Kill files get to go first.  NewsClip filtering comes after that.
This can be changed by the system administrator if you desire to
have NewsClip filtering work as a pre-pass, like the kill file.



.H 1 "Licence"
.P
The NewsClip\*(Tm system is Copyright {copyright} 1989 by Looking Glass
Software Limited.  This manual and other associated documents, unless
specified otherwise, are Copyright {copyright} 1989 by Looking Glass
Software Limited.   These programs and documents may be used only by licenced
customers of the NewsClip system, or those performing a limited
duration evaluation of the system.
.P
Since this is a programming language system, you might assume that you
are free to give out or sell compiled programs.  This is not the case.
The compiler in this system is actually fairly simple, and just checks
and maps types and statements.  It makes the language more readable and
reliable.
.P
The real work is done by the library, which is quite complex.  If you
look at your executables, you will find that the library makes up the
bulk of them.
.P
You are free to do whatever you wish with your newsclip source programs,
the intermediate C programs the compiler outputs, and the object modules
your C compiler makes from those.  You can't, however, give out our
library in any form without our permission.  We will arrange permission
under certain circumstances -- send us mail.

.H 2 "Single User"
.P
A single user licence is just that -- a licence for a single person
to use NewsClip to filter news.  You can't let other people use it, and
you can't filter feeds with it.   You can, however, run it on more
than one machine, as long as it's just you using it on each machine.

.H 2 "Site"
.P
A site licence lets everybody on the licenced computer use NewsClip
tools on that computer.  Everybody can compile their own programs, or
one person can compile programs for other people on that computer.
Feeds can be filtered, both to and from.
.P
Site licences come in different sizes -- workstation, minicomputer,
BBS, network and mainframe.  If you grow in a dramatic way, an upgrade
can be easily arranged.

.H 2 "Feeds"
.P
Naturally it's easy to filter your outgoing feeds with NewsClip.  You
will also want to filter the feed that feeds you.  That means running
your NewsClip feed program on the feeding machine.
.P
To do this, you are permitted to move the library source to your feed
machine, and compile it there.  Please inform the administrators of that
machine that they must pay a licence fee if they wish to use the software
other than for feeding your site.

.H 2 "Evalu-Ware"
.P
Some versions of NewsClip are released as what we term ``Evalu-Ware'' --
our name for what some people have called ``Shareware.''  (We use the
different name simply because the ``Share'' in \fIShareware\fP has led
many people to believe such programs are not regular commercial software
products.   In fact, Evalu-ware products are fully commercial software
systems.  They simply allow an unusual form of distribution that benefits
both the customer and the publisher.
.P
In particular, users can access the software far more easily (particularly
in the case of Unix software, for which there is no single medium) and they
can perform a no-risk evaluation of the actual product.
.P
You can copy the Evalu-Ware versions of the NewsClip system freely.  You
can leave the source code available for network access and distribute it to
your friends and associates.
.P
When you get the source code, you may compile it and try out the system.
Use it and experiment with it for a while, then make your own judgement
about whether you wish to continue using it.   If you do, call or write
us to arrange a licence.   You can phone 519-884-7473, or 800-USE-NETS
in the USA.   Or mail to \fBcliporder@clarinet.com\fP.   Read the file
\fBLicence\fP in the source directory for full details.
.P
If you don't wish to continue using it, simply erase the binaries and
you have lost nothing.

.H 2 "Notes"
.P
Newsclip is a trademark of Looking Glass Software Limited.
.P
ClariNet is a trademark of Clarinet Communications Corp.
.P
Unix is a trademark of AT&T Bell Labs.
