
/* Declarations that run before the user program */
/* Copyright 1989 Looking Glass Software Limited.  All Rights Reserved. */


#ifdef INTS_32
typedef int int32;
typedef short int16;
#else
typedef long int32;
typedef int int16;
#endif

typedef long datehold;
typedef int newsgroup;
typedef unsigned char byte;
typedef unsigned char bool;

/* fake definition for database pointer */
typedef struct database_struct {
		int foo;
		} *dbptr;

typedef struct user_name {
	char *emailname;	/* the mail name, ie: user@site.foo */
	char *fullname;		/* the full name or comment */
	} username;


typedef union d_union {
	int	uinteger;	/* integer or newsgroup types */
	long	udate;		/* date or long int types */
	char	*ustring;	/* string types */
	char	*regexp;	/* compiled regular expressions */
	username *uusername;	/* a user name struct */
	} datau;

/* The struct for a multi-valued array.  The array is declared with only
   one element, but in fact this structure can be allocated with enough
   space for any number of elements, and C lets us access them without
   checks. */

typedef struct h_array {
	int arsize;		/* number of elements in the array */
	byte artype;		/* type of the elements in the array */
	datau vals[1];		/* actually an extensible array, as allocated */
	} array;

/* database structure */

typedef struct db_record {
	char *name;
	struct db_record *next;
	byte hflags;
	int intval;			/* the cell's value */
	datehold access_date;		/* last time of access */
	} userdb;

typedef struct ng_record {
	char *key;
	struct ng_record *next;
	byte hflags;
	/* extras not important */
	} ngrec;

/* Struct defining header items to process */
struct hitem_list {
	char *hname;		/* name of header */
	int dtype;		/* data type of header data */
	char *delims;		/* delimiters to use if an array */
	datau *var;		/* address of variable to put data into */
	};

extern ngrec **ngarray;
extern int score;
#define Reject -30000
#define Accept 30000

/* Macros used in the code */

#define count(x)  (x->arsize)		/* array count */
#define mailname(x)	(x->emailname)
#define realname(x)	(x->fullname)	/* from id full name */
#define ngn(x)	ngarray[x]->key		/* news group name */

/* date constants */
#define	day		(60*60*24l)
#define	week		(7*day)
#define	month		2629728l	/* special 'average' month 30.4 days */
/* special text variables */
#define signature	1
#define included	2
#define newtext		4
#define	text		6	
#define	body		7

#define article_bytes art_bytes()

/* function declarations for predefineds */
extern dbptr read_database();
extern write_database();
extern free_database();
extern dbptr fresh_database();

#define chindex(str,dex)  str[dex]
#define permstring allocstring

extern int db_lookup();			/* user database lookup fun */
extern userdb *db_create();		/* lookup and create function */
extern userdb *ufirst_rec();
#define unext_rec(db,rec)	rec->next

/* array creating routines */
extern array *uparse_array();
extern array *fresh_array();


/* special externals, that might be repeated, for indirectly referenced
   header items */

extern array *newsgroups;		/* always present */
extern array *distribution;		/* for Rdistribution */
extern array *followup_to;		/* for Rfollowup_to */
extern array *references;		/* for is_followup */
extern username *reply_to;		/* for Rreply_to */
extern username *sender;		/* For Rsender */
extern username *from;			/* for the two above */

#define true 1
#define false 0

/* various nil constants */
#define nilstring (char *) 0
#define niluserid (username *)0
#define nildatabase (dbptr)0
#define nilnewsgroup (newsgroup)0
#define nilarray (array *)0

/* Functions for the IN and HAS operators all return booleans (ints) and
   as such do not have to be declared */
