
/* Copyright 1989 Looking Glass Software Limited.  All Rights Reserved. */


#include "common.h"


#include "tree.h"
#include "node.h"
#include "db.h"
/* The kinds of symbols */

#define ST_VAR		1
#define ST_LABEL	2
#define ST_FUNC		3
#define ST_PROC		4
#define ST_LABREF	5		/* an undeclared label ref */
/*#define ST_CONST	6		UNUSED */
#define ST_TEXT		7		/* text symbol */

typedef struct sym_entry {
	char *name;
	struct sym_entry *next;
	byte hflags;
	byte sflags;		/* our symbol flags */
	byte decl_type;		/* what kind of symbol this is */
	dtype type;		/* user type */
	struct typelist * argtypes;	/* list of argument types */
	} *symptr;

/* Symbol Flags */

#define NF_DECLARED 1		/* this symbol has been declared */
#define NF_PREFIX 2		/* this is a user global and needs a prefix */

/* special struct for outside symtab array */

struct outsym {
	char *name;		/* name of symbol */
	byte odecl_type;	/* outside sym decl type */
	dtype otype;		/* actual return type etc. */
	byte flags;		/* special flags */
	struct typelist *atlist;	/* argument type list */
	};


/* struct for newsgroup names and patterns and other things that get
   mapped into numbers */

typedef struct ng_name {
	char *name;
	struct ng_name *next;
	byte hflags;
	int ngnum;			/* the newsgroup number */
	struct ng_name *ng_next;	/* chain of newsgroups in order */
	} numstring;

struct stringmap {
	dbptr	dbase;			/* the database */
	int	counter;		/* counter of elements */
	numstring *first;		/* first in chain */
	numstring *current;		/* current in chain */
	};


#include "cfuncs.h"

/* symbol flags */

#define SPC_HEADER	1		/* make a header reference */
#define SPC_STAT	2		/* turn on needs stat */
#define SPC_FROM	3		/* insist that from header be refed */
#define SPC_NEWSGROUPS	4		/* insist that newsgroups be refed */
#define SPC_REF		5		/* needs the references line */
#define SPC_DIST	6		/* wants distribution level */

#define OSF_SPECIAL_MASK 7
#define SF_FORWARD 8			/* This is a forward reference */
#define SF_LOCAL 16			/* this is a local symbol */
#define OSF_REFERENCED 32		/* this symbols has been referenced
					   already */
#define OSF_PREDEF 64			/* this symbol does not have to be
					   declared externally */
#define OSF_CONST 128			/* the symbol is a constant */

/* error names */
#define SYNTAX_ERROR 2
#define TYPE_ERROR 1

