/* The declarations common to the compiler and runtime modules */
/* Copyright 1989 Looking Glass Software Limited.  All Rights Reserved. */


#include "sysdefs.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>

#define DEBUG 1
#define debug 1
#define debstr stderr

#include "debug.h"

#ifdef INTS_32
typedef int int32;
typedef short int16;
#else
typedef long int32;
typedef int int16;
#endif

typedef long datehold;
typedef int newsgroup;

/* The types for data values in NL programs */

#define T_NONE 0
#define T_INTEGER 1
#define T_DATE 2
#define T_NEWSGROUP 3
#define T_NUMERIC T_NEWSGROUP	/* Less or equal this are equiv numeric types */
#define T_STRING 4
#define T_USERNAME 5
#define T_DATABASE 6

/* internal types */
#define T_TEXT 7		/* article body strings */
#define T_GENARRAY	10	/* any kind of array */
#define T_GENPTR	11	/* any kind of pointer type */

#define T_ARRAY 64
#define T_DUALCASE 128
#define T_BASETYPE 63

#define arrayof(x) (T_ARRAY|x)

typedef unsigned char byte;
typedef unsigned char bool;
typedef byte dtype;		/* data type */


#define FALSE 0
#define TRUE 1

/* The result of parsing a mail From: address */

typedef struct user_name {
	char *emailname;	/* the mail name, ie: user@site.foo */
	char *fullname;		/* the full name or comment */
	} username;


typedef union d_union {
	int	uinteger;	/* integer or newsgroup types */
	long	udate;		/* date or long int types */
	char	*ustring;	/* string types */
	char	*regexp;	/* compiled regular expressions */
	username *uusername;	/* a user name struct */
	} datau;

/* The struct for a multi-valued array.  The array is declared with only
   one element, but in fact this structure can be allocated with enough
   space for any number of elements, and C lets us access them without
   checks. */

typedef struct h_array {
	int arsize;		/* number of elements in the array */
	byte artype;		/* type of the elements in the array */
	datau vals[1];		/* actually an extensible array, as allocated */
	} array;


/* Struct defining header items to process */
struct hitem_list {
	char *hname;		/* name of header */
	int dtype;		/* data type of header data */
	char *delims;		/* delimiters to use if an array */
	datau *var;		/* address of variable to put data into */
	};

/* useful macros */

#define max(x,y)	((x)>(y) ? (x):(y))
#define min(x,y)	((x)<(y) ? (x):(y))

/* case */

/* lower case if we know it's a letter. (ASCII only) */
#define lowerlet(x) (x | 0x20)

/* lower case after testing. (ASCII only) */
#define lowcase(x) (((x) >= 'A' && (x) <= 'Z') ? (x) | 0x20 : (x))
