#! /usr/bin/perl -w

# Copyright (c) 2001                      RIPE NCC
# 
# 
# All Rights Reserved
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
# 
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: flags2hdr.pl,v 1.3 2003/07/04 14:13:19 engin Exp $

# file: flags2hdr.pl
# description: convert FLAGS.txt into a C header file

use strict;
use English;

# get output filename
if (@ARGV != 1) {
    print STDERR "Syntax: $PROGRAM_NAME [output_file.h]\n";
    exit(1);
}
my $fname = shift(@ARGV);

# get a symbol to #ifdef wrap the header
my $wrapper = $fname;
$wrapper =~ s/[^A-Za-z0-9_]/_/g;
$wrapper =~ s/^([^A-Za-z_])/_$1/;

# output beginning
print "#ifndef $wrapper\n";
print "#define $wrapper\n";
print "\n";
print "char flag_txt[] = \n";

# read and convert
while (defined(my $input = <>)) {
    chomp($input);
    # escape unsavoury characters
    $input =~ s/\\/\\\\/g;
    $input =~ s/([\x00-\x1F\x7F-\xFF])/sprintf('\\x%02X', $1)/ge;
    $input =~ s/\"/\\\"/g;
    # print our line
    print "    \"$input\\n\"\\\n";
}

# output end
print ";\n";
print "\n";
print "#endif /* $wrapper */\n";

