#ifndef _EP_H_
#define _EP_H_

#include <stdio.h>
#include "lg.h"
#include <glib.h>


/* return codes used by functions in EP module
   and also referenced in dbupdate 
   set to bit values, 0,1,2,4,etc */
typedef enum
{
  EP_OK      =0, /* input processed successfully */
  EP_FAIL    =1, /* input processed with error */
  EP_FATAL   =2  /* fatal error occured, stop processing */
} EP_return_codes;

/* convert the enum to a printable string */
#define EP_ret2str(r) \
  (((r) == EP_OK)        ? "EP_OK" : \
   ((r) == EP_FAIL)      ? "EP_FAIL" : \
   ((r) == EP_FATAL)     ? "EP_FATAL" : \
                            "UNKNOWN" )

typedef void EP_input_structure_t;
typedef void EP_blob_credential_t;
typedef void (*ObjFunc) (EP_blob_credential_t* data, gpointer user_data);

void EP_init(LG_context_t* ctx, gchar* tmp_dir,
             gchar* ca_file, gchar* crl_dir);
void EP_end();

int EP_unfold(FILE* stream, gboolean is_mail, 
                               char *X509cert_file,
                               EP_input_structure_t **input_structure);

gchar* EP_get_candidate_keywords(EP_input_structure_t* input);
const gchar* EP_get_mail_hdr_field(EP_input_structure_t* input, gchar* field);
void EP_blobs_foreach(EP_input_structure_t* input, ObjFunc func, gpointer user_data);

const gchar* EP_get_blob(EP_blob_credential_t* input);
GList* EP_get_credentials(EP_blob_credential_t* input);

void EP_input_structure_free(EP_input_structure_t* input);
void EP_blob_credential_free(EP_blob_credential_t* blob_credential);

#endif
