/***************************************
  $Revision: 1.7 $

  process.cc 

  Status: NOT REVIEWED, TESTED

  Author(s):       Engin Gunduz

  ******************/ /******************
  Modification History:
        engin (01/03/2001) Created.
  ******************/ /******************
  Copyright (c) 2001                              RIPE NCC

  All Rights Reserved

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/





#include "dbupdate.h"
#include "process.h"

extern char * copyright_notice;
extern char * netupdclientIP;

extern int count_successful;
extern int count_unsuccessful;

/* process_networkupdate function processes network updates. Since dbupdate is 
   invoked by inetd for networkupdates, we simply read the standard input to get 
   the objects. It must process an object as soon as it reads it from the stdin.
   That is, there is no need for keeping a linked list of objects, so there
   won't be any object reordering */

void process_networkupdate(credentials_struct credentials,  
                           GHashTable * AUTO_NIC_hdl_hash, 
                           char * ack_file_name, 
                           GHashTable * ntfy_hash,
                           GHashTable * forw_hash,
                           GHashTable * cross_hash){


GSList *next = NULL;
int object_count = 0;
char *object = NULL;
char * line;
int result = 0;
ip_addr_t *peerip;

    /* here we will check if the peer is authorised to do networkupdates */

    /* get the IP of the peer. */
    peerip = (ip_addr_t *)malloc(sizeof(ip_addr_t));
    SK_getpeerip(0, peerip);

    /* convert it to a char *, for reporting */
    netupdclientIP = (char *)malloc(64);
    IP_addr_b2a(peerip, netupdclientIP, 64);
   
    /* and check if the peer has permission to do networkupdate 
       As the "source" to AA_can_networkupdate we use the first
       updatable source. Since currently we don't support multiple 
       sources, this is not a problem but when we support it, we must change this.
       Or, rather, we can simply change AA_can_networkupdate not to ask for
       a source. This probably also requires changing aaa table of the ripadmin
       db.  */
    if(!AA_can_networkupdate(peerip, sources[0])){
      
      printf("\n\n***You are not authorized to do network updates***\n\n");
      close(0);
      exit(1);

    }
  
    /* print the copyright notice (PW_RESP_HEADER) */
    printf("\n%s\n", copyright_notice);
    fflush(0);

    line = (char *)malloc(1024);

  
    while(fgets(line, 1023, stdin ) != NULL){

      /* first, if it is a pasword, save it, but do not regard it as an attrib */ 
      if(strstr(line, "password:") == line){
        credentials.password_list = g_slist_append(credentials.password_list, 
                                      g_strstrip(strdup(line + strlen("password:"))));
        continue;

      }
      line = UP_remove_EOLs(line); /* remove '\n's and '\r' first */

      /* remove trailing white space */
      line = g_strchomp(line); 

      if(strlen(line) == 0){/* then, this was an empty line */

        if(object != NULL){

           /* first log the object */
           UP_log_networkupdate(object, netupdclientIP);

           result = process_object(object, credentials, AUTO_NIC_hdl_hash, ack_file_name,
                      ntfy_hash, forw_hash, cross_hash);
           
           /* keep a tally */
           if(result == UP_OK){
             count_successful++;
           }else{
             count_unsuccessful++;
           }
           
           free(object);
           object = NULL;

        }

      }else{
        if(object == NULL && strlen(line) != 0){

          object = (char *)malloc(strlen(line) + 2);
          object = strcpy(object, line);
          object = strcat(object, "\n"); /* add EOL again (we removed it before) */

        }
        else{

          object = (char *)realloc(object, strlen(object) + strlen(line) + 2);
          object = strcat(object, line);
          object = strcat(object, "\n");

        }
      }
      
    }


    /* now, if at the very and of the input file there wasn't an 
       empty line, we have to add the remaining object in the 'object'
       variable */
    if(object != NULL){
       process_object(object, credentials, AUTO_NIC_hdl_hash, ack_file_name,
                      ntfy_hash, forw_hash, cross_hash);
       /* keep a tally */
       if(result == UP_OK){
         count_successful++;
       }else{
         count_unsuccessful++;
       }
       
       object = NULL;
    }

    close(0);

  
}/* process_networkupdate */




