# pgpdata2ring.pl - convert key-cert data file to PGP compatible format
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: pgpdata2ring.pl,v 2.1 1998/12/09 14:39:21 roman Exp $
#
#	$RCSfile: pgpdata2ring.pl,v $
#	$Revision: 2.1 $
#	$Author: roman $
#	$Date: 1998/12/09 14:39:21 $
#
# This script can be used to convert key-cert objects in DB data file
# to simple PGP ascii-armored format, to be imported to PGP keyring
# or whatever.
#
# Example usage:
#
#   pgpdata2ring /usr/local/ripedb/data/ripedb.kc > /var/tmp/allkeys
#   PGPPATH=/usr/local/ripedb/.pgp ; export PGPPATH
#   pgpk -a /var/tmp/allkeys
#

my($skip) = 0;

while (<>) {
  next if /^#/;
  if (/^\s*$/) {
    $skip = 0;
    next;
  }
  next if $skip;

  next unless /^\*?(\w+):\s*(.*)$/;

  if ($1 eq 'XX') {
    $skip = 1;
    next;
  }

  if ($1 eq 'kc' or $1 eq 'key-cert') {
    print "\n# $2\n\n";
    next;
  }

  if ($1 eq 'ce' or $1 eq 'certif') {
    print "$2\n";
  }
}

