# newdb.pl
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: newdb.pl,v 2.2 1997/10/02 15:26:00 chris Exp $
#
#	$RCSfile: newdb.pl,v $
#	$Revision: 2.2 $
#	$Author: chris $
#	$Date: 1997/10/02 15:26:00 $

# This is a little tool to generate an empty database which just contains
# the generation date, and the COPYRIGHT notice as defined in the config
# file. Mainly used for testing purposes.
# One should be careful with this, since it will simply overwrite existing
# database files if the -f flag is given. No Mercy.

require "rconf.pl";
require "getopts.pl";

&Getopts('f');

# You need help or have no command line arguments ?

if (!$ARGV[0]) {
	print <<"EOF";

Usage: $0 [-f] file

-f		Force new database even if file exists
filename	The name of the new database file to be generated

EOF

	exit;
}

# Check to see if file exists, and if the force overwrite flag is set

if (-e $ARGV[0] && !$opt_f) {
   print STDERR "File exists, will not overwrite\n";
   exit;
}

# Read the conf, for the COPYRIGHT notice

$conffile=$ENV{"RIPEDBCNF"};
$conffile= $RIPEConfig{DEFCONFIG} unless $conffile;
&rconf($conffile);

# Here we go ...

open(NEWDB, ">".$ARGV[0]) || &fatalerror("Cannot open $ARGV[0]: $!");

# Print generation date and copyright to the database
#
# printright is required since addkey doesn\'t work
# correct when an offset==0

&printrights(NEWDB);

# And that was it ...

close(NEWDB);

# Delete indexes in case they happen to exist ...

&delormoveindices($ARGV[0], "", 0);
&delormoveindices($ARGV[0].$CLASSLESSEXT, "", 1);

# end of script
