#       dbadd - add, delete objects
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
# Copyright (c) 1998                              RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: dbadd.pl,v 2.6 1998/07/15 18:01:24 joao Exp $
#
#	$RCSfile: dbadd.pl,v $
#	$Revision: 2.6 $
#	$Author: joao $
#	$Date: 1998/07/15 18:01:24 $

require "dbopen.pl";
require "dbclose.pl";
require "cldb.pl";
require "enukey.pl";
require "enkeys.pl";
require "enwrite.pl";
require "addkey.pl";
require "dbmatch.pl";
require "defines.pl";
require "enread.pl";
require "encmp.pl";
require "updatecheck.pl";
require "serial.pl";
require "cross-notify.pl";

sub finalchecksandupdate {
    local(*entry, $type, *autonichandles, *options)=@_;
    
    local($returncode)=$O_OK;
    
    local($source)=$entry{"so"};
    local($split)=$SPLIT{$source};
    
    print STDERR "finalchecksandupdate - opening database\n" if $opt_V;
    print STDERR "finalchecksandupdate - auto: ", join(" ", @autonichandles),"\n" if ($opt_V);
    
    local($db)='db';
    local(%db,@db);
    
    #
    # we need to open the two possible databases with NIC handles always
    # in the same order, else we might get a deadlock situation 
    # in case of a split database. The order is: pn, ro
    
    local($nicdb)='nicdb';
    local(%nicdb,@nicdb);
    
    local($mtdb)='mtdb';
    local(%mtdb,@mtdb);
    
    local($othernicdb)='othernicdb';
    local(%othernicdb,@othernicdb);
    
    local(%nicentry);
    
    if (($split) && ($type eq "pn")) {
    
       %nicentry=("ro", "1", "so", $source); 
       
       if (!&dbopen(*othernicdb, *nicentry, 1)) {
          
          return ($O_COULDNOTOPEN, "ro");
          
       }
       
    }
                                        
    if (&dbopen(*db, *entry, 1)) {
       
       if (($split) && ($type eq "ro")) {
    
          %nicentry=("pn", "1", "so", $source); 
       
          if (!&dbopen(*othernicdb, *nicentry, 1)) {
          
             &dbclose(*db);
             
             return ($O_COULDNOTOPEN, "pn");
          
          }
       
       }
       
       &dbclopen(*entry,1) if ($CLASSLESSDBS{$type});
       
       #
       # and now we are going to do the update
       
       if ($options & $DELETEOPTION) {
       
          print STDERR "finalchecksandupdate - deleting entry\n" if $opt_V;
          
          $options|=$DELETEOPTION;
          
          #
          # don't delete persons/roles/maintainers
          # that are referenced by other objects
          #
          # note1: this routine is a bit clumsy. We might want
          #        to redesign it once we have some time
          # note2: it also doesn't work yet... & is thus
          #        disabled for now.
          
          if (0) {
                    
          # if (($type ne "dn") && ($ALLOBJPOINTSTO=~ /(^| )$type( |$)/)) {
             
             #
             # always allow InterNIC entries to be deleted
             
             next if ($entry{"nh"}=~ /^[A-Z]\d*$/);
             
             local($attr, $pointsto, $pointstosource);
             local(@keys, @longkeys, @nonsplitkeys);
             
             local(%donedb)=();
             local(%pointstoentry);
             local($pointstodb)='pointstodb';
             local(%pointstodb, @pointstodb);
             
             #              
             # we don't lock the databases right now since
             # it is of no use: 
             # 
             # - we would need to release the locks before we do the update
             #
             # of course it can be done but that needs more work and
             # perl doesn't make this easy
             #
             # but we are prepared:
             #
             # we need to use this standard order for the database checks
             # to avoid deadlock when locking split databases :-(
             
             local(@dbs)=keys %OBJATSQ;
             
             if (!$split) {
             
                $attr=join(" ", grep($POINTSTO{$_}=~ /(^| )$type( |$)/, split(/ /,$ALLOBJPOINTSTOATTR)));
                   
                @nonsplitkeys=&makekeys($entry{$type}, $attr, *longkeys);
                @nonsplitkeys=@longkeys if (@longkeys);
                push(@nonsplitkeys, &makekeys($entry{"nh"}, $attr, *longkeys)) if (($entry{"nh"}) && ($type=~ /^pn|ro$/));
                
             }
             
             foreach $pointsto (@dbs) {
                
                #
                # always make sure to search first our own database
                # files might contain more sources and we can get errors
                # if we open an already opened file (but with another source)
                
                foreach $pointstosource ($source, keys %DBFILE) {
                   
                   #
                   # skip files that are already searched:
                   #
                   # - if we have a non split database
                   # - if we have more sources in one db file
                   
                   next if $donedb{$DBFILE{$pointstosource}};
                   $donedb{$DBFILE{$pointstosource}}=1;
                   
                   if ($SPLIT{$pointstosource}) {
                
                      next if ($OBJPOINTSTO{$pointsto}!~ /(^| )$type( |$)/);
                
                      $attr=join(" ", grep($POINTSTO{$_}=~ /(^| )$type( |$)/, split(/ /, $OBJPOINTSTOATTR{$pointsto})));
                   
                      @keys=&makekeys($entry{$type}, $attr, *longkeys);
                      @keys=@longkeys if (@longkeys);
                      push(@keys, &makekeys($entry{"nh"}, $attr, *longkeys)) if (($entry{"nh"}) && ($type=~ /^pn|ro$/));
             
                   }
                   else {
                   
                      @keys=@nonsplitkeys;
                   
                   }
                
                   if (($source ne $pointstosource) || 
                       (($source eq $pointstosource) && ($SPLIT{$pointstosource}) && ($pointsto!~ /^pn|ro$/))) {
                   
                      %nicentry=($pointsto, "", "so", $pointstosource); 
                      &dbopen(*pointstodb, *nicentry, 0) || next;
                
                   }
                
                   foreach (@keys) {
                
                      @longkeys=($_);
             
                      if (($source eq $pointstosource) && ((!$split) || (($type=~ /^pn|ro$/) && ($pointsto=~ /^pn|ro$/) && ($pointsto eq $type)))) {
                   
                         foreach (&dbmatch(*db, *longkeys, "", 0)) {
                      
                            &enread($db, *pointstoentry, $_);
                   
                            if (!&encmp(*entry, *pointstoentry)) {
                         
                               $returncode=$E_STILLREFERENCED;
                         
                               last;
                         
                            }
                   
                         }
                            
                      }
                      elsif (($source eq $pointstosource) && (($type=~ /^pn|ro$/) && ($pointsto=~ /^pn|ro$/))) {
                            
                         foreach (&dbmatch(*othernicdb, *longkeys, "", 0)) {
                      
                            &enread($othernicdb, *pointstoentry, $_);
                   
                            if (!&encmp(*entry, *pointstoentry)) {
                         
                               $returncode=$E_STILLREFERENCED;
                        
                               last;
                            
                            }
                         
                         }
                   
                      }
                      else {
                   
                         foreach (&dbmatch(*pointstodb, *longkeys, "", 0)) {
                      
                            &enread($pointstodb, *pointstoentry, $_);
                   
                            if (!&encmp(*entry, *pointstoentry)) {
                         
                               $returncode=$E_STILLREFERENCED;
                         
                               last;
                         
                            }
                            
                            &dbclose(*pointstodb);
                   
                         }
                      
                         
                      }
                   
                      last if ($returncode==$E_STILLREFERENCED);
                      
                   }
                   
                   last if ($returncode==$E_STILLREFERENCED);

                }
                
                last if ($returncode==$E_STILLREFERENCED);
             
             }
             
          }
          
          $returncode=&dbdel(*db, *entry, $type, $options) if ($returncode==$O_OK);
          
          if ($returncode==$O_OK) {
             
             local(%nothing)=();
             
	     &AddNotify(*entry, *nothing);
	     
	     #
             # we might have to delete a just assigned NIC handle
             
             delete($ASSIGNEDNIC{$source, $entry{"nh"}}) if (grep($entry{"nh"} eq $_, values %ASSIGNEDNIC));
             
          }
                                             
       }
       else {         # $options & $DELETEOPTION
       
          local(@uniquekey)=(&enukey(*entry, $type));
          local(@result)=&dbmatch(*db, *uniquekey, "", 0);
          
          local(%oldobject)=();
          
          #
          # this one is for the updating of old classless inetnum objects
          
          if (($type eq "in") && (!@result)) {
          
             local(@longkeys);
             local(@keys)=&makekeys($entry{$type}, "", *longkeys);
             local(@newresult)=&dbmatch(*db, *keys, $type, $INTERSECTIONOPTION);
             
             # print STDERR join(" ",@keys), "*$entry{$type}*newress: ", join(" ", @newresult),join(" ", @longkeys), "*\n";
                          
             if (@newresult) {
                
                local($offset,$code,$newvalue);
                
                foreach $offset (@newresult) {
                   
                   &enread($db, *oldobject, $offset);
                   
                   ($newvalue, $code)=&normalizerange($oldobject{$type}, $type);
                   
                   # print STDERR "old: $oldobject{$type}*$newvalue new: $entry{$type}\n";
                   
                   next if (($newvalue ne $entry{$type}) || ($entry{"so"} ne $oldobject{"so"}) || ($entry{"na"} ne $oldobject{"na"}));
                   
                   @result=($done);
                   $options|=$BACKWARDCOMPATIBILITYOPTION;
                   
                   last;
                      
                }
                
                %oldobject=() if (!@result);
             
             }
             
          
          }
          
          #
          # this one is for person objects without a NIC handle
          
          if (($type eq "pn") && (!@result) && ($entry{"nh"})) {
             
             local($oldcholdentry);
          
             local($oldvalue)=delete($entry{"nh"});
             local($oldch)=delete($entry{"ch"});
             
             #
             # try this one first:
             
             local(@otheruniquekey)=(&enukey(*entry, $type));
             local(@newresult)=&dbmatch(*db, *otheruniquekey, "", $INTERSECTIONOPTION);
             
             if (@newresult) {
                
                local($offset);
                
                foreach $offset (@newresult) {
                   
                   &enread($db, *oldobject, $offset);
                   
                   $oldcholdentry=delete($oldobject{"ch"});
                   
                   next if (!&encmp(*entry, *oldobject));
                   
                   $oldobject{"ch"}=$oldcholdentry;
                   
                   $done=$offset;
                   @result=($done);
                   
                   last;
                      
                }
                
                %oldobject=() if (!@result);
             
             }
             
             $entry{"nh"}=$oldvalue;
             $entry{"ch"}=$oldch;
                       
          }
          
          #
          # check if we are doing an modification
          
          if (@result) {
	
	     if (scalar(@result)>1) {
	    
	        print STDERR "finalchecksandupdate - multiple match - ".$en{$type}."\n" if ($opt_V);
	    
	        $returncode=$E_MULT_MATCH;
	
	     }
             else {

	        &enread($db, *oldobject, $result[0]) if (!%oldobject);
	        
	        print STDERR "finalchecksandupdate - modification match - ".$oldobject{$type}."\n" if ($opt_V);

                $options|=$MODIFYOPTION;
                
                $returncode=$E_NOOP if (&encmp(*entry, *oldobject));
                   
                $returncode=$E_NOTNEW if (($returncode==$O_OK) && ($type eq "in") && ($opt_A));
                   
                $returncode=$E_NOTNEW if (($returncode==$O_OK) && ($NEWMODE));
             
             }
             
             if ($returncode==$O_OK) {
                
                local($date)=0;
                local($newdate)=0;
                local($curdate)=0;
                
                local($email);
    
                #
                # Check update date
    
                foreach (split(/\n/, $entry{"ch"})) {
     	           ($email, $date)=split(/\s+/, $_);
	           $newdate=$date if ($date>$newdate);
                }
                
                foreach (split(/\n/, $oldobject{"ch"})) {
 	           ($email, $date)=split(/\s+/, $_);
	           $curdate=$date if ($date>$curdate);
                }
    
                $returncode=$E_OLDER if ($newdate<$curdate);
	  
	     }
	  
          }          
          
          if ($returncode==$O_OK) {
          
             #
             # assign NIC handle
          
             if ($entry{"nh"}=~ /^$AUTONICPREFIXREGULAR(\d+)([A-Z]+)$/o) {
                $idnumber=$1;
                local($idinitials)=$2;
                $entry{"nh"}=&findfirstfreehandle(*db, *othernicdb, *entry);
                $ASSIGNEDNIC{$source, $idnumber}=$entry{"nh"};
                $ASSIGNEDNIC{$source, $idnumber, $idinitials}=$entry{"nh"};
                $options|=$ASSIGNEDNICOPTION;
             }
          
             #
             # substitute NIC handles if necessary
             
             print STDERR "auto: ", join(" ", @autonichandles),"\n" if ($opt_V);
                          
             foreach $attribute (@autonichandles) {
             
                @attributes=();
             
                foreach (split(/\n/, $entry{$attribute})) {
                
                   if (/^$AUTONICPREFIXREGULAR(\d+)([A-Z]*)$/) {
                   
                      if ($ASSIGNEDNIC{$source, $1, $2}){
                         push(@attributes, $ASSIGNEDNIC{$source, $1, $2});
                      }
                      elsif ($ASSIGNEDNIC{$source, $1}){
                         push(@attributes, $ASSIGNEDNIC{$source, $1});
                      }
                      else {
                      
                         &adderror(*entry, "not assigned auto NIC handle used as a reference ($_)");
                      
                         $returncode=$E_GENERAL;
                      
                         last;
                      
                      }
                   
                   }
                   else {
                      push(@attributes, $_);
                   }
             
                }
             
                last if ($returncode!=$O_OK);
             
                $entry{$attribute}=join("\n", @attributes);
             
             }
             
          }
       
          $options|=$NEWOPTION if (!($options & $MODIFYOPTION));
       
          #
          # check if NIC handle is not already assigned
          
          if (($options & $NEWOPTION) && ($entry{"nh"})) {
             
             local(@longkeys)=();
             local(@keys)=&makekeys($entry{"nh"}, "", *longkeys);
             
             if ((&dbmatch(*db, *keys, "", 0)) ||
                 (&dbmatch(*othernicdb, *keys, "", 0))) {
                
                $returncode=$GENERALERROR;
                
                &adderror(*entry, "NIC handle (".$entry{"nh"}.") already in use for other object");
                
             }
             
          }
       
          #
          # here we need the 'do referenced objects really exist code'
          #
          # we check only maintainers for now...
       
          # print STDERR "do check mnt: ($returncode)",$entry{"mb"}," ",$entry{"ml"},"\n";
       
          if (($returncode==$O_OK) && (($entry{"mb"}) || ($entry{"ml"}))) {
             
             # print STDERR "trouve! do check mnt: ($returncode)",$entry{"mb"}," ",$entry{"ml"},"\n";
             
             my @notfound=();

	     my $mntner;
             my @mntners = undef;
	     push @mntners, split(' ', $entry{mb}),
 	                    split(' ', $entry{ml});

	     ## foreach was giving errors
	     ## 2nd time round the loop $mntner was set to 1

	     while ($mntner = shift @mntners) {
                
	       print STDERR "mt: $mntner\n" if $opt_V;
                
	       next if !$mntner;
	       next if ($mntner eq $entry{"mt"});
	       next if ($ExistMaintainer{$mntner});
	       next if (&GetMaintainer($mntner, $entry{"so"}, 0));
                
	       push @notfound, $mntner;
             }
             
             if (@notfound) {
                &adderror(*entry,
			  "unknown maintainer(s) \"@notfound\" referenced");
                $returncode=$GENERALERROR;
             }
          }
       
	  if ($returncode==$O_OK) {
	    $returncode=&updatecheck(*db, *oldobject, *entry, $type, $options);
          }

          if ($returncode==$O_OK) { 

	       if ($options & $MODIFYOPTION) {
		 $returncode=&dbdel(*db, *oldobject, $type,
				    $options | $NOCHECKSOPTION);
	       }

	       if ($returncode==$O_OK) {
		 $returncode=&dbadd(*db, *entry, $type, $options) ;
	       }
	  
	     if ($returncode==$O_OK) {
	       &AddNotify(*oldobject, *entry);
	
	     }
          }
       
       }
	
       &dbclclose() if ($CLASSLESSDBS{$type});
       
       &dbclose(*db);
       &dbclose(*othernicdb) if (($split) && (($type eq "ro") || ($type eq "pn")));
    

    }
    else {
    
       &dbclose(*othernicdb) if (($split) && ($type eq "pn"));
    
       return ($O_COULDNOTOPEN, $type);
       
    }
    

	   # If object has been successfully updated ($O_OK ?)  do the
	   # cross notification checks and generate messages if
	   # needed.  Messages will be in a form suitable to feed to
	   # to sendmail (or other MTA) and are put in temporary
	   # files. add_cross_notify returns (possibly empty) list of
	   # file names.  They will be sent at the same time as the
	   # Update Notification.

    # Do the cross notification checks here
    #   1. after the dbases have been closed (we need to open them again)
    #   2. while the new and old objects are still in scope

    # use $::REPLYTO as the originator of the update message
    # it gets set somewhere (?)

    undef @::cross_notification_mailfiles;

    if ($returncode == $O_OK) {
      if ($options & $DELETEOPTION) {
	push @::cross_notification_mailfiles,
          add_cross_notify(\%entry, undef, $::REPLYTO);
      }

      if ($options & $NEWOPTION) {
	push @::cross_notification_mailfiles,
          add_cross_notify(undef, \%entry, $::REPLYTO);
      }
    }

    return ($returncode, "");
}

sub dbadd {
    local(*db, *entry, $type, $options)=@_;

    print STDERR "dbadd - finding unique key $type (",$entry{$type},")\n" if $opt_V;

    local($uniquekey)=&enukey(*entry, $type);

    #
    # entry already exists
    
    return $E_EXIST if (defined($db{$uniquekey}));
    
    #
    # add object to db
        
    seek($db, 0, 2);
    local($offset)=&enwrite($db, *entry, 0, 0);

    #
    # find all keys and add to db
    
    local(@keys,@other,@pointsto,@otherpointsto,@classless);
    
    &enkeys(*entry, $OBJKEYS{$type}, *keys, *other, *pointsto, *otherpointsto, *classless, 1);
    
    foreach ($uniquekey, @keys) {
       print STDERR "dbadd - adding normal & unique keys\n" if $opt_V;
       &addkey(*db, $_, $offset);
    }
    
    foreach (@other) {
       print STDERR "dbadd - adding other keys\n" if $opt_V;
       &addkey(*db, $_, $offset);
    }
       
    foreach (@pointsto) {
       print STDERR "dbadd - adding pointsto keys\n" if $opt_V;
       &addkey(*db, $_, $offset);
    }

    foreach (@otherpointsto) {
       print STDERR "dbadd - adding otherpointsto keys\n" if $opt_V;
       &addkey(*db, $_, $offset);
    }
       
    #
    # No need to modify the classless index if this is a
    # modification, rather than a addition of a new object
    
    if (($CLASSLESSDBS{$type}) &&
        ((!($options & $MODIFYOPTION)) ||
         ($type!~ /^i[n6]|rt$/) ||
         ($options & $BACKWARDCOMPATIBILITYOPTION))) {
       
       foreach (@classless) {
          print STDERR "dbadd - adding classless keys\n" if $opt_V;
          &inscla(*mspnxl, $_, $uniquekey);
       }
       
    }
    
    print STDERR "dbadd - writing serial log\n" if $opt_V;

    &writeseriallog($ADDACTION,*entry);
    
    print STDERR "dbadd - returning\n" if $opt_V;

    return $O_OK;

}

sub dbdel {
    local(*db, *entry, $type, $options) = @_;
    
    print STDERR "dbdel - called for $type(",$entry{$type},") ($options)\n" if $opt_V;

    local(@uniquekey)=(&enukey(*entry, $type));
    local(@result)=&dbmatch(*db, *uniquekey, "", 0);

    print STDERR "dbdel -  result: ",@result," unique: ",@uniquekey,"\n" if ($opt_V);

    #
    # entry not found

    return $E_NOT_FOUND if (!@result);
    
    #
    # delete any exactly matching objects
    
    local($returncode)=$E_MISMATCH;
    
    foreach $offset (@result) {
	
       &enread($db, *oldobject, $offset);
	
       next if (!&encmp(*entry, *oldobject));

       $returncode=$O_OK;
 
       #
       # Dummy updatecheck to get notification.
       # New object is null, updatecheck will recognize and
       # skip checks not done for deletes. Only do if it is
       # a true delete, and not a replace

       if (!($options & $NOCHECKSOPTION)) {
	  
	  local(%nothing)=();
	    
	  $returncode=&updatecheck(*db, *entry, *nothing, $type, $options);
	  
	  return $returncode if ($returncode!=$O_OK);
	  
       }

       #
       # delete object
       
       seek($db, $offset, 0);
       print $db "*", $DELETEDOBJECT, "\:";
        
       local(@keys,@other,@pointsto,@otherpointsto,@classless);
    
       &enkeys(*entry, $OBJKEYS{$type}, *keys, *other, *pointsto, *otherpointsto, *classless, 1);
        
       foreach (@uniquekey, @keys) {
          print STDERR "dbdel - deleting normal keys\n" if $opt_V;
          &delkey(*db, $_, $offset);
       }
       
       foreach (@other) {
          print STDERR "dbdel - deleting other keys\n" if $opt_V;
          &delkey(*db, $_, $offset);
       }
       
       foreach (@pointsto) {
          print STDERR "dbdel - deleting pointsto keys\n" if $opt_V;
          &delkey(*db, $_, $offset);
       }
       
       foreach (@otherpointsto) {
          print STDERR "dbdel - deleting otherpointsto keys\n" if $opt_V;
          &delkey(*db, $_, $offset);
       }
       
       #
       # No need to modify the classless index if this is a
       # modification, rather than a real delete.

       if (($CLASSLESSDBS{$type}) &&
           ((!($options & $MODIFYOPTION)) ||
            ($type!~ /^i[n6]|rt$/) ||
            ($options & $BACKWARDCOMPATIBILITYOPTION))) {
       
          foreach (@classless) {
             print STDERR "dbdel - deleting classless keys\n" if $opt_V;
             &delcla(*mspnxl, $_, $uniquekey[0]);
          }
       
       }
       
       print STDERR "dbdel - writing serial log\n" if $opt_V;
          
       &writeseriallog($DELETEACTION, *entry);
    
    }
    
    return $returncode;
    
}

1;
