#	$RCSfile: template.pl,v $
#	$Revision: 1.4 $
#	$Author: marten $
#	$Date: 1994/11/23 14:20:44 $

# template.pl - spits out a template for an object, based on the config
# file. Assumes that the config has already been read.
# Takes object type as input. Outputs to currently selected output.

sub Template {

    local($type) = @_;
    local(%mand) = ();
    local(%mult) = ();
    local(%guar) = ();
    local(%obsoleted) = ();

    foreach (split(/\s+/, $OBJMAND{$type})) {
	$mand{$_} = 1;
    }

    foreach (split(/\s+/, $OBJMULT{$type})) {
	$mult{$_} = 1;
    }

    foreach (split(/\s+/, $GRD{$type})) {
        $guar{$_} = 1;
    }

    foreach (split(/\s+/, $OBS{$type})) {
	$obsoleted{$_} = 1;
    }

    # Special, guarded objects must contain a "mnt-by" attribute.
    # It is always mentioned to optional, and cannot be mandatory
    # for now because there should be a bypass to get guarded objects
    # in .... Authorise?

    if ($GRDOBJ{$type}) {
	$mand{"mb"} = 1;
    }

    foreach (split(/\s+/, $OBJATSQ{$type})) {
	if ($obsoleted{$_}) {
	    printf "%-12s %-12s\n", $ATTL{$_}.":", "[obsoleted]";
	} else {
	    printf "%-12s %-12s %-12s %-12s\n",
	    $ATTL{$_}.":",
	    $mand{$_} ? "[mandatory]" : "[optional]",
	    $mult{$_} ? "[multiple]"  : "[single]",
	    $guar{$_} ? "[guarded]"   : "";
	}
    }
}

1;
