#       enread - read RIPE database entry
#
#	$RCSfile: enread.pl,v $
#	$Revision: 0.18 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $
#
#       This routine reads RIPE database entries in %entry and returns the
#       type, "" when nothing has been found, $DELETEDOBJECT when
#       the object has been deleted, and an other invalid type when an 
#       invalid object has been found.
#       When no valid/deleted object has been found %entry is set to ().
#
#       file       file to read from

#
# enread
#
# Take care with changing anything in this routine.
# It is highly optimized for speed, especially for (sorted) big objects.
#

sub enread {

    local(*entry, $file, $offs) = @_;
    local($line);
    local($value);
    local($tag)="pn";  # needed for starting up,
                       # use a valid attribute, pn is probably a good guess ;-)
    local($newtag)="";
    
    local($type)="";
    
    local(@lines)=();  # also needed for proper startup
    
    %entry=();

    if (defined($offs)) {
	seek($file, $offs, 0);
    }
    
    while (($line=<$file>) && (($line=~ /^\s+$/) || ($line=~ /^\#/))) {
       # print STDERR "skip lines: ", $line;
    }
    
    # print STDERR "first line: ", $line;
    
    #
    # skip deleted objects immediately
    #
    
    if ($line=~ /^\*?${DELETEDOBJECT}\:/o) {
       # print STDERR "XX object $line";
       
       while (($line=<$file>) && ($line!~ /^\s+$/)) {}
                      
       return ($DELETEDOBJECT);
    }
    
    #
    # don't forget to check for the type for the first line...
    #
    
    if ($line=~ /^\s*\*?${tag}\s*\:|^\s*$ATTL{$tag}\s*\:/i) {
       $type=$tag if ($OBJATSQ{$tag});
       # print STDERR "type found: $type\n";
    }
    
    if ($line) {
    
       $entry{"offset"} = tell($file) - length($line);
       
       while (1) {

          ($newtag,$value)=split(/\s*\:\s*/,$line,2);
          
          $value=~ s/\s*$//g;
          
          if ($newtag=~ /^\s*\*?$tag$|^\s*$ATTL{$tag}$/i) {
       
             if ($value) {
                # print STDERR "tag: $tag value: $value\n";
                push(@lines,$value);
             }
             else {
                &syslog("ERRLOG", "enread: empty attribute, normal $tag (offset: ".$offs." ".$entry{"offset"}." ".tell($file).") in line: $line");
             }
             
          }
          else {
                          
             if (length($line) == length($newtag)) {
                
                if ($line=~ /^\s*$/) {
                      
                   if ($entry{$tag}) {
                      $entry{$tag}=join("\n",$entry{$tag},@lines) if (scalar(@lines));
                   }
                   else {
                      $entry{$tag}=join("\n",@lines) if (scalar(@lines));
                   }
                      
                   # print STDERR "type: $type entry:\n", %entry, "\n";
                   
                   if ($type) {
                      return ($type);
                   }
                   else {
                      &syslog("ERRLOG", "enread: object has no type (offset: ".$offs." ".$entry{"offset"}." ".tell($file).") in line: ".$line);  
                      
                      %entry=();
                      
                      # just create a type that is not the same as others and 
                      # that is for sure invalid ...
                      
                      return ($DELETEDOBJECT.$DELETEDOBJECT);
                   }
                }

                elsif ($line!~ /^#/) {
                
                   # print STDERR "$offs $line";
                      
                   &syslog("ERRLOG", "enread: no attribute in line (tag: $tag, type: $type) (offset: ".$offs." ".$entry{"offset"}." ".tell($file).") in line: ".$line);  
                         
                   while (($line=<$file>) && ($line!~ /^\s+$/)) {}
                     
                   %entry=();
                      
                   # just create a type that is not the same as others and 
                   # that is for sure invalid ...
                      
                   return ($DELETEDOBJECT.$DELETEDOBJECT);
                
                }
             }
             else {
             
                if ($entry{$tag}) {
                   $entry{$tag}=join("\n",$entry{$tag},@lines) if (scalar(@lines));
                }
                else {
                   $entry{$tag}=join("\n",@lines) if (scalar(@lines));
                }
                
                $tag="";
                $newtag=~ s/^\*//;
                $newtag=~ tr/A-Z/a-z/;
                $newtag=$ATTR{$newtag};
                $tag=$newtag if (!$tag);
                
                $type=$tag if ((!$type) && ($OBJATSQ{$tag}));
                
                if ($value) {
                   # print STDERR "newtag: $tag type: $type value: $value\n";
                   @lines=($value);
                }
                else {
                   @lines=();
                   &syslog("ERRLOG", "enread: empty attribute, newtag $newtag (offset: ".$offs." ".$entry{"offset"}." ".tell($file).") in line:".$line);
                }
             
             }
             
          }
       
          $line=<$file>;
          # print STDERR $line;
       }  
    }
    else {
       return ("");
    }
}

1; 	# PC version of perl seems to require this for require()
