#!PERL
#
#	$RCSfile: checkupd.pl,v $
#	$Revision: 1.5 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $
#
# Quick script to check what would happen to a mail or any update for that
# matter
#

USE_DBM

@INC = ("LIBDIR","/ncc/dbase/lib", @INC);

require "enparse.pl";
require "enwrite.pl";
require "rconf.pl";
require "defines.pl";
require "getopts.pl";

# Options:
#
# -s  -  Give a summary of errors
# -m  -  assume it is from an "mh show"
# -v  -  verbose mode
# -f  -  full output

&Getopts('asmvfh');

if ( $opt_h ) {
        print STDERR "Usage: $0 -s -v -f -m -h\n";
	print STDERR "\n-s  - Give a summary\n";
        print STDERR "-m  - assume an \"mh show\"\n";
	print STDERR "-f  - give full output (oks as well)\n";
        print STDERR "-v  - verbose mode\n";
	print STDERR "-a  - for assignments\n";
        print STDERR "-h  - help message\n";
	exit(-1);
}

if ( $opt_v ) {
	$verbose = 1;
}

if ( $opt_s ) {
	$summary = 1;
}
 
if ( $opt_m ) {
	$mh = 1;
}

if ( $opt_f ) { 
	$full = 1;
}

# Read config file from RIPEDBCNF, or set to default.

$conffile=$ENV{"RIPEDBCNF"};
$conffile= "DEFCONFIG" unless $conffile;
&rconf("$conffile");


local($i,$j,$k,$b) = 0;
$i = $j = $k = $b = 0;
local($stat) = 0;
local($got_a_dash) = 0;

if ($verbose) {
	print STDERR "About to read in update.....\n\n";
}
if ($mh || $opt_a) {
	if ($verbose) {
		print STDERR "Assuming a \"mh show\" as input\n";
	}
	while(<>) {
		if($_ =~ /^\-+/) {
			$got_a_dash++;
			if($opt_a) {
				last;
			}
		}
		if($got_a_dash == 2) {
			if ($verbose) {
				print STDERR "Seems to be the end of mh stuff\n";
			}
			last;
		}
		next;
	}
}
	
while(($stat,$hasdelete,%a) = &enparse("STDIN")) {
	next if $stat == 0;
	last if $stat == $EOF;
	$b++;
        if ($stat == $O_ERROR) {
		$i++;
                &enwrite(*a,1,1);
		print "\n";
        }
	if ($stat == $O_WARNING) {
                &enwrite(*a,1,1);
		print "\n";
		$k++;
	}
	if ($stat == $O_OK ) {
		if ($full) {
                	&enwrite(*a,1,1);
			print "\n";
		}
		$j++;
	}
}
if ($summary) {
	print "\n>>> Summary of the update <<<\n\n";
	print "Errors\t\t$i\n";
	print "Warnings\t$k\n";
	print "Ok\'s\t\t$j\n\n";
	print "Total\t\t$b\n";
}
