use Test::More tests => 2;
use strict;

BEGIN { use_ok('RPSL') }


# look for memory leaks in error's created by RPSL::add

my $DEBUG      = 0;             # set to 1 for debug messages
my $ITERATIONS = 10_000;        # 1_000_000;
my $HALFWAY    = $ITERATIONS/2; # integer please


## main


my $basemem = mem();
my $one_iter = 0;
my $two_iter = 0;
my $ten_iter = 0;
my $halfway = 0;


my $i=0;
while ( $i++ < $ITERATIONS ) {
	my $rpsl = RPSL->new(person());

	my $attr=RPSL::Attribute->new('person:      Joe Blank');

	# try to replace the first attr.
	$rpsl->add($attr, 0);

	$one_iter = mem() if $i == 1;
	$two_iter = mem() if $i == 2;
	$ten_iter = mem() if $i == 10;
	$halfway = mem() if $i == $HALFWAY;
}
my $lastmem = mem();

# for some reason one_iter is always a few bytes short
# of the others. I'm happy if it doesn't budge over 
# 100,000 iterations from the 2nd iteration
ok(($halfway == $ten_iter and $ten_iter == $lastmem), "leak test");

if ($DEBUG) {
	printf "iterations    %7d\n", $ITERATIONS;
	printf "base mem        %5d bytes\n", $basemem;
	printf "one iteration   %5d bytes\n", $one_iter;
	printf "two iterations  %5d bytes\n", $two_iter;
	printf "halfway         %5d bytes\n", $halfway;
	printf "last mem        %5d bytes\n", $lastmem;
}

exit;

sub mem {
	# sz            SIZE
	# rss           RSS
	# rssize        RSS
	# rsz           RSZ
	# vsize         VSZ
	# vsz           VSZ

	# The SIZE and RSS fields don't count the  page  tables  and
	# the  task_struct of a proc; this is at least 12k of memory
	# that is always resident. SIZE is the virtual size  of  the
	# proc (code+data+stack).

	open(MEM, "ps -o rsz --pid $$ --no-headers|")
		or die "can't open ps: $!";
	my $mem = <MEM>;
	$mem+=0;
	return $mem;
	close MEM;
}

sub person {
return <<PERSON_OBJECT;
person:       Fred Bloggs 
a ddress:      38 Branfiddle Lane
a ddress:      Corset
a ddress:      England
p hone:        +23 04 4444444
f ax-no:       +23 04 4534534
e -mail:       bloggs\@fred.uk
n ic-hdl:      FB934-RIPE
c hanged:      hostmaster\@fred.uk 19990427
changed:      hostmaster\@nic.uk 20 000404
s ource:       RIPE
PERSON_OBJECT
}
