#!/bin/sh
check_error()
{
	if [ $1 -ne 0 ] 
	then
	echo "loader failure [$1]. Exiting\n" >>$LOG
	exit 1
fi

}

loadpass()
{
  for object_file in ${LIST} 
  do
    echo `date` Loading ${object_file}  >>$LOG
    ${UNZIP1} ${object_file} | eval ${FILTER} | ./loader -L $1 -p ${PROPERTIES} -s ${SOURCE}
    check_error $?
  done
}



echo "*******************"`date`"******************" >$LOG
echo "Creating tables\n" >>$LOG
echo "Creating tables\n"

cd SQL; ./create.first-stage >>../$LOG; cd ..

echo `date`"\n" >>$LOG
echo "Loading tables - I pass\n" >>$LOG
echo "Loading tables - I pass\n"

loadpass 1 
check_error $?


echo `date`"\n" >>$LOG
echo "Making indexes\n" >>$LOG

cd SQL; ./create.second-stage >>../$LOG; cd ..

echo `date`"\n" >>$LOG
echo "Loading tables - II pass\n" >>$LOG

loadpass 2
check_error $?

echo `date`"\n" >>$LOG
echo "Making more indexes\n" >>$LOG

cd SQL; ./create.third-stage >>../$LOG; cd ..

echo "Finished "`date` >>$LOG

