/***************************************
  $Revision: 1.24 $

  Example code: main server code.

  Status: NOT REVUED, TESTED

  Author:       Chris Ottrey + pretty much everybody else involved :-)

  +html+ <DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL>
  +html+ </DL>
 
  ******************/ /******************
  Modification History:
        ottrey (09/03/1999) Created.
  ******************/ /******************
  Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
  Copyright (c) 1998                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#include <signal.h>
#include "erroutines.h"
#include "constants.h"
#include "properties.h"
#include "server.h"
#include "bitmask.h"
#include "thread.h"
#include "memwrap.h"

#include "ca_configFns.h"
#include "ca_macros.h"
#include "ca_srcAttribs.h"

#include "sk.h"

void error_init(int argc, char ** argv) {
  char *slash;     
  char progname[32];
  
  slash = strrchr(argv[0],'/');                            
  strncpy(progname, (slash != NULL) ? slash+1 : argv[0], 31);
  progname[31]=0;
  

  ER_init(progname, 1);

#if 0
  /* add one more definition */
  {
    char *err_msg = NULL;
    char *buf = 
      "CREATE test { FORMAT SEVCHAR|FACSYMB|TEXTLONG|DATETIME SOCK 2 }"
      "( FAC rp ASP RP_SRCH_GEN|RP_SRCH_DET|RP_LOAD_GEN SEV d-f ) "
      "( FAC QI|SQ ASP SQ_QRYTIME | QI_COLL_GEN SEV d-f )"  
      "( FAC PW ASP PW_I_QRYLOG SEV I-f )"
      "( FAC ALL SEV E- )"
      /*      "( FAC SV  ASP SV_PORT  SEV d )" */
      ;

    int parsres = ER_parse_spec(buf, &err_msg);

    if( parsres != 0 ) { /* print only on failure */
      puts(err_msg);
    }
    
    wr_free(err_msg);
    
    dieif( parsres != 0 );
  }
#endif

} /* error_init() */

int main(int argc, char** argv) {
  char *prop_file_name;                       
  char *result;
  sigset_t sset;

/* Initialize GLib library to be thread-safe */
   g_thread_init(NULL); 

/* Create signal handling thread and block signals for others */
   /*   printf("Starting the signal handler\n");*/
   TH_create((void *(*)(void *))SV_signal_thread, NULL);
     
   sigemptyset(&sset);
   /* SIGTERM will switch the updates on and off */
   sigaddset(&sset, SIGTERM);
   /* SIGINT stops all servers by setting do_server to 0 */
   sigaddset(&sset, SIGINT); 
   pthread_sigmask(SIG_BLOCK, &sset, NULL);
           
  
  /* 1. Get the config file name from argv[1] */
  if (argc == 2) {
    prop_file_name = (char *)calloc(1, strlen(argv[1])+1 );
    strcpy(prop_file_name,argv[1]);
  } else { 
    die;
  }

 /* 3. Set the constants. */
  /* fprintf(stderr,"Constants:\n");  */
  result=CO_set(); 
  free(result);
  fprintf(stderr,"Configuration [%s]:\n", prop_file_name);
  ca_init(prop_file_name);

  /* Initialize error handling */
  error_init(argc, argv);

  /* 4. Start the server */
  SV_start();

  return(0);

} /* main() */

