/***************************************
  $Revision: 1.3 $

  Radix tree (rx).  er_RX_errors.h - definition of errors for the radix module

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* step 1 */

typedef enum {
	 LOW_QI_OK=0,
	 LOW_QI_SQLERR,
	 LOW_QI_CANTDB
} QI_err_code_t;

/* step 2 */

#define QI_OK		ER_SEV_I + (FAC_QI<<16) + LOW_QI_OK
#define QI_SQLERR       ER_SEV_E + (FAC_QI<<16) + LOW_QI_SQLERR
#define QI_CANTDB       ER_SEV_E + (FAC_QI<<16) + LOW_QI_CANTDB

/* step 3 */

#ifdef ER_IMPL

er_list_t QI_mod_err[]={
  { ERDUP(QI_OK),  	"OK" },
  { ERDUP(QI_SQLERR),  	"SQL error" },
  { ERDUP(QI_CANTDB),  	"SQL cannot connect" },
  ER_LASTTXT
};

#endif /* ER_IMPL */
