#ifndef AU_UTIL_H
#define AU_UTIL_H 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <regex.h>
#include <glib.h>
#include "er_UP_errors.h"
#include "erroutines.h"

#define AU_MAIL_FROM 1
#define AU_CRYPT_PW 2
#define AU_PGP 3
#define AU_NONE 4

#ifdef __cplusplus
extern "C" {
#endif


typedef struct _credentials_struct{
   GSList * password_list;
   char * from;
   char * pgp_struct;
} credentials_struct;


typedef struct _auth_struct{
  int type;
  char * auth;
  char * mntner_name;
  int index;
  char * pgp_struct;
} auth_struct;

char * AU_crypt(const char *key, const char *setting);
int AU_authorise(GSList * auth_vector, credentials_struct credentials);

#ifdef __cplusplus
 }
#endif

#endif
