/***************************************
  $Revision: 1.11 $

  Error reporting (er) erroutines.h  - header file for error reporting.

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#ifndef ER_H
#define ER_H

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <assert.h>
#include <time.h>
#include <stdarg.h>
#include <strings.h>

#include <bitmask.h>
#include <er_aspects.h>
#include <stubs.h>

#ifdef ER_IMPL
#define EXTDEF
#define EXTINI(a,b) a = b;
#else
#define EXTDEF extern 
#define EXTINI(a,b) extern a;
#endif

#ifdef __cplusplus
extern "C" {
#endif


typedef unsigned int er_mask_t;

typedef int er_ret_t;

#define MNELEN 16
typedef struct {
   er_ret_t	code;
   char		mnem[MNELEN];
   char		text[80];
} er_list_t;


typedef struct {
   er_ret_t	code;
   char		name[4];
   char 	desc[80];
   er_list_t   *errs;
} er_main_t;

#define ER_SEV_C 0x40000000	/*+ circular buffer dump +*/
#define ER_SEV_F 0x20000000	/*+ fatal error +*/
#define ER_SEV_E 0x10000000	/*+ error +*/
#define ER_SEV_W 0x08000000	/*+ warning +*/
#define ER_SEV_I 0x04000000	/*+ information +*/
#define ER_SEV_D 0x02000000	/*+ debug message +*/
#define ER_SEV_L 0x01000000	/*+ library error +*/


/*  macro to see if the code is OK -- masks out the facility and compares,
    assuming all OK codes within the facilities are 0
*/



#define ER_SEV_TXT 20

#define ER_MSGLEN 256
#define ER_ERRLEN 2048

typedef struct {
    int 	sev;
    char 	chr[2];
    char 	txt[ER_SEV_TXT];
} er_level_t;

#ifndef ER_IMPL /* for client modules */
extern er_level_t er_level_a[];
#else /* full definition */
er_level_t er_level_a[] = {
  { ER_SEV_C,	"?" , "BUG! bad sev: circ" },
  { ER_SEV_F,   "F" , "fatal error" },
  { ER_SEV_E, 	"E" , "error" },
  { ER_SEV_W, 	"W" , "warning" },
  { ER_SEV_I,	"I" , "information" },
  { ER_SEV_D, 	"D" , "debug msg" },
  { ER_SEV_L, 	"L" , "library err" },
  { 0,          "-" , "BUG! no such sev 0" }
};
#endif /* ER_IMPL */

#define DEFFAC(a,b) { FAC_##a, #a, b, a##_mod_err }

/* the macro expects two arguments:
	 capital letters symbol of the facility
	 short (<80 chars) description
   which then are expanded, eg. DEFFAC(TT, "test facility") expands to:
  { FAC_TT , "TT",   "test facility" ,  NULL} ,
  Therefore, the FAC_TT must be defined in the enum below.
  The  er_fac_code_t enum   must begin with FAC_NONE=0 
			and must end   with FAC_LAST.
  The  er_main_err array    must end   with FAC_NONE.

  The user code must contain INITFAC(a) call early in the code that
  sets the pointer to the respective ??_mod_err array. There is nothing
  wrong in calling it twice, so don't hesitate if you must do it.
 
  After a facility number changes (eg. because another one was added or
  deleted before yours) ALL your code must be recompiled before linking. 
*/

#define ER_LASTTXT {-1}		/* macro for use in error text arrays */

#define ERDUP(a) a, #a      

#include "er_facilities.h"

/*************************************************************************/

/* mode values (bitmap: describes what kind of severity and mnemonic we
want back. */

/* bits 0-1 (values 0-3) - severity: */
#define ER_M_SEVCHAR 1      /* one-letter severity indication */
#define ER_M_SEVLONG 2      /* long severity indication */

/* bit 2 (values 0 or 4) - mnemonic */
#define ER_M_MNEMONIC 4

/* bit 3 (values 0 or 8) - error text */
#define ER_M_TEXTLONG 8

/* bits 4-5 (values 0, 16, 32, 48) - user id's */
#define ER_M_UIDUID  16
#define ER_M_UIDEUID 32

/* bit 6 (values 0 or 64) - process id's */
#define ER_M_PIDFULL 64

/* bit 7 (values 0 or 128) - facility symbol */
#define ER_M_FACSYMB  128


/* bit 8 (values 0 or 256) - program name (argv[0]) */
#define ER_M_PROGNAME	256

/* bit 9 (values 0 or 512) - current date and time */
#define ER_M_DATETIME   512

#define ER_M_THR_ID    2048

#define ER_M_DEFAULT  (ER_M_DATETIME | ER_M_FACSYMB  | ER_M_SEVCHAR \
                     | ER_M_MNEMONIC | ER_M_TEXTLONG | ER_M_PIDFULL \
                     | ER_M_THR_ID   | ER_M_PROGNAME )


int NOERR(er_ret_t a);
#define ERR(a) (!NOERR(a))


void ER_init(int argc, char **argv);

#define ER_dbg_eq(mod, asp, typ, expr)  \
                ER_dbg_va (mod, asp, #expr " = " typ, expr)

void ER_perror(int facwhere, int errcode, ...);
void ER_dbg_va( int facwhere, er_mask_t asp, char *txt, ...);
void ER_inf_va( int facwhere, er_mask_t asp, char *txt, ...);
int ER_anybody_wants( int facwhere, int errcode, er_mask_t asp );
int ER_is_traced(int facwhere, er_mask_t asp);

/* This is just provisional ! */
typedef struct {
  FILE       *fdes; 
                   /* file descriptor. This is REALLY provisional! */
  int        fac;  /* facility */
  er_mask_t  asp;  /* mask of aspects */
  int        sev;  /* minimal severity */
  int        mode; /* bitmask of output mode - bits of information that
		      should be printed */		    
} er_path_t;

void ER_setpath(er_path_t *newset);

#ifdef ER_IMPL

/* global vars !!!!! must be set for reporting purposes. 
   Must be initialised in main() by ER_init().
*/
 char er_progname[32];
 char er_pid[16];

/* those are private variables */

er_path_t        er_provisional_struct;
pthread_mutex_t  er_pathlist_mutex;
int              er_pathlist_mutex_initialised = 0;
#endif

#if 0

typedef struct {
  mask_t fac_mask;
  mask_t asp_mask;
  int    sev_min;
  int    sev_max;
  unsigned err;     /* a specific error code - or 0 to mean all errors */
} er_filter_t;


enum {
  ER_PATH_UNBUF=1,  /* unbuffered file/socket access via a file descriptor */
  ER_PATH_BUFPTR,   /* buffered   file access via a FILE structure  */
  ER_PATH_BUFNAM,   /* buffered   file access via a file name 
		       (file reopened for every message) */
  ER_PATH_EMAIL,    /* e-mail constructed, send at the end or after one message
		       depending on options */
  ER_PATH_SYSLOG    /* syslog msg sent at every message */
} er_path_mt;


typedef struct {
  char              active;
  pthread_mutex_t   mutex;
  er_path_mt        type;  
  er_option_mt    options;
  union {
    struct {
      int    fd;                /* int filedescr for FILEUNBUF */
    } unbuf;
    struct {
      FILE  *fp;                /* FILE* fp for FILEBUFPTR */
    } bufptr;
    struct {
      char  filename[80];       /* filename for FILEBUFNAM */
    } bufnam;
    struct {
      char  address[80];        /* address(es) for EMAIL */
    } email;
    struct {
      int facility;             /* openlog(3) parameters for SYSLOG */
      int logopt;
      char ident[32];
    } syslog;
  } desc;
} er_path_t;


#endif /* if 0 */

#ifdef __cplusplus
}
#endif



#undef EXTDEF
#undef EXTINI
#endif /* ER_H */
