#ifndef READ_ACCESS_CONTROL
#define READ_ACCESS_CONTROL

/***************************************
  $Revision: 1.5 $

  Access Control module (ac).

  Status: NOT REVUED, NOT TESTED

  +html+ <DL COMPACT>
  +html+ <DT>Online References:
  +html+ <DD><UL>
  +html+ </UL>
  +html+ </DL>
  +html+ <PRE>
  +html+ </PRE>
 
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#include "erroutines.h"
#include "iproutines.h"
#include "rxroutines.h"


#ifdef AC_IMPL
#define EXTDEF 
#else
#define EXTDEF extern
#endif

/* Access control structure */
typedef struct {
  unsigned maxbonus;    /* (before temporary denial) -1 == unlimited */
  int      maxpublic;   /* max# of public objects, -1 == unlimited (default) */
  short    maxdenials;  /* before the permanent ban is set */
  char     deny;        /* THE ban itself */
  char     trustpass;   /* has power to pass ip addresses */
} acl_st;


/* Accounting == counters */
typedef struct {
  int connections;
  int addrpasses;
  int denials;
  int queries;
  int public_objects;     
  int private_objects;    
  int private_bonus;      /* maintained only in runtime tree */
} acc_st;


#define ACC_PLUS 0
#define ACC_MINUS 1

void AC_init();
void AC_log(char *hostaddress);
char *AC_to_string();
char *AC_hostinfo_to_string();


/* MB */
er_ret_t AC_build(void);
er_ret_t AC_fetch_acc( ip_addr_t *, acc_st * );
er_ret_t AC_check_acl( ip_addr_t *, acc_st *, acl_st *);
void AC_acc_addup(acc_st *, acc_st *, int);
er_ret_t AC_commit(ip_addr_t *, acc_st *,acl_st * );
er_ret_t AC_rxwalkhook_print(rx_node_t *node, int level, int nodecounter, void *con);
er_ret_t AC_rxwalkhook_print_acl(rx_node_t *node, int level, int nodecounter, void *con);
er_ret_t AC_acc_load(void);


/* declare global accounting trees */
EXTDEF rx_tree_t  *act_runtime;
EXTDEF rx_tree_t  *act_hour;
EXTDEF rx_tree_t  *act_minute;

/* declare global access control list tree */
EXTDEF rx_tree_t  *act_acl;

#endif /* READ_ACCESS_CONTROL */
