/***************************************
  $Revision: 1.7 $

  Radix tree (rx).  rx_print.c - functions to print a forest/tree/node
                                 (mainly for debugging purposes)

  Status: NOT REVUED, TESTED, INCOMPLETE

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#define RX_IMPL
#include <rxroutines.h>

er_ret_t
rx_walk_hook_printnode(rx_node_t *node, int level, int nodecounter, void *trash)
{
  char line[200]="", buf[1024];

  int i;

  // indent
  for(i=0;i<level;i++) strcat(line,"  ");
  
  rx_nod_print(node, buf, 1024);

  fprintf(stderr,
	  "%s** level %d ** node: %s\n",
    // @ %p; parent %p, child[0]=%p, child[1]=%p\n", 
	  line, level, buf
	  );
    //  node, node->parent_ptr, node->child_ptr[0], node->child_ptr[1] );

  return RX_OK;
}

/***************************************************************************/

er_ret_t
rx_tree_print( rx_tree_t     *tree ) 
{
int cnt;
er_ret_t err;

 if( tree->top_ptr != NULL ) {
   cnt = rx_walk_tree(tree->top_ptr, rx_walk_hook_printnode, 
		      RX_WALK_CNTGLU,  // print also glue nodes
		      255, 0, 0, NULL, &err);
   fprintf(stderr,"Traversed %d nodes\n", cnt);
 }
 else {
   fprintf(stderr,"The tree is empty!\n");
 }

 return err;
}


/***************************************************************************/
static
void
rx_space_printone(void *voptr, void *junkdata)
{
rx_tree_t *ptr = voptr;
char prstr[IP_PREFSTR_MAX];

  printf("%50s:%d\n", "reg_id",   ptr->reg_id);
  printf("%50s:%d\n", "space",    ptr->space );
  printf("%50s:%d\n", "family",   ptr->family );
  printf("%50s:%d\n", "subtrees", ptr->subtrees);
  printf("%50s:%d\n", "mem_mode", ptr->mem_mode);
  printf("%50s:%d\n", "num_nodes",ptr->num_nodes);
  printf("%50s:%08x\n", "top_ptr", (int) ptr->top_ptr);
  printf("%50s:%d\n", "maxbits",  ptr->maxbits);

  if( IP_pref_b2a(  &(ptr->prefix), prstr, IP_PREFSTR_MAX) != IP_OK )
    die; // program error.

  printf("%50s:%s\n", "prefix", prstr);
}


/***************************************************************************/
/*+ print the whole forest +*/

void
rx_space_list(void)
{
g_list_foreach( rx_forest, rx_space_printone, NULL);
}
/***************************************************************************/

void
rx_nod_print( rx_node_t *node, char *buf, int maxchar )
{
  char pref[IP_PREFSTR_MAX];
  
  if( IP_pref_b2a(  &(node->prefix), pref, IP_PREFSTR_MAX) != IP_OK ) {
    die;
  }
  
  snprintf(buf, maxchar, "%s%s", 
	   ( node->glue ) ? "++glue++" : "", pref);
}
/***************************************************************************/

void 
rx_stk_print( rx_nodcpy_t   stack[],         // stack==array of node_copies
	      int           stackdepth )
{
  int i;
  rx_node_t *node;
  char buf[1024];

  ER_dbg_va(FAC_RX, ASP_RX_STKBLD_DET, 
	    "stack dump: %d elements", stackdepth);

  for(i = 0; i < stackdepth; i++) {
    node = & stack[i].cpy;

    rx_nod_print(node, buf, 1024);

    ER_dbg_va(FAC_RX, ASP_RX_STKBLD_DET, "position %d: %s", i, buf);
  }
}
