#ifndef READ_ATTRIBUTES
#define READ_ATTRIBUTES

/***************************************
  $Revision: 1.5 $

  Attributes module (at) - this _should_ eventually get merged in with the
  config module.

  Status: NOT REVUED, NOT TESTED

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#include <glib.h>
#include "bitmask.h"

/*+ Number of duplicate tokens in the Attributes[] array +*/
#define DUP_TOKENS 2

/*+ 
    All the attributes.
    Note: this _should_ match exactly with the Attributes[] array - but
    unfortunately they _could_ differ.  This may need re-designing.
+*/
typedef enum AT_Type_t {
  A_AC=0, /*+ admin-c       +*/            
  A_AA,   /*+ as-name       +*/            
  A_AD,   /*+ address       +*/            
  A_AG,   /*+ aggr-mtd      +*/           
  A_AB,   /*+ aggr-bndry    +*/         
  A_AH,   /*+ author        +*/             
  A_AN,   /*+ aut-num       +*/            
  A_AS,   /*+ as-set        +*/             
  A_AT,   /*+ auth          +*/               
  A_AZ,   /*+ alias         +*/              
  A_CE,   /*+ certif        +*/             
  A_CH,   /*+ changed       +*/            
  A_CY,   /*+ country       +*/            
  A_CN,   /*+ cross-nfy     +*/          
  A_CO,   /*+ components    +*/         
  A_CT,   /*+ cross-mnt     +*/          
  A_DA,   /*+ dom-name      +*/           
  A_DE,   /*+ descr         +*/              
  A_DF,   /*+ default       +*/            
  A_DC,   /*+ dictionary    +*/         
  A_DI,   /*+ dom-net       +*/            
  A_DN,   /*+ domain        +*/             
  A_DT,   /*+ upd-to        +*/             
  A_EC,   /*+ export-comps  +*/       
  A_EN,   /*+ encapsulatio n+*/      
  A_EM,   /*+ e-mail        +*/             
  A_EX,   /*+ export        +*/             
  A_FI,   /*+ filter        +*/             
  A_FP,   /*+ fingerpr      +*/           
  A_FS,   /*+ filter-set    +*/         
  A_FX,   /*+ fax-no        +*/             
  A_HO,   /*+ holes         +*/              
  A_IF,   /*+ ifaddr        +*/             
  A_IJ,   /*+ inject        +*/             
  A_IN,   /*+ inetnum       +*/            
  A_I6,   /*+ inet6num      +*/           
  A_IP,   /*+ import        +*/             
  A_IR,   /*+ inet-rtr      +*/           
  A_IS,   /*+ rtr-set       +*/            
  A_KC,   /*+ key-cert      +*/           
  A_LA,   /*+ local-as      +*/           
  A_LI,   /*+ limerick      +*/           
  A_MH,   /*+ method        +*/             
  A_MB,   /*+ mnt-by        +*/             
  A_ML,   /*+ mnt-lower     +*/          
  A_MO,   /*+ member-of     +*/          
  A_MR,   /*+ mbrs-by-ref   +*/        
  A_MS,   /*+ members       +*/            
  A_MT,   /*+ mntner        +*/             
  A_MN,   /*+ mnt-nfy       +*/            
  A_NA,   /*+ netname       +*/            
  A_NH,   /*+ nic-hdl       +*/            
  A_NS,   /*+ nserver       +*/            
  A_NY,   /*+ notify        +*/             
  A_OR,   /*+ origin        +*/             
  A_OW,   /*+ owner         +*/              
  A_PE,   /*+ peer          +*/               
  A_PG,   /*+ peering       +*/            
  A_PH,   /*+ phone         +*/              
  A_PL,   /*+ protocol      +*/           
  A_PN,   /*+ person        +*/             
  A_PS,   /*+ peering-set   +*/        
  A_RF,   /*+ refer         +*/              
  A_RM,   /*+ remarks       +*/            
  A_RO,   /*+ role          +*/               
  A_RP,   /*+ rp-attribute  +*/       
  A_RS,   /*+ route-set     +*/          
  A_RT,   /*+ route         +*/              
  A_RZ,   /*+ rev-srv       +*/            
  A_SD,   /*+ sub-dom       +*/            
  A_SO,   /*+ source        +*/             
  A_ST,   /*+ status        +*/             
  A_TB,   /*+ trouble       +*/            
  A_TD,   /*+ typedef       +*/            
  A_TC,   /*+ tech-c        +*/             
  A_TX,   /*+ text          +*/               
  A_WD,   /*+ withdrawn     +*/          
  A_ZC,   /*+ zone-c        +*/             
  A_END
} AT_Type;

char * const *AT_get_sources(void);
const char *AT_get_source(int index);
char * AT_sources_to_string(void);
char * AT_sources_list_to_string(GList *sources);
char * const *AT_get_attributes(void);
const char *AT_get_attribute(AT_Type attr_index, int offset);
const char *AT_get_attribute_desc(AT_Type attr_index);
const char *AT_get_attribute_frmt(AT_Type attr_index);
char *AT_attributes_to_string(int offset);

#endif /* READ_ATTRIBUTES */
