/*
 * gets.c,v 1.1 1994/01/28 17:22:27 franktor Exp
 *
 * gets.c  -  Prompt the user for a line of text and return it.
 *		This is a simple interface to the GNU readline library.
 *
 * Copyright (C) 1990,1992 UNINETT
 *
 * Geir Pedersen, Geir.Pedersen@usit.uio.no
 *
 * Frank: Added hook to log all input.
 *
*/

#include <stdio.h>
#include <sr-logger.h>

extern int	rl_bind_key (), *rl_insert ();
extern char	*readline ();
extern 		add_history ( );
extern int	rmrefnr;
extern		ToLogInp( );

void gnu_gets_setup ()
{
   rl_bind_key ( '\t', rl_insert );
}


char *gnu_gets ( prompt, from, buf, len )
   char			*prompt;
   FILE			*from;
   char	   		*buf;
   int               	len;
{
   static char          *gets_line      = (char *) NULL;

   if ( from != stdin )
   {
      char	*cp;

      if ( !fgets ( buf, len, from ) )
	 return (char *) NULL;
      if ( cp = (char *) index ( buf, '\n' ) )
	 *cp = '\0';
      return buf;
   }

   if ( gets_line != (char *) NULL )
      free ( gets_line );

   gets_line = readline ( prompt );

   if ( gets_line && *gets_line )
      add_history ( gets_line );

   if ( gets_line )
   {
      strncpy ( buf, gets_line, len );
      ToLogInp(rmrefnr, prompt, buf);
      return buf;
   }
   else
      return (char *) NULL;
}

char
gnu_getchar(char *prompt) {
  static char buf[2];
  (void) gnu_gets(prompt, stdin, buf, 1);
  ToLogInp(rmrefnr, prompt, buf);
  return *buf;
}
