/*
 * client.h,v 1.1 1994/01/28 17:06:20 franktor Exp
 */

#ifndef CLIENT_H
#define CLIENT_H

#include <sr-general.h>
#ifndef VMS
#include <high/client-structs.h>
#include <high/sr_structcodec.h>
#include <high/structcodec.h>
#include <high/sr_structproto.h>
#else
#include <client-structs.h>
#include <sr_structcodec.h>
#include <structcodec.h>
#include <sr_structproto.h>
#endif /* !VMS */

extern elemDesc desc_HC_Packet[]; /* From include/high/client-structdesc.h */

/* From backend.h */
int OpenConnection(connectionParameters *);


typedef struct ServerConnection {
  struct ServerConnection *next;/* Linked list, starting with first_client */
  int			ref;	/* Unique number */
  int			fd;	/* File descriptor in structcodec connection */
/*ServerConnectionStatus status; * Status of connection */
  HC_PacketTypes	status;	/* Tells what type of req/resp is pending */
  Boolean	selectOnWrite;
  HC_Packet		*packet; /* Pointer to incoming packets */
} ServerConnection;

#if 0
typedef enum ServerConnectionStatus {
  clientReady		= 0,	/* Client is ready for search/present */
  clientOpening		= 1,	/* Client is trying to open connection */
  clientInitialising	= 2,	/* Client has sent an initialize request */
  clientSearching	= 3,	/* Client has sent a search request */
  clientPresenting	= 4,	/* Client has sent a present request */
  clientDeleteResult	= 5,	/* Client has sent a delete result request */
  clientClosing		= 6 	/* Client has sent a close request */
} ServerConnectionStatus;
#endif
#endif
