
/* 
 * structcodec.h,v 1.1 1994/01/28 17:06:06 franktor Exp
 *
 * structcodec.h
 *
 * coder / decoder for c structores
 *
 * Geir Pedersen
*/

#ifndef STRUCTCODEC_H
#define STRUCTCODEC_H

#include <sr-general.h>

typedef enum socketStat { sockStatOK, sockStatFailed, sockStatClosed, sockStatPacketReady } socketStat; 

typedef enum elemType { elemDone, elemInt, elemBoolean, elemCharPtr, elemStruct,
		        elemStructPtr, elemEnum, elemUnion } elemType;

typedef struct elemDesc {
   elemType		type;
   struct elemDesc	*desc;
   unsigned int		size;
        /* index to element in structure descriptor deptermining which union element is to be used  */
   unsigned int		unionDiscriminator; 
} elemDesc;

/* routines available to structcodec users */

extern Boolean initialise_socket ( int fd, elemDesc *sending_struct, elemDesc *recv_struct );
void free_socket ( int fd );
extern socketStat handle_socket ( int fd, Boolean read, Boolean write, Boolean exception, Boolean *selectForWrite );
extern socketStat send_struct ( int fd, void *p, Boolean *selectForWrite );
extern socketStat read_struct ( int fd, void **p );
extern void free_struct ( void *P, elemDesc *topEd );

#endif
