#include "client.h"

#ifndef VMS
#include <malloc.h>
#else
#include <stdlib.h>
#endif

/*
 * HC_FreePacket():
 * Frees a HC_Packet received from/sent to the high-level client-server.
 * If you HC_Free() a packet you have built "by hand", note that all non-NULL
 * pointers in the packet are recursively followed and freed.
 */

void HC_FreePacket (HC_Packet *pk)
{
  free_struct (pk, desc_HC_Packet);
}



/*
 * HC_AllocPacket():
 * Allocate a HC_Packet and its "u" member, and set the type and ref members.
 */

HC_Packet *HC_AllocPacket (HC_PacketTypes type, int ref)
{
  static unsigned HC_packet_size[] = {
    sizeof(HC_OpenRequest),		sizeof(HC_OpenResponse),
    sizeof(HC_SearchRequest),		sizeof(HC_SearchResponse),
    sizeof(HC_PresentRequest),		sizeof(HC_PresentResponse),
    sizeof(HC_DeleteResultSetRequest),	sizeof(HC_DeleteResultSetResponse),
    sizeof(HC_CloseRequest),		sizeof(HC_CloseResponse),
    sizeof(HC_ErrorMsg),		0
  };
  HC_Packet		*pk = (HC_Packet *) malloc ( sizeof(HC_Packet) );
  pk->type		= type;
  pk->ref		= ref;
  *((void **)&(pk->u))	= calloc ( 1, HC_packet_size[type] );
  return pk;
}
