#!/usr/bin/perl

# $Id: lg.cgi,v 1.4 2010/02/18 15:53:56 bergroth Exp $

#
# Whacked (reimplemented) looking-glass CGI script using CGI.pm.
# Havard Eidnes (he@nordu.net) 21 Feb 2000.
#

use CGI;
use Net::Telnet ();
use Net::DNS ();
use File::Basename;

push(INC, ".");

# $|=1;

$setupfile = basename($0, ".cgi") . "-setup.pl";

require $setupfile;

# when to display cache?  max time difference (in seconds)
if (!defined($max_time_diff)) {
    $max_time_diff = "180";		# 3 minutes
}

# Ensure $cache_dir is set
if (!defined($cache_dir)) {
    $cache_dir = "./lg-cache";
}

# Ensure that %queries is defined
if (!defined(%queries)) {
    %queries = (
		"bgp" => "show ip bgp",
		"bgp dampened-paths" => "show ip bgp dampened-paths",
		"bgp flap-statistics" => "show ip bgp flap-statistics",
#		"bgp summary" => "show ip bgp summary",
#		"environmental" => "show enviro all",
		"mbgp" => "show ip mbgp",
		"mroute" => "show ip mroute",
		"mroute summary" => "show ip mroute summary",
		"msdp" => "show ip msdp summary",
		"mtrace" => "mtrace",
		"sdr" => "show ip sdr",
		"ping" => "ping",
		"trace" => "trace",
#		"CPU" => "sh processes cpu",
#		"memory" => "sh processes memory",
		);

    %Juniperqueries = (
		"bgp" => "show route protocol bgp",
		"bgp dampened-paths" => "show route protocol bgp damping suppressed",
		"bgp flap-statistics" => "show route protocol bgp damping history",
#		"bgp summary" => "show bgp summary",
#		"environmental" => "show chassis environment",
		"mbgp" => "show route protocol bgp table inet.2",
		"mroute" => "show multicast route group",
		"mroute summary" => "show multicast route brief",
		"msdp" => "show msdp",
		"mtrace" => "mtrace",
		"sdr" => "show multicast sessions",
		"ping" => "ping interface lo0 count 5",
		"trace" => "traceroute interface lo0",
#		"CPU" => "show system processes summary",
#		"memory" => "show system processes brief",
		);
}

$q = new CGI;

# XXX check HTTP_REFERER?


# Make sure they typed in something

$qt = $q->param('query');
$router = $q->param('router');
#$isJuniper = ($router =~ /0-rtr/);
$isJuniper = $Junipers{$router};
$arg = $q->param('arg');
$arg =~ s/\s+$//g;
$arg =~ s/^\s+//g;


# Validate the input:

if (! &validate_router($router)) {
    $results[0] = "You did not pick one of the listed routers.\n";
    &print_results("");
}

#if ($arg !~ /^[-A-Za-z0-9_\/| \.]*$/) {
if ($arg !~ /^[-A-Za-z0-9_\/ \.\:]*$/) {
    $results[0] = "Funny characters in argument; ignoring.\n";
    &print_results("");
}

if (length($arg) >= 50) {
    $results[0] = "Too long argument string; ignoring.\n";
    &print_results("");
}

# Remove bad arguments
if (($arg ne '')&&(($qt eq "bgp") || ($qt eq "mbgp"))) {
    if (("neighbor" =~ m/$arg/i) ||
	("summary" =~ m/$arg/i)) {
	$results[0] = "Disallowed arguments; ignoring.\n";
	&print_results("");
    }

}


# If given no query, just display the query page.

if (! defined($qt)) {
    &print_results("");
}

# For some commands refuse to execute without an argument
if ((($qt eq "bgp") ||
     ($qt eq "mbgp") ||
     ($qt eq "mroute")) &&
    (! defined($arg) || ($arg eq "")))
{
    if ($isJuniper) {
	$results[0] = "Please give argument to \'$Juniperqueries{$qt}\'.\n";
    } else {
	$results[0] = "Please give argument to \'show ip $qt\'.\n";
    }

    $results[1] = "Dumping the entire table would cause too much stress\n";
    $results[2] = "on this machine.\n";
    if ($isJuniper) {
	&print_results($Juniperqueries{$qt});
    } else {
	&print_results($queries{$qt});
    }
}

# Some queries we force to the cache if no arg given
# ...as a somewhat lame attempt at prevent collection of massive
# amounts of data...
if (($qt eq "bgp flap-statistics") ||
    ($qt eq "bgp dampened-paths") ||
    ($qt eq "mroute summary") ||
    ($qt eq "msdp sa-cache")
    )
{
    if (! defined($arg) || ($arg eq "")) {
	$file = "$cache_dir/$router,$qt";
	$file =~ s/ /,/g;

	if (-e $file) {
	    @stat = stat($file);
	    $mtime = $stat[9];
	    $dtime = time - $mtime;

	    if ($dtime <= $max_time_diff) {
		open(CACHE, "<$file");
		while(<CACHE>) {
		    push(@results, $_);
		}
		close(CACHE);
		$seconds = $dtime;
		if ($isJuniper) { # TSS ESIMERKKI
			&print_results($Juniperqueries{$qt});
		} else {
			&print_results($queries{$qt});
		}
	    }
	}
	if ($isJuniper) {
		@results = &DoTelnet($router, $Juniperqueries{$qt}); #KORJAA
	} else {
		@results = &DoTelnet($router, $queries{$qt}); #KORJAA
	}
	open(CACHE, ">$file$$") || die "Could not create $file$$: $!";
	foreach $n (0 .. $#results) {
	    print CACHE $results[$n];
	}
	close CACHE;
	rename("$file$$", "$file"); # for atomic cache file update
	if ($isJuniper) {
		&print_results($Juniperqueries{$qt}); #KORJAA
	} else {
		&print_results($queries{$qt}); #KORJAA
	}
    }
    else			# Parameter given, do command
    {
	if ($isJuniper) {
		&DoCmd($router, $Juniperqueries{$qt} . " $arg"); #KORJAA
	} else {
		&DoCmd($router, $queries{$qt} . " $arg"); #KORJAA
	}
    }
}
elsif (defined $queries{$qt}) {
	if ($isJuniper) {
    		&DoCmd($router, $Juniperqueries{$qt} . " $arg"); #KORJAA
	} else {
    		&DoCmd($router, $queries{$qt} . " $arg"); #KORJAA
	}
}
else
{
    $results[0] = "Unknown query: $qt\n";
    &print_results($qt);
}

exit(1);


sub print_header {
    my($try);

    print $q->header();
    $try = basename($0, ".cgi") . "-head.html";
    if (-f $try) {
	&print_file($try);
    } else {
	&print_file("head.html");
    }
}

sub print_form {
    my($r, $q);
    my(@qrs, $n, $i, $j);

    print <<END
<form
    method="POST"
    action="./lg.cgi#result">

<dl>
<dt> <b>Query:</b>
   <dd>
END
    ;
    print "   <select name=\"router\">\n";
    foreach $r (@routers) {
	if (defined($router) && $r eq $router) {
	    print "     <option selected>$r\n";
	} else {
	    print "     <option>$r\n";
	}
    }
    print "   </select>\n";

    print " <table cellspacing=10>\n";
    @qrs = sort(keys %queries);
    $n = ($#qrs + 1) / 3;
    print "     <tr>\n";
    for ($i = 0; $i < 3; $i++) {
	print "       <td>\n";
	for ($j = 0; $j < $n; $j++) {
	    $q = shift @qrs;
	    if (defined($q)) {
		print "<input type=radio name=\"query\" value=\"$q\"";
		if (defined($qt) && $q eq $qt) {
		    print " checked"
		    }
		print "> $q";
		print "<br>\n";
	    }
	}
    }
    print "     </tr>\n";
    print "  </table>\n";

    print <<END
	<br> &nbsp;
	<dd>
    <b>Argument:</b>
END
    ;
    if (defined($arg)) {
	print "  <input name=\"arg\" size=20 value=\"$arg\">\n";
    } else {
	print "  <input name=\"arg\" size=20>\n";
    }

    print <<END
	<br> &nbsp;
	<dd> 
	<input type=submit value="Submit"> |
	<input type=reset value="Reset"> 
END
    ;


    print <<END
   <dd>
   <dd>
<p>
END
    ;

    print <<END
</dl>

<p>

</form>
END
    ;
}

sub print_result_header {
    my($cmd) = @_;

    print "<hr width=85% size=2>\n";
    print "<a name=result><h2>Results of query:</h2>\n";
    
    print <<END

<b>Router:</b> $router<br>
<b>Command:</b> '$cmd'<br>
<p>

<pre>
END
    ;
    select(STDOUT); $| = 1;	# unbuffer
}

sub print_result_trailer {

    print <<END

</pre>
END
    ;
}

sub print_file {
    my($fn) = @_;

    open(INFILE, "<$fn");
    while (<INFILE>) {
	print;
    }
    close(INFILE);
}

sub print_trailer {

    &print_file("tail.html");
}

sub print_results {
    my($cmd) = @_;

    &print_header();
    &print_form();

    if (defined($qt)) {		# This is the result of a query 

	&print_result_header($cmd);

	if ($seconds) {
	    print "<b>";
	    print "From cache (age: $seconds secs) ";
	    print "(max: $max_time_diff secs)";
	    print "</b><br>\n\n";
	}

	foreach $n (0 .. $#results) {
	    print $results[$n];
	}

    }

    &print_trailer();
    exit(0);
}

sub DoCmd {
    my($router, $cmd) = @_;
    
    &print_header();
    &print_form();
    &print_result_header($cmd);

    &DoTelnetLM($router, $cmd);
    &print_result_trailer();
    &print_trailer();
    exit(0);
}

# Try to prepend lo0. to the name, to use the NORDUnet convention of
# naming the loopback interface on our router.  The loopback is always
# up, and is a way to ensure that we're not being hit by problems
# caused by lack of maintenance of the DNS mappings...

sub tryL0 {
    my($router) = @_;
    my($l0) = "lo0." . $router;
    my($q, $res, $rr);

    $res = new Net::DNS::Resolver;
    $q = $res->search($l0);
    if ($q) {
	foreach $rr ($q->answer) {
	    next unless $rr->type eq "A";
	    return $l0;
	}
    }
    return $router;
}
	      
sub get_login {
    my($router) = @_;
    my($l, @f, $id, $pass);

    if (!open(IN, "/etc/lg-login")) {
	$out[0] = "Could not open login-info: $!\n";
	return @out;
    }
    $l = <IN>;
    @f = split(' ', $l);

    $id = $f[0];
    $pass = $f[1];

    close(IN);
    return ($id, $pass);
}

sub get_prompt {
    my($router) = @_;
    my($ix, $p);

    if (($ix = index($router, ".")) != -1) {
	$p = substr($router, 0, $ix);
	if ($isJuniper) { $p .= '-re[01]'; }
	$p .= '[>\#]';
	return $p;
    }
    
    return '-re[01][>\#]';
}

sub DoTelnet {
    my($router, $cmd) = @_;
    my($t, @out, $id, $pass,$p);

    ($id, $pass) = &get_login($router);
    if ($isJuniper) {
	$p= "$id\\@".$p;
    }

    $t = new Net::Telnet(Timeout => 10,
			 Prompt => "/" . $p . "/",
			 );
    $t->errmode("return");
    $t->open(&tryL0($router));
    if (!defined $t->login($id, $pass)) {
	$out[0] = "Error logging in to router:<br>\n";
	$out[1] = $t->errmsg();
	$t->close;
	return @out;
    }
    if ($isJuniper) {
    	if (!defined($t->cmd("set cli screen-length 0"))) {
		$out[0] = "Error doing \"set cli screen-length 0\":<br>\n";
		$out[1] = $t->errmsg();
		$t->close;
		return @out;
    	}
    } else {
    	if (!defined($t->cmd("term len 0"))) {
		$out[0] = "Error doing \"term len 0\":<br>\n";
		$out[1] = $t->errmsg();
		$t->close;
		return @out;
    	}
    }
    @out = $t->cmd(String => "$cmd",
		   Timeout => 60,
		   
		   );
    if ($#out == -1) {
	$out[0] = "Error processing request:<br>\n";
	$out[3] = $t->errmsg();
    }
    $t->close;
    return @out;
}

# Do "one-line-at-a-time and print results while we go" command
# execution.

sub DoTelnetLM {
    my($router, $cmd) = @_;
    my($t, $id, $pass, $p, $first);

    if ($isJuniper) {
	$p= "$id\\@".$p;
    }
    ($id, $pass) = &get_login($router);

    $p = &get_prompt($router);
    if ($isJuniper) {
	$p= "$id\\@".$p;
    }
    $t = new Net::Telnet(Timeout => 10,
			 Prompt => "/" . $p . "/",
			 );
    $t->errmode("return");
    $t->open(&tryL0($router));
    if (!defined $t->login($id, $pass)) {
	print "Error logging in to router:<br>\n";
	print $t->errmsg();
	$t->close;
	return;
    }
    if ($isJuniper) {
    	if (!defined($t->cmd("set cli screen-length 0"))) {
		print "Error doing \"set cli screen-length 0\":<br>\n";
		print $t->errmsg();
		$t->close;
		return;
    	}
    } else {
    	if (!defined($t->cmd("term len 0"))) {
		print "Error doing \"term len 0\":<br>\n";
		print $t->errmsg();
		$t->close;
		return;
    	}
    }

    $t->print("$cmd");

    # We need to do this "by hand", since the "cmd()" method
    # returns all the output on one blob, and we want to process it
    # line-by-line.

    my($l) = "";
    my($timeout) = 5;
    my($first) = 0;
    my($ttweak) = 0;		# tweaked timeout?

    while($l !~ /^$p/) {
	$l = $t->getline(Timeout => $timeout);
	if (!defined($l)) {
	    if ($ttweak == 0) {
		$t->print("");
		$timeout = 15;	# increase timeout
		$ttweak = 1;
		next;		# try again, see if we get prompt
				# This is because the prompt is not on
				# a complete line by itself, so we
				# don't get at it via getline().
	    }
	    if ($ttweak == 1) {
		$t->print("");	# one more try, e.g. at end of traceroute
		$ttweak = 2;
		next;
	    }
	    print "Timed out waiting for data:<br>\n";
	    print $t->errmsg();
	    $t->close;
	    return;
	}
	if ($first == 0) {
	    $first = 1;
	    next;		# Drop first line (echo of command)
	}
	if ($l !~ /^$p/) {	# Don't print prompt at end
	    print $l;
	}
    }

    $t->close;
    return;
}

#

sub validate_router {
    my($router) = @_;
    my($r);

    foreach $r (@routers) {
	if ($router eq $r) {
	    return 1;
	}
    }
    return undef;
}
