#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/signal.h>
#include <sys/errno.h>

#define RETRY_LIMIT	5
#define RETRY_DELAY	1

int old_sigmask = 0;
#define BEGIN_CRITICAL	{ old_sigmask = sigblock(~0); open_lockfile(); }
#define END_CRITICAL	{ sigsetmask(old_sigmask); close_lockfile(); }

int lock_fd = -1;
char *lock_name = "lock";

open_lockfile()
{
  register int retries=0;

  while ((lock_fd=open(lock_name, O_RDONLY|O_CREAT|O_BLKANDSET|O_NDELAY, 0666))
	 < 0  &&  errno == EWOULDBLOCK) {
    if (retries++ > RETRY_LIMIT) {
      fprintf(stderr, "%s: lock file busy (too many retries)\n", lock_name);
      exit(-1);
    }
    sleep(RETRY_DELAY);
  }
  if (lock_fd < 0) {
    perror(lock_name);
    exit(-1);
  }
}

close_lockfile()
{
  if (lock_fd >= 0)
    close(lock_fd);
  unlink(lock_name);
}

char *progname;

main(argc,argv)
     int argc;
     char **argv;
{
  int stat;
  char str[255];

  progname = argv[0];
  argc--; argv++;

  if (*argv[0] == '-')
    if (argv[0][1] == 'l') {
      if (argv[0][2])
	lock_name = &argv[0][2];
      else if (argv[1]) {
	lock_name = argv[1];
	argc--; argv++;
      }
      else {
	fprintf(stderr, "Missing lock file name\n");
	usage();
	/*NOTREACHED*/
      }
      argc--; argv++;
    }
    else {
      fprintf(stderr, "Unknown option -%c\n", argv[0][1]);
      usage();
      /*NOTREACHED*/
    }
  if (argc < 2) {
    fprintf(stderr, "Missing filename\n");
    usage();
    /*NOTREACHED*/
  }
  sprintf(str, "%s -> %s", argv[0], argv[1]);
  BEGIN_CRITICAL;
  if (rename(argv[0], argv[1]) < 0)
    perror(str);
  END_CRITICAL;
}

usage()
{
  fprintf(stderr, "Usage:  %s [-l lock] f1 f2\n   Renames 'f1' to 'f2' while holding an exclusive \"in-use\" lock\n   on 'lock' (default \"lock\").\n", progname);
  exit(1);
}

