#include	<stdio.h>
#include	"oracle.h"
/*
**      ORACLE -- ho ho         Copyright (c) P. S. Langston - NYC NY  1978
*/

static  char    *sccs   = "@(#)oracle.c	1.12  10/19/85 -- (c) psl  
978";
static  char    *h_sccs = H_SCCS;

short	uid;

int     bye();
struct  questr *findq();
extern  char    *copy(), *uidnam();

main(argc, argv)
char	*argv[];
{
	char buf[TEXTLEN];
	int i;
	long now;
	struct questr *qp;

	sysinit("oracle", argc, argv);
	uid = myruid();
	if (uid == NO_ONE) {
	    printf("Sorry, super-user.");
	    printf("  Everybody knows super-users already know everything\n");
	    exit(1);
	}
	time(&now);
	srand((int) now & 0xFFFF);
	printf("Welcome to Ask-the-Oracle ...\n\n");
	printf("I am able to answer short questions of a general nature.\n");
	printf("I'm not too good on personal problems (although I'll try)\n");
	for (;;) {
	    questn("Do you have a question that you need answered? ",
	     buf, TEXTLEN);
	    if (buf[0] == 'y')
		break;
	    else if (buf[0] == 'n') {
		printf("When, (and if), you do, let me know\n");
		if (rand() & 020)
		    goto ask;
		exit(1);
	    } else if (buf[0] == 's' && buf[1] == 'n' && uid == privuid) {
		snoop(buf[2]);
		exit(0);
	    } else if (buf[0] == 'a' && buf[1] == 'n' && uid == privuid)
		goto ask;
	    else if (buf[0] == 'p' && buf[1] == 'u' && uid == privuid) {
		purge();
		exit(0);
	    } else
		printf("Please answer with \"yes\" or \"no\"\n");
	}
	for (i = 0; i < 10; i++) {
	    questn("\nWhat is your question? (one line only)\n", buf, 128);
	    if (issent(buf))
		break;
	    if (i & 1)
		printf("I don't understand that.  Try re-phrasing it\n");
	    else
		printf("Try again, this time using a complete sentence.\n");
	}
	if (i >= 10)
	    exit(1);
	i = newquest(buf);
	if (i == 0) {
	    printf("%s", hmm[rand() % 9]);
	    printf("I'll have to think that over and mail you an answer.\n");
	}
ask:
	if ((qp = findq()) == 0)
	    exit(0);
	printf("Meanwhile, perhaps you could answer this question for me:\n");
	answer(qp);
}

answer(qp)
struct  questr *qp;
{
	char buf[TEXTLEN];
	int i;

	for (i = 0; i < 10; i++) {
	    printf("%s", qp->q_quest);
	    questn(" (one line only)\n", buf, TEXTLEN);
	    if (issent(buf))
		break;
	    if (i & 1)
		printf("Can you be more explicit?\n");
	    else
		printf("Please answer the question in more detail\n");
	}
	printf("Thank you\n");
	oldquest(qp, buf);
}

issent(buf)
char    *buf;
{
	register char *cp, c;
	int wds, vow;

	wds = vow = 0;
	for (cp = buf; c = *cp; cp++) {
	    c &= ~040;
	    if (c == 'A'
	    || c == 'E'
	    || c == 'I'
	    || c == 'O'
	    || c == 'U'
	    || c == 'Y')
		vow++;
	    else if (c < '@') {
		if (vow && ++wds > 3)
		    return(1);
		vow = 0;
	    }
	}
	return(0);
}

newquest(quest)
char    *quest;
{
	struct questr q;
	FILE *ifp;


	if (can_answer(quest))
	    return(1);
	if ((ifp = fopen(indexfile, "a")) == NULL) {
	    fprintf(stderr, "Can't open %s for append\n", indexfile);
	    exit(3);
	}
	q.q_askuid = uid;
	q.q_ansuid = NO_ONE;
	strcpy(q.q_asknam, uidnam(uid));
	lock(&lck);
	strcpy(q.q_quest, quest);
	time(&(q.q_askdat));
	fwrite(&q, sizeof q, 1, ifp);
	fclose(ifp);
	unlock(&lck);
	return(0);
}

struct  questr *
findq()
{
	register int n;
	FILE *ifp;
	static struct questr q;

	if ((ifp = fopen(indexfile, "r")) == NULL) {
	    fprintf(stderr, "Can't open %s for read\n", indexfile);
	    exit(3);
	}
	for (n = 0; fread(&q, sizeof q, 1, ifp) > 0; n++) {
	    if (q.q_ansuid == NO_ONE && q.q_askuid != uid) {
		fclose(ifp);
		q.q_ansuid = n;	/* save question number in ansuid */
		return(&q);
	    }
	}
	fclose(ifp);
	return(0);
}

snoop(arg)
char    arg;
{
	char buf[10];
	int n;
	struct questr q;
	FILE *ifp;

	if ((ifp = fopen(indexfile, "r")) == NULL) {
	    fprintf(stderr, "Can't open %s for read\n", indexfile);
	    exit(3);
	}
	for (n = 0; fread(&q, sizeof q, 1, ifp) > 0; n++) {
	    if (arg != 'o' && q.q_ansuid != NO_ONE)
		continue;
	    printf("\nAsked by %s (%d) %s",
	     q.q_asknam, q.q_askuid, ctime(&q.q_askdat));
	    printf(" %s\n", q.q_quest);
	    if (q.q_ansuid == NO_ONE) {
		questn("Skip, Answer, Reject or Quit? (s|a|r|q) ", buf, 10);
		q.q_ansuid = n;                    /* in case we answer it */
		if (buf[0] == 'a')
		    answer(&q);
		else if (buf[0] == 'r')
		    oldquest(&q, "Your question is rejected as unworthy.");
		else if (buf[0] == 'q')
		    break;
	    } else {
		printf("Answered by %s (%d) %s",
		 q.q_ansnam, q.q_ansuid, ctime(&q.q_ansdat));
		printf(" %s\n", q.q_answer);
	    }
	}
	fclose(ifp);
}

purge()
{
	struct questr q;
	FILE *ifp, *tfp;

	if ((ifp = fopen(indexfile, "r")) == NULL) {
	    fprintf(stderr, "Can't open %s for read\n", indexfile);
	    exit(3);
	}
	lock(&lck);
	if ((tfp = fopen(tmpfile, "w")) == NULL) {
	    fprintf(stderr, "Can't open %s for write\n", tmpfile);
	    bye();
	}
	while (fread(&q, sizeof q, 1, ifp) > 0) {
	    if (q.q_ansuid != NO_ONE)
		continue;
	    if (fwrite(&q, sizeof q, 1, tfp) <= 0) {
		fprintf(stderr, "Couldn't write out an unanswered question\n");
		bye();
	    }
	}
	fclose(ifp);
	fclose(tfp);
	if (unlink(indexfile) == -1)
	    perror(indexfile);
	if (link(tmpfile, indexfile) != -1)
	    unlink(tmpfile);
	else
	    perror(tmpfile);
	unlock(&lck);
}

oldquest(qp, answer)
struct  questr *qp;
char    *answer;
{
	register int n, fh;
	char buf[128];
	long addr;

	if ((fh = open(indexfile, 2)) < 0) {
	    fprintf(stderr, "Can't open %s for writing\n", indexfile);
	    exit(3);
	}
	addr = qp->q_ansuid;		/* question number was saved here */
	addr *= sizeof *qp;
	lock(&lck);
	qp->q_ansuid = uid;
	strcpy(qp->q_ansnam, uidnam(uid));
	strcpy(qp->q_answer, answer);
	time(&(qp->q_ansdat));
	if (sendans(qp) == -1) {
	    fprintf(stderr, "I don't think that's right...\n");
	    fprintf(stderr, "But thanks for trying.\n");
	    bye();
	}
	lseek(fh, addr, 0);
	if (write(fh, qp, sizeof (*qp)) != sizeof (*qp))
	    fprintf(stderr, "I have trouble remembering that answer.\n");
	close(fh);
	unlock(&lck);
}

sendans(qp)
struct  questr *qp;
{
	char *cp, buf[512], fname[64];

	cp = copy("\tConcerning your question:\n\"", buf);
	cp = copy(qp->q_quest, cp);
	cp = copy("\"\n\tThe Oracle says:\n\"", cp);
	cp = copy(qp->q_answer, cp);
	cp = copy("\"\n", cp);
	anonmail("Delphi!Oracle", qp->q_asknam, buf);	/* send it disguised */
}

bye()
{
	while (unlock(&lck) > 0);
	exit(1);
}

can_answer(quest)                         /* try to catch common questions */
char    *quest;
{
	register char *cp, *qp, c;
	char qbuf[128], buf[128];
	int retval;
	FILE *qfp;

	if ((qfp = fopen(q_afile, "r")) == NULL)
	    return(0);
	for (cp = quest, qp = qbuf; c = *cp++; ) {
	    if ((c < '0' && c != ' ')
	     || (c > '9' && c < 'A')
	     || (c > 'Z' && c < 'a')
	     || c > 'z')
		continue;
	    if (c >= 'A' && c <= 'Z')
		c |= 040;
	    *qp++ = c;
	}
	*qp++ = '\n';
	*qp = '\0';
	for (retval = 0; !feof(qfp); ) {
	    while (fgets(buf, sizeof buf, qfp) != NULL && *buf != 'Q');
	    if (*buf != 'Q')
		break;
	    if (glbmtch(qbuf, &buf[1])) {
		while (fgets(buf, sizeof buf, qfp) != NULL && *buf != 'A');
		do {
		    fputs(&buf[1], stdout);
		} while (fgets(buf, sizeof buf, qfp) != NULL && *buf == 'A');
		retval = 1;
		break;
	    }
	}
	fclose(qfp);
	return(retval);
}

glbmtch(str, pat)
char    *str, *pat;
{
	register pc, sc, ok;

	for (;;) {
	    pc = *pat++;
	    if ((sc = *str++) == '\0') {
		if (pc == '\0')
		    return(1);
		if (pc != '*')
		    return(0);
	    }
	    if (pc == '*') {
		if (*pat != '\0')
		    for (--str; !glbmtch(str, pat);)
			if (*str++ == '\0')
			    return(0);
		return(1);
	    }
	    if (pc == '[') {
		for (ok = 0; ; ) {
		    if ((pc = *pat++) == '\0')
			return(0);
		    if (pc == ']') {
			if (ok)
			    break;
			return(0);
		    }
		    if (pc == '-') {
			if ((pc = *pat++) == '\0')
			    return(0);
			if (sc <= (pc &= 0177) && sc >= (pat[-3] & 0177))
			    ok = 1;
		    } else if (sc == (pc &= 0177))
			ok = 1;
		}
		continue;
	    }
	    if (pc != '?' && sc != (pc &= 0177))
		return(0);
	}
}
