/******************************************/
/* printpla.c                             */
/*                                        */
/* Functions to print the data            */
/* from RST- or DAT-files                 */
/*                                        */
/* (c) 1995 C. Quix                       */
/* Email: Christoph_Quix@p17.ks.fido.de   */
/******************************************/
#include <stdio.h>
#include "planets.h"

#define blank putc(' ',fp)
#define nl    putc('\n',fp)

void printString(FILE *fp, char *str, WORD length)  {
	WORD i;
	for(i=0;i<length;i++) putc(str[i],fp);
}


void printTorp(FILE *fp, WORD index)  {
	
	switch(index)  {
	 case 1: 
		fprintf(fp,"M1");
		break;
	 case 2:
		fprintf(fp,"Pr");
		break;
	 case 3:
		fprintf(fp,"M2");
		break;
	 case 4:
		fprintf(fp,"GB");
		break;
	 case 5:
		fprintf(fp,"M3");
		break;
	 case 6:
		fprintf(fp,"M4");
		break;
	 case 7:
		fprintf(fp,"M5");
		break;
	 case 8:
		fprintf(fp,"M6");
		break;
	 case 9:
		fprintf(fp,"M7");
		break;
	 case 10:
		fprintf(fp,"M8");
		break;
	 default: 
		fprintf(fp,"--");
	}
}


void printBeam(FILE *fp, WORD index)  {
	
	switch(index)  {
	 case 1: 
		fprintf(fp,"Las ");
		break;
	 case 2:
		fprintf(fp,"XRay");
		break;
	 case 3:
		fprintf(fp,"Plas");
		break;
	 case 4:
		fprintf(fp,"Blas");
		break;
	 case 5:
		fprintf(fp,"PosB");
		break;
	 case 6:
		fprintf(fp,"Disr");
		break;
	 case 7:
		fprintf(fp,"HeBl");
		break;
	 case 8:
		fprintf(fp,"Phas");
		break;
	 case 9:
		fprintf(fp,"HeDi");
		break;
	 case 10:
		fprintf(fp,"HePh");
		break;
	 default: 
		fprintf(fp,"----");
	}
}


void printShips(FILE *fp, Ship* s, ShipXY *xy, WORD numberOfShips)  {
	
	extern HullSpec   hullSpecs[MAXHULL];
	extern XYPlan     xyPlanetData[MAXPLANET];
	extern PlanetName planetNames[MAXPLANET];
	extern RaceName   raceNames[MAXRACE];
	extern WORD       raceNumber;

	WORD i,j,ok;
	LONG sumFuel=0,sumTrit=0,sumDura=0,sumMoly=0,sumClan=0,sumSupp=0,sumMC=0,sumTorp=0,sumFigh=0;
	
	fprintf(fp,"Ships of ");
	printString(fp,raceNames[raceNumber-1].longName,30);
	nl;
	fprintf(fp,"%-4s","ID");
	fprintf(fp,"%-21s","Name");
	fprintf(fp,"%-31s","Hull Type");
	fprintf(fp,"%-12s","Location");
	fprintf(fp,"%-12s","Waypoint");
	fprintf(fp,"%-2s","W");
	fprintf(fp,"%-3s","En");
	fprintf(fp,"%-5s","Beam");
	fprintf(fp,"%-3s","#");
	fprintf(fp,"%-3s","Trp");
	fprintf(fp,"%-3s"," #");
	fprintf(fp,"%-3s","Bay");
	fprintf(fp,"%-4s","L/F"); /* 102 */
	fprintf(fp,"%-5s","Miss");
	fprintf(fp,"%-4s","TwIc");
	fprintf(fp,"%-5s","Enmy");
	fprintf(fp,"%-3s","Dm");
	fprintf(fp,"%-5s","Crew");
	fprintf(fp,"%-5s","Clan"); /*128*/
	fprintf(fp,"%-5s","Fuel");
	fprintf(fp,"%-5s","Trit");
	fprintf(fp,"%-5s","Dura");
	fprintf(fp,"%-5s","Moly");
	fprintf(fp,"%-5s","Supp");
	fprintf(fp,"%-5s"," MC ");
	fprintf(fp,"%-5s","Wght");
	fprintf(fp,"%-10s","Orb. Ships");
	nl;
	for(i=0;i<178;i++) putc('-',fp);
	nl;
	
	for(i=0;i<numberOfShips;i++)  {
		fprintf(fp,"%3d ",s[i].id);
		printString(fp,s[i].name,20);
		blank;
		printString(fp,hullSpecs[s[i].hullType-1].name,30);
		blank;
		ok=0;
		for (j=0;j<MAXPLANET;j++)  {
			if ((xyPlanetData[j].x==s[i].x) && (xyPlanetData[j].y==s[i].y) && (!ok))  {
				printString(fp,planetNames[j].name,11);
				blank;
				ok=1;
			}
		}
		if (!ok)  {
			fprintf(fp,"(%4d,%4d) ",s[i].x,s[i].y);
		}
		ok=0;
		for (j=0;j<MAXPLANET;j++)  {
			if ((xyPlanetData[j].x==s[i].x+s[i].deltax) && (xyPlanetData[j].y==s[i].y+s[i].deltay) && (!ok))  {
				printString(fp,planetNames[j].name,11);
				blank;
				ok=1;
			}
		}
		if (!ok)  {
			fprintf(fp,"(%4d,%4d) ",s[i].x+s[i].deltax,s[i].y+s[i].deltay);
		}
		
		fprintf(fp,"%1d ",s[i].warp);
	    fprintf(fp,"%2d ",s[i].engineIndex);
		printBeam(fp,s[i].beamIndex);
		blank;
		fprintf(fp,"%2d ",s[i].numberOfBeams);
		printTorp(fp,s[i].torpIndex);
		blank;
		fprintf(fp,"%2d ",s[i].numberOfLaunchers);
		fprintf(fp,"%2d ",s[i].numberOfBays);
		fprintf(fp,"%3d ",s[i].numberOfFightTorp);
		if (s[i].numberOfLaunchers)
			sumTorp+=s[i].numberOfFightTorp;
		if (s[i].numberOfBays)
			sumFigh+=s[i].numberOfFightTorp;
		
		switch(s[i].mission)  {
		 case 1: 
			fprintf(fp,"Expl ");
			fprintf(fp,"---");
			break;
		 case 2:
			fprintf(fp,"MiSw ");
			fprintf(fp,"---");
			break;
		 case 3:
			fprintf(fp,"LayM ");
			fprintf(fp,"---");
			break;
		 case 4:
			fprintf(fp,"Kill ");
			fprintf(fp,"---");
			break;
		 case 5:
			fprintf(fp,"SeSw ");
			fprintf(fp,"---");
			break;
		 case 6:
			fprintf(fp,"Col  ");
			fprintf(fp,"---");
			break;
		 case 7:
			fprintf(fp,"Tow  ");
			fprintf(fp,"%3d",s[i].towed);
			break;
		 case 8:
			fprintf(fp,"Intc ");
			fprintf(fp,"%3d",s[i].intercept);
			break;
		 case 9:
			fprintf(fp,"Spe1 ");
			fprintf(fp,"---");
			break;
		 case 10:
			fprintf(fp,"Spe2 ");
			fprintf(fp,"---");
			break;
		 default: 
			fprintf(fp," %2d  ",s[i].mission);
			fprintf(fp,"---");
		}
		blank;
		if (s[i].enemy)
			printString(fp,raceNames[s[i].enemy-1].shortName,4);
		else
			fprintf(fp,"----");
		blank;
		fprintf(fp,"%2d",s[i].damage);
		fprintf(fp,"%5d",s[i].crew);
		fprintf(fp,"%5d",s[i].clans);
		fprintf(fp,"%5d",s[i].fuel);
		fprintf(fp,"%5d",s[i].trit);
		fprintf(fp,"%5d",s[i].dura);
		fprintf(fp,"%5d",s[i].moly);
		fprintf(fp,"%5d",s[i].supplies);
		fprintf(fp,"%5d",s[i].megaCredits);
		fprintf(fp,"%5d",xy[s[i].id-1].mass);
		blank;
		ok=0;
		for(j=0;j<MAXSHIP;j++)  {
			if ((xy[j].x==s[i].x) && (xy[j].y==s[i].y) && (s[i].id != j+1))  {
				if (ok)
					putc(',',fp);
				fprintf(fp,"%d",j+1);
				if (xy[j].owner!=raceNumber)
					putc('!',fp);
				ok=1;
			}
		}
		if (!ok) 
			fprintf(fp,"none");
		nl;
		sumClan+=s[i].clans;
		sumFuel+=s[i].fuel;
		sumTrit+=s[i].trit;
		sumDura+=s[i].dura;
		sumMoly+=s[i].moly;
		sumSupp+=s[i].supplies;
		sumMC+=s[i].megaCredits;
	}
	for(i=0;i<178;i++) putc('-',fp);
	nl;
	fprintf(fp,"%-90s","Total: ");
	fprintf(fp,"Torp:%4d ",sumTorp);
	fprintf(fp,"Figh:%4d ",sumFigh);
	for(i=0;i<18;i++) blank;
	fprintf(fp,"%5d",sumClan);
	fprintf(fp,"%5d",sumFuel);
	fprintf(fp,"%5d",sumTrit);
	fprintf(fp,"%5d",sumDura);
	fprintf(fp,"%5d",sumMoly);
	fprintf(fp,"%5d",sumSupp);
	fprintf(fp,"%5d",sumMC);
	nl;nl;
}

		
void printAlienShips(FILE *fp,AlienShip* s, ShipXY *xy, WORD numberOfAlienShips)  {
	
	extern HullSpec   hullSpecs[MAXHULL];
	extern XYPlan     xyPlanetData[MAXPLANET];
	extern PlanetName planetNames[MAXPLANET];
	extern RaceName   raceNames[MAXRACE];
	extern WORD       raceNumber;
	
	WORD i,j,ok;
	
	fprintf(fp,"Scanned Enemy Ships\n");
	fprintf(fp,"%-4s","ID");
	fprintf(fp,"%-13s","Owner");
	fprintf(fp,"%-21s","Name");
	fprintf(fp,"%-31s","Hull Type");
	fprintf(fp,"%-3s","Bm");
	fprintf(fp,"%-6s","T/F");
	fprintf(fp,"%-3s","En");
	fprintf(fp,"%-5s","Mass");
	fprintf(fp,"%-5s","Carg");
	fprintf(fp,"%-5s","Fuel");
	fprintf(fp,"%-5s","Crew");
	fprintf(fp,"%-12s","Location");
	fprintf(fp,"%-5s","Bear");
	fprintf(fp,"%-5s","Warp");
	fprintf(fp,"%-5s"," Wght");
	fprintf(fp,"%-10s","Orb. Ships");
	nl;
	for(i=0;i<138;i++) putc('-',fp);
	nl;
	
	for(i=0;i<numberOfAlienShips;i++)  {
		fprintf(fp,"%3d ",s[i].id);
		if (s[i].owner) 
			printString(fp,raceNames[s[i].owner-1].shortName,12);
		else
			fprintf(fp,"%-12s","<unknown>");
		blank;
		printString(fp,s[i].name,20);
		blank;
		if (s[i].hull)  {
			printString(fp,hullSpecs[s[i].hull-1].name,30);
			fprintf(fp,"%2d ",hullSpecs[s[i].hull-1].beams);
			fprintf(fp,"%2d/%2d ",hullSpecs[s[i].hull-1].torpBays,hullSpecs[s[i].hull-1].fighterBays);
			fprintf(fp,"%2d ",hullSpecs[s[i].hull-1].numberOfEngines);
			fprintf(fp,"%4d ",hullSpecs[s[i].hull-1].mass);
			fprintf(fp,"%4d ",hullSpecs[s[i].hull-1].cargo);
			fprintf(fp,"%4d ",hullSpecs[s[i].hull-1].fuelTank);
			fprintf(fp,"%4d ",hullSpecs[s[i].hull-1].crew);
		}
		else 
			fprintf(fp,"%-62s","<unknown>");
		blank;
		ok=0;
		for (j=0;j<MAXPLANET;j++)  {
			if ((xyPlanetData[j].x==s[i].x) && (xyPlanetData[j].y==s[i].y) && (!ok))  {
				printString(fp,planetNames[j].name,11);
				blank;
				ok=1;
			}
		}
		if (!ok)  {
			fprintf(fp,"(%4d,%4d) ",s[i].x,s[i].y);
		}
		if (s[i].angle < 361) 
			fprintf(fp," %3d ",s[i].angle);
		else
			fprintf(fp," ??? ");
		fprintf(fp," %2d  ",s[i].warp);
		fprintf(fp,"%5d",xy[s[i].id-1].mass);
		blank;
		ok=0;
		for(j=0;j<MAXSHIP;j++)  {
			if ((xy[j].x==s[i].x) && (xy[j].y==s[i].y) && (s[i].id != j+1))  {
				if (ok)
					putc(',',fp);
				fprintf(fp,"%d",j+1);
				if (xy[j].owner!=raceNumber)
					putc('!',fp);
				ok=1;
			}
		}
		if (!ok) 
			fprintf(fp,"none");
		nl;
	}
	
	for (i=0;i<MAXSHIP;i++)  {
		if ((xy[i].owner!=raceNumber) && (xy[i].owner!=0))  {
			ok=0;
			for(j=0;j<numberOfAlienShips;j++)  {
				if (s[j].id==(i+1))  {
					ok=1;
				}
			}
			if (!ok)  {
				fprintf(fp,"%3d ",i+1);
				printString(fp,raceNames[xy[i].owner-1].shortName,12);
				blank;
				fprintf(fp,"%-21s","<unknown>");
				fprintf(fp,"%-63s","<unknown>");
				ok=0;
				for (j=0;j<MAXPLANET;j++)  {
					if ((xyPlanetData[j].x==xy[i].x) && (xyPlanetData[j].y==xy[i].y) && (!ok))  {
						printString(fp,planetNames[j].name,11);
						blank;
						ok=1;
					}
				}
				if (!ok)  {
					fprintf(fp,"(%4d,%4d) ",xy[i].x,xy[i].y);
				}
				fprintf(fp,"  ?  "); /* Bearing unknown */
				fprintf(fp,"  ?  "); /* Warp unknown */
				fprintf(fp,"%5d",xy[i].mass);
				blank;
				ok=0;
				for(j=0;j<MAXSHIP;j++)  {
					if ((xy[j].x==xy[i].x) && (xy[j].y==xy[i].y) && (i!=j))  {
						if (ok)
							putc(',',fp);
						fprintf(fp,"%d",j+1);
						if (xy[j].owner!=raceNumber)
							putc('!',fp);
						ok=1;
					}
				}
				if (!ok) 
					fprintf(fp,"none");
				nl;
			}
		}
	}
	nl;
}


void printPlanets(FILE *fp, Planet *p, ShipXY *xy, WORD numberOfPlanets, WORD what)  {
/* if what==0 then print scanned planets
 * else print colonized planets */
	
	extern XYPlan     xyPlanetData[MAXPLANET];
	extern PlanetName planetNames[MAXPLANET];
	extern RaceName   raceNames[MAXRACE];
	extern WORD       raceNumber;

	WORD i,j,ok,px,py,tx1;
	LONG sumFuel=0,sumTrit=0,sumDura=0,sumMoly=0,sumClan=0,sumSupp=0,sumMC=0;
	LONG sumMi=0, sumFa=0,sumDf=0,sumNatives=0;
	
	if (what)  {
		fprintf(fp,"Planets of ");
	}
	else  {
		fprintf(fp,"Scanned planets for ");
	}
	printString(fp,raceNames[raceNumber-1].longName,30);
	nl;
	
	fprintf(fp,"%-4s"," ID");
	fprintf(fp,"%-21s"," Name");
	fprintf(fp,"%-4s"," Mi");
	fprintf(fp,"%-4s"," Fa");
	fprintf(fp,"%-4s"," Df");
	fprintf(fp,"%-17s","      Fuel");
	fprintf(fp,"%-17s","      Trit");
	fprintf(fp,"%-17s","      Dura");
	fprintf(fp,"%-17s","      Moly");
	fprintf(fp,"%-6s"," Supp");
	fprintf(fp,"%-6s","  MC");
	fprintf(fp,"%-6s","Clans");
	fprintf(fp,"%-3s","Tx");
	fprintf(fp,"%-4s","Hap");
	fprintf(fp,"%-7s","Native");
	fprintf(fp,"%-3s","Tx");
	fprintf(fp,"%-4s","Tx1");
	fprintf(fp,"%-4s","Hap");
	fprintf(fp,"%-6s","Race");
	fprintf(fp,"%-6s","Gov");
	fprintf(fp,"%-4s","Tmp");
	fprintf(fp,"%-12s","Orb. Ships");
	nl;
	for(i=0;i<176;i++) putc('-',fp);
	nl;
	
	for (i=0;i<numberOfPlanets;i++)  {
		if (((!what) && (p[i].owner!=raceNumber)) || ((what) && (p[i].owner==raceNumber)))  {
			fprintf(fp,"%3d ",p[i].id);
			printString(fp,planetNames[p[i].id-1].name, 20);
			blank;
			fprintf(fp,"%3d ",p[i].mines);
			fprintf(fp,"%3d ",p[i].facs);
			fprintf(fp,"%3d ",p[i].defposts);
			fprintf(fp,"%5d/%5d(%3d) ",p[i].fuel,p[i].fuelGround,p[i].fuelMiningRate);
			fprintf(fp,"%5d/%5d(%3d) ",p[i].trit,p[i].tritGround,p[i].tritMiningRate);
			fprintf(fp,"%5d/%5d(%3d) ",p[i].dura,p[i].duraGround,p[i].duraMiningRate);
			fprintf(fp,"%5d/%5d(%3d) ",p[i].moly,p[i].molyGround,p[i].molyMiningRate);
			fprintf(fp,"%5d ",p[i].supplies);
			fprintf(fp,"%5d ",p[i].megaCredits);
			fprintf(fp,"%5d ",p[i].clans);
			fprintf(fp,"%2d ",p[i].colonistTax);
			fprintf(fp,"%3d ",p[i].colonistStatus);
			fprintf(fp,"%6d ",p[i].natives);
			fprintf(fp,"%2d ",p[i].nativeTax);
			tx1=p[i].natives*0.01*p[i].government*0.2*0.1;
			fprintf(fp,"%3d ",tx1);
			fprintf(fp,"%3d ",p[i].nativeStatus);
			switch(p[i].nativeRace)  {
			 case 1: 
				fprintf(fp,"Human");
				break;
			 case 2:
				fprintf(fp,"Bovin");
				break;
			 case 3:
				fprintf(fp,"Repti");
				break;
			 case 4:
				fprintf(fp,"Avian");
				break;
			 case 5:
				fprintf(fp,"Amorp");
				break;
			 case 6:
				fprintf(fp,"Insec");
				break;
			 case 7:
				fprintf(fp,"Amphi");
				break;
			 case 8:
				fprintf(fp,"Ghips");
				break;
			 case 9:
				fprintf(fp,"Silic");
				break;
			 default: 
				fprintf(fp,"-----");
			}
			blank;
			
			switch(p[i].government)  {
			 case 1: 
				fprintf(fp,"Anarc");
				break;
			 case 2:
				fprintf(fp,"PreTr");
				break;
			 case 3:
				fprintf(fp,"EarTr");
				break;
			 case 4:
				fprintf(fp,"Triba");
				break;
			 case 5:
				fprintf(fp,"Feuda");
				break;
			 case 6:
				fprintf(fp,"Monar");
				break;
			 case 7:
				fprintf(fp,"Repre");
				break;
			 case 8:
				fprintf(fp,"Parti");
				break;
			 case 9:
				fprintf(fp,"Unity");
				break;
			 default: 
				fprintf(fp,"-----");
			}
			blank;
			fprintf(fp,"%3d ",p[i].temperature);

			ok=0;
			px=xyPlanetData[p[i].id-1].x;
			py=xyPlanetData[p[i].id-1].y;

			for(j=0;j<MAXSHIP;j++)  {
				if ((xy[j].x==px) && (xy[j].y==py))  {
					if (ok)
						putc(',',fp);
					fprintf(fp,"%d",j+1);
					if (xy[j].owner != raceNumber)
						putc('!',fp);
					ok=1;
				}
			}
			if (!ok) 
				fprintf(fp,"none");
			nl;
			sumClan+=p[i].clans;
			sumFuel+=p[i].fuel;
			sumTrit+=p[i].trit;
			sumDura+=p[i].dura;
			sumMoly+=p[i].moly;
			sumSupp+=p[i].supplies;
			sumMC+=p[i].megaCredits;
			sumMi+=p[i].mines;
			sumFa+=p[i].facs;
			sumDf+=p[i].defposts;
			sumNatives+=p[i].natives;
		}
	}
	for(i=0;i<176;i++) putc('-',fp);
	nl;
	fprintf(fp,"%-22s","Total: ");
	fprintf(fp,"%5d",sumMi);
	fprintf(fp,"%5d",sumFa);
	fprintf(fp,"%5d",sumDf);
	fprintf(fp,"     %7d     ",sumFuel);
	fprintf(fp,"     %7d     ",sumTrit);
	fprintf(fp,"     %7d     ",sumDura);
	fprintf(fp,"     %7d     ",sumMoly);
	fprintf(fp,"%6d",sumSupp);
	fprintf(fp,"%6d",sumMC);
	fprintf(fp,"%7d",sumClan);
	for(i=0;i<5;i++) blank;
	fprintf(fp,"%8d",sumNatives);
	nl;nl;
}

					
void printStarbases(FILE *fp,Starbase *s, ShipXY *xy, WORD numberOfStarbases) {
	
	extern PlanetName planetNames[MAXPLANET];
	extern RaceName   raceNames[MAXRACE];
	extern WORD       raceNumber;
	extern HullSpec   hullSpecs[MAXHULL];
	extern TrueHull   trueHulls[MAXRACE];

	WORD i;
	WORD sumFigh=0, sumDf=0;
	
	fprintf(fp,"Starbases of ");
	printString(fp,raceNames[raceNumber-1].longName,30);
	nl;
	fprintf(fp,"%-4s"," ID");
	fprintf(fp,"%-21s","   Name");
	fprintf(fp,"%-4s","Def");
	fprintf(fp,"%-3s","Fg");
	fprintf(fp,"%-3s","Dm");
	fprintf(fp,"%-4s","HTL");
	fprintf(fp,"%-4s","ETL");
	fprintf(fp,"%-4s","BTL");
	fprintf(fp,"%-4s","TTL");
	fprintf(fp,"%-10s","Mission");
	fprintf(fp,"%-11s","RepDock");
	fprintf(fp,"%-50s"," BuildDock");
	nl;
	for(i=0;i<122;i++) putc('-',fp);
	nl;
	
	for(i=0;i<numberOfStarbases;i++)  {
		fprintf(fp,"%3d ",s[i].id);
		printString(fp,planetNames[s[i].id-1].name,20);
		blank;
		fprintf(fp,"%3d ",s[i].defposts);
		fprintf(fp,"%2d ",s[i].fighters);
		fprintf(fp,"%2d ",s[i].damage);
		fprintf(fp,"%2d  ",s[i].hullTechLevel);
		fprintf(fp,"%2d  ",s[i].engineTechLevel);
		fprintf(fp,"%2d  ",s[i].beamTechLevel);
		fprintf(fp,"%2d  ",s[i].torpTechLevel);
		
		sumDf+=s[i].defposts;
		sumFigh+=s[i].fighters;
		
		switch(s[i].mission)  {
		 case 1: 
			fprintf(fp,"Refuel   ");
			break;
		 case 2:
			fprintf(fp,"Max Def. ");
			break;
		 case 3:
			fprintf(fp,"Load Torp");
			break;
		 case 4:
			fprintf(fp,"Unload   ");
			break;
		 case 5:
			fprintf(fp,"Repair   ");
			break;
		 case 6:
			fprintf(fp,"Surrender");
			break;
		 default: 
			fprintf(fp,"   ???   ");
		}
		blank;
		
		switch (s[i].fixShip) {
		 case 1:
			fprintf(fp,"Fix %3d    ",s[i].fixID);
		    break;
		 case 2:
			fprintf(fp,"Recycle %3d",s[i].fixID);
			break;
		 default:
			fprintf(fp,"Nothing    ");
		}

		if (s[i].ship)  {
			printString(fp,hullSpecs[trueHulls[raceNumber-1].hullIndex[s[i].ship-1]-1].name,30);
			putc(',',fp);
			fprintf(fp," Eng.%2d,",s[i].shipEngineIndex);
			if (s[i].shipBeamsOnShip)  {
				fprintf(fp," %d*",s[i].shipBeamsOnShip);
			    printBeam(fp,s[i].shipBeamIndex);
			}
			else
				fprintf(fp," No Beams");
			
			putc(',',fp);
			
			if (s[i].shipTorpsOnShip)  {
				fprintf(fp," %d*",s[i].shipTorpsOnShip);
				printTorp(fp,s[i].shipTorpIndex);
				blank;
			}
			else 
				fprintf(fp," No Torps");
		}
		else 
			fprintf(fp,"Nothing");
		nl;
	}
	for(i=0;i<122;i++) putc('-',fp);
	nl;
	fprintf(fp,"%-23s","Total: ");
	fprintf(fp,"%5d",sumDf);
	fprintf(fp,"%4d",sumFigh);
	nl;nl;
}


void printMessages(FILE *fp, Message *m, WORD numberOfMessages)  {
	
	extern RaceName   raceNames[MAXRACE];
	extern WORD       raceNumber;
	WORD i,j;
	
	fprintf(fp,"%d Messages for ",numberOfMessages);
	printString(fp,raceNames[raceNumber-1].longName,30);
	nl;
	
	for(i=0;i<numberOfMessages;i++)  {
		fprintf(fp,"------====== Message %d ======------\n",i+1);
		for (j=0;j<m[i].length;j++)  {
			if (m[i].text[j]==13) 
				putc('\n',fp);
			else
				putc(m[i].text[j],fp);
		}
		nl;
	}
	nl;
}


void printScores(FILE *fp, Score *s)  {
	
	extern RaceName   raceNames[MAXRACE];
	WORD i;
	WORD sumBases=0, sumPlanets=0, sumShips=0, sumFreighters=0;
	
	fprintf(fp,"%-12s","    Race");
	fprintf(fp,"%-12s","   Bases");
	fprintf(fp,"%-12s","  Planets");
	fprintf(fp,"%-12s"," Cap.Ships");
	fprintf(fp,"%-12s","Freighters");
	fprintf(fp,"%-12s","   Score");
	nl;
	for(i=0;i<72;i++) putc('-',fp);
	nl;
	
	for (i=0;i<MAXRACE;i++)  {
		printString(fp,raceNames[i].shortName,12);
		fprintf(fp,"    %3d     ",s[i].bases);
		fprintf(fp,"    %3d     ",s[i].planets);
		fprintf(fp,"    %3d     ",s[i].ships);
		fprintf(fp,"    %3d     ",s[i].freighters);
		fprintf(fp,"    %4d    ",s[i].bases*120+s[i].planets*10+s[i].ships*10+s[i].freighters);
		sumBases+=s[i].bases;
		sumPlanets+=s[i].planets;
		sumShips+=s[i].ships;
		sumFreighters+=s[i].freighters;
		nl;
	}
	for(i=0;i<72;i++) putc('-',fp);
	nl;
	fprintf(fp,"%-12s","Total:");
	fprintf(fp,"    %3d     ",sumBases);
	fprintf(fp,"    %3d     ",sumPlanets);
	fprintf(fp,"    %3d     ",sumShips);
	fprintf(fp,"    %3d     ",sumFreighters);
	fprintf(fp,"    %4d    ",sumBases*120+sumPlanets*10+sumShips*10+sumFreighters);
	nl;nl;
}
	
				   
void printVCRs(FILE *fp, Vcr *v, WORD numberOfVCRs)  {
	
	extern RaceName   raceNames[MAXRACE];
	extern WORD       raceNumber;
	extern HullSpec   hullSpecs[MAXHULL];

	WORD i,j,ok,hullIndex;
	
	fprintf(fp,"%d VCRs for ",numberOfVCRs);
	printString(fp,raceNames[raceNumber-1].longName,30);
	nl;
	
	for(i=0;i<numberOfVCRs;i++)  {
		for(j=0;j<60;j++) putc('-',fp);
		nl;
		
		fprintf(fp,"Battle #%d\n",i+1);
		printString(fp,raceNames[v[i].race1-1].longName,30);
		printString(fp,raceNames[v[i].race2-1].longName,30);
		nl;
		fprintf(fp,"Id: %3d   ",v[i].id1);
		printString(fp,v[i].name1,20);
		fprintf(fp,"Id: %3d   ",v[i].id2);
		printString(fp,v[i].name2,20);
		nl;
		/* Search for Hull of Ship 1 */
		ok=0;
		hullIndex=MAXHULL+1;
		for(j=0;(j<MAXHULL) && (!ok);j++)   {
			if (hullSpecs[j].picture==v[i].bitmap1)  {
				hullIndex=j;
				ok=1;
			}
		}
		if (hullIndex<MAXHULL)
			printString(fp,hullSpecs[hullIndex].name,30);
		else
			fprintf(fp,"%-30s","Planet");
		
		/* Search for Hull of Ship 2 */
		ok=0;
		hullIndex=MAXHULL+1;
		for(j=0;(j<MAXHULL) && (!ok);j++)   {
			if (hullSpecs[j].picture==v[i].bitmap2) {
				hullIndex=j;
				ok=1;
			}
		}
		if (hullIndex<MAXHULL)
			printString(fp,hullSpecs[hullIndex].name,30);
		else
			fprintf(fp,"%-30s","Planet");
		nl;
		
		fprintf(fp,"Crew: %4d",v[i].crew1);
		for(j=0;j<20;j++) blank;
		fprintf(fp,"Crew: %4d",v[i].crew2);
		nl;
		
		if (v[i].numberOfBeams1)  {
			fprintf(fp,"Beams: %2d ",v[i].numberOfBeams1);
			printBeam(fp,v[i].beamIndex1);
		}
		else
			fprintf(fp,"%-15s","No Beams");
		for(j=0;j<16;j++) blank;
		if (v[i].numberOfBeams2)  {
			fprintf(fp,"Beams: %2d ",v[i].numberOfBeams2);
			printBeam(fp,v[i].beamIndex2);
		}
		else
			fprintf(fp,"%-15s","No Beams");
		nl;
		
		if (v[i].torpIndex1)  {
			fprintf(fp,"Torps: %2d ",v[i].numberOfLaunchers1);
			printTorp(fp,v[i].torpIndex1);
			fprintf(fp," (%3d)       ",v[i].numberOfTorpFighters1);
		}
		else  {
			if (v[i].numberOfBays1)  {
				fprintf(fp,"Bays: %2d  ",v[i].numberOfBays1);
				fprintf(fp," (%3d Fight.)  ",v[i].numberOfTorpFighters1);
			}
			else 
				fprintf(fp," No Torps, No Fighterbays");
		}
		
		for(j=0;j<5;j++) blank;
		if (v[i].torpIndex2)  {
			fprintf(fp,"Torps: %2d ",v[i].numberOfLaunchers2);
			printTorp(fp,v[i].torpIndex2);
			fprintf(fp," (%3d)",v[i].numberOfTorpFighters2);
		}
		else  {
			if (v[i].numberOfBays2)  {
				fprintf(fp,"Bays: %2d  ",v[i].numberOfBays2);
				fprintf(fp," (%3d Fight.)",v[i].numberOfTorpFighters2);
			}
			else 
				fprintf(fp," No Torps, No Fighterbays");
		}
		nl;
		
		fprintf(fp,"Mass  : %4d",v[i].mass1);
		for(j=0;j<18;j++) blank;
		fprintf(fp,"Mass  : %4d",v[i].mass2);
		nl;
		
		fprintf(fp,"Damage:  %3d",v[i].damage1);
		for(j=0;j<18;j++) blank;
		fprintf(fp,"Damage:  %3d",v[i].damage2);
		nl;
		
		fprintf(fp,"Shield:  %3d",v[i].shield1);
		for(j=0;j<18;j++) blank;
		fprintf(fp,"Shield:  %3d",v[i].shield2);
		nl;
	}
	nl;
}
		

/**********************************************/
/* Functions to print general data            */
/**********************************************/

/* HULLSPEC.DAT */
/* Sorry, not completed */
/* Use VPUTIL, Infolist, ... instead */
/* void printHullSpec(FILE *fp)  {
	extern HullSpec hullSpecs[MAXHULL];
	extern TrueHull trueHulls[MAXRACE];
	extern RaceName raceNames[MAXRACE];
	
	WORD i,j;
	
	for(i=0;i<MAXRACE;i++)  {
		printString(fp,raceNames[i].longName,30);
		blank;
		fprintf(fp,"%-s",
* */
