/******************************************/
/* main.c                                 */
/*                                        */
/* main-function for VPREPORT             */
/* Declaration of global variables        */
/*                                        */
/* (c) 1995 C. Quix                       */
/* Email: Christoph_Quix@p17.ks.fido.de   */
/******************************************/

#include <stdlib.h>
#include <stdio.h>
#include "planets.h"

/***********************************/
/* Global variables                */
/***********************************/
HullSpec        hullSpecs[MAXHULL];
TrueHull        trueHulls[MAXRACE];
BeamSpec        beamSpecs[MAXBEAM];
TorpSpec        torpSpecs[MAXTORP];
EngSpec         engSpecs[MAXENG];
XYPlan          xyPlanetData[MAXPLANET];
PlanetName      planetNames[MAXPLANET];
RaceName        raceNames[MAXRACE];
WORD            raceNumber;
char            GlobalPath[200];

void help() {
	fprintf(stderr,"\nError! Invalid Parameter\n\n");
	fprintf(stderr,"vpreport [-R] read from RST-File\n");
	fprintf(stderr,"         [-D] read from DAT-Files (after unpack)\n");
	fprintf(stderr,"             one of -R,-D is necessary\n");
	fprintf(stderr,"         [-N NUM]  player number (necessary)\n");
	fprintf(stderr,"         [-P PATH] path to files\n");
	fprintf(stderr,"         [-G GLOBALPATH] path to global data files\n");
	fprintf(stderr,"         [-o file] output file (default:stdout)\n\n");
	
	fprintf(stderr,"         [-s] print own ships\n");
	fprintf(stderr,"         [-e] print enemy ships\n");
	fprintf(stderr,"         [-p] print planets\n");
	fprintf(stderr,"         [-l] print scanned planets\n");
	fprintf(stderr,"         [-b] print starbases\n");
	fprintf(stderr,"         [-m] print messages\n");
	fprintf(stderr,"         [-c] print scores\n");
	fprintf(stderr,"         [-v] print vcr info\n");
	fprintf(stderr,"         [-a] print all\n\n");
	exit(1);
}

/****************************/
/* main                     */
/****************************/
int main(int argc, char* argv[]) {
	
	RstFile *rst;
	FILE *fp,*out;
	char path[100];
	char fname[115],fout[120];
	WORD i;
	WORD readrst=0,readdat=0;
	WORD ship=0,ensh=0,plan=0,scpl=0,sb=0,msg=0,sc=0,vcr=0;
	
	/* Init */
	path[0]='.';
	path[1]=0;
	out=stdout;
	fout[0]=0;
	GlobalPath[0]='.';
	GlobalPath[1]=0;
	
	for(i=1;i<argc;i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
			 case 'R':
				readrst=1;
				break;
			 case 'D':
				readdat=1;
				break;
			 case 'N':
				i++;
				raceNumber=atoi(argv[i]);
				if ((raceNumber<1) || (raceNumber>11)) {
					fprintf(stderr,"Invalid player number!\n");
					help();
				}
				break;
			 case 'P':
				i++;
				strcpy(path,argv[i]);
				break;
			 case 'G':
				i++;
				strcpy(GlobalPath,argv[i]);
				break;
			 case 'o':
				i++;
				strcpy(fout,argv[i]);
				break;
			 case 's':
				ship=1;
				break;
			 case 'e':
				ensh=1;
				break;
			 case 'p':
				plan=1;
				break;
			 case 'l':
				scpl=1;
				break;
			 case 'b':
				sb=1;
				break;
			 case 'm':
				msg=1;
				break;
			 case 'c':
				sc=1;
				break;
			 case 'v':
				vcr=1;
				break;
			 case 'a':
				ship=ensh=plan=scpl=sb=msg=sc=vcr=1;
				break;
			 default: help();
			}
		}
		else {
			help();
		}
	}
	
	readHullSpec();
	readTrueHulls();
	readBeamSpec();
	readTorpSpec();
	readEngSpec();
	readXYPlan();
	readPlanetNames();
	readRaceNames();
	
	if ((raceNumber<1) || (raceNumber>11)) {
		fprintf(stderr,"Invalid player number!\n");
		help();
	}
	
	if ((!readrst) && (!readdat)) {
		fprintf(stderr,"You must use -r or -d\n\n");
		help();
	}
	
	if (readrst)  {
		sprintf(fname,"%s/player%d.rst",path,raceNumber);
		fp=fopen(fname,"rb");
				
		if (fp)  {
			rst=readRst(fp);
			fclose(fp);
		}
		else  {
			fprintf(stderr,"Unable to open RST-File\n");
			exit(1);
		}
	}
	
	if (readdat)  {
		rst=readDatFiles(raceNumber,path);
	}
		
	if(raceNumber!=rst->playernumber)  {
		fprintf(stderr,"Hmm!? Something is not ok!");
		help();
	}

	if (fout[0])  {
		out=fopen(fout,"w");
		if (!out)  {
			fprintf(stderr,"Unable to open output file %s\n",fout);
			help();
		}
	}
	
	fprintf(out,"Turn %d, Timestamp: ",rst->turnNumber);
	printString(out,rst->timestamp,18);
	putc('\n',out);
	putc('\n',out);
	
	if (ship)
		printShips(out,rst->shipInfo,rst->shipXYInfo,rst->numberOfShips);
	if (ensh)
		printAlienShips(out,rst->alienShipInfo,rst->shipXYInfo,rst->numberOfAlienShips);
	if (plan)
		printPlanets(out,rst->planetInfo,rst->shipXYInfo,rst->numberOfPlanets,1);
	if (scpl)
		printPlanets(out,rst->planetInfo,rst->shipXYInfo,rst->numberOfPlanets,0);
	if (sb)
		printStarbases(out,rst->starbaseInfo,rst->shipXYInfo,rst->numberOfStarbases);
	if (msg)
		printMessages(out,rst->messageInfo,rst->numberOfMessages);
	if (sc)
		printScores(out,rst->scoreInfo);
	if (vcr)
		printVCRs(out, rst->vcrInfo, rst->numberOfVCRs);
	if (out!=stdout)
		fclose(out);
	
	return rst->turnNumber;
}
	
