/*
	Copyright 1994 Dave Boynton.
	You are granted the right to use this source code as you see fit,
	with the exception of redistributing it without this notice.
	Questions should be directed to dboynton@clark.net.
*/

#include <stdio.h>
#include <string.h>
#ifdef __TURBOC__
#include <mem.h>
#endif

#define ADMIN_ERROR \
	"\nSorry, administrator failure, couldn't verify your file.\n"
#define ADMIN_ERROR1 \
	"Player ?: admin failure.\n"

#define FILE_ERROR  \
	"\nSorry, couldn't verify your file.\n"
#define FILE_ERROR1 \
	"Player ?: file error.\n"

#define DATE_ERROR  \
	"\nSorry, your turn %d file is stale, download the current \n"\
	"player%d.rst and create a new turn.\n"
#define DATE_ERROR1 \
	"Player %d: stale.\n"

#define NO_ERROR \
	"\nPlayer%d:\nYour turn %d file is verified, with %d commands found.\n"
#define NO_ERROR1 \
	"Player %d: verified with %d commands.\n"

#define DIRCHAR	'/'

int compareinfo(FILE *fi, char * compare2, int flag);

char *nextturnpath="nextturn.hst";
short turn;

/*
usage:		uturn [nextturnpath], stdin=turn data, stdout=mail response

return:  	0 no error
			1 admin error
			2 corrupt error?
			3 stale
*/
int main(int argc, char *argv[])
{
	FILE *fi;
	FILE *nt;
	char compare2[19];
	int problems=0;

	nt=fopen(nextturnpath,"rb");
	if ( nt == NULL ) {
		perror(nextturnpath);
		printf(ADMIN_ERROR);
		return 1;
	}
	memset(compare2, 0, 19);
	if ( fread(compare2, 18, 1, nt) != 1 ) {
		printf(ADMIN_ERROR);
		fclose(nt);
		return 1;
	}
	turn=0;
	turn=fgetc(nt);
	turn += fgetc(nt)*256;
	fclose(nt);

	if ( argc > 2 ) {
	    printf("Checking turn %d, date stamp %s:\n", turn, compare2);
	    while ( argc > 1 ) {
		fi=fopen(argv[1],"rb");
		if ( fi != NULL ) {
		    problems+=compareinfo(fi, compare2, 1);
		    fclose(fi);
		}
		argc--;
		argv++;
	    }
	    return problems;
	} else {
	    return compareinfo(stdin, compare2, 0);
	}
}



int compareinfo(FILE *fi, char * compare2, int flag)
{
	short player;
	long commands;
	char compare1[19];

	player=fgetc(fi);
	fgetc(fi);

	commands=fgetc(fi);
	commands += fgetc(fi) * 256;
	commands += fgetc(fi) * 256 *256;
	commands += fgetc(fi) * 256 *256 *256;

	memset(compare1, 0, 19);
	if ( fread(compare1, 18, 1, fi) != 1 ) {
	    if ( flag )
		printf(FILE_ERROR1);
	    else
		printf(FILE_ERROR);
	    return 2;
	}
	if ( strcmp(compare1, compare2) != 0 ) {
	    if ( flag ) 
		printf(DATE_ERROR1, player);
	    else
		printf(DATE_ERROR, turn, player);
	    return 3;
	} else {
	    if ( flag )
		printf(NO_ERROR1, player, commands);
	    else
		printf(NO_ERROR, player, turn, commands);
	    return 0;
	}
}








