#ifndef __ALTSPEC_H
#define __ALTSPEC_H
/* ALTSPEC.H v3.15
 A collection of user defined structures concerning datafiles used
   in VGA Planets.

included in this version, structures for
   .\XYPLAN.DAT
   .\HULLSPEC.DAT
   .\ENGSPEC.DAT
   .\BEAMSPEC.DAT
   .\TORPSPEC.DAT
   .\TRUEHULL.DAT
   .\RACE.NM
   .\HOST.DIR\PDATA.HST
   .\HOST.DIR\SHIP.HST
   .\HOST.DIR\SHIPXY.HST
   .\HOST.DIR\BDATA.HST
   .\HOST.DIR\XYPLAN.HST
   .\PLAYER.DIR\PDATA*.DAT
   .\PLAYER.DIR\SHIP*.DAT
   .\PLAYER.DIR\SHIPXY*.DAT
   .\PLAYER.DIR\BDATA*.DAT
   .\PLAYER.DIR\TARGET*.DAT
   .\HOST.DIR\MINES.HST

Stuff not in this version(and may never be so don't hold your breath):
   PLAYER*.TRN
   PLAYER*.RST
   XYPLAN.NM

These VGA Planets specs brought to you by Micheal Keane
       (micheal.keane???.???.???.???@fidonet.org)
       with help from Thomas Voigt and Stephan Piettesch(sp?)

 All strings are of the specified length and are padded out with spaces
   (chr 32).
 ie:
 char shipname[30];
 this is a 30 byte string. 30 bytes means 30 bytes. No nulls tacked on
 the end. unused spaces are padded with spaces. When displaying these
 strings, have a char save byte equal stringname[30]. Then change
 stringname[30] to a null. Strings will dipslay correctly. Then change it
 back with your save byte. Works great in BEAMS.

 This should be enough info to write most utils. By the request of Thomas
   Voigt, I'm not including the TRN and RST structures, but you should be
   able to figure out most of the stuff and be able to read them. Thomas
   wanted to make sure the specs weren't used for cheating by altering your
   TRN file. You'll notice the many checksums will take figuring out.
 There's enough info for HOSTs in here to do wholesale cheating without
   the TC even blinking. TC only gets goofy when you start tampering with
   TRN files...

 Supplemental structs to make useage easier
 I use them like so(Planet being an array of pdata)
       Planet[50].buried.moly = 2000
       Planet[50].mined.neut = 2000
 IMHO, less confusing than
       Planet[50].buriedmoly = 2000
       Planet[50].minedmoly = 2000
 used in the SHIP.HST and PDATA.HST specs
 cut 'n' paste if you don't like using them.
*/

/*  xy and for ship.hst */
typedef struct {
  int x;
  int y;
} xy;

/* LONG INTEGER mineral  for pdata.hst  */
typedef struct {
  long int neut;
  long int trit;
  long int dur;
  long int moly;
} mineral;

/* INTEGER mineral type for ship.hst and pdata.hst */
typedef struct  {
  int neut;
  int trit;
  int dur;
  int moly;
} mineral2;

/*  TORPSPEC.DAT
 10 torp spec records
 38 bytes long each
 purpose: define all the torpedo launcher specs along with the single
     torpedos.
*/
typedef struct {
  char torpname[20];
  int unitMC;       /* # of megacredits required to build a
                      SINGLE torpedo  */
  int MC;           /* # of megacredits required to build  */
  int trit;         /* # of minerals required to build */
  int dur;          /* ditto */
  int moly;         /* ditto */
  int mass;         /* mass of this torpedo launcher */
  int tech;         /* tech level required to build */
  int antilife;     /* determines how many crew members are killed
                      when shields are down */
  int destr;        /* destructive power towards hull and shields */
} torpspec;

/*  BEAMSPEC.DAT
 10 beam spec records
 36 bytes long each
 purpose: define all 10 beams and their various values
*/
typedef struct {
  char beamname[20];
  int MC;           /* # of megacredits required to build */
  int trit;         /* # of minerals required to build */
  int dur;          /* ditto */
  int moly;         /* ditto */
  int mass;         /* mass of this weapon */
  int tech;         /* tech level required to build */
  int antilife;     /* determines how many crew members are killed
                    when shields are down */
  int destr;        /* destructive power towards hull and shields  */
} beamspec;

/* TRUEHULL.DAT
 11 true hull spec records
 40 bytes long each
  purpose: defines which ships each race has. Maximum of 20 per race.
     More than one race may have a specific ship. If that shipslot is
     empty, then it equals 0(or null).
*/
typedef struct {
  int hull[20];
} truehull;

/* HULLSPEC.DAT
 105 hull spec records
 60 bytes long each
 purpose: define the properties of each hull type.
   Note: special functions are NOT defined in this. They go by slot number
     and cannot be assigned to multiple ships(ie: only 1 shiptype can have
     an alchemy function). Also, which races can build these ships are
     NOT defined in here either. They're in TRUEHULL.DAT.
     Shorthand abbreviations are given for the ships that have these
     abilities in the normal specs.
 (P)HOSTv3.0 original abilities:
       graviotonic\cloaking - 44, 45, 46 (BR4, BR5, MCBR)
       alchemy - supplies to minerals - 105 (merlin)
               - minerals to fuel - 104 (neutronic refinery)
       cloaking - 21, 22, 25, 26, 27, 28, 29, 31    (privs, lizards,
                  32, 33, 36, 43, 47                 fascists, birds)
 (P)HOSTv3.1x added abilities:
       terraformers - warm to 50 - 3 (bohemian)
                      cooler to 50 - 8 (eros)
                      heat to 100 - 64 (onyx)
       hyperdrive - 51, 77, 87 (BL21, B200, falcon)
 PHOST/WORM added abiltiies:
       adv wormhole scanner - 3 (bohemian)        
 HOSTv3.20 added abilities:
       chunneling - 56 (firecloud)
       imperial assault - 69 (ssd)
       fuel scoop - 96 (cobol)
       bioscanner - 9, 84, 96 (bynhild, pawn, cobol)
       casino - 42 (lady royale)
       glory device - 39, 41 (d19, saber)
       alchemy - minerals to fuel - 97 (aries)
 RacePlus/PlaceRus added abilities: (race specific in RacePlus)
       lizard chameleon - 23, 49 (t-rex, madonnzilla)
       bird sabotage - 32 (bright heart)       
       fascist boarding party - 38 (d3 thorn)
       priv crew replacement - 43 (dwarfstar)
       cyborg super tractor beam - 58 (quietus)
       ee gravity well - 70 (gorbie)
       robot repair ship - 83 (cybernaut)
       colonial stealth fighter gather
            gatherer(SFG) - 100 (sagittarus)
            cargo ship(target id) - 101 (gemini)  
*/
typedef struct {
  char hullname[30];
  int picture;   /* picture of the ship */
  int huh1;      /* 2 unknown bytes (equals &h0100 in all records) */
  int trit;      /* # of minerals required for construction */
  int dur;       /* ditto */
  int moly;      /* ditto */
  int neut;      /* fuel capasity */
  int crew;      /* crew members onboard when at full capasity */
  int engines;   /* number of engines needed for the ship */
  int mass;      /* HULL mass */
  int tech;      /* tech level needed to build */
  int cargo;     /* cargo room */
  int bays;      /* # of fighter bays */
  int torps;     /* # of torp launchers that can be added */
  int beams;     /* # of beams that can be added */
  int MC;        /* # of MC required to build */
} hullspec;

/*  ENGSPEC.DAT
 9 engine spec records
 66 bytes long each
 Checksum is added to end of file
      long int checksum;
*/
typedef struct {
  char engname[20];
  int MC;                 /* # of MC required to build */
  int trit;               /* # of minerals required for construction */
  int dur;                /* ditto */
  int moly;               /* ditto */
  int tech;               /* tech level needed to build */
  long int warp[9];       /*  when reading, divide by warp squared
                           ie: warp2 = warp2 / 2 ^ 2
                           when writing, multiply by warp squared
                           ie: warp4 = warp4 * 4 ^ 2  */
} engspec;

/* SHIP.HST, SHIP*.DAT
 500 ship records
 ?? bytes long each
 Purpose: contains ALL the ships in the game.
   the SHIP*.DAT that is in player directories are prefixed instead by
       an INTEGER that specifies how many ship records are in the file.
 The SHIP*.DAT also has a 10 character checksum tacked onto the end of the
 file. No idea how it works(something to do with registration).
 This checksum is identical in all the player files.
 at the top of the file, an integer tells how many records are in the file.
*/
typedef struct {
  int shipid;              /* ship record number */
  int race;                /* race of the owner of this ship */
  char FC[3];              /* friendly code */
  int speed;               /* warp speed */
  xy waypoint;             /* INTEGER X&Y coordinates of waypoint
                            RELATIVE to current position  */
  int x;                   /*  location..  */
  int y;
  int enginetech;          /* type of engine, see: ENGSPEC.DAT */
  int hulltype;            /* type of hull, see: HULLSPEC.DAT  */
  int beamtech;            /* type of beam, see: BEAMSPEC.DAT */
  int beamnum;             /* # of beams */
  int bays;                /* # of fighters in cargo hold */
  int torptech;            /* type of torp bay, see: TORPSPEC.DAT */
  int fish;                /* # of fighters or torps in cargo hold */
  int tubenum;             /* # of torp launchers in hull */
  int mission;             /* mission # */
  int enemy;               /* primary enemy */
  int towedship;           /* # of the ship being towed by this ship */
  int damage;              /* % of damage * 100 */
  int crew;                /* # of crew members */
  int clans;               /* clans in cargo hold */
  char shipname[20];       /* ship name (obviously) */
  int neut;                /* fuel onboard */
  int trit;                /* tritanium in cargo hold */
  int dur;                 /* duranium in cargo hold */
  int moly;                /* molydenum in cargo hold */
  int supplies;            /* supplies in cargo hold */

  mineral2 unload;         /* unload cargo */ 
  int unCol;               /* unload Colonists */
  int unS;                 /* unload Supplies */
  int unplanet;            /* unload on to planet target number */
  mineral2 trans;          /* transfer cargo */
  int transC;              /* transport Colonists */
  int transS;              /* transport Supplies  */
  int transtarget;         /* transport target ship ID number */
  
  int intercept;           /* # of the ship being intercepted */
  int MC;                  /* # of megacredits on the ship */
} ship;

/*  PDATA*.DAT
 500 planet records
 ??? bytes long each
 Purpose: store data for all 500 planets. does NOT include starbases.
       that information is in BDATA.HST.
   the PDATA*.DAT that is in player directories are prefixed instead by
       an INTEGER that specifies how many ship records are in the file.
 The PDATA*.DAT also has a 10 character checksum tacked onto the end of the
 file. No idea how it works(something to do with registration).
 This checksum is identical in all the player files.
        int checksum;            in PDATA*.DAT, this is the # of records
                                   in the file there are. in PDATA.HST,
                                   this seems to be a checksum(?)
*/
typedef struct {
  int race;                  /* race of owner, 0 if unowned */
  int planetnum;             /* planet record number */
  char FC[3];                /* friendly code */
  int mines;                 /* # of mines */
  int factories;             /* # of factories */
  int defense;               /* # of defense posts */
  mineral mined;             /* 4 LONG INTEGERS of mined minerals */
  long int clanscolonists;   /* # of clans of the owner's race */
  long int supplies;         /* # of supplies */
  long int MC;               /* # of megacredits */
  mineral buried;            /* 4 LONG INTEGERS of minerals buried */
  mineral2 rate;             /* 4 INTEGERS of mineral mining rate * 100 */
  int taxcolonists;          /* tax rate of colonists * 100 */
  int taxnatives;            /* tax rate of natives * 100 */
  int happycolonists;        /* happy points for colonists */
  int happynatives;          /* happy points for natives */
  int govnatives;            /* type of government for natives */
  long int clansnatives;     /* # of clans of natives */
  int racenatives;           /* race of the natives */
  int temp;                  /* planet temperature */
  int buildsb;               /* build a starbase! */
} pdata;

/* BDATA.HST, BDATA*.DAT
 500 starbase records
  bytes long each
 Purpose: store data for all 500 starbases. does NOT include planets.
       that information is in PDATA.HST.
 The BDATA*.DAT also has a 10 character checksum tacked onto the end of the
 file. No idea how it works(something to do with registration).
 This checksum is identical in all the player files.
      int checksum;        this is the # of records in the BDATA*.DAT
                             in BDATA.HST, this is a checksum of some kind.
*/
typedef struct  {
  int planetid;            /* planet # that the starbase orbits */
  int race;                /* race # of the owner */
  int defense;             /* # of starbase defense posts */
  int damage;              /* % of damage sustained * 100 */
  int enginetech;          /* engine tech level at this base */
  int hulltech;            /* hull tech level at this base */
  int beamtech;            /* beam tech level at this base */
  int torptech;            /* torp tech level at this base */

  /* Engines stored at the starbase by slot */
  int eng[9];

  /* hulls stored at the starbase by the race's TRUEHULL.DAT hullslots */
  int hull[20];
	
  /* beams stored at the starbase by slot */
  int beam[10];

  /* torp launchers at the starbase by slot */
  int launch[10];

  /* torps in storage */
  int torps[10];

  int fighters;            /* fighters at the starbase */
  int shiptofix;           /* ship to fix or scrap */
  int fixorscrap;          /* 1=fix 2=recycle */
  int orders;              /* mission # for the base */

  /* 
  These next slots are blank if no ship is being built, otherwise,
  they'll be filled in. coponents used in the building must be on
  hand for the construction. In other words, when the build order is
  given, the coponents don't "disappear".
  */

  int buildhull;           /* hull being built by slot */
  int buildeng;            /* engine being used by slot */
  int buildbeam;           /* beams being used by slot */
  int buildbeamnum;        /* # of beams being used */
  int buildtorp;           /* torp launchers being used by slot */
  int buildtorpnum;        /* # of torp launchers being used */
  int buildfighters;       /* what is tim thinking?! */
} bdata;

/* SHIPXY.HST, SHIPXY*.DAT
 500 shipxy records
 8 bytes long each
 purpose: contains the XY, race and bearing of all 500 ships.
   even in SHIPXY*.DAT in player directories there are 500 entries.
   records of ships out of range are blank
 The SHIPXY*.DAT also has a 10 character checksum tacked onto the end of the
 file. No idea how it works(something to do with registration).
 This checksum is identical in all the player files.
 */
typedef struct {
  int x;                     /* ship location */
  int y;               
  int race;                  /* race of ship owner */
  int mass;               
} shipxy;

/* XYPLAN.DAT, XYPLAN.HST
 500 planet XY records
 6 bytes long each
 purpose: contains the xy of all the planets in the game. these can be
   tricky to handle when hosting.
*/
typedef struct {
	int x;               
	int y;               
  int checknum;          /* not sure how the checksum is calculated.
                         usually it's blank */
} xyplan;

/* TARGET*.DAT
 variable # of ship records
 ??? bytes long each
    purpose: identifies for the player ships that are within visual range
       by mass, xy, race, ship id, picture, etc...
 The TARGET*.DAT also has a 10 character checksum tacked onto the end of the
 file. No idea how it works(something to do with registration).
 This checksum is identical in all the player files.
 */
typedef struct {
  int id;
  int race;
  int warp;
  int x;
  int y;
  int hull;
  int heading;
  char shipname[20];
} targetxy;

/*  RACE.NM
 1 big record
  why: The file has all the long names, then all the short ones, and then
   all the adj. Thus, you have to read it in as one big record unfortunately.
    purpose: formal long names of each race, short names of each race and
        adj. names of each race
 */
typedef struct {
  char formal[11][30];
  char informal[11][20];
  char adj[11][12];
} racenm;

typedef struct {
  int x;
  int y;
  int race;
  long int units;
  int web;
} allmines;
#endif
