DECLARE SUB LBase ()
DECLARE SUB LBeam (n%)
DECLARE SUB LEng (n%)
DECLARE SUB LHull (n%)
DECLARE SUB LoadHostData ()
DECLARE SUB LPlanet ()
DECLARE SUB LShip ()
DECLARE SUB LTorp (n%)
DECLARE SUB PutError (g$)
DECLARE SUB PutMessage (rc%, gg$)
DECLARE SUB SaveHostData ()
DECLARE SUB SBase ()
DECLARE SUB ShipXYR ()
DECLARE SUB SPlanet ()
DECLARE SUB SShip ()
DECLARE SUB StoreNewMess (rc%, m$)
DECLARE SUB LoadBrain ()
DECLARE SUB PlanetEcon ()
DECLARE SUB SaveBrain ()
DECLARE SUB PlanetCheck ()
DECLARE SUB MoveMinerals ()
DECLARE SUB BuildNewShips ()
DECLARE SUB SortClassList ()
DECLARE SUB BuildShip (fgship%)
DECLARE SUB WorkOnSBase ()
DECLARE SUB BuildNewStarbase ()
DECLARE SUB Alchemy ()
DECLARE SUB Explore ()
DECLARE SUB LoadFuel ()
DECLARE SUB PCheck (v%)
DECLARE SUB Eggs ()
DECLARE SUB WarShips ()
DECLARE SUB Dumpmess ()
DECLARE SUB Refuel ()
DECLARE FUNCTION RNDNAME$ ()
DECLARE FUNCTION PLANETNAME$ (n%)
DECLARE FUNCTION RACENAME$ (n%, fg%)
DECLARE FUNCTION RAND% (a%, b%)
DECLARE FUNCTION CargoR% ()
DECLARE FUNCTION FuelR% ()
DECLARE FUNCTION CheckTimeStamp% ()

'Size of shipshort is 34 bytes
TYPE SHIPSHORT
   ID AS INTEGER       'ID number of ship
   pNum AS INTEGER     'Player ID number
   warp AS INTEGER     'Warp factor
   xShip AS INTEGER    'X
   yShip AS INTEGER    'Y
   hull AS INTEGER     'Hull type
   heading AS INTEGER  'ships heading
   nm AS STRING * 20   'ship name
END TYPE

'Size of shiptype is 107 bytes
TYPE SHIPTYPE
   ID AS INTEGER       'ID number of ship
   pNum AS INTEGER     'Player ID number
   fCode AS STRING * 3 'Friend ID code
   warp AS INTEGER     'Warp factor
   xWay AS INTEGER     'DX to waypoint from X
   yWay AS INTEGER     'DY to waypoint from Y
   xShip AS INTEGER    'X cor.
   yShip AS INTEGER    'Y cor.
   eng AS INTEGER      'engine type
   hull AS INTEGER     'hull type
   weapon AS INTEGER   'weapon type
   wbanks AS INTEGER   'number of weapon banks
   bays AS INTEGER     'number of fighter bays
                       'if bays>0 then tube and tbanks are ignored
                       'a ship may have fighter or torpedoes
                       'NOT both
   tube AS INTEGER     'torpedoe launcher type
   torp AS INTEGER     'number of torpedoes/fighters
   tbanks AS INTEGER   'number of torpedoe banks
   mission AS INTEGER  'ship mission type
   enemy AS INTEGER    'primary enemy ID number
   tow AS INTEGER      'ID # of ship in tow
   damage AS INTEGER   'amount of damage done to ship
   crew AS INTEGER     'number of crew
   col AS INTEGER      'number of colonists X 100
   nm AS STRING * 20   'name of ship
   eleN AS INTEGER     'Neutronium
   eleT AS INTEGER     'Tritanium
   eleD AS INTEGER     'Duranium
   eleM AS INTEGER     'Molybdenum
   eleS AS INTEGER     'supplies (Carbon Matrix)
   unN AS INTEGER      'unload Neutronium
   unT AS INTEGER      'unload Tritanium
   unD AS INTEGER      'unload Duranium
   unM AS INTEGER      'unload Molybdenum
   unCol AS INTEGER    'unload Colonists
   unS AS INTEGER      'unload Supplies
   unplanet AS INTEGER 'unload on to planet target number
   transN AS INTEGER   'transport Neutronium
   transT AS INTEGER   'transport Tritanium
   transD AS INTEGER   'transport Duranium
   transM AS INTEGER   'transport Molybdenum
   transC AS INTEGER   'transport Colonists
   transS AS INTEGER   'transport Supplies
   transtarget AS INTEGER 'transport target ship ID number
   iTarget AS INTEGER  'intercept target ship ID number
   cash AS INTEGER     'the amount of cash on board the ship
END TYPE

'size=60
TYPE HULLSPEC
   nm AS STRING * 30    'hull class name
   bin AS INTEGER       'the bin resource file slot image
   doa AS INTEGER       'the image of a heavily damaged ship
   eleT AS INTEGER      'amount of Tritanium needed to build
   eleD AS INTEGER      'amount of Duranium needed to build
   eleM AS INTEGER      'amount of Molybdenum needed to build
   eleN AS INTEGER      'maximun Neutronium that can be carried
   crew AS INTEGER      'maximum crew
   engines AS INTEGER   'number of engines required to build
   mass AS INTEGER      'mass of hull
   tech AS INTEGER      'tech level of ship
   cargo AS INTEGER     'maximum cargo (does not include neutronium)
   bays AS INTEGER      'maximum number of fighter bays
   torp AS INTEGER      'maximum number of torp tubes
   weapon AS INTEGER    'maximum number of beam weapons
   cost AS INTEGER     'cost to build
END TYPE

TYPE ENGSPEC
   nm AS STRING * 20     'name of engine
   cost AS INTEGER       'cost to build one
   eleT AS INTEGER       'amount needed to build one
   eleD AS INTEGER       'amount needed to build one
   eleM AS INTEGER       'amount needed to build one
   tech AS INTEGER       'tech level needed to build one
   ec(1 TO 9) AS LONG    'energy cost to go all warp speeds per 10,000 mt
                         'energy cost is in mt's
END TYPE

TYPE TORPSPEC
   nm AS STRING * 20
   cost AS INTEGER     'cost of one torpedoe
   tubecost AS INTEGER 'cost of the launch tube
   eleT AS INTEGER     'needed to build tube
   eleD AS INTEGER     'needed to build tube
   eleM AS INTEGER     'needed to build tube
   mass AS INTEGER     'mass of the weapon bank
   tech AS INTEGER     'tech level
   kill AS INTEGER     'the life killing power of the weapon
   smash AS INTEGER    'the ablity to smash a ship to bits
                       'to build One torpedoe of any type
                       'requires 1 eleN + 1 T.D.M
END TYPE

TYPE BEAMSPEC
   nm AS STRING * 20
   cost AS INTEGER     'cost to build
   eleT AS INTEGER
   eleD AS INTEGER
   eleM AS INTEGER
   mass AS INTEGER     'mass of the weapon bank
   tech AS INTEGER     'tech level
   kill AS INTEGER     'the life killing power of the weapon
   smash AS INTEGER    'the ablity to smash a ship to bits
END TYPE

'Size of plantype is 85 bytes
TYPE plantype
   pNum AS INTEGER               'the player race of this planet
   ID AS INTEGER                 'the ID number of this planet
   fCode AS STRING * 3           'the friendly code
   mines AS INTEGER              'number of mines on planet
   factories AS INTEGER          'number of factories on planet
   SDI AS INTEGER                'SDI factor (planetary defenses)
   eleN AS LONG                  'KT's of Neutronium ready for use
   eleT AS LONG                  'KT's of Tritanium  ready for use
   eleD AS LONG                  'KT's of Duranium ready for use
   eleM AS LONG                  'KT's of Molybdenum ready for use
   eleC AS LONG                  'number of colony clans
   eleS AS LONG                  'KT's of supplies ready for use
   money AS LONG                 'the planets money reserves
   resN AS LONG                  'eleN contained within planet
   resT AS LONG                  'eleT contained within planet
   resD AS LONG                  'eleD contained within planet
   resM AS LONG                  'eleM contained within planet
   easyN AS INTEGER              '(0-100) odds of mining eleN
   easyT AS INTEGER              '(0-100) odds of mining eleT
   easyD AS INTEGER              '(0-100) odds of mining eleD
   easyM AS INTEGER              '(0-100) odds of mining eleM
   taxC AS INTEGER               'tax rate of colonists
   taxN AS INTEGER               'tax rate of natives
   happynessC AS INTEGER         'happyness of colonists
   happynessN AS INTEGER         'happyness of natives
   SPI AS INTEGER                'socio political index
   native AS LONG                'native population
   species AS INTEGER            'type of native population
   climate AS INTEGER            'weather conditions
   bStarbase AS INTEGER          'build a starbase!
END TYPE

'size=156
TYPE BASETYPE
   ID AS INTEGER                    'same as planet ID #
   pNum AS INTEGER                  'race ID number of base
   defense AS INTEGER               'defense power
   damage AS INTEGER
   techE AS INTEGER                 'engine tech level
   techH AS INTEGER                 'hull tech level
   techW AS INTEGER                 'weapon tech level
   techT AS INTEGER                 'torpedoe tech level
   storeE(1 TO 9) AS INTEGER        'count of engines in storeage
   storeH(1 TO 20) AS INTEGER       'count of hulls in storeage
   storeW(1 TO 10) AS INTEGER       'count of weapons in storeage
   storeT(1 TO 10) AS INTEGER       'count of tubes in storeage
   storeTorps(1 TO 10) AS INTEGER   'count of torps in storeage
   storeF AS INTEGER                'count of fighters in storeage
   workonshipID AS INTEGER          'id of ship to work on
   workonshipAction AS INTEGER      'action flag 1=fix 2=scrap
   mission AS INTEGER               'mission number
   makeshipH AS INTEGER             'make ship with this hull
   makeshipE AS INTEGER             'make ship with this engine
   makeshipW AS INTEGER             'make ship with this weapon
   makeshipWc AS INTEGER            '(this many of em weapons)
   makeshipT AS INTEGER             'make ship with this type launcher
   makeshipTc AS INTEGER            '(this many of em launchers)
   makeshipFc AS INTEGER            'make ship with this many fighters
END TYPE

'Version 3.2
TYPE CONFIGTYPE
   recycle AS INTEGER          '% of ore recovered from colonizing ships
   meteor AS INTEGER           '% odds of one large meteor impact
   mine AS INTEGER             'flag mine fields yes (1) or no (0)
   Alchemy AS INTEGER          'flag alchemy yes (1) or no (0)
   delold AS INTEGER           'flag delete old messages yes (1)
   nopassword AS INTEGER       'flag disable passwords yes (1)
   gkill(11) AS INTEGER        'ground combat kill ratios
   opkill(11) AS INTEGER       'ground combat defense factor
   freefighter(11) AS INTEGER  'number of free fighters
   minerates(11)  AS INTEGER   'mineral mining rates
   taxrate(11) AS INTEGER      'tax 50% to 500%
   rebelbfs AS INTEGER         'build fighters in space
   coloniesbfs AS INTEGER      'build fighters in space
   robotbfs AS INTEGER         'build fighters in space
   cloakshipopps  AS INTEGER   '0% - 50% cloak ship falure
   robcloaked AS INTEGER       'rob cloaked ships (yes/no)
   shipscan AS INTEGER         'ship scan range limit
   darkrange AS INTEGER        'range of dark sence
   hiss AS INTEGER             'hiss mission on and off
   rebelga AS INTEGER          'rebel ground attack on and off
   fedsr AS INTEGER            'super refit on and off
   web AS INTEGER              'web mines on and off
   cloakburn AS INTEGER        'cloaked ship fuel burn 1 to 50 kt
   sensorrange AS INTEGER      'range of the sensor mission
   nativenew AS INTEGER        'add new natives
   planetattack AS INTEGER     'planets attack ships (yes/no)
   cyborga AS INTEGER          'cyborg assimulation rate (1-100)
   webdecay AS INTEGER         'web mine decay rate
   minedecay AS INTEGER        'mine field decay rate
   maxmine AS INTEGER          'max mine field radius in lightyears
   isotope AS INTEGER          'new mineral form rate
   decay AS INTEGER            'decay of structures on underpop planet
   overpop AS INTEGER          'eat supplies? (yes/no)
   nofuelmove AS INTEGER       'ships without fuel can move (yes/no)
   oddsmine AS INTEGER         'odds of hitting a mine
   oddsweb AS INTEGER          'odds of hitting a web mine
   mineseerange AS INTEGER     'range that you can see mines
   antimine AS INTEGER         'mines distroy enemy mines
   shieldbonus AS INTEGER      'engine shield bonus shield
   sbrate AS INTEGER           'engine shield bonus % rate
   cfsweeprate AS INTEGER      'colonies fighter sweep rate
   cfsweepweb AS INTEGER       'colonies fighter sweep web mines (yes/no)
   minesweeprate AS INTEGER    'rate that weapons sweep mines
   websweeprate AS INTEGER     'rate that weapons sweep web mines
   lizardmaxhiss AS INTEGER    'the max that a hiss mission can effect planet
   robfailrate AS INTEGER      'the odds that the rob mission will fail
   rebelnoatt AS INTEGER       'planets can attack rebels (yes/no)
   fascistnoatt AS INTEGER     'planets can attack fascists (yes/no)
   minesweeprange AS INTEGER   'the range that a mine field can be sweeped
   websweeprange AS INTEGER    'the range that a web field can be sweeped
   sciencemissions AS INTEGER  'ship science missions
   cloakedmineodds AS INTEGER  'the odds that a cloaked ship will hit a mine
   nocloakdamage AS INTEGER    'the amount of damage that prevents cloaking
   fedcrewbonus AS INTEGER     'fed ships get a combat bonus (yes/no)

   oddssm AS INTEGER           'odds of small meteor impacts
   smminN AS LONG              'minimum Neutronium in meteor
   smminD AS LONG
   smminT AS LONG
   smminM AS LONG
   smmaxN AS LONG              'maximum Neutronium in meteor
   smmaxD AS LONG
   smmaxT AS LONG
   smmaxM AS LONG

   numlg AS INTEGER            'number of large meteors to impact
   lgminN AS LONG              'minimum Neutronium in meteor
   lgminD AS LONG
   lgminT AS LONG
   lgminM AS LONG
   lgmaxN AS LONG              'maximum Neutronium in meteor
   lgmaxD AS LONG
   lgmaxT AS LONG
   lgmaxM AS LONG
   meteormess AS INTEGER      'send meteor messages?
   onetow AS INTEGER          'a ship with one engine can tow another
   hyper AS INTEGER           'hyper space jumps
   cdeathrate AS INTEGER      'colonist death rate
   gwell AS INTEGER           'grivity wells
   crysclim AS INTEGER        'crystals immune to bad climates
   nweb AS INTEGER            'normal mines destroy web mines
   clpop AS INTEGER           'climate limits population
   maxincome AS LONG          'max income that the planet can make per turn
   ionstorm AS INTEGER        '0%-100% The activity rating of Ion storms
   chunnel AS INTEGER         'warp chunnel
   spiboost AS INTEGER        'super spi bonus
   ionminehide AS INTEGER     'ion storms hide mines
   glory AS INTEGER           'klingon glory device (D19, Saber)
   loki AS INTEGER            'loki anti-cloaking
   lady AS INTEGER            'laby royal gambing
   cloakattack AS INTEGER     'cloaked ships can attack
   clone AS INTEGER           'ships can be cloned
   boarding AS INTEGER        'crystals and privateers can capture with tow
   imperialAssult AS INTEGER  'super star destroyer can take planets with 10 clans
END TYPE

COMMON SHARED race AS INTEGER
COMMON SHARED planetSlot AS INTEGER 'Slot of planet to be loaded in to
                                    'plan
COMMON SHARED shipSlot AS INTEGER   'Slot of ship that is to be
                                    'loaded into me
COMMON SHARED baseSlot AS INTEGER
COMMON SHARED baseT AS BASETYPE     'base data
COMMON SHARED me AS SHIPTYPE        'ship data
COMMON SHARED you AS SHIPTYPE
COMMON SHARED plan AS plantype      'planet data
COMMON SHARED hull AS HULLSPEC      'hull specs
COMMON SHARED engv AS ENGSPEC       'engine specs
COMMON SHARED beam AS BEAMSPEC      'beam weapon specs
COMMON SHARED torpv AS TORPSPEC     'torpedoe specs
COMMON SHARED seed AS LONG
COMMON SHARED dist AS INTEGER
COMMON SHARED targetcount AS INTEGER
COMMON SHARED truehull() AS INTEGER  'truehull(base.makeshipH, race)
COMMON SHARED mapx()    AS INTEGER        'ship X
COMMON SHARED mapy()    AS INTEGER        'ship Y
COMMON SHARED mapr()    AS INTEGER        'ship race ID number
COMMON SHARED mapm()    AS INTEGER        'ship mass in KT's
COMMON SHARED mapc()    AS INTEGER        'cloaked ship flag
COMMON SHARED sshield()    AS INTEGER     'ship shields
COMMON SHARED pshield()    AS INTEGER     'planet shields
COMMON SHARED xPlanet()    AS INTEGER     'planet X
COMMON SHARED yPlanet()    AS INTEGER     'planet Y
COMMON SHARED rPlanet()    AS INTEGER     'planet race ID
COMMON SHARED rBase()    AS INTEGER       'race of bases
COMMON SHARED ingame()   AS INTEGER       'flag of players in game
COMMON SHARED plrace()   AS INTEGER
COMMON SHARED cprace()   AS INTEGER
COMMON SHARED frrace()   AS INTEGER
COMMON SHARED bsrace()   AS INTEGER
COMMON SHARED dumpoldm()   AS INTEGER
COMMON SHARED fig AS CONFIGTYPE
COMMON SHARED xmine()    AS INTEGER
COMMON SHARED ymine()    AS INTEGER
COMMON SHARED rmine()    AS INTEGER
COMMON SHARED zmine()    AS LONG
COMMON SHARED wmine()    AS INTEGER
COMMON SHARED ek AS STRING * 1
COMMON SHARED path AS STRING
COMMON SHARED regkey() AS LONG
COMMON SHARED regname() AS STRING * 25
COMMON SHARED regad() AS STRING * 25
COMMON SHARED playrace() AS INTEGER
COMMON SHARED pbrain() AS INTEGER
COMMON SHARED abrain() AS INTEGER
COMMON SHARED ebrain() AS INTEGER
COMMON SHARED shipclass() AS INTEGER
COMMON SHARED classlist() AS INTEGER
COMMON SHARED lowtech AS INTEGER
DIM classlist(105) AS INTEGER
DIM shipclass(20, 11) AS INTEGER
DIM pbrain(500) AS INTEGER
DIM abrain(500) AS INTEGER
DIM ebrain(11) AS INTEGER
DIM playrace(11) AS INTEGER
DIM truehull(20, 11) AS INTEGER
DIM mapx(500) AS INTEGER
DIM mapy(500) AS INTEGER
DIM mapr(500) AS INTEGER
DIM mapm(500) AS INTEGER
DIM mapc(500) AS INTEGER
DIM xPlanet(500) AS INTEGER
DIM yPlanet(500) AS INTEGER
DIM rPlanet(500) AS INTEGER
DIM rBase(500) AS INTEGER
DIM ingame(11) AS INTEGER
DIM plrace(11) AS INTEGER
DIM cprace(11) AS INTEGER
DIM frrace(11) AS INTEGER
DIM bsrace(11) AS INTEGER
DIM dumpoldm(11) AS INTEGER
DIM xmine(500) AS INTEGER
DIM ymine(500) AS INTEGER
DIM zmine(500) AS LONG
DIM rmine(500) AS INTEGER
DIM wmine(500) AS INTEGER


'$INCLUDE: 'CPCOMH.BI'
DEFINT A-Z

DIM nc AS LONG
DIM I AS LONG
DIM char AS STRING * 1
STACK 9000
   PRINT
   PRINT
   PRINT " VGA Planets(tm)"
   PRINT " CPLAYER Program [ Version 3.02 ]"
   PRINT " Copyright (c) 1993 by Tim Wisseman"
   PRINT " All rights reserved"
   PRINT
   PRINT " CPLAYER.EXE is a freeware program"
   PRINT

   PRINT " Basic Error Trap ON"
   ON ERROR GOTO Errorhandle

   ek = CHR$(13) + CHR$(10)

   p$ = COMMAND$
   sw = 1
   IF LEN(p$) > 0 THEN
      FOR I = 1 TO LEN(p$)
         a$ = MID$(p$, I, 1)
         IF a$ <> " " THEN
            IF sw = 2 THEN
               IF VAL(a$) > 0 THEN playrace(VAL(a$)) = 1
               IF a$ = "a" OR a$ = "A" THEN playrace(10) = 1
               IF a$ = "b" OR a$ = "B" THEN playrace(11) = 1
               IF a$ = "*" THEN lowtech = 1
            END IF
            IF sw = 1 THEN
               IF a$ = "/" THEN
                  sw = 2
               ELSE
                  path = path + a$
               END IF
            END IF
         END IF
      NEXT I
   END IF

   path = LTRIM$(RTRIM$(path))
   IF LEN(path) > 0 THEN
      IF RIGHT$(path, 1) <> "\" THEN
         path = path + "\"
      END IF
   END IF

   IF sw <> 2 THEN
      g$ = " ERROR: You did not specify any races to play." + ek
      g$ = g$ + "        No action taken" + ek + ek
      g$ = g$ + "   CPLAYER c:\path /123456789ab"
      PutError g$
      END
   END IF

   ek = CHR$(13)
   RANDOMIZE TIMER

   IF LEN(path) = 0 THEN
      PRINT " Processing files in current directory"
   ELSE
      PRINT " Processing files in : "; path
   END IF
   PRINT

   f1 = FREEFILE
   OPEN path + "CPERROR.LOG" FOR OUTPUT AS #f1
   CLOSE #f1

   g$ = "Computer Player error log:" + ek + CHR$(10)
   f1 = FREEFILE
   OPEN path + "CPERROR.LOG" FOR BINARY AS #f1
      l = LEN(g$)
      pt = 1
      FOR I = 1 TO l
         char = MID$(g$, I, 1)
         PUT #f1, pt, char
         pt = pt + 1
      NEXT I
   CLOSE #f1

   g$ = " **********************" + CHR$(13) + "  " + DATE$ + "   " + TIME$ + CHR$(13)
   PutError g$

   LoadHostData

   FOR r = 1 TO 11
      FOR I = 1 TO 20
         READ shipclass(I, r)
      NEXT I
   NEXT r

   SortClassList

   'DelOldMess

   FOR race = 1 TO 11
      IF playrace(race) = 1 THEN
         F$ = path + "player" + LTRIM$(STR$(race)) + ".trn"
         IF LEN(DIR$(F$)) > 0 THEN
            PRINT "Turn file found for the "; RACENAME(race, 1)
            PRINT "Computer will skip this player this turn"
            playrace(race) = 0
         ELSE
            PRINT "*** Computer will play for the "; RACENAME(race, 1); " ***"
         END IF
      END IF
   NEXT race
   PRINT
   PRINT "FREE MEMORY : "; FRE(-1)
   PRINT

   Dumpmess

   FOR race = 1 TO 11
      IF playrace(race) = 1 THEN
         PRINT "Playing : "; RACENAME(race, 1)
         LoadBrain
         PlanetCheck
         PlanetEcon
         MoveMinerals
         WorkOnSBase
         BuildNewShips
         BuildNewStarbase
         Explore
         Eggs
         WarShips
         Alchemy
         Refuel
         SaveBrain
      END IF
   NEXT race
   ShipXYR
   SaveHostData

END

DATA 1,1,1,1,1,3,3,3,2,1,3,4,3,3,3,3,5,2,4,6
DATA 1,1,7,1,1,3,1,3,2,3,3,4,5,2,4,6,0,0,0,0
DATA 1,1,7,1,1,1,1,3,3,2,3,3,4,1,5,2,4,6,0,0
DATA 1,3,1,7,1,1,1,3,3,2,3,3,3,3,5,2,4,6,0,0
DATA 1,1,1,1,1,7,1,1,1,1,1,4,1,1,2,1,5,2,3,6
DATA 1,1,1,1,1,1,1,1,2,3,4,5,2,4,6,0,0,0,0,0
DATA 1,1,1,7,1,1,1,1,2,3,3,4,5,2,4,6,0,0,0,0
DATA 1,1,1,1,1,7,1,1,1,3,2,3,3,5,2,4,6,0,0,0
DATA 1,3,1,1,7,1,1,2,3,3,5,2,4,6,0,0,0,0,0,0
DATA 1,1,1,1,7,1,1,1,1,1,1,2,1,1,1,3,5,2,4,6
DATA 1,1,1,1,7,1,1,1,1,1,2,1,1,1,1,3,5,2,4,6

Errorhandle:
   er$ = "Fatal Program Error "
   PutError er$
   er$ = "      CPLAYER program stopped before completion."
   PutError er$
   er$ = "      BASIC Error number : " + STR$(ERR)
   PutError er$
   END 1

SUB Alchemy
DIM I AS LONG
DIM p AS LONG
DIM x1 AS LONG
DIM size AS LONG

   'hull = 104 netronic refineray
   'hull = 105 merlin class

   PRINT "Checking for Alchemy ships"
   f1 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         IF mapr(I) = race THEN
            size = 107
            x1 = (I - 1) * size + 3
            GET #f1, x1, me
            IF me.hull = 104 THEN fgN = 1
            IF me.hull = 105 THEN fgM = 1
         END IF
      NEXT I
   CLOSE #f1

   IF fgN = 1 OR fgM = 1 THEN
      size = 85
      f2 = FREEFILE
      OPEN path + "PDATA.HST" FOR BINARY AS #f2
         FOR p = 1 TO 500
            IF rPlanet(p) = race THEN
               x1 = (p - 1) * size + 3
               GET #f2, x1, plan
               IF plan.pNum = race THEN
                  IF fgN = 1 THEN
                     IF plan.eleN < 200 THEN
                        IF plan.eleD > 200 OR plan.eleT > 200 OR plan.eleM > 200 THEN
                           IF plan.eleS > 200 THEN
                              plan.eleS = plan.eleS - 100
                              plan.eleN = plan.eleN + 100
                              IF plan.eleD > 200 THEN
                                 plan.eleD = plan.eleD - 100
                              ELSEIF plan.eleT > 200 THEN
                                 plan.eleT = plan.eleT - 100
                              ELSEIF plan.eleM > 200 THEN
                                 plan.eleM = plan.eleM - 100
                              END IF
                           END IF
                        END IF
                     END IF
                  END IF
                  IF fgM = 1 THEN
                     IF plan.eleS > 200 THEN
                        plan.eleS = plan.eleS - 90
                        plan.eleM = plan.eleM + 10
                        plan.eleD = plan.eleD + 10
                        plan.eleT = plan.eleT + 10
                     END IF
                  END IF
               END IF
               PUT #f2, x1, plan
            END IF
         NEXT p
      CLOSE #f2
   END IF

END SUB

SUB BuildNewShips
DIM classcount(7) AS INTEGER
DIM tar(7) AS INTEGER
DIM x1 AS LONG
DIM size AS LONG
DIM S AS LONG
DIM I AS LONG

   'ship types:
   '1 explorier
   '2 egg
   '3 small warship
   '4 large warship
   '5 netronic refineray
   '6 merlin class

   PRINT "Ship Building"
   f1 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         IF mapr(I) = race THEN
            size = 107
            x1 = (I - 1) * size + 3
            GET #f1, x1, me
            IF me.hull > 0 AND me.hull < 105 THEN
               classcount(classlist(me.hull)) = classcount(classlist(me.hull)) + 1
            END IF
            '*** KILL MISSION 4 ***
            SELECT CASE classlist(me.hull)
               CASE 3, 4, 5, 6
                  me.mission = 4
               CASE ELSE
                  me.mission = 1
            END SELECT
            '***                ***
            me.fCode = CHR$(RND * 26 + 64) + CHR$(RND * 26 + 64) + CHR$(RND * 26 + 64)
            PUT #f1, x1, me
         END IF
      NEXT I
   CLOSE #f1

   FOR x = 1 TO 500
      SELECT CASE abrain(x)
         CASE 5, 7
            pcount = pcount + 1
         CASE 6
            sbcount = sbcount + 1
      END SELECT
   NEXT x

   tar(1) = pcount \ 30 + 10
   tar(2) = 1 + pcount \ 30
   tar(3) = pcount \ 3
   tar(4) = pcount \ 5 + 1
   tar(5) = 1
   tar(6) = 1
   tar(7) = 1

   makethis = 4

   FOR I = 7 TO 4 STEP -1
      IF tar(I) > classcount(I) THEN makethis = I
   NEXT I

   IF tar(3) > classcount(3) THEN makethis = 3

   IF tar(2) > classcount(2) THEN makethis = 2

   IF tar(1) > classcount(1) THEN makethis = 1

   IF classcount(2) < 1 AND classcount(1) > 6 THEN makethis = 2

   IF classcount(5) < 1 THEN
      IF pcount > 20 AND classcount(3) > 3 AND classcount(4) > 2 THEN
         makethis = 5
      END IF
   END IF
   
   IF classcount(6) < 1 THEN
      IF pcount > 20 AND classcount(3) > 3 AND classcount(4) > 2 THEN
         makethis = 6
      END IF
   END IF
   
   c = 0
   IF makethis > 0 THEN
      FOR I = 1 TO 20
         IF shipclass(I, race) = makethis THEN c = c + 1
      NEXT I
      IF c > 0 THEN
         r = INT(c * RND + .5)
         IF r > c THEN r = c
         IF r < 1 THEN r = 1
         c = 0
         fgship = 0
         FOR I = 1 TO 20
            IF shipclass(I, race) = makethis THEN c = c + 1
            IF c = r THEN
               c = 999
               fgship = I
               IF truehull(fgship, race) = 0 THEN
                  PRINT "BAD HULL DATA ERROR!"
                  END 1
               END IF
            END IF
         NEXT I
         IF fgship > 0 THEN
            PRINT "Trying to build a ship class "; makethis
            FOR I = 1 TO 500
               IF rBase(I) = race AND rPlanet(I) = race THEN
                  baseSlot = I
                  LBase
                  IF baseT.techE >= 6 THEN
                     planetSlot = I
                     LPlanet
                     LHull truehull(fgship, race)
                     IF hull.cost < plan.money THEN
                        IF hull.eleM < plan.eleM THEN
                           IF hull.eleT < plan.eleT THEN
                              IF hull.eleD < plan.eleD THEN
                                 IF hull.tech <= baseT.techH THEN
                                    BuildShip fgship
                                 END IF
                              END IF
                           END IF
                        END IF
                     END IF
                     SPlanet
                  END IF
                  SBase
               END IF
            NEXT I
         END IF
      END IF
   END IF



END SUB

SUB BuildNewStarbase
   ' 7  Building Starbase here
   FOR p = 1 TO 500
      IF rPlanet(p) = race THEN
         IF abrain(p) = 7 AND rBase(p) <> race THEN
            planetSlot = p
            LPlanet
            IF plan.money >= 900 THEN
               IF plan.eleT >= 402 THEN
                  IF plan.eleD >= 120 THEN
                     IF plan.eleM >= 340 THEN
                         PRINT "Building starbase!"
                         plan.money = plan.money - 900
                         plan.eleT = plan.eleT - 402
                         plan.eleD = plan.eleD - 120
                         plan.eleM = plan.eleM - 340
                         rBase(planetSlot) = race
                         baseT.ID = planetSlot
                         baseT.pNum = race
                         baseT.defense = 0
                         baseT.damage = 0
                         baseT.techE = 1
                         baseT.techH = 1
                         baseT.techW = 1
                         baseT.techT = 1
                         SELECT CASE plan.species
                            CASE 1
                               baseT.techH = 10
                            CASE 7
                               baseT.techW = 10
                            CASE 8
                               baseT.techE = 10
                            CASE 9
                               baseT.techT = 10
                         END SELECT
                         FOR I = 1 TO 9
                            baseT.storeE(I) = 0
                         NEXT I
                         FOR I = 1 TO 20
                            baseT.storeH(I) = 0
                         NEXT I
                         FOR I = 1 TO 10
                            baseT.storeW(I) = 0
                            baseT.storeT(I) = 0
                            baseT.storeTorps(I) = 0
                         NEXT I
                         baseT.storeF = 0
                         baseT.mission = 1
                         baseT.makeshipH = 0
                         baseT.makeshipE = 0
                         baseT.makeshipW = 0
                         baseT.makeshipWc = 0
                         baseT.makeshipT = 0
                         baseT.makeshipTc = 0
                         baseT.makeshipFc = 0
                         baseSlot = planetSlot
                         SBase
                         SPlanet
                      END IF
                   END IF
                END IF
             END IF
          END IF
       END IF
   NEXT p

END SUB

SUB BuildShip (fgship%)
   FOR I = 1 TO 10
      IF I < 9 THEN
         IF baseT.storeE(I) >= hull.engines THEN bestE = I
      ELSE
         IF baseT.storeE(9) >= hull.engines THEN bestE = 9
      END IF
      IF baseT.storeT(I) >= hull.torp THEN bestT = I
      IF baseT.storeW(I) >= hull.weapon THEN bestW = I
   NEXT I

   IF bestE < 6 THEN
      PRINT "I don't want low tech engines. . ."
      EXIT SUB
   END IF

   IF bestE = 0 OR bestT = 0 OR bestW = 0 THEN
      PRINT "I don't have all the parts to build a ship. . ."
      EXIT SUB
   END IF

   fg = 0
   FOR I = 450 TO 1 STEP -1
      IF mapr(I) = 0 THEN fg = I
   NEXT I

   IF fg = 0 THEN
      PRINT "All ship slots are full. . . "
      EXIT SUB
   END IF

   mapr(fg) = race
   me.ID = fg
   me.pNum = race
   me.fCode = CHR$(RND * 50 + 64) + CHR$(RND * 50 + 64) + CHR$(RND * 50 + 64)
   me.warp = 0
   me.xWay = 0
   me.yWay = 0
   me.xShip = xPlanet(planetSlot)
   me.yShip = yPlanet(planetSlot)
   mapx(fg) = me.xShip
   mapy(fg) = me.yShip
   me.eng = bestE
   me.hull = truehull(fgship, race)
   me.weapon = bestW
   me.wbanks = hull.weapon
   IF hull.weapon = 0 THEN me.weapon = 0
   me.bays = hull.bays
   me.tube = bestT
   me.torp = 0
   me.tbanks = hull.torp
   IF hull.torp = 0 THEN me.tube = 0
   me.mission = 1
   me.enemy = 0
   me.tow = 0
   me.damage = 0
   me.crew = hull.crew
   me.col = 0
   me.nm = RNDNAME
   me.eleN = 0
   max = hull.eleN
   IF plan.eleN > hull.eleN THEN
      me.eleN = max
      plan.eleN = plan.eleN - max
   ELSE
      me.eleN = 50
   END IF
   me.eleT = 0
   me.eleD = 0
   me.eleM = 0
   me.eleS = 0
   me.unN = 0
   me.unT = 0
   me.unD = 0
   me.unM = 0
   me.unCol = 0
   me.unS = 0
   me.unplanet = 0
   me.transN = 0
   me.transT = 0
   me.transD = 0
   me.transM = 0
   me.transC = 0
   me.transS = 0
   me.transtarget = 0
   me.iTarget = 0
   me.cash = 0


   baseT.storeE(bestE) = baseT.storeE(bestE) - hull.engines
   baseT.storeW(bestW) = baseT.storeW(bestW) - hull.weapon
   baseT.storeT(bestT) = baseT.storeT(bestT) - hull.torp

   PRINT "NOW Building a Ship"

   IF me.hull = 0 THEN
      PRINT "FATAL DATA ERROR !"
      SLEEP 10
      END
   END IF

   shipSlot = fg
   SShip

END SUB

FUNCTION CargoR%
   c = hull.cargo
   c = c - me.col - me.eleT - me.eleD - me.eleM - me.eleS
   c = c - me.torp
   IF c < 0 THEN c = 0
   CargoR = c
END FUNCTION

SUB CheckFig
   DIM oldfig AS CONFIGTYPE
   f1 = FREEFILE
   OPEN path + "OLDFIG.HST" FOR BINARY AS #f1
      GET #f1, 1, oldfig
      PUT #f1, 1, fig
   CLOSE #f1
   fg = 0
   IF oldfig.recycle <> fig.recycle THEN fg = 1
   IF oldfig.meteor <> fig.meteor THEN fg = 1
   IF oldfig.mine <> fig.mine THEN fg = 1
   IF oldfig.Alchemy <> fig.Alchemy THEN fg = 1
   IF oldfig.delold <> fig.delold THEN fg = 1

   IF fg = 1 THEN
      g$ = "< Message from Mr. Host >" + ek + ek
      g$ = g$ + " I have set the following:" + ek + ek
      g$ = g$ + "  Colonize recycle rate : " + STR$(fig.recycle) + " % " + ek
      g$ = g$ + "  ^ ( minerals recovered from hull )" + ek + ek
      g$ = g$ + " Odds of a meteor " + STR$(fig.meteor) + " %" + ek
      g$ = g$ + " Antiship space mines "
      IF fig.mine = 0 THEN
         g$ = g$ + " : NO " + ek
      ELSE
         g$ = g$ + " : YES " + ek
      END IF
      g$ = g$ + " Alchemy ships "
      IF fig.Alchemy = 0 THEN
         g$ = g$ + " : NO " + ek
      ELSE
         g$ = g$ + " : YES " + ek
      END IF
      g$ = g$ + " Delete Old Messages"
      IF fig.delold = 0 THEN
         g$ = g$ + " : NO " + ek
      ELSE
         g$ = g$ + " : YES " + ek
      END IF
      FOR I = 1 TO 11
         IF ingame(I) THEN
            PutMessage I, g$
         END IF
      NEXT I
   END IF
END SUB

DEFSNG A-Z
DEFINT A-Z
SUB CKI (n%)
   IF n > 10000 THEN
      e$ = "DATA OVERFLOW ERROR! in player " + STR$(race) + " .TRN file "
      PutError e$
      n = 0
   END IF
   IF n < 0 THEN
      e$ = "DATA UNDERFLOW ERROR! in player " + STR$(race) + " .TRN file"
      PutError e$
      n = 0
   END IF
END SUB

DEFSNG A-Z
DEFLNG A-Z
SUB CKL (n&)
   IF n& > 1000000000 THEN
      e$ = "BIG DATA OVERFLOW ERROR! in player " + STR$(race) + " .TRN file "
      PutError e$
      n& = 0
   END IF
   IF n& < 0 THEN
      e$ = "BIG DATA UNDERFLOW ERROR! in player " + STR$(race) + " .TRN file"
      PutError e$
      n& = 0
   END IF
END SUB

DEFINT A-Z
SUB DelOldMess
'this sub searches messages to the computer player and dumps them
'or recycles them
   DIM x1 AS LONG
   DIM x2 AS LONG
   DIM x3 AS LONG
   DIM mpt AS LONG
   DIM char AS STRING * 1
   DIM messcount(11) AS INTEGER
   IF LEN(DIR$(path + "MESSPNT.NEW")) > 0 THEN KILL path + "MESSPNT.NEW"
   IF LEN(DIR$(path + "MESS.NEW")) > 0 THEN KILL path + "MESS.NEW"
   nul = 0

   PRINT "Saving subspace message traffic..."
   
   IF LEN(DIR$(path + "MESSPNT.OLD")) = 0 THEN
      f2 = FREEFILE
      OPEN path + "MESSPNT.OLD" FOR BINARY AS #f2
         PUT #f2, 1, nul
      CLOSE #f2
   END IF

   IF LEN(DIR$(path + "MESSPNT.EXT")) = 0 THEN
      f2 = FREEFILE
      OPEN path + "MESSPNT.EXT" FOR BINARY AS #f2
         PUT #f2, 1, nul
      CLOSE #f2
   END IF

   f2 = FREEFILE
   OPEN path + "MESSPNT.OLD" FOR BINARY AS #f2
      GET #f2, 1, c
      IF c > 0 THEN
         ic = 1
         WHILE ic <= c
            x1 = (ic - 1) * 8 + 3
            GET #f2, x1, r
            IF r > 0 AND r < 12 THEN
               IF playrace(r) = 0 THEN
                  PRINT ".";
                  x2 = x1 + 2
                  x3 = x2 + 4
                  GET #f2, x2, mpt
                  GET #f2, x3, l
                  m$ = ""
                  f3 = FREEFILE
                  OPEN path + "MESS.OLD" FOR BINARY AS #f3
                     I = 0
                     WHILE I < l
                        I = I + 1
                        GET #f3, mpt, char
                        mpt = mpt + 1
                        m$ = m$ + char
                     WEND
                  CLOSE #f3
                  StoreNewMess r, m$
               END IF
            ELSE
               er$ = "Race Message ERROR" + STR$(r) + "message # " + STR$(ic)
               PutError er$
            END IF
            ic = ic + 1
         WEND
      END IF
   CLOSE #f2


   IF LEN(DIR$(path + "MESSPNT.TMP")) > 0 THEN KILL path + "MESSPNT.TMP"
   IF LEN(DIR$(path + "MESS.TMP")) > 0 THEN KILL path + "MESS.TMP"

   IF LEN(DIR$(path + "MESSPNT.NEW")) > 0 AND LEN(DIR$(path + "MESS.NEW")) > 0 THEN
      NAME path + "MESSPNT.NEW" AS path + "MESSPNT.TMP"
      NAME path + "MESS.NEW" AS path + "MESS.TMP"
   ELSE
      nul = 0
      f1 = FREEFILE
      OPEN path + "MESSPNT.TMP" FOR BINARY AS #f1
         PUT #f1, 1, nul
      CLOSE #f1
      OPEN path + "MESS.TMP" FOR BINARY AS #f1
         PUT #f1, 1, nul
      CLOSE #f1
   END IF
   PRINT

END SUB

SUB Dumpmess
'this sub searches old read messages and dumps them
'or recycles them
   DIM x1 AS LONG
   DIM x2 AS LONG
   DIM x3 AS LONG
   DIM mpt AS LONG
   DIM char AS STRING * 1
   DIM messcount(11) AS INTEGER
   IF LEN(DIR$(path + "MESSPNT.NEW")) > 0 THEN KILL path + "MESSPNT.NEW"
   IF LEN(DIR$(path + "MESS.NEW")) > 0 THEN KILL path + "MESS.NEW"
   nul = 0

   IF LEN(DIR$(path + "MESSPNT.OLD")) = 0 THEN
      f2 = FREEFILE
      OPEN path + "MESSPNT.OLD" FOR BINARY AS #f2
         PUT #f2, 1, nul
      CLOSE #f2
   END IF

   f2 = FREEFILE
   OPEN path + "MESSPNT.OLD" FOR BINARY AS #f2
   f3 = FREEFILE
   OPEN path + "MESSPNT.NEW" FOR BINARY AS #f3
      GET #f2, 1, c
      newc = 0
      IF c > 0 THEN
         ic = 1
         WHILE ic <= c
            x1 = (ic - 1) * 8 + 3
            GET #f2, x1, r
            IF r > 0 AND r < 12 THEN
               IF playrace(r) = 0 THEN
                  newc = newc + 1
                  x2 = x1 + 2
                  x3 = x2 + 4
                  GET #f2, x2, mpt
                  GET #f2, x3, l
                  x1 = (newc - 1) * 8 + 3
                  x2 = x1 + 2
                  x3 = x2 + 4
                  PUT #f3, x1, r
                  PUT #f3, x2, mpt
                  PUT #f3, x3, l
               END IF
            END IF
            ic = ic + 1
         WEND
      END IF
      PUT #f3, 1, newc
   CLOSE #f3
   CLOSE #f2

   IF LEN(DIR$(path + "MESSPNT.OLD")) > 0 THEN KILL path + "MESSPNT.OLD"
   NAME path + "MESSPNT.NEW" AS path + "MESSPNT.OLD"

END SUB

SUB Eggs
DIM x1 AS LONG
DIM size AS LONG
DIM S AS LONG
DIM I AS LONG
DIM distold AS LONG
DIM dx AS LONG
DIM dy AS LONG
DIM d AS LONG
DIM near(6) AS INTEGER
DIM nearD(6) AS LONG
DIM distold2 AS LONG

   FOR I = 1 TO 6
      near(I) = 1
      nearD(I) = 50000
   NEXT I

   PRINT "Setting Eggs Way Points"
   f1 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         IF mapr(I) = race THEN
            shipSlot = I
            size = 107
            x1 = (I - 1) * size + 3
            GET #f1, x1, me
            IF classlist(me.hull) = 2 THEN
               IF me.eleN < 50 THEN LoadFuel
               IF me.col < 100 THEN
                  distold = 30000
                  distold2 = 30000
                  fgP2 = 0
                  fgP = 0
                  f2 = FREEFILE
                  OPEN path + "PDATA.HST" FOR BINARY AS #f2
                     size = 85
                     FOR x = 1 TO 500
                        IF rPlanet(x) = race THEN
                           x1 = (x - 1) * size + 3
                           GET #f2, x1, plan
                           IF plan.eleC > 1000 THEN
                              dx = xPlanet(x) - me.xShip
                              dy = yPlanet(x) - me.yShip
                              d = SQR(dx ^ 2 + dy ^ 2)
                              IF d < distold THEN
                                 distold = d
                                 fgP = x
                              END IF
                              IF plan.eleC > 4000 THEN
                                 IF d < distold2 THEN
                                    distold2 = d
                                    fgP2 = x
                                 END IF
                              END IF
                           END IF
                        END IF
                     NEXT x
                  CLOSE #f2
                  IF fgP2 > 0 THEN fgP = fgP2
                  IF fgP > 0 THEN
                     dx = xPlanet(fgP) - me.xShip
                     dy = yPlanet(fgP) - me.yShip
                     WHILE ABS(dx) > 160 OR ABS(dy) > 160
                       dx = dx * .8
                       dy = dy * .8
                     WEND
                     me.xWay = dx
                     me.yWay = dy
                     me.warp = me.eng
                     IF dx = 0 AND dy = 0 AND rPlanet(fgP) = race THEN
                        planetSlot = fgP
                        LPlanet
                        LHull me.hull
                        plan.eleM = plan.eleM + me.eleM
                        me.eleM = 0
                        plan.eleD = plan.eleD + me.eleD
                        me.eleD = 0
                        plan.eleT = plan.eleT + me.eleT
                        me.eleT = 0
                        plan.eleS = plan.eleS + me.eleS
                        me.eleS = 0
                        plan.money = plan.money + me.cash
                        me.cash = 0
                        plan.eleC = plan.eleC + me.col
                        me.col = 0
                        k = CargoR
                        ks = k * .2
                        k = k - ks
                        IF plan.eleS > ks THEN
                           me.eleS = ks
                           plan.eleS = plan.eleS - ks
                        END IF
                        IF plan.money > ks * 3 THEN
                           me.cash = ks * 3
                           plan.money = plan.money - ks * 3
                        END IF
                        IF plan.eleC > k THEN
                           me.col = ks
                           plan.eleC = plan.eleC - ks
                        END IF
                        SPlanet
                     END IF
                  END IF
               ELSE
                  distold = 30000
                  fgP = 0
                  f2 = FREEFILE
                  OPEN path + "PDATA.HST" FOR BINARY AS #f2
                     size = 85
                     FOR x = 1 TO 500
                        IF rPlanet(x) = race THEN
                           x1 = (x - 1) * size + 3
                           GET #f2, x1, plan
                           IF plan.eleC < 200 AND pbrain(x) > 200 THEN
                              dx = xPlanet(x) - me.xShip
                              dy = yPlanet(x) - me.yShip
                              d = SQR(dx ^ 2 + dy ^ 2)
                              IF d < distold THEN
                                 distold = d
                                 fgP = x
                              END IF
                           END IF
                        END IF
                     NEXT x
                  CLOSE #f2
                  IF fgP > 0 THEN
                     dx = xPlanet(fgP) - me.xShip
                     dy = yPlanet(fgP) - me.yShip
                     WHILE ABS(dx) > 160 OR ABS(dy) > 160
                       dx = dx * .8
                       dy = dy * .8
                     WEND
                     me.xWay = dx
                     me.yWay = dy
                     me.warp = me.eng
                     IF dx = 0 AND dy = 0 AND rPlanet(fgP) = race THEN
                        planetSlot = fgP
                        LPlanet
                        plan.eleS = plan.eleS + me.eleS
                        plan.eleC = plan.eleC + me.col
                        plan.money = plan.money + me.cash
                        me.eleS = 0
                        me.col = 0
                        me.cash = 0
                        SPlanet
                     END IF
                  ELSE
                     c = 0
                     FOR ii = 1 TO 6
                        near(ii) = 0
                        nearD(ii) = 30000
                     NEXT ii
                     FOR ii = 1 TO 500
                        IF abrain(ii) = 0 AND rPlanet(ii) = 0 THEN
                           dx = xPlanet(ii) - me.xShip
                           dy = yPlanet(ii) - me.yShip
                           d = SQR((dx) ^ 2 + (dy) ^ 2)
                           IF d < nearD(5) THEN
                              c = c + 1
                              nearD(6) = d
                              near(6) = ii
                              FOR x = 5 TO 1 STEP -1
                                 IF nearD(x + 1) < nearD(x) THEN
                                    SWAP nearD(x + 1), nearD(x)
                                    SWAP near(x + 1), near(x)
                                 END IF
                              NEXT x
                           END IF
                        END IF
                     NEXT ii
                     IF c >= 5 THEN
                        r = RND * 5
                        IF RND < .8 THEN r = 1
                        IF r < 1 THEN r = 1
                        IF r > 5 THEN r = 5
                        dx = xPlanet(near(r)) - me.xShip
                        dy = yPlanet(near(r)) - me.yShip
                        WHILE ABS(dx) > 160 OR ABS(dy) > 160
                          dx = dx * .8
                          dy = dy * .8
                        WEND
                        me.xWay = dx
                        me.yWay = dy
                        fgP = near(r)
                     END IF
                     IF me.wbanks > 0 THEN me.mission = 4
                     me.warp = me.eng
                     IF dx = 0 AND dy = 0 AND rPlanet(fgP) = 0 AND fgP > 0 THEN
                        planetSlot = fgP
                        LPlanet
                        plan.eleS = plan.eleS + me.eleS
                        plan.eleC = plan.eleC + me.col
                        plan.money = plan.money + me.cash
                        plan.pNum = race
                        rPlanet(fgP) = race
                        me.eleS = 0
                        me.col = 0
                        me.cash = 0
                        SPlanet
                     END IF
                  END IF
               END IF
               size = 107
               x1 = (I - 1) * size + 3
               PUT #f1, x1, me
            END IF
         END IF
      NEXT I
   CLOSE #f1

END SUB

SUB Explore
DIM x1 AS LONG
DIM size AS LONG
DIM S AS LONG
DIM I AS LONG
DIM ii AS LONG
DIM near(6) AS INTEGER
DIM nearD(6) AS LONG
DIM dx AS LONG
DIM dy AS LONG
DIM d AS LONG

   FOR I = 1 TO 6
      near(I) = 1
      nearD(I) = 50000
   NEXT I


   PRINT "Setting EX Way Points"
   f1 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f1
      size = 107
      FOR I = 1 TO 500
         IF mapr(I) = race THEN
            shipSlot = I
            size = 107
            x1 = (I - 1) * size + 3
            GET #f1, x1, me
            LHull me.hull
            IF classlist(me.hull) = 1 THEN
               IF me.eleN < 50 THEN LoadFuel
               IF CargoR >= 10 AND me.col < 10 THEN me.col = 10
               IF me.tbanks > 0 AND CargoR >= 10 AND me.torp < 10 THEN me.torp = 10
               FOR ii = 1 TO 500
                  IF me.xShip = xPlanet(ii) THEN
                     IF me.yShip = yPlanet(ii) THEN
                        planetSlot = ii
                        LPlanet
                        IF me.eleN < 50 AND rPlanet(ii) = 0 THEN
                           LHull me.hull
                           d = hull.eleN - me.eleN
                           IF plan.eleN < d THEN d = plan.eleN
                           me.eleN = me.eleN + d
                           plan.eleN = plan.eleN - d
                        END IF
                        IF rPlanet(ii) = 0 THEN
                           plan.pNum = race
                           plan.eleC = 15
                           plan.eleS = plan.eleS + 10
                           plan.money = plan.money + 30
                           rPlanet(ii) = race
                           abrain(ii) = 3
                        ELSEIF rPlanet(ii) <> race THEN
                           abrain(ii) = 9
                        END IF
                        PCheck v
                        pbrain(ii) = v
                        SPlanet
                     END IF
                  END IF
               NEXT ii
               c = 0
               FOR ii = 1 TO 6
                  near(ii) = 0
                  nearD(ii) = 30000
               NEXT ii
               FOR ii = 1 TO 500
                  IF abrain(ii) = 0 THEN
                     dx = xPlanet(ii) - me.xShip
                     dy = yPlanet(ii) - me.yShip
                     d = SQR((dx) ^ 2 + (dy) ^ 2)
                     IF d < nearD(5) THEN
                        c = c + 1
                        nearD(6) = d
                        near(6) = ii
                        FOR x = 5 TO 1 STEP -1
                           IF nearD(x + 1) < nearD(x) THEN
                              SWAP nearD(x + 1), nearD(x)
                              SWAP near(x + 1), near(x)
                           END IF
                        NEXT x
                     END IF
                  END IF
               NEXT ii
               IF c >= 5 THEN
                  r = RND * 5
                  IF RND < .8 THEN r = 1
                  IF r < 1 THEN r = 1
                  IF r > 5 THEN r = 5
                  dx = xPlanet(near(r)) - me.xShip
                  dy = yPlanet(near(r)) - me.yShip
                  WHILE ABS(dx) > 160 OR ABS(dy) > 160
                    dx = dx * .8
                    dy = dy * .8
                  WEND
                  me.xWay = dx
                  me.yWay = dy
               END IF
               IF me.wbanks > 0 THEN me.mission = 4
               me.warp = me.eng
               PUT #f1, x1, me
            END IF
         END IF
      NEXT I
   CLOSE #f1
END SUB

FUNCTION FuelR%
   FuelR = hull.eleN - me.eleN
END FUNCTION

SUB LBase
DIM size AS LONG
DIM x1 AS LONG
DIM b AS LONG
   size = 156
   b = baseSlot
   x1 = (b - 1) * size + 3
   f2 = FREEFILE
   OPEN path + "BDATA.HST" FOR BINARY AS #f2
      GET #f2, x1, baseT
   CLOSE #f2
END SUB

SUB LBeam (n%)
   IF n < 0 OR n > 10 THEN EXIT SUB
   size = 36
   x1 = (n - 1) * size + 1
   f1 = FREEFILE
   OPEN "BEAMSPEC.DAT" FOR BINARY AS #f1
      GET #f1, x1, beam
   CLOSE #f1
END SUB

SUB LEng (n%)
   IF n < 1 OR n > 10 THEN
      er$ = "ERROR IMPOSSIBLE ENG SPECS " + STR$(n)
      PutError er$
   END IF
   size = 66
   x1 = (n - 1) * size + 1
   f1 = FREEFILE
   OPEN "ENGSPEC.DAT" FOR BINARY AS #f1
      GET #f1, x1, engv
   CLOSE #f1
END SUB

SUB LHull (n%)
   IF n < 1 THEN
      er$ = "ERROR! Impossible Hull specs! Player # " + STR$(race)
      PutError er$
      EXIT SUB
   END IF
   size = 60
   x1 = (n - 1) * size + 1
   f1 = FREEFILE
   OPEN "HULLSPEC.DAT" FOR BINARY AS #f1
      GET #f1, x1, hull
   CLOSE #f1
END SUB

SUB LoadBrain
DIM x1 AS LONG
   f1 = FREEFILE
   F$ = path + "brain" + LTRIM$(RTRIM$(STR$(race))) + ".hst"
   IF LEN(DIR$(F$)) > 0 THEN
      OPEN F$ FOR BINARY AS #f1
         FOR I = 1 TO 500
            x1 = I * 2 - 1
            GET #f1, x1, pbrain(I)
         NEXT I
         FOR I = 1 TO 500
            x1 = I * 2 - 1 + 1000
            GET #f1, x1, abrain(I)
         NEXT I
         FOR I = 1 TO 11
            x1 = I * 2 - 1 + 2000
            GET #f1, x1, ebrain(I)
         NEXT I
      CLOSE #f1
   ELSE
      OPEN F$ FOR BINARY AS #f1
         nul = 0
         FOR I = 1 TO 500
            x1 = I * 2 - 1
            PUT #f1, x1, nul
         NEXT I
         FOR I = 1 TO 500
            x1 = I * 2 - 1 + 1000
            PUT #f1, x1, nul
         NEXT I
         FOR I = 1 TO 11
            x1 = I * 2 - 1 + 2000
            PUT #f1, x1, nul
         NEXT I
      CLOSE #f1
   END IF

   r = RND * 500
   IF r > 500 THEN r = 500
   IF r < 1 THEN r = 1
   abrain(r) = 0

END SUB

SUB LoadFuel
DIM x1 AS LONG
DIM size AS LONG
DIM p AS LONG
DIM max AS LONG
DIM fgmax AS LONG
   x = me.xShip
   y = me.yShip
   fg = 0
   FOR I = 1 TO 500
      IF mapr(I) <> race AND mapr(I) > 0 THEN
         IF ABS(x - mapx(I)) < 80 THEN
            IF ABS(y - mapy(I)) < 80 THEN
               fg = 1
            END IF
         END IF
      END IF
   NEXT I
   FOR I = 1 TO 500
      IF rPlanet(I) <> race AND rPlanet(I) > 0 THEN
         IF ABS(x - xPlanet(I)) < 20 THEN
            IF ABS(y - yPlanet(I)) < 20 THEN
               fg = 1
            END IF
         END IF
      END IF
   NEXT I
   IF fg = 0 THEN
      LHull me.hull
      req = hull.eleN - me.eleN
      req = req * .7
      size = 85
      max = 0
      f2 = FREEFILE
      OPEN path + "PDATA.HST" FOR BINARY AS #f2
         FOR p = 1 TO 500
            IF rPlanet(p) = race THEN
               x1 = (p - 1) * size + 3
               GET #f2, x1, plan
               IF max < plan.eleN THEN
                   max = plan.eleN
                   fgmax = p
               END IF
            END IF
         NEXT p
         IF max < req THEN req = max
         IF fgmax > 0 THEN
            x1 = (fgmax - 1) * size + 3
            GET #f2, x1, plan
            plan.eleN = plan.eleN - req
            me.eleN = me.eleN + req
            PUT #f2, x1, plan
         END IF
      CLOSE #f2
   END IF
END SUB

SUB LoadHostData
   DIM x1 AS LONG
   DIM z AS LONG
   DIM size AS LONG
   f1 = FREEFILE
   OPEN path + "SHIPXY.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         GET #f1, , mapx(I)
         GET #f1, , mapy(I)
         GET #f1, , mapr(I)
         GET #f1, , mapm(I)
         IF mapr(I) > 11 OR mapr(I) < 1 THEN mapr(I) = 0
      NEXT I
   CLOSE #f1

   OPEN path + "MINES.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         GET #f1, , xmine(I)
         GET #f1, , ymine(I)
         GET #f1, , rmine(I)
         GET #f1, , zmine(I)
         GET #f1, , wmine(I)
      NEXT I
   CLOSE #f1

   OPEN path + "XYPLAN.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         GET #f1, , xPlanet(I)
         GET #f1, , yPlanet(I)
         GET #f1, , rPlanet(I)
      NEXT I
   CLOSE #f1
   
   size = 107
   PRINT "Searching for ships"
   OPEN path + "SHIP.HST" FOR BINARY AS #f1
      FOR z = 1 TO 500
         x1 = (z - 1) * size + 3
         GET #f1, x1, me
         mapr(z) = me.pNum
      NEXT z
   CLOSE #f1
   
   PRINT "Searching for planets..."
   size = 85
   OPEN path + "PDATA.HST" FOR BINARY AS #f1
      FOR z = 1 TO 500
         x1 = (z - 1) * size + 3
         GET #f1, x1, plan
         IF plan.pNum > 0 THEN
            rPlanet(z) = plan.pNum
         END IF
         IF plan.ID <> z THEN
            er$ = "Disk read/write error"
            PutError er$
         END IF
      NEXT z
   CLOSE #f1
   
   size = 156
   OPEN path + "BDATA.HST" FOR BINARY AS #f1
      FOR z = 1 TO 500
         x1 = (z - 1) * size + 3
         GET #f1, x1, baseT
         IF baseT.pNum > 0 THEN
            rBase(z) = baseT.pNum
         END IF
      NEXT z
   CLOSE #f1

   OPEN path + "GEN.HST" FOR BINARY AS #f1
      FOR I = 1 TO 11
         x1 = 46 + I * 2 - 1
         GET #f1, x1, ingame(I)
      NEXT I
   CLOSE #f1

   OPEN "TRUEHULL.DAT" FOR BINARY AS #f1
      FOR r = 1 TO 11
         FOR I = 1 TO 20
            x1 = (I - 1) * 2 + (r - 1) * 40 + 1
            GET #f1, x1, truehull(I, r)
         NEXT I
      NEXT r
   CLOSE #f1

   IF LEN(DIR$(path + "HCONFIG.HST")) > 0 THEN
      OPEN path + "HCONFIG.HST" FOR BINARY AS #f1
         GET #f1, 1, fig
      CLOSE #f1
   ELSE
      fig.meteor = 0
      fig.recycle = 0
   END IF
END SUB

SUB LPlanet
DIM x1 AS LONG
DIM size AS LONG
DIM p AS LONG
   size = 85
   p = planetSlot
   x1 = (p - 1) * size + 3
   f2 = FREEFILE
   OPEN path + "PDATA.HST" FOR BINARY AS #f2
      GET #f2, x1, plan
   CLOSE #f2
END SUB

SUB LShip
DIM x1 AS LONG
DIM size AS LONG
DIM S AS LONG
   size = 107
   S = shipSlot
   x1 = (S - 1) * size + 3
   f2 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f2
      GET #f2, x1, me
   CLOSE #f2
   mapr(S) = me.pNum
END SUB

SUB LTorp (n%)
   IF n < 1 OR n > 10 THEN EXIT SUB
   size = 38
   x1 = (n - 1) * size + 1
   f1 = FREEFILE
   OPEN "TORPSPEC.DAT" FOR BINARY AS #f1
      GET #f1, x1, torpv
   CLOSE #f1
END SUB

SUB MoveMinerals
DIM x1 AS LONG
DIM size AS LONG
DIM p AS LONG
DIM nl AS LONG
DIM ml AS LONG
DIM tl AS LONG
DIM dl AS LONG
DIM mcl AS LONG
DIM v AS LONG
DIM count AS LONG
DIM top AS LONG
DIM topP AS LONG

   PRINT "Beaming up minerals"
   count = 0
   FOR p = 1 TO 500
      IF rBase(p) = race THEN
         count = count + 1
         abrain(p) = 6
      END IF
      IF abrain(p) = 6 AND rBase(p) <> race THEN abrain(p) = 5
      IF abrain(p) = 7 THEN abrain(p) = 5
      IF rPlanet(p) = race THEN
         IF rBase(p) <> race THEN
            IF abrain(p) = 5 OR abrain(p) = 7 THEN
               IF pbrain(p) > topP THEN
                  topP = pbrain(p)
                  top = p
               END IF
            END IF
         END IF
      END IF
   NEXT p

   IF top > 0 AND topP > 500 THEN
      count = count + 1
      abrain(top) = 7
   END IF

   IF count < 1 THEN
      PRINT "No planets found"
      EXIT SUB
   END IF

   PRINT "I have "; count; " good planets"

   size = 85
   f2 = FREEFILE
   OPEN path + "PDATA.HST" FOR BINARY AS #f2
      FOR p = 1 TO 500
         IF rPlanet(p) = race THEN
            sw = 0
            SELECT CASE abrain(p)
               CASE 5, 6, 7
                  sw = 1
            END SELECT
            IF sw = 1 THEN
               x1 = (p - 1) * size + 3
               GET #f2, x1, plan
               IF plan.pNum = race AND rBase(p) <> race THEN
                  REM
                  v = plan.eleM \ 4
                  IF v > 50 THEN v = 50
                  IF pbrain(p) < 500 THEN v = plan.eleM
                  ml = ml + v
                  plan.eleM = plan.eleM - v
                  REM
                  v = plan.eleD \ 4
                  IF v > 50 THEN v = 50
                  IF pbrain(p) < 500 THEN v = plan.eleD
                  dl = dl + v
                  plan.eleD = plan.eleD - v
                  REM
                  v = plan.eleT \ 4
                  IF v > 50 THEN v = 50
                  IF pbrain(p) < 500 THEN v = plan.eleT
                  tl = tl + v
                  plan.eleT = plan.eleT - v
                  REM
                  v = plan.eleN \ 4
                  IF v > 50 THEN v = 50
                  nl = nl + v
                  plan.eleN = plan.eleN - v
                  REM
                  v = plan.money \ 3
                  IF v > 400 THEN v = 400
                  mcl = mcl + v
                  plan.money = plan.money - v
                  REM
               END IF
               x1 = (p - 1) * size + 3
               PUT #f2, x1, plan
            END IF
         END IF
      NEXT p
      nl = nl \ count
      ml = ml \ count
      tl = tl \ count
      dl = dl \ count
      mcl = mcl \ count
      size = 85
      FOR p = 1 TO 500
         IF rPlanet(p) = race THEN
            sw = 0
            SELECT CASE abrain(p)
               CASE 6, 7
                  sw = 1
            END SELECT
            IF sw = 1 THEN
               x1 = (p - 1) * size + 3
               GET #f2, x1, plan
               IF plan.pNum = race THEN
                  plan.eleN = plan.eleN + nl
                  plan.eleT = plan.eleT + tl
                  plan.eleD = plan.eleD + dl
                  plan.eleM = plan.eleM + ml
                  plan.money = plan.money + mcl
               END IF
               PUT #f2, x1, plan
            END IF
         END IF
      NEXT p
   CLOSE #f2

END SUB

SUB PCheck (v%)
   v = 0
   IF plan.eleN > 500 THEN v = v + 100
   IF plan.eleM > 500 THEN v = v + 200
   IF plan.eleD > 500 THEN v = v + 100
   IF plan.eleT > 500 THEN v = v + 130
   IF plan.resN > 1000 THEN v = v + 200
   IF plan.resM > 1000 THEN v = v + 400
   IF plan.resT > 1000 THEN v = v + 200
   IF plan.resD > 1000 THEN v = v + 200
   IF plan.money > 2000 THEN v = v + 400
   IF plan.money > 500 THEN v = v + 50
   IF plan.eleS > 100 THEN v = v + 80
   IF plan.climate > 30 AND plan.climate < 70 THEN v = v + 50
   IF plan.native > 500 THEN
      SELECT CASE plan.species
         CASE 1
            v = v + 10
         CASE 2
            v = v + 1000
         CASE 3
            v = v + 30
         CASE 4
            v = v + 300
         CASE 5
            v = v - 200
         CASE 6
            v = v + 400
         CASE 7
            v = v + 30
         CASE 9
            v = v + 60
      END SELECT
      IF plan.species <> 5 THEN v = v + plan.SPI * 10
   END IF
END SUB

SUB PlanetCheck
DIM x1 AS LONG
DIM size AS LONG
DIM p AS LONG

   '**** ABRAIN ****
   ' 0  None
   ' 1  Explored
   ' 2  Attack
   ' 3  Dropping Some Colonists
   ' 4  Dropping Many Colonists
   ' 5  My Planet
   ' 6  Starbase
   ' 7  Building Starbase here
   ' 8  Please send colonists
   ' 9  Enemy Planet


   PRINT "THINKING ABOUT: Planetary Values"
   size = 85
   f2 = FREEFILE
   OPEN path + "PDATA.HST" FOR BINARY AS #f2
      FOR p = 1 TO 500
         IF rPlanet(p) = race THEN
            IF rBase(p) = race THEN
               abrain(p) = 6
            END IF
            IF abrain(p) = 0 THEN abrain(p) = 5
            IF abrain(p) = 3 THEN abrain(p) = 5
            x1 = (p - 1) * size + 3
            GET #f2, x1, plan
            IF plan.pNum = race THEN
               PCheck v
               pbrain(p) = v
            ELSE
               g$ = "Planet ID Error!"
               PutError g$
            END IF
         END IF
         IF abrain(p) = 3 THEN
            x1 = (p - 1) * size + 3
            GET #f2, x1, plan
            PCheck v
            pbrain(p) = v
            IF rPlanet(p) <> race AND rPlanet(p) > 0 THEN
               abrain(p) = 9
            ELSE
               abrain(p) = 1
            END IF
         END IF
      NEXT p
   CLOSE #f2
END SUB

SUB PlanetEcon
DIM x1 AS LONG
DIM size AS LONG
DIM p AS LONG
   PRINT "THINKING ABOUT: Planetary Economies"
   size = 85
   f2 = FREEFILE
   OPEN path + "PDATA.HST" FOR BINARY AS #f2
      FOR p = 1 TO 500
         IF rPlanet(p) = race THEN
            x1 = (p - 1) * size + 3
            GET #f2, x1, plan
            IF plan.pNum = race THEN
               h = plan.eleS \ 8
               plan.eleS = plan.eleS - h
               plan.money = plan.money + h
               IF plan.happynessC > 60 THEN
                  plan.taxC = plan.taxC + 1
               END IF
               IF plan.happynessN > 60 THEN
                  plan.taxN = plan.taxN + 1
               END IF
               IF plan.happynessC < 60 THEN
                  plan.taxC = plan.taxC - 3
                  IF plan.taxC < 0 THEN plan.taxC = 0
               END IF
               IF plan.happynessN < 60 THEN
                  plan.taxN = plan.taxN - 3
                  IF plan.taxN < 0 THEN plan.taxN = 0
               END IF
               IF plan.eleC < 101 THEN
                  maxfact = plan.eleC
               ELSE
                  maxfact = 100 + (SQR(plan.eleC - 95))
               END IF
               WHILE plan.factories < maxfact AND plan.money > 3 AND plan.eleS > 0
                  plan.eleS = plan.eleS - 1
                  plan.money = plan.money - 3
                  plan.factories = plan.factories + 1
               WEND
               IF plan.eleC > 50 THEN
                  maxmines = 100
               ELSE
                  maxmines = plan.eleC
               END IF
               WHILE plan.mines < maxmines AND plan.money > 4 AND plan.eleS > 0
                  plan.eleS = plan.eleS - 1
                  plan.money = plan.money - 4
                  plan.mines = plan.mines + 1
               WEND
               IF plan.money > 1000 AND plan.eleS > 100 THEN
                  maxsdi = SQR(plan.eleC) + 30
                  WHILE plan.money > 10 AND plan.eleS > 0 AND plan.SDI < maxsdi
                     plan.SDI = plan.SDI + 1
                     plan.money = plan.money - 10
                     plan.eleS = plan.eleS - 1
                  WEND
               END IF
               plan.fCode = CHR$(64 + RND * 50) + CHR$(64 + RND * 50) + CHR$(64 + RND * 50)
            END IF
            PUT #f2, x1, plan
         END IF
      NEXT p
   CLOSE #f2
END SUB

FUNCTION PLANETNAME$ (n%)
   DIM nm AS STRING * 20
   f5 = FREEFILE
   OPEN "PLANET.NM" FOR BINARY AS #f5
      x1 = (n - 1) * 20 + 1
      GET #f5, x1, nm
      a$ = RTRIM$(nm)
   CLOSE #f5
   PLANETNAME = a$
END FUNCTION

SUB PutError (g$)
DIM pt AS LONG
DIM char AS STRING * 1
   PRINT g$
   f4 = FREEFILE
   OPEN path + "CPERROR.LOG" FOR BINARY AS #f4
      pt = LOF(f4) + 1
      g$ = g$ + ek + CHR$(10)
      l = LEN(g$)
      FOR I = 1 TO l
         char = MID$(g$, I, 1)
         PUT #f4, pt, char
         pt = pt + 1
      NEXT I
   CLOSE #f4

   OPEN path + "CPOLD.LOG" FOR BINARY AS #f4
      pt = LOF(f4) + 1
      l = LEN(g$)
      FOR I = 1 TO l
         char = MID$(g$, I, 1)
         PUT #f4, pt, char
         pt = pt + 1
      NEXT I
   CLOSE #f4
END SUB

SUB PutMessage (rc%, gg$)
DIM pt AS LONG
DIM ptold AS LONG
DIM x1 AS LONG
DIM x2 AS LONG
DIM x3 AS LONG
DIM x1old AS LONG
DIM x2old AS LONG
DIM x3old AS LONG
DIM char AS STRING * 1

'
'   this sub stores a message and data on the message for later use
'MESSPNT.TMP
'|2 integer (count) |2 integer (race) |4 long (pointer to MESS.TMP) |2 integer (length) |...

'MESS.TMP
'| message data | message data |

   m$ = gg$
   IF rc > 11 OR rc < 1 THEN EXIT SUB
   IF m$ = "" THEN EXIT SUB
   f2 = FREEFILE
   OPEN path + "MESSPNT.TMP" FOR BINARY AS #f2
      GET #f2, 1, count
      count = count + 1
      PUT #f2, 1, count
      x1 = (count - 1) * 8 + 3
      x2 = x1 + 2
      x3 = x2 + 4
      l = LEN(m$)
      IF count > 1 THEN
         x1old = (count - 2) * 8 + 3
         x2old = x1old + 2
         x3old = x2old + 4
         GET #f2, x2old, ptold
         GET #f2, x3old, lold
         pt = ptold + (lold)
      ELSE
         pt = 1
      END IF
      PUT #f2, x1, rc
      PUT #f2, x2, pt
      PUT #f2, x3, l
   CLOSE #f2
   OPEN path + "MESS.TMP" FOR BINARY AS #f2
      FOR I = 1 TO l
         IF ASC(MID$(m$, I, 1)) + 13 > 254 THEN
            MID$(m$, I, 1) = " "
         END IF
         MID$(m$, I, 1) = CHR$(ASC(MID$(m$, I, 1)) + 13)
        ' PUT #f2, pt&, char
        ' pt = pt + 1
      NEXT I
      PUT #f2, pt&, m$
      pt = pt + 1
   CLOSE #f2
END SUB

FUNCTION RACENAME$ (n%, fg%)
   IF n < 1 OR n > 11 THEN EXIT FUNCTION
   SELECT CASE fg
      CASE 1
         S = 30
         x1 = (n - 1) * 30 + 1
      CASE 2
         S = 20
         x1 = (n - 1) * 20 + 331
      CASE 3
         S = 12
         x1 = (n - 1) * 12 + 551
      CASE ELSE
         EXIT FUNCTION
   END SELECT

   n$ = STRING$(S, 32)

   f4 = FREEFILE
   OPEN path + "RACE.NM" FOR BINARY AS #f4
      GET #f4, x1, n$
   CLOSE #f4

   FOR I = 1 TO LEN(n$)
      IF ASC(MID$(n$, I, 1)) > 127 OR ASC(MID$(n$, I, 1)) < 12 THEN
         MID$(n$, I, 1) = " "
      END IF
   NEXT I

   RACENAME = RTRIM$(LTRIM$(n$))

END FUNCTION

SUB Refuel
DIM x1 AS LONG
DIM size AS LONG
DIM S AS LONG
DIM I AS LONG
DIM ii AS LONG
DIM dx AS LONG
DIM dy AS LONG
DIM d AS LONG
DIM fgD AS LONG
DIM fghelp(6) AS INTEGER

   FOR I = 1 TO 6
      fghelp(I) = 0
   NEXT I
   
   c = 1
   PRINT "Setting Refueler Way Points"
   f1 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f1
      size = 107
      FOR I = 1 TO 500
         IF mapr(I) = race THEN
            shipSlot = I
            size = 107
            x1 = (I - 1) * size + 3
            GET #f1, x1, me
            IF me.eleN = 0 AND c < 7 THEN
               fghelp(c) = I
               c = c + 1
            END IF
         END IF
      NEXT I
   CLOSE #1
   
   FOR c = 1 TO 6
      IF fghelp(c) > 0 THEN
         fgD = 30000
         fgtank = 0
         f1 = FREEFILE
         OPEN path + "SHIP.HST" FOR BINARY AS #f1
            size = 107
            FOR I = 1 TO 500
               IF mapr(I) = race THEN
                  shipSlot = I
                  size = 107
                  x1 = (I - 1) * size + 3
                  GET #f1, x1, me
                  IF me.eleN >= 130 THEN
                     dx = mapx(I) - mapx(fghelp(c))
                     dy = mapy(I) - mapy(fghelp(c))
                     d = SQR(dx ^ 2 + dy ^ 2)
                     IF d < fgD THEN
                        fgD = d
                        fgtank = I
                     END IF
                  END IF
               END IF
            NEXT I
         CLOSE #1
         IF fgtank > 0 THEN
            shipSlot = fgtank
            LShip
            dx = mapx(fghelp) - me.xShip
            dy = mapy(fghelp) - me.yShip
            WHILE ABS(dx) > 160 OR ABS(dy) > 160
              dx = dx * .8
              dy = dy * .8
            WEND
            me.xWay = dx
            me.yWay = dy
            me.warp = me.eng
            LoadFuel
            SShip
         END IF
      END IF
   NEXT c

   FOR v = 1 TO 499
      FOR z = v + 1 TO 500
         IF mapr(v) = race THEN
            IF mapr(z) = race THEN
               IF mapx(v) = mapx(z) THEN
                  IF mapy(v) = mapy(z) THEN
                     shipSlot = v
                     LShip
                     LHull me.hull
                     maxyou = hull.eleN
                     you = me
                     shipSlot = z
                     LShip
                     LHull me.hull
                     maxme = hull.eleN
                     tfuel = me.eleN + you.eleN
                     me.eleN = 0
                     you.eleN = 0
                     sw = 1
                     WHILE tfuel > 0
                        sw = sw + 1
                        IF sw > 1 THEN sw = 0
                        tfuel = tfuel - 1
                        IF sw = 0 THEN
                           IF me.eleN < maxme THEN
                              me.eleN = me.eleN + 1
                           ELSEIF you.eleN < maxyou THEN
                              you.eleN = you.eleN + 1
                           END IF
                        END IF
                        IF sw = 1 THEN
                           IF you.eleN < maxyou THEN
                              you.eleN = you.eleN + 1
                           ELSEIF me.eleN < maxme THEN
                              me.eleN = me.eleN + 1
                           END IF
                        END IF
                     WEND
                     shipSlot = z
                     SShip
                     SWAP you, me
                     shipSlot = v
                     SShip
                  END IF
               END IF
            END IF
         END IF
      NEXT z
   NEXT v

END SUB

FUNCTION RNDNAME$
   r = INT(RND * 65)
   IF r < 1 THEN r = 1
   IF r > 65 THEN r = 65

   SELECT CASE r
      CASE 1
         g$ = "USS Bounty"
      CASE 2
         g$ = "USS Bovanova"
      CASE 3
         g$ = "Red October"
      CASE 4
         g$ = "Eat Flaming Death"
      CASE 5
         g$ = "Rust Bucket"
      CASE 6
         g$ = "Tax Man"
      CASE 7
         g$ = "Space Seed"
      CASE 8
         g$ = "USS Enterprise"
      CASE 9
         g$ = "Termy"
      CASE 10
         g$ = "Death From Above"
      CASE 11
         g$ = "The Searcher"
      CASE 12
         g$ = "USS Sean Penn"
      CASE 13
         g$ = "USS Gates"
      CASE 14
         g$ = "Raptor"
      CASE 15
         g$ = "Heart of Topring"
      CASE 16
         g$ = "Topaw"
      CASE 17
         g$ = "USS Stargazer"
      CASE 18
         g$ = "USS Clinton"
      CASE 19
         g$ = "USS Kennedy"
      CASE 20
         g$ = "USS Regan"
      CASE 21
         g$ = "USS Kaden"
      CASE 22
         g$ = "USS Kaiser"
      CASE 23
         g$ = "USS Kammere"
      CASE 24
         g$ = "USS Kang"
      CASE 25
         g$ = "USS Kashi"
      CASE 26
         g$ = "USS Keller"
      CASE 27
         g$ = "USS Kelly"
      CASE 28
         g$ = "Portland"
      CASE 29
         g$ = "USS Hood"
      CASE 30
         g$ = "Casnovia"
      CASE 31
         g$ = "USS Tucson"
      CASE 32
         g$ = "USS Daytona"
      CASE 33
         g$ = "USS Hamilton"
      CASE 34
         g$ = "USS Providence"
      CASE 35
         g$ = "Atlanta"
      CASE 36
         g$ = "Tacoma"
      CASE 37
         g$ = "Phoenix Sun"
      CASE 38
         g$ = "USS Spokane"
      CASE 39
         g$ = "York"
      CASE 40
         g$ = "Seabrook"
      CASE 41
         g$ = "USS Redmond"
      CASE 42
         g$ = "USS Bellevue"
      CASE 43
         g$ = "The Knoxville"
      CASE 44
         g$ = "HMCS Kamloops"
      CASE 45
         g$ = "USS Orem"
      CASE 46
         g$ = "USS Aptos"
      CASE 47
         g$ = "Dave"
      CASE 48
         g$ = "Durham"
      CASE 49
         g$ = "Sierra"
      CASE 50
         g$ = "USS Reston"
      CASE 51
         g$ = "California"
      CASE 52
         g$ = "USS Forestfire"
      CASE 53
         g$ = "USS Independence"
      CASE 54
         g$ = "Monkey Business"
      CASE 55
         g$ = "USS Minow"
      CASE 56
         g$ = "Larry Bud Melman"
      CASE 57
         g$ = "USS Dave"
      CASE 58
         g$ = "USS Wallace"
      CASE 59
         g$ = "USS Billery"
      CASE 60
         g$ = "USS Joyceland"
      CASE 61
         g$ = "Lizard Face"
      CASE 62
         g$ = "USS Algore"
      CASE 63
         g$ = "USS Ackman"
      CASE 64
         g$ = "USS Emmit Smith"
      CASE 65
         g$ = "USS Rush"
   END SELECT
   RNDNAME = g$
END FUNCTION

SUB SaveBrain
   f1 = FREEFILE
   F$ = path + "brain" + LTRIM$(RTRIM$(STR$(race))) + ".hst"
   OPEN F$ FOR BINARY AS #f1
      FOR I = 1 TO 500
         x1 = I * 2 - 1
         PUT #f1, x1, pbrain(I)
      NEXT I
      FOR I = 1 TO 500
         x1 = I * 2 - 1 + 1000
         PUT #f1, x1, abrain(I)
      NEXT I
      FOR I = 1 TO 11
         x1 = I * 2 - 1 + 2000
         PUT #f1, x1, ebrain(I)
      NEXT I
   CLOSE #f1
END SUB

SUB SaveHostData
   f1 = FREEFILE
   OPEN path + "SHIPXY.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         PUT #f1, , mapx(I)
         PUT #f1, , mapy(I)
         PUT #f1, , mapr(I)
         PUT #f1, , mapm(I)
      NEXT I
   CLOSE #f1

   OPEN path + "MINES.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         PUT #f1, , xmine(I)
         PUT #f1, , ymine(I)
         PUT #f1, , rmine(I)
         PUT #f1, , zmine(I)
         PUT #f1, , wmine(I)
      NEXT I
   CLOSE #f1

   OPEN path + "XYPLAN.HST" FOR BINARY AS #f1
      FOR I = 1 TO 500
         PUT #f1, , xPlanet(I)
         PUT #f1, , yPlanet(I)
         PUT #f1, , rPlanet(I)
      NEXT I
   CLOSE #f1

END SUB

SUB SBase
DIM x1 AS LONG
DIM size AS LONG
DIM b AS LONG
   size = 156
   b = baseSlot
   x1 = (b - 1) * size + 3
   f2 = FREEFILE
   OPEN path + "BDATA.HST" FOR BINARY AS #f2
      PUT #f2, x1, baseT
   CLOSE #f2
END SUB

SUB ShipMass
DIM x1 AS LONG
DIM size AS LONG
DIM S AS LONG
DIM I AS LONG
   'figures the ships mass and stores mass in mapm()
   'mass is in Kilotons
   PRINT "Figuring mass of all ships."
   f1 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f1
      f2 = FREEFILE
      OPEN "HULLSPEC.DAT" FOR BINARY AS #f2
         f3 = FREEFILE
         OPEN "BEAMSPEC.DAT" FOR BINARY AS #f3
            f4 = FREEFILE
            OPEN "TORPSPEC.DAT" FOR BINARY AS #f4
               FOR I = 1 TO 500
                  IF mapr(I) > 0 THEN
                     w = 0
                     shipSlot = I
                     size = 107
                     x1 = (I - 1) * size + 3
                     GET #f1, x1, me

                     IF me.eleN < 1 THEN me.mission = 0

                     IF me.mission = 10 AND me.eleN > 0 THEN
                        mapc(me.ID) = 1
                     ELSE
                        mapc(me.ID) = 0
                     END IF
                     IF me.mission = 9 AND me.eleN > 0 AND me.pNum = 3 THEN
                        SELECT CASE me.hull
                           CASE 21, 22, 25, 26, 27, 28, 29, 47, 31
                              mapc(me.ID) = 1
                           CASE 32, 33, 45, 38, 36, 43, 46, 44, 45
                              mapc(me.ID) = 1
                        END SELECT
                     END IF
                     IF me.mission < 7 AND (me.tow > 0 OR me.iTarget > 0) THEN
                        me.tow = 0
                        me.iTarget = 0
                        PUT #f1, x1, me
                     END IF
                     IF hull.bays = 0 AND me.bays > 0 THEN
                        me.torp = 0
                        me.bays = 0
                        PUT #f1, x1, me
                     END IF
                     IF hull.torp = 0 AND me.tbanks > 0 THEN
                        me.tbanks = 0
                        me.torp = 0
                        PUT #f1, x1, me
                     END IF
                     IF me.bays < 1 AND me.tbanks < 1 AND me.torp > 0 THEN
                        me.torp = 0
                        PUT #f1, x1, me
                     END IF
                     IF (me.damage > 99 AND me.pNum <> 2) THEN
                        me.pNum = 0
                        me.ID = 0
                        mapr(I) = 0
                        PUT #f1, x1, me
                     END IF
                     IF me.damage > 151 AND me.pNum = 2 THEN
                        me.pNum = 0
                        me.ID = 0
                        mapr(I) = 0
                        PUT #f1, x1, me
                     END IF
                     IF ABS(me.xWay) > 200 OR ABS(me.yWay) > 200 THEN
                        me.xWay = 0
                        me.yWay = 0
                        PUT #f1, x1, me
                     END IF
                     IF me.damage > 0 AND me.eleS >= 5 THEN
                        WHILE me.damage > 0 AND me.eleS >= 5
                           me.damage = me.damage - 1
                           me.eleS = me.eleS - 5
                        WEND
                        PUT #f1, x1, me
                     END IF
                     IF me.damage > 10 THEN
                        maxspeed = 10 - me.damage \ 10
                        IF me.pNum = 2 THEN maxspeed = maxspeed + 4
                        IF me.warp > maxspeed THEN me.warp = maxspeed
                        PUT #f1, x1, me
                     END IF
                     size = 60
                     x1 = (me.hull - 1) * size + 1
                     GET #f2, x1, hull
                     IF me.weapon > 0 THEN
                        size = 36
                        x1 = (me.weapon - 1) * size + 1
                        GET #f3, x1, beam
                        w = w + beam.mass * me.wbanks
                     END IF
                     IF me.tube > 0 THEN
                        size = 38
                        x1 = (me.tube - 1) * size + 1
                        GET #f4, x1, torpv
                        w = w + torpv.mass * me.tbanks
                     END IF
                     w = hull.mass + me.torp + me.eleM + me.eleN + me.eleT
                     w = w + me.eleD + me.col + me.eleS
                     mapm(I) = w
                  END IF
               NEXT I
            CLOSE #f4
         CLOSE #f3
      CLOSE #f2
   CLOSE #f1
END SUB

SUB ShipXYR
DIM x1 AS LONG
DIM size AS LONG
DIM I AS LONG
   'this file makes new XYR data for map*() arrays
   PRINT "Getting Ship (X,Y)'s"
   f2 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f2
      FOR I = 1 TO 500
         IF mapr(I) > 0 THEN
            size = 107
            x1 = (I - 1) * size + 3
            GET #f2, x1, me
            mapx(I) = me.xShip
            mapy(I) = me.yShip
            mapr(I) = me.pNum
         END IF
      NEXT I
   CLOSE #f2
END SUB

SUB SortClassList
   FOR r = 1 TO 11
      FOR I = 1 TO 20
         v = shipclass(I, r)
         x = truehull(I, r)
         classlist(x) = v
      NEXT I
   NEXT r
   FOR x = 1 TO 105
      IF classlist(x) = 0 THEN
         PRINT "ERROR! : Ship Type"; x; " is undefined!"
      END IF
   NEXT x
END SUB

SUB SPlanet
DIM size AS LONG
DIM x1 AS LONG
DIM p AS LONG
   size = 85
   p = planetSlot
   x1 = (p - 1) * size + 3
   f2 = FREEFILE
   OPEN path + "PDATA.HST" FOR BINARY AS #f2
      PUT #f2, x1, plan
   CLOSE #f2
   rPlanet(planetSlot) = plan.pNum
END SUB

SUB SShip
DIM x1 AS LONG
DIM size AS LONG
DIM S AS LONG
   size = 107
   S = shipSlot
   x1 = (S - 1) * size + 3
   f2 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f2
      PUT #f2, x1, me
   CLOSE #f2
   IF mapr(S) <> me.pNum THEN
      BEEP
      g$ = "WARNING: A ship may have vanished.  player #" + STR$(mapr(S)) + " or " + STR$(me.pNum)
      PRINT g$
      PutError g$
   END IF
   mapr(S) = me.pNum
END SUB

SUB StoreNewMess (rc%, m$)
'
'   this sub stores a message and data on the message for later use
'   in the event that a player misses a turn
'MESSPNT.NEW
'|2 integer (count) |2 integer (race) |4 long (pointer to MESS.TMP) |2 integer (length) |...

'MESS.NEW
'| message data | message data |

DIM pt AS LONG
DIM ptold AS LONG
DIM char AS STRING * 1
DIM x1 AS LONG
DIM x2 AS LONG
DIM x3 AS LONG
DIM x1old AS LONG
DIM x2old AS LONG
DIM x3old AS LONG

   IF m$ = "" THEN EXIT SUB
   f3 = FREEFILE
   OPEN path + "MESSPNT.NEW" FOR BINARY AS #f3
      GET #f3, 1, count
      count = count + 1
      PUT #f3, 1, count
      x1 = (count - 1) * 8 + 3
      x2 = x1 + 2
      x3 = x2 + 4
      l = LEN(m$)
      IF count > 1 THEN
         x1old = (count - 2) * 8 + 3
         x2old = x1old + 2
         x3old = x2old + 4
         GET #f3, x2old, ptold
         GET #f3, x3old, lold
         pt = ptold + (lold)
      ELSE
         pt = 1
      END IF
      PUT #f3, x1, rc
      PUT #f3, x2, pt
      PUT #f3, x3, l
   CLOSE #f3
   OPEN path + "MESS.NEW" FOR BINARY AS #f3
      FOR I = 1 TO l
         char = MID$(m$, I, 1)
         PUT #f3, pt, char
         pt = pt + 1
      NEXT I
   CLOSE #f3
END SUB

SUB WarShips
DIM x1 AS LONG
DIM size AS LONG
DIM S AS LONG
DIM I AS LONG
DIM ii AS LONG
DIM near(6) AS INTEGER
DIM nearD(6) AS LONG
DIM dx AS LONG
DIM dy AS LONG
DIM d AS LONG
DIM fgBD AS LONG

   FOR I = 1 TO 6
      near(I) = 1
      nearD(I) = 50000
   NEXT I

   PRINT "Setting WAR Way Points"
   f1 = FREEFILE
   OPEN path + "SHIP.HST" FOR BINARY AS #f1
      size = 107
      FOR I = 1 TO 500
         IF mapr(I) = race THEN
            shipSlot = I
            size = 107
            x1 = (I - 1) * size + 3
            GET #f1, x1, me
            IF classlist(me.hull) = 3 OR classlist(me.hull) = 4 THEN
               IF me.eleN < 50 THEN LoadFuel
               IF me.eleN > 0 AND me.xWay = 0 AND me.yWay = 0 THEN
                  LHull me.hull
                  IF hull.bays > 0 AND me.torp > 20 THEN
                     GOSUB GOWAR
                  ELSEIF hull.torp > 0 AND me.torp > 20 THEN
                     GOSUB GOWAR
                  ELSE
                     GOSUB GOHOME
                  END IF
               END IF
               me.warp = me.eng
               me.mission = 4
               PUT #f1, x1, me
            END IF
         END IF
      NEXT I
   CLOSE #f1
   EXIT SUB

GOHOME:
   fgBase = 0
   fgBD = 30000
   FOR ii = 1 TO 500
      IF rBase(ii) = race THEN
         dx = xPlanet(ii) - me.xShip
         dy = yPlanet(ii) - me.yShip
         d = SQR(dx ^ 2 + dy ^ 2)
         IF d < fgBD THEN
            fgBD = d
            fgBase = ii
         END IF
      END IF
   NEXT ii
   IF fgBase > 0 THEN
      dx = xPlanet(fgBase) - me.xShip
      dy = yPlanet(fgBase) - me.yShip
      WHILE ABS(dx) > 160 OR ABS(dy) > 160
         dx = dx * .8
         dy = dy * .8
      WEND
      me.xWay = dx
      me.yWay = dy
      me.warp = me.eng
      IF dx <= 50 AND dy <= 50 THEN
         GOSUB LoadShip
      END IF
   END IF
RETURN

LoadShip:
   shipSlot = fgBase
   LPlanet
   baseSlot = fgBase
   LBase
   LHull me.hull
   IF me.tbanks > 0 AND me.tube > 0 THEN
      LTorp me.tube
      WHILE plan.money > 200 AND plan.eleM > 0 AND plan.eleT > 0 AND plan.eleD > 0 AND CargoR > 1
         plan.money = plan.money - torpv.cost
         plan.eleM = plan.eleM - 1
         plan.eleD = plan.eleD - 1
         plan.eleT = plan.eleT - 1
         me.torp = me.torp + 1
      WEND
   END IF
   IF me.bays > 0 THEN
      IF race = 9 OR race = 10 OR race = 11 THEN
         WHILE plan.eleS > 5 AND plan.eleT > 2 AND plan.eleM > 3 AND CargoR > 1
            plan.eleS = plan.eleS - 5
            plan.eleM = plan.eleM - 3
            plan.eleT = plan.eleT - 2
            me.torp = me.torp + 1
         WEND
      ELSE
         WHILE plan.money > 1000 AND plan.eleT > 2 AND plan.eleM > 3 AND CargoR > 1
            plan.money = plan.money - 100
            plan.eleM = plan.eleM - 3
            plan.eleT = plan.eleT - 2
            me.torp = me.torp + 1
         WEND
      END IF
   END IF
   SPlanet
   SBase
RETURN

GOWAR:
   FOR ii = 1 TO 6
      near(ii) = 0
      nearD(ii) = 30000
   NEXT ii
   IF RND < .5 THEN
      c = 0
      FOR ii = 1 TO 500
         IF abrain(ii) = 9 THEN
            dx = xPlanet(ii) - me.xShip
            dy = yPlanet(ii) - me.yShip
            d = SQR((dx) ^ 2 + (dy) ^ 2)
            IF d < nearD(6) THEN
               c = c + 1
               nearD(6) = d
               near(6) = ii
               FOR x = 5 TO 1 STEP -1
                  IF nearD(x + 1) < nearD(x) THEN
                     SWAP nearD(x + 1), nearD(x)
                     SWAP near(x + 1), near(x)
                  END IF
               NEXT x
            END IF
         END IF
      NEXT ii
      IF c > 0 THEN
         IF c >= 5 THEN
            r = RND * 5
            IF r < 1 THEN r = 1
            IF r > 5 THEN r = 5
         ELSE
            r = c
         END IF
         dx = xPlanet(near(r)) - me.xShip
         dy = yPlanet(near(r)) - me.yShip
         WHILE ABS(dx) > 160 OR ABS(dy) > 160
           dx = dx * .8
           dy = dy * .8
         WEND
         me.xWay = dx
         me.yWay = dy
         me.warp = me.eng
         me.mission = 4
      END IF
      ELSE
      FOR ii = 1 TO 6
         nearD(ii) = 30000
         near(ii) = 0
      NEXT ii
      FOR ii = 1 TO 500
         IF mapr(ii) > 0 AND mapr(ii) <> race THEN
            dx = me.xShip - mapx(ii)
            dy = me.yShip - mapy(ii)
            d = SQR((dx) ^ 2 + (dy) ^ 2)
            IF d < nearD(6) THEN
               c = c + 1
               nearD(6) = d
               near(6) = ii
               FOR x = 5 TO 1 STEP -1
                  IF nearD(x + 1) < nearD(x) THEN
                     SWAP nearD(x + 1), nearD(x)
                     SWAP near(x + 1), near(x)
                  END IF
               NEXT x
            END IF
         END IF
      NEXT ii
      IF c > 0 THEN
         IF c >= 5 THEN
            r = RND * 5
            IF r < 1 THEN r = 1
            IF r > 5 THEN r = 5
         ELSE
            r = c
         END IF
         dx = mapx(near(r)) - me.xShip
         dy = mapy(near(r)) - me.yShip
         WHILE ABS(dx) > 160 OR ABS(dy) > 160
           dx = dx * .8
           dy = dy * .8
         WEND
         me.xWay = dx
         me.yWay = dy
         me.warp = me.eng
         me.mission = 4
      END IF
   END IF
RETURN

END SUB

SUB WorkOnSBase
   PRINT "Working on starbases"
   FOR I = 1 TO 500
      IF mapr(I) = race THEN
         sc = sc + 1
      END IF
      IF rPlanet(I) = race THEN
         pc = pc + 1
      END IF
   NEXT I

   FOR p = 1 TO 500
      IF rBase(p) = race THEN
         baseSlot = p
         planetSlot = p
         LBase
         LPlanet
         IF baseT.techE < 10 THEN
            PRINT "Improving Engine Tech Level"
            IF lowtech = 0 THEN
               WHILE plan.money > 1000 AND baseT.techE < 10
                  plan.money = plan.money - baseT.techE * 100
                  baseT.techE = baseT.techE + 1
               WEND
            ELSE
               WHILE plan.money > 1000 AND baseT.techE < 6
                  plan.money = plan.money - baseT.techE * 100
                  baseT.techE = baseT.techE + 1
               WEND
            END IF
         END IF
         
         IF lowtech = 0 THEN
            IF (baseT.techH < 10 AND pc > 20) OR baseT.techH < 6 THEN
               IF plan.money > baseT.techH * 200 THEN
                  PRINT "Improving Hull Tech Level"
                  plan.money = plan.money - baseT.techH * 100
                  baseT.techH = baseT.techH + 1
               END IF
            END IF
         ELSE
            IF baseT.techH < 6 THEN
               IF plan.money > baseT.techH * 200 THEN
                  PRINT "Improving Hull Tech Level"
                  plan.money = plan.money - baseT.techH * 100
                  baseT.techH = baseT.techH + 1
               END IF
            END IF
         END IF

         IF lowtech = 0 THEN
            IF (baseT.techT < 10 AND sc > 10) OR baseT.techT < 3 THEN
               IF plan.money > baseT.techT * 500 THEN
                  PRINT "Improving Torp Tech Level"
                  plan.money = plan.money - baseT.techT * 100
                  baseT.techT = baseT.techT + 1
               END IF
            END IF
         ELSE
            IF (baseT.techT < 6 AND sc > 10) OR baseT.techT < 3 THEN
               IF plan.money > baseT.techT * 500 THEN
                  PRINT "Improving Torp Tech Level"
                  plan.money = plan.money - baseT.techT * 100
                  baseT.techT = baseT.techT + 1
               END IF
            END IF
         END IF

         IF lowtech = 1 THEN
            IF (baseT.techW < 10 AND sc > 10) OR baseT.techW < 4 THEN
               IF plan.money > baseT.techW * 500 THEN
                  PRINT "Improving Beam Weapon Tech Level"
                  plan.money = plan.money - baseT.techW * 100
                  baseT.techW = baseT.techW + 1
               END IF
            END IF
         ELSE
            IF (baseT.techW < 6 AND sc > 10) OR baseT.techW < 4 THEN
               IF plan.money > baseT.techW * 500 THEN
                  PRINT "Improving Beam Weapon Tech Level"
                  plan.money = plan.money - baseT.techW * 100
                  baseT.techW = baseT.techW + 1
               END IF
            END IF
         END IF

         IF race = 9 OR race = 10 OR race = 11 THEN
            PRINT "Building fighters in space"
            WHILE plan.eleT > 3 AND plan.eleM > 2 AND baseT.storeF < 60 AND plan.eleS > 5
               plan.eleT = plan.eleT - 3
               plan.eleM = plan.eleM - 2
               baseT.storeF = baseT.storeF + 1
               plan.eleS = plan.eleS - 5
            WEND
         ELSE
            IF plan.money > 20000 THEN
               PRINT "Building 100mc fighters"
               WHILE plan.money > 20000 AND plan.eleT > 3 AND plan.eleM > 2 AND baseT.storeF < 60
                  plan.eleT = plan.eleT - 3
                  plan.eleM = plan.eleM - 2
                  baseT.storeF = baseT.storeF + 1
                  plan.money = plan.money - 100
               WEND
            END IF
         END IF

         IF baseT.techE >= 6 THEN
            PRINT "Building Engines"
            b = baseT.techE
            IF b > 9 THEN b = 9
            I = b
            IF baseT.storeE(I) < 4 THEN
               LEng I
               WHILE baseT.storeE(I) < 4 AND plan.money > engv.cost AND plan.eleM > engv.eleM AND plan.eleD > engv.eleD AND plan.eleT > engv.eleT
                  plan.money = plan.money - engv.cost
                  plan.eleM = plan.eleM - engv.eleM
                  plan.eleD = plan.eleD - engv.eleD
                  plan.eleT = plan.eleT - engv.eleT
                  baseT.storeE(I) = baseT.storeE(I) + 1
               WEND
            END IF
            IF baseT.storeE(I) < 10 AND plan.money > 500 AND plan.eleM > 200 THEN
               LEng I
               WHILE baseT.storeE(I) < 10 AND plan.money > engv.cost AND plan.eleM > engv.eleM AND plan.eleD > engv.eleD AND plan.eleT > engv.eleT
                  plan.money = plan.money - engv.cost
                  plan.eleM = plan.eleM - engv.eleM
                  plan.eleD = plan.eleD - engv.eleD
                  plan.eleT = plan.eleT - engv.eleT
                  baseT.storeE(I) = baseT.storeE(I) + 1
               WEND
            END IF
         END IF

         PRINT "Building Weapon systems"
         IF pc > 10 AND sc > 10 THEN
            FOR I = 1 TO baseT.techW
               IF baseT.storeW(I) < 10 THEN
                  LBeam I
                  WHILE baseT.storeW(I) < 10 AND plan.money > beam.cost AND plan.eleD > beam.eleD AND plan.eleT > beam.eleT AND plan.eleM > beam.eleM
                      plan.money = plan.money - beam.cost
                      plan.eleD = plan.eleD - beam.eleD
                      plan.eleT = plan.eleT - beam.eleT
                      plan.eleM = plan.eleM - beam.eleM
                      baseT.storeW(I) = baseT.storeW(I) + 1
                  WEND
               END IF
            NEXT I
         END IF
         IF baseT.techW >= 3 THEN
            I = 3
            IF baseT.storeW(I) < 10 THEN
               LBeam I
               WHILE baseT.storeW(I) < 10 AND plan.money > beam.cost AND plan.eleD > beam.eleD AND plan.eleT > beam.eleT AND plan.eleM > beam.eleM
                   plan.money = plan.money - beam.cost
                   plan.eleD = plan.eleD - beam.eleD
                   plan.eleT = plan.eleT - beam.eleT
                   plan.eleM = plan.eleM - beam.eleM
                   baseT.storeW(I) = baseT.storeW(I) + 1
               WEND
            END IF
         END IF

         PRINT "Building torpedo systems"
         IF sc > 10 AND pc > 20 THEN
            FOR I = 1 TO baseT.techT
               IF baseT.storeT(I) < 10 THEN
                  LTorp I
                  WHILE baseT.storeT(I) < 10 AND plan.money > torpv.tubecost AND plan.eleM > torpv.eleM AND plan.eleD > torpv.eleD AND plan.eleT > torpv.eleT
                     plan.money = plan.money - torpv.tubecost
                     plan.eleD = plan.eleD - torpv.eleD
                     plan.eleT = plan.eleT - torpv.eleT
                     plan.eleM = plan.eleM - torpv.eleM
                     baseT.storeT(I) = baseT.storeT(I) + 1
                  WEND
               END IF
            NEXT I
         END IF
         IF baseT.techT >= 3 THEN
            I = 3
            IF baseT.storeT(I) < 10 THEN
               LTorp I
               WHILE baseT.storeT(I) < 10 AND plan.money > torpv.tubecost AND plan.eleM > torpv.eleM AND plan.eleD > torpv.eleD AND plan.eleT > torpv.eleT
                  plan.money = plan.money - torpv.tubecost
                  plan.eleD = plan.eleD - torpv.eleD
                  plan.eleT = plan.eleT - torpv.eleT
                  plan.eleM = plan.eleM - torpv.eleM
                  baseT.storeT(I) = baseT.storeT(I) + 1
               WEND
            END IF
         END IF

         WHILE baseT.defense < 200 AND plan.money > 2000
            baseT.defense = baseT.defense + 1
            plan.money = plan.money - 10
         WEND

         baseT.mission = 6
         SBase
         SPlanet
      END IF
   NEXT p
END SUB

