/***************************************************************************
vpc_play.h headers for vpc_play.c Miikka
***************************************************************************/

#define DEBUG
#define ERROR_TRAP
#define COMPUTER_CHEATS
#define DEBUG_MACRO        if(CLIP_INFO(5)) printf("file %s line %d \n",__FILE__,__LINE__)
#define DEBUG_MACRO2       if(CLIP_INFO(6)) printf("file %s line %d \n",__FILE__,__LINE__)
#define DEBUG_MACRO3       if(CLIP_INFO(7)) printf("file %s line %d \n",__FILE__,__LINE__)



// definitions here to make this easier
//explanations:

// alchemy first: make alchemy ships before anything at bases if tech=10
// base eggs:     use super transports as base eggs for many many bases

// militarist:  concentrates on making defence posts and warships
// scientist:   greater fraction of ships to explore
// economist:   greater fraction of ships to freighters

// aggressive:  more initial on ships less on defence posts
// defensive:   more initial on defence posts and base defences+fighters

// alchemy first and base eggs can be combined with any other strategy,
// mixing strategies attempts to combine parts, but reduces their effect,
// if the player concentrates on war it will be harder to concentrate on
// exploration or population expansion at the same time...

#define STRATEGY_ALCHEMY_FIRST       1
#define STRATEGY_BASE_EGGS           2

#define STRATEGY_SCIENTIST           4
#define STRATEGY_ECONOMIST           8
#define STRATEGY_MILITARIST         16

#define STRATEGY_AGGRESSIVE         32
#define STRATEGY_DEFENSIVE          64


//   '**** ABRAIN ****
#define ABRAIN_NONE    		0
#define ABRAIN_EXPLORED		1
#define ABRAIN_ATTACK		2
#define ABRAIN_DROP_SOME	3
#define ABRAIN_DROP_MANY	4
#define ABRAIN_MY_PLANET	5
#define ABRAIN_STARBASE		6
#define ABRAIN_BUILD_BASE       7
#define ABRAIN_PLEASE_SEND      8
#define ABRAIN_ENEMY            9

//  ship classes
#define EXPLORER 		1
#define EGG			2
#define DESTROYER		3
#define BATTLESHIP		4
#define REFINERY		5
#define MERLIN			6
#define FUEL_CARRIER		7
#define BIG_EGG                 8
//  ship missions

#define EXPLORE			1
#define MINE_SWEEP		2
#define LAY_MINES		3
#define KILL			4
#define SENSOR_SWEEP		5
#define COLONIZE		6
#define TOW			7
#define INTERCEPT		8
#define SPECIAL			9
#define CLOAK		       10

//race types
#define RACE_FED    1
#define RACE_LIZ    2
#define RACE_ROM    3
#define RACE_KLI    4
#define RACE_PRI    5
#define RACE_BOR    6
#define RACE_CRY    7
#define RACE_EMP    8
#define RACE_CYL    9
#define RACE_REB   10
#define RACE_COL   11

//informative level (unused right now)
#define INFO_NONE      0
#define INFO_HOST      1
#define INFO_GENERAL   2
#define INFO_DETAILED  3
#define INFO_DEBUG     4
#define CLIP_INFO( a )  ( informative >= (a))
#define INFO_CLIP( a )  CLIP_INFO( a )


#define CHEAT_STANDARD 0
#define CHEAT_LITTLE   1
#define CHEAT_MINIMUM  2
#define CHEAT_NONE     3
#define CLIP_CHEAT( a ) ( no_cheating <= (a))
#define CHEAT_CLIP( a ) CLIP_CHEAT( a )


#define FREEFILE       NULL
#define MAX( a , b )   ((a)>(b)?(a):(b))
#define MIN( a, b )    ((a)<(b)?(a):(b))
#define ABS( a )       ((a)>0?(a):(-(a)))
#define SQR( a )       sqrtl(a)
#define SWAP( a , b )  swapper(&(a),&(b))



#define SHIPTYPE_BYTES    sizeof(struct shiptype)
#define SHIPSHORT_BYTES   sizeof(struct shipshort)
#define HULLSPEC_BYTES    sizeof(struct hullspec)
#define ENGSPEC_BYTES     sizeof(struct engspec)
#define TORPSPEC_BYTES    sizeof(struct torpspec)
#define BEAMSPEC_BYTES    sizeof(struct beamspec)
#define PLANTYPE_BYTES    sizeof(struct plantype)
#define BASETYPE_BYTES    sizeof(struct basetype)
#define CONFIGTYPE_BYTES  sizeof(struct configtype)

//'Size of shipshort is 34 bytes
#ifdef UNUSED
typedef struct shipshort {
   int ID,pNum,warp,xShip,yShip,hull,heading;
   char nm[20];
} SHIPSHORT;
#endif

//'Size of shiptype is 107 bytes


//TYPE SHIPTYPE
typedef struct shiptype {
   int ID;//   ID AS INTEGER       'ID number of ship
   int pNum;//pNum AS INTEGER     'Player ID number
   char fCode[3];//fCode AS STRING * 3 'Friend ID code
   int warp;//warp AS INTEGER     'Warp factor
   int xWay;//xWay AS INTEGER     'DX to waypoint from X
   int yWay;//yWay AS INTEGER     'DY to waypoint from Y
   int xShip;//xShip AS INTEGER    'X cor.
   int yShip;//yShip AS INTEGER    'Y cor.
   int eng;//eng AS INTEGER      'engine type
   int hull;//hull AS INTEGER     'hull type
   int weapon;//weapon AS INTEGER   'weapon type
   int wbanks;//wbanks AS INTEGER   'number of weapon banks
   int bays;//bays AS INTEGER     'number of fighter bays
   //		       'if bays>0 then tube and tbanks are ignored
   //		       'a ship may have fighter or torpedoes
   //		       'NOT both
   int tube;//tube AS INTEGER     'torpedoe launcher type
   int torp;//torp AS INTEGER     'number of torpedoes/fighters
   int tbanks;//tbanks AS INTEGER   'number of torpedoe banks
   int mission;// AS INTEGER  'ship mission type
   int enemy;// AS INTEGER    'primary enemy ID number
   int tow;// AS INTEGER      'ID # of ship in tow
   int damage;// AS INTEGER   'amount of damage done to ship
   int crew;// AS INTEGER     'number of crew
   int col;// AS INTEGER      'number of colonists X 100
   char nm[20];// AS STRING * 20   'name of ship
   int eleN;// AS INTEGER     'Neutronium
   int eleT;// AS INTEGER     'Tritanium
   int eleD;// AS INTEGER     'Duranium
   int eleM;// AS INTEGER     'Molybdenum
   int eleS;// AS INTEGER     'supplies (Carbon Matrix)
   int unN;// AS INTEGER      'unload Neutronium
   int unT;// AS INTEGER      'unload Tritanium
   int unD;// AS INTEGER      'unload Duranium
   int unM;// AS INTEGER      'unload Molybdenum
   int unCol;// AS INTEGER    'unload Colonists
   int unS;// AS INTEGER      'unload Supplies
   int unplanet;// AS INTEGER 'unload on to planet target number
   int transN;// AS INTEGER   'transport Neutronium
   int transT;// AS INTEGER   'transport Tritanium
   int transD;// AS INTEGER   'transport Duranium
   int transM;// AS INTEGER   'transport Molybdenum
   int transC;// AS INTEGER   'transport Colonists
   int transS;// AS INTEGER   'transport Supplies
   int transtarget;// AS INTEGER 'transport target ship ID number
   int iTarget;// AS INTEGER  'intercept target ship ID number
   int cash;// AS INTEGER     'the amount of cash on board the ship
} SHIPTYPE; //} TYPE

//'size=60
typedef struct hullspec {//TYPE HULLSPEC
   char nm[30];// AS STRING * 30    'hull class name
   int bin;// ;//AS INTEGER       'the bin resource file slot image
   int doa;// ;//AS INTEGER       'the image of a heavily damaged ship
   int eleT;// ;//AS INTEGER      'amount of Tritanium needed to build
   int eleD;// ;//AS INTEGER      'amount of Duranium needed to build
   int eleM;// ;//AS INTEGER      'amount of Molybdenum needed to build
   int eleN;// ;//AS INTEGER      'maximun Neutronium that can be carried
   int crew;// ;//AS INTEGER      'maximum crew
   int engines;// ;//AS INTEGER   'number of engines required to build
   int mass ;//AS INTEGER      'mass of hull
   int tech ;//AS INTEGER      'tech level of ship
   int cargo ;//AS INTEGER     'maximum cargo (does not include neutronium)
   int bays ;//AS INTEGER      'maximum number of fighter bays
   int torp ;//AS INTEGER      'maximum number of torp tubes
   int weapon ;//AS INTEGER    'maximum number of beam weapons
   int cost ;//AS INTEGER     'cost to build
} HULLSPEC; //} TYPE

typedef struct engspec {//TYPE ENGSPEC
   char nm[20];// AS STRING * 20     'name of engine
   int cost ;//AS INTEGER       'cost to build one
   int eleT ;//AS INTEGER       'amount needed to build one
   int eleD ;//AS INTEGER       'amount needed to build one
   int eleM ;//AS INTEGER       'amount needed to build one
   int tech ;//AS INTEGER       'tech level needed to build one
   long eng[9];//ec(1 ; // 9) AS LONG    'energy cost to go all warp speeds per 10,000 mt
   //to get fuel consumption in KT's: exact_eta*eng[warp]*mass/100000
   //mass in kt's warp is warp speed, exact_eta is 1.235 etc turns.
   //exact_eta = exact distance divided by warp squared...
   //this does NOT amortize the fuel consumption, this is still primitive
		 //	 'energy cost is in mt's
} ENGSPEC;//} TYPE

typedef struct torpspec {//TYPE ; //RPSPEC
   char nm[20];// AS STRING * 20
   int cost ;//AS INTEGER     'cost of one torpedoe
   int tubecost ;//AS INTEGER 'cost of the launch tube
   int eleT ;//AS INTEGER     'needed to build tube
   int eleD ;//AS INTEGER     'needed to build tube
   int eleM ;//AS INTEGER     'needed to build tube
   int mass ;//AS INTEGER     'mass of the weapon bank
   int tech ;//AS INTEGER     'tech level
   int kill ;//AS INTEGER     'the life killing power of the weapon
   int smash ;//AS INTEGER    'the ablity to smash a ship to bits
       //		       'to build One torpedoe of any type
	 //	       'requires 1 eleN + 1 T.D.M
} TORPSPEC ; //RPSPEC;//} TYPE

typedef struct beamspec {//TYPE BEAMSPEC
   char nm[20];// AS STRING * 20
   int cost ;//AS INTEGER     'cost to build
   int eleT ;//AS INTEGER
   int eleD ;//AS INTEGER
   int eleM ;//AS INTEGER
   int mass ;//AS INTEGER     'mass of the weapon bank
   int tech ;//AS INTEGER     'tech level
   int kill ;//AS INTEGER     'the life killing power of the weapon
   int smash ;//AS INTEGER    'the ablity to smash a ship to bits
} BEAMSPEC;//} TYPE

//'Size of plantype is 85 bytes
typedef struct plantype {//TYPE plantype
   int pNum ;//AS INTEGER               'the player race of this planet
   int ID ;//AS INTEGER                 'the ID number of this planet
   char fCode[3];// AS STRING * 3           'the friendly code
   int mines ;//AS INTEGER              'number of mines on planet
   int factories ;//AS INTEGER          'number of factories on planet
   int SDI ;//AS INTEGER                'SDI factor (planetary defenses)
   long eleN;// AS LONG                  'KT's of Neutronium ready for use
   long eleT ;//AS LONG                  'KT's of Tritanium  ready for use
   long eleD ;//AS LONG                  'KT's of Duranium ready for use
   long eleM ;//AS LONG                  'KT's of Molybdenum ready for use
   long eleC ;//AS LONG                  'number of colony clans
   long eleS ;//AS LONG                  'KT's of supplies ready for use
   long money ;//AS LONG                 'the planets money reserves
   long resN ;//AS LONG                  'eleN contained within planet
   long resT ;//AS LONG                  'eleT contained within planet
   long resD ;//AS LONG                  'eleD contained within planet
   long resM ;//AS LONG                  'eleM contained within planet
   int easyN ;//AS INTEGER              '(0-100) odds of mining eleN
   int easyT ;//AS INTEGER              '(0-100) odds of mining eleT
   int easyD ;//AS INTEGER              '(0-100) odds of mining eleD
   int easyM ;//AS INTEGER              '(0-100) odds of mining eleM
   int taxC ;//AS INTEGER               'tax rate of colonists
   int taxN ;//AS INTEGER               'tax rate of natives
   int happynessC ;//AS INTEGER         'happyness of colonists
   int happynessN ;//AS INTEGER         'happyness of natives
   int SPI ;//AS INTEGER                'socio political index
   long native ;//AS LONG                'native population
   int species ;//AS INTEGER            'type of native population
   int climate ;//AS INTEGER            'weather conditions
   int bStarbase ;//AS INTEGER          'build a starbase!
} PLANTYPE;//} TYPE

//'size=156
typedef struct basetype {//TYPE BASETYPE
   int ID ;//AS INTEGER                    'same as planet ID #
   int pNum ;//AS INTEGER                  'race ID number of base
   int defense ;//AS INTEGER               'defense power
   int damage ;//AS INTEGER
   int techE ;//AS INTEGER                 'engine tech level
   int techH ;//AS INTEGER                 'hull tech level
   int techW ;//AS INTEGER                 'weapon tech level
   int techT ;//AS INTEGER                 'torpedoe tech level
   int storeE[9];//(1 ; // 9) ;//AS INTEGER        'count of engines in storeage
   int storeH[20];//(1 ; // 20) ;//AS INTEGER       'count of hulls in storeage
   int storeW[10];//(1 ; // 10) ;//AS INTEGER       'count of weapons in storeage
   int storeT[10];//(1 ; // 10) ;//AS INTEGER       'count of tubes in storeage
   int storeTorps[10];//(1 ; // 10) ;//AS INTEGER   'count of torps in storeage
   int storeF ;//AS INTEGER                'count of fighters in storeage
   int workonshipID ;//AS INTEGER          'id of ship to work on
   int workonshipAction ;//AS INTEGER      'action flag 1=fix 2=scrap
   int mission ;//AS INTEGER               'mission number
   int makeshipH ;//AS INTEGER             'make ship with this hull
   int makeshipE ;//AS INTEGER             'make ship with this engine
   int makeshipW ;//AS INTEGER             'make ship with this weapon
   int makeshipWc ;//AS INTEGER            '(this many of em weapons)
   int makeshipT ;//AS INTEGER             'make ship with this type launcher
   int makeshipTc ;//AS INTEGER            '(this many of em launchers)
   int makeshipFc ;//AS INTEGER            'make ship with this many fighters
} BASETYPE;//} TYPE

//'Version 3.2
typedef struct configtype { //TYPE CONFIGTYPE
   int recycle ;//AS INTEGER          '% of ore recovered from colonizing ships
   int meteor ;//AS INTEGER           '% odds of one large meteor impact
   int mine ;//AS INTEGER             'flag mine fields yes (1) or no (0)
   int Alchemy ;//AS INTEGER          'flag alchemy yes (1) or no (0)
   int delold ;//AS INTEGER           'flag delete old messages yes (1)
   int nopassword ;//AS INTEGER       'flag disable passwords yes (1)
   int gkill[11];//(11) ;//AS INTEGER        'ground combat kill ratios
   int opkill[11];//(11) ;//AS INTEGER       'ground combat defense factor
   int freefighter[11];//(11) ;//AS INTEGER  'number of free fighters
   int minerates[11];//(11)  ;//AS INTEGER   'mineral mining rates
   int taxrate[11];//(11) ;//AS INTEGER      'tax 50% to 500%
   int rebelbfs ;//AS INTEGER         'build fighters in space
   int coloniesbfs ;//AS INTEGER      'build fighters in space
   int robotbfs ;//AS INTEGER         'build fighters in space
   int cloakshipopps  ;//AS INTEGER   '0% - 50% cloak ship falure
   int robcloaked ;//AS INTEGER       'rob cloaked ships (yes/no)
   int shipscan ;//AS INTEGER         'ship scan range limit
   int darkrange ;//AS INTEGER        'range of dark sence
   int hiss ;//AS INTEGER             'hiss mission on and off
   int rebelga ;//AS INTEGER          'rebel ground attack on and off
   int fedsr ;//AS INTEGER            'super refit on and off
   int web ;//AS INTEGER              'web mines on and off
   int cloakburn ;//AS INTEGER        'cloaked ship fuel burn 1 to 50 kt
   int sensorrange ;//AS INTEGER      'range of the sensor mission
   int nativenew ;//AS INTEGER        'add new natives
   int planetattack ;//AS INTEGER     'planets attack ships (yes/no)
   int cyborga ;//AS INTEGER          'cyborg assimulation rate (1-100)
   int webdecay ;//AS INTEGER         'web mine decay rate
   int minedecay ;//AS INTEGER        'mine field decay rate
   int maxmine ;//AS INTEGER          'max mine field radius in lightyears
   int isotope ;//AS INTEGER          'new mineral form rate
   int decay ;//AS INTEGER            'decay of structures on underpop planet
   int overpop ;//AS INTEGER          'eat supplies? (yes/no)
   int nofuelmove ;//AS INTEGER       'ships without fuel can move (yes/no)
   int oddsmine ;//AS INTEGER         'odds of hitting a mine
   int oddsweb ;//AS INTEGER          'odds of hitting a web mine
   int mineseerange ;//AS INTEGER     'range that you can see mines
   int antimine ;//AS INTEGER         'mines distroy enemy mines
   int shieldbonus ;//AS INTEGER      'engine shield bonus shield
   int sbrate ;//AS INTEGER           'engine shield bonus % rate
   int cfsweeprate ;//AS INTEGER      'colonies fighter sweep rate
   int cfsweepweb ;//AS INTEGER       'colonies fighter sweep web mines (yes/no)
   int minesweeprate ;//AS INTEGER    'rate that weapons sweep mines
   int websweeprate ;//AS INTEGER     'rate that weapons sweep web mines
   int lizardmaxhiss ;//AS INTEGER    'the max that a hiss mission can effect planet
   int robfailrate ;//AS INTEGER      'the odds that the rob mission will fail
   int rebelnoatt ;//AS INTEGER       'planets can attack rebels (yes/no)
   int fascistnoatt ;//AS INTEGER     'planets can attack fascists (yes/no)
   int minesweeprange ;//AS INTEGER   'the range that a mine field can be sweeped
   int websweeprange ;//AS INTEGER    'the range that a web field can be sweeped
   int sciencemissions ;//AS INTEGER  'ship science missions
   int cloakedmineodds ;//AS INTEGER  'the odds that a cloaked ship will hit a mine
   int nocloakdamage ;//AS INTEGER    'the amount of damage that prevents cloaking
   int fedcrewbonus ;//AS INTEGER     'fed ships get a combat bonus (yes/no)

   int oddssm ;//AS INTEGER           'odds of small meteor impacts
   long smminN ;//AS LONG              'minimum Neutronium in meteor
   long smminD ;//AS LONG
   long smminT ;//AS LONG
   long smminM ;//AS LONG
   long smmaxN ;//AS LONG              'maximum Neutronium in meteor
   long smmaxD ;//AS LONG
   long smmaxT ;//AS LONG
   long smmaxM ;//AS LONG

   int numlg ;//AS INTEGER            'number of large meteors to impact
   long lgminN ;//AS LONG              'minimum Neutronium in meteor
   long lgminD ;//AS LONG
   long lgminT ;//AS LONG
   long lgminM ;//AS LONG
   long lgmaxN ;//AS LONG              'maximum Neutronium in meteor
   long lgmaxD ;//AS LONG
   long lgmaxT ;//AS LONG
   long lgmaxM ;//AS LONG
   int meteormess ;//AS INTEGER      'send meteor messages?
   int onetow ;//AS INTEGER          'a ship with one engine can tow another
   int hyper ;//AS INTEGER           'hyper space jumps
   int cdeathrate ;//AS INTEGER      'colonist death rate
   int gwell ;//AS INTEGER           'grivity wells
   int crysclim ;//AS INTEGER        'crystals immune to bad climates
   int nweb ;//AS INTEGER            'normal mines destroy web mines
   int clpop ;//AS INTEGER           'climate limits population
   long maxincome ;//AS LONG          'max income that the planet can make per turn
   int ionstorm ;//AS INTEGER        '0%-100% The activity rating of Ion storms
   int chunnel ;//AS INTEGER         'warp chunnel
   int spiboost ;//AS INTEGER        'super spi bonus
   int ionminehide ;//AS INTEGER     'ion storms hide mines
   int glory ;//AS INTEGER           'klingon glory device (D19, Saber)
   int loki ;//AS INTEGER            'loki anti-cloaking
   int lady ;//AS INTEGER            'laby royal gambing
   int cloakattack ;//AS INTEGER     'cloaked ships can attack
   int clone ;//AS INTEGER           'ships can be cloned
   int boarding ;//AS INTEGER        'crystals and privateers can capture with tow
   int imperialAssult ;//AS INTEGER  'super star destroyer can take planets with 10 clans
} CONFIGTYPE;//} TYPE

//new fangled headers of Miikka's functions
void init_fleet_missions(void);
int is_armed(SHIPTYPE *me);
int has_cloaking_device(SHIPTYPE *me);
int can_cloak(SHIPTYPE *me);
int waypoint_eta(SHIPTYPE *me);
int convex_hull_analysis(int am_i_inside_ID);
void BuildNewShipsAllBases(void);

int plan_afford_tube(TORPSPEC *tube, PLANTYPE *plan, int urgent, int many);
int plan_afford_beam(BEAMSPEC *beam, PLANTYPE *plan, int urgent, int many);
int plan_afford_eng(ENGSPEC *eng, PLANTYPE *plan, int urgent, int many);
int plan_afford_hull(HULLSPEC *hullv, PLANTYPE *plan, int urgent, int many);

int raw_build_hull(BASETYPE *baseT, PLANTYPE *plan, HULLSPEC *hull, int fgship);
int raw_build_beam(BASETYPE *baseT, PLANTYPE *plan, BEAMSPEC *beam, int fgship);
int raw_build_tube(BASETYPE *baseT, PLANTYPE *plan, TORPSPEC *tube, int fgship);
int raw_build_eng(BASETYPE *baseT, PLANTYPE *plan, ENGSPEC *eng, int fgship);

int try_to_complete_parts(HULLSPEC *hull, BASETYPE *baseT, PLANTYPE *plan, int hullnum);
void compute_dominion(void);
void compute_best_path(void);
int LoadMeUpBaby(SHIPTYPE *me, int fgBase);
int GOHOME(SHIPTYPE *me, int warship_flag);
void GOWAR(SHIPTYPE *me, int type);
void Intercept(void);
void Retreive(void);
void Capture(void);
int get_orbit_planet(SHIPTYPE *me);
int get_orbit_hull(PLANTYPE *ball, int wanted_hull);
int has_a_defender(int plan_ID);
int can_i_make_it(SHIPTYPE *me);
int get_plan_highest_metal(PLANTYPE *plan);
int get_plan_lowest_metal(PLANTYPE *plan);
int am_i_in_a_friendly_minefield( int shipnum );
int am_i_in_an_enemy_minefield( int shipnum );
int am_i_in_minefield_x( int shipnum, int minefield );
void do_mine_sweeping(SHIPTYPE *me);
void do_mine_laying(SHIPTYPE *me);
void find_war_destiny(SHIPTYPE *me, int type_of_destiny);
int should_i_lay_mines(SHIPTYPE *me);
int should_i_mine_sweep(SHIPTYPE *me);
int are_you_worthy_of_me(SHIPTYPE *local_me, SHIPTYPE *local_you);
int am_i_a_match_for_you(SHIPTYPE *local_me, SHIPTYPE *local_you);
int am_i_low_on_torps(SHIPTYPE *me);
int am_i_loaded_with_torps(SHIPTYPE *me);
int am_i_ok_on_torps(SHIPTYPE *me);
int has_gravitronic_accelerator(SHIPTYPE *me);
int has_hyperwarp(SHIPTYPE *me);
int is_planet_in_a_friendly_minefield( int plannum );
int is_planet_in_an_enemy_minefield( int plannum );
int is_planet_in_minefield_x( int plannum, int minefield );
int am_i_at_friendly_base(int shipnum);
void Specials(void);
void some_ship_common_sense(SHIPTYPE *me);
int is_ship_obsolete(SHIPTYPE *me);
//these are race micro cheats
int am_i_a_spider_weaver(SHIPTYPE *me);
int am_i_robot_cats_paw(SHIPTYPE *me);
int am_i_lizard_cruiser(SHIPTYPE *me);
int am_i_fighter_pod(SHIPTYPE *me);
int am_i_battlestar(SHIPTYPE *me);
int am_i_borg_cube(SHIPTYPE *me);
int beam_minerals_home(SHIPTYPE *me); //goes with borg micro cheat
void clear_globals(void);
void default_fig(void);
int has_glory_device(SHIPTYPE *me);
int is_science_ship(SHIPTYPE *me);
int has_anti_cloak(SHIPTYPE *me);
int is_pleasure_ship(SHIPTYPE *me);
int compute_class_ship( SHIPTYPE *me );
int compute_class_hull( int hull );


//forgotten original headers
void SaveHostData(void);
//original headers
void LBase(BASETYPE *baseT, int baseslot);
void LBeam(BEAMSPEC *beam, int beamslot);
void LEng(ENGSPEC *engv, int engslot);
void LHull(HULLSPEC *hull, int hullslot);
void LoadHostData(void);
void LPlanet(PLANTYPE *ball, int planslot);
int LShip(SHIPTYPE *load_me, int junker);
void LTorp(TORPSPEC *torpv, int torpslot);
void PutError(char *g);
void PutMessage(int rc, char *gg);
void SaveHostData();
void SBase(BASETYPE *baseT, int baseslot);
void ShipXYR(void);
void SPlanet(PLANTYPE *ball, int planslot);
void SShip(SHIPTYPE *save_me, int shipslot);
void StoreNewMess (int rc, char *m);
void LoadBrain (void);
void PlanetEcon (void);
void SaveBrain (void);
void PlanetCheck (void);
void MoveMinerals (void);
//int BuildNewShips (void);
void BuildNewShips(BASETYPE *baseT,PLANTYPE *plan);
void SortClassList (void);
int BuildShip (BASETYPE *baseT, PLANTYPE *plan, int fgship, HULLSPEC *hull);
void WorkOnSBase (void);
void BuildNewStarbase (void);
void Alchemy (void);
void Explore (void);
void LoadFuel (SHIPTYPE *i_am, int dork);
int PCheck (PLANTYPE *plan);
void Eggs (void);
void WarShips (void);
void Dumpmess (void);
void Refuel (void);
char *RNDNAME (SHIPTYPE *me);
char *PLANETNAME (int n);
char *RACENAME (int n, int fg);
int RAND (int a, int b);
int CargoR (SHIPTYPE *me);
int FuelR (SHIPTYPE *me);
int CheckTimeStamp (void);
int find_nearest_planets(SHIPTYPE *me_too, int nearM[6], long nearD[6], int mission_mode);


// Miikka's additions
extern const int shipcloak[11][20];
extern int cloaklist[105];//(105)
//extern const char hullname[11][20][20];
extern int dominion[500];//update each turn, 1=in dominion, 0=outside
extern int factories[500]; //intelligence reports (unknown accuracy)
extern long colonists[500]; //must update for each race of course
extern long natives[500];  //for now they are accurate later will have
extern long money[500];  //fuzzy factor, empire will have exact knowledge
extern int mines[500];   //of planets they have dark sensed etc...
extern int defenses[500];

extern int informative;
extern int no_cheating;
extern int is_hidden;    //number of turns visible UNUSED
extern int emergency; //0=safe 100=im going to die UNUSED
extern int greatest_x;
extern int least_x;
extern int greatest_y;
extern int least_y;
extern int convex_trial;
extern int strategy_option;
extern int intercept_called;
extern int pcount;
extern int epcount;
extern int sbcount;
extern int dominion_unexplored_count;
extern int total_dominion;
extern int no_politics_disasters;
extern int in_a_minefield[500];
extern int planet_in_a_minefield[500];
extern int scouts;
extern int eggs;
extern int destroyers;
extern int battleships;
extern int refineries;
extern int merlins;
extern int fuel_carriers;
extern int big_eggs;
extern int specials;
extern float fuzzy_scouts;
extern float fuzzy_eggs;
extern float fuzzy_warships;
extern int ships_counted;
extern long total_eleN_consumption;
extern long total_eleS_consumption;
extern long total_eleT_consumption;
extern long total_eleD_consumption;
extern long total_eleM_consumption;
extern long total_cash_consumption;
extern long total_eleC_consumption;
extern long total_eleN_production;
extern long total_eleS_production;
extern long total_eleT_production;
extern long total_eleD_production;
extern long total_eleM_production;
extern long total_cash_production;
extern long total_eleC_production;
extern const char speciesname[10][20];
extern const char shipname[75][18];
//here are the special race specific mini cheats
extern int cheat_with_colonies;
extern int cheat_with_borg;
extern int cheat_with_empire;
extern int cheat_with_robots;
extern int cheat_with_privateers;
extern int cheat_with_rebels;
extern int cheat_with_feds;
extern int cheat_with_lizards;
extern int cheat_with_romulans;
extern int cheat_with_klingons;
extern int cheat_with_crystal;
extern const float shipfuzzyclass[11][20][3];//fuzzy logic version class
extern float fuzzyclasslist[105][3];


//these are most of the original globals
extern int race ;//AS INTEGER
extern CONFIGTYPE fig;// AS CONFIGTYPE
extern char path[];//AS STRING
//long regkey[] ;//AS LONG
extern char regname[];// AS STRING * 25
extern char regad[];// AS STRING * 25
extern int lowtech;//AS INTEGER
extern int classlist[105];//(105) ;//AS INTEGER
extern const int shipclass[11][20];

extern int pbrain[500];//(500) ;//AS INTEGER
extern int abrain[500];//(500) ;//AS INTEGER
extern int ebrain[11];//(11) ;//AS INTEGER
extern int playrace[11];//(11) ;//AS INTEGER
extern int truehull[11][20];//(20, 11) ;//AS INTEGER
extern int mapx[500];//(500) ;//AS INTEGER
extern int mapy[500];//(500) ;//AS INTEGER
extern int mapr[500];//(500) ;//AS INTEGER
extern int mapm[500];//(500) ;//AS INTEGER
extern int mapc[500];//(500) ;//AS INTEGER
extern int xPlanet[500];//(500) ;//AS INTEGER
extern int yPlanet[500];//(500) ;//AS INTEGER
extern int rPlanet[500];//(500) ;//AS INTEGER
extern int rBase[500];//(500) ;//AS INTEGER
extern int ingame[11];//(11) ;//AS INTEGER
extern int plrace[11];//(11) ;//AS INTEGER
extern int cprace[11];//(11) ;//AS INTEGER
extern int frrace[11];//(11) ;//AS INTEGER
extern int bsrace[11];//(11) ;//AS INTEGER
extern int dumpoldm[11];//(11) ;//AS INTEGER
extern int xmine[500];//(500) ;//AS INTEGER
extern int ymine[500];//(500) ;//AS INTEGER
extern long zmine[500];//(500) ;//AS LONG
extern int rmine[500];//(500) ;//AS INTEGER
extern int wmine[500];//(500) ;//AS INTEGER
