#include "crysball.hpp"
#include "cbvgap.h"

void nicestru(char *destination, int taso, int nyky, long klaani)
{
	long	maksimi;

	maksimi = 0L;
	switch(taso) {
		case 1:	if(klaani <= 200L) maksimi = klaani;
				else maksimi = 200L + long(sqrt(double(klaani - 200L)));
        		break;
		case 2:	if(klaani <= 100L) maksimi = klaani;
				else maksimi = 100L + long(sqrt(double(klaani - 100L)));
        		break;
		case 3: if(klaani <= 50L) maksimi = klaani;
				else maksimi = 50L + long(sqrt(double(klaani - 50L)));
        		break;
	}
	if(nyky >= 0) wsprintf(destination, "%d (%ld)", nyky, maksimi);
	else wsprintf(destination, "? (?)");
}

void niceint(char *destination, char *format, int luku)
{
	if(luku >= 0) wsprintf(destination, format, luku);
	else wsprintf(destination, "?");
}

void nicelong(char *destination, char *format, long luku)
{
	if(luku >= 0L) wsprintf(destination, format, luku);
	else wsprintf(destination, "?");
}

void nicefeel(char *destination, int fiilis, long maara)
{
	char	szFeel[30];

    if(maara > 0L) {
		strcpy(szFeel, "Fighting (%d)");
		if(fiilis > 19) strcpy(szFeel, "Rioting (%d)");
		if(fiilis > 39) strcpy(szFeel, "Very angry (%d)");
		if(fiilis > 49) strcpy(szFeel, "Unhappy (%d)");
		if(fiilis > 69) strcpy(szFeel, "Calm (%d)");
		if(fiilis > 89) strcpy(szFeel, "Happy (%d)");
		wsprintf(destination, szFeel, fiilis);
	} else wsprintf(destination, "");
}

void nicetax(char *destination, int prose, int gover, long maara, long maxi)
{
	long	rahat, gprose;

	if(maara > 0L) {
		switch(gover) {
			case 0: gprose =   0L; break;
			case 1: gprose =  20L; break;
			case 2: gprose =  40L; break;
			case 3: gprose =  60L; break;
			case 4: gprose =  80L; break;
			case 5: gprose = 100L; break;
			case 6: gprose = 120L; break;
			case 7: gprose = 140L; break;
			case 8: gprose = 160L; break;
			case 9: gprose = 180L; break;
		}
		rahat = long((long(prose) * gprose * maara) / 100000L);
        if(rahat > maxi) rahat = maxi;
		wsprintf(destination, "%d%% (%ld)", prose, rahat);
	} else wsprintf(destination, "");
}

TRaceDlg::TRaceDlg(PTWindowsObject AParent, LPSTR AResource, LPSTR ATitle)
		:TDialog(AParent, AResource)
{
	SetCaption(ATitle);
	RaceLst = new TListBox(this, RACELIST);
}

void TRaceDlg::Ok(RTMessage Msg)
{
	TDialog::Ok(Msg);

	int i;

	i = RaceLst->GetSelIndex();
	if(i>-1) ((TSpaceWindow *)Parent)->Siirto = i;
}

void TRaceDlg::SetupWindow()
{
	TDialog::SetupWindow();

	int i;
	char szBuff[80], szRaceNM[50];

	for(i=0; i< 12; i++) {
		racenmAdjective(i, szRaceNM, sizeof(szRaceNM));
		if(i < 10) wsprintf(szBuff, " %2d  ...  %s", i, szRaceNM);
		else wsprintf(szBuff, "%2d  ...  %s", i, szRaceNM);
		RaceLst->AddString(szBuff);
	}
	RaceLst->SetSelIndex(((TSpaceWindow *)Parent)->Siirto);
}

void TRaceDlg::HandleLBNs(RTMessage Msg)
{
	if(Msg.LP.Hi == LBN_DBLCLK) WMRInfo(Msg);
}


void TRaceDlg::WMRInfo(RTMessage)
{
	int i;
	char szProp[160], szHelper[130];

	GetPrivateProfileString("Files", "CB.Directory", ".\\", szHelper, 128, "crysball.ini");
	ConstructPath(szProp, szHelper, "raceprop", "dbv");

	vprprop	tieto(szProp);

	i = RaceLst->GetSelIndex();
	if(i>0) {
		tieto.read(i);
		racenmLongName(i, Rotu.szNa, sizeof(Rotu.szNa));
		wsprintf(Rotu.szSc, "%5d", scoreTotal(i));
		wsprintf(Rotu.szBa, "%3d", scoreBase(i));
		wsprintf(Rotu.szPl, "%3d", scorePlanet(i));
		wsprintf(Rotu.szWS, "%3d", scoreWarShip(i));
		wsprintf(Rotu.szCS, "%3d", scoreCargoShip(i));
		wsprintf(Rotu.szIn[0], "%s", tieto.Line(1));
		wsprintf(Rotu.szIn[1], "%s", tieto.Line(2));
		wsprintf(Rotu.szIn[2], "%s", tieto.Line(3));
		wsprintf(Rotu.szIn[3], "%s", tieto.Line(4));
		if(GetModule()->ExecDialog(new TRaceInfoDlg(this, LPSTR MAKEINTRESOURCE(ShowRInfo))) == IDOK);
	}

}

TRaceInfoDlg::TRaceInfoDlg(PTWindowsObject AParent, LPSTR AResource)
		:TDialog(AParent, AResource)
{
	new	TEdit(this, RacName, 31);
	new	TEdit(this, RacScore, 6);
	new	TEdit(this, RacBases, 4);
	new	TEdit(this, RacPlanets, 4);
	new	TEdit(this, RacWShips, 4);
	new	TEdit(this, RacCShips, 4);
	new	TEdit(this, RacInfo1, 40);
	new	TEdit(this, RacInfo2, 40);
	new	TEdit(this, RacInfo3, 40);
	new	TEdit(this, RacInfo4, 40);

	TransferBuffer = (void far *) &((TRaceDlg *)Parent)->Rotu;
}

TPassWordDlg::TPassWordDlg(PTWindowsObject AParent, LPSTR AResource)
		:TDialog(AParent, AResource)
{
	new	TEdit(this, ID_PASSWD, 11);

	TransferBuffer = (void far *) &((TSpaceWindow *)Parent)->szPass;
}

TRScoreDlg::TRScoreDlg(PTWindowsObject AParent, LPSTR AResource)
		:TDialog(AParent, AResource)
{
	new	TEdit(this, Rac01Name, 31);
	new	TEdit(this, Rac02Name, 31);
	new	TEdit(this, Rac03Name, 31);
	new	TEdit(this, Rac04Name, 31);
	new	TEdit(this, Rac05Name, 31);
	new	TEdit(this, Rac06Name, 31);
	new	TEdit(this, Rac07Name, 31);
	new	TEdit(this, Rac08Name, 31);
	new	TEdit(this, Rac09Name, 31);
	new	TEdit(this, Rac10Name, 31);
	new	TEdit(this, Rac11Name, 31);
	new	TEdit(this, Rac01Score, 7);
	new	TEdit(this, Rac02Score, 7);
	new	TEdit(this, Rac03Score, 7);
	new	TEdit(this, Rac04Score, 7);
	new	TEdit(this, Rac05Score, 7);
	new	TEdit(this, Rac06Score, 7);
	new	TEdit(this, Rac07Score, 7);
	new	TEdit(this, Rac08Score, 7);
	new	TEdit(this, Rac09Score, 7);
	new	TEdit(this, Rac10Score, 7);
	new	TEdit(this, Rac11Score, 7);
	new	TEdit(this, Rac01Base, 4);
	new	TEdit(this, Rac02Base, 4);
	new	TEdit(this, Rac03Base, 4);
	new	TEdit(this, Rac04Base, 4);
	new	TEdit(this, Rac05Base, 4);
	new	TEdit(this, Rac06Base, 4);
	new	TEdit(this, Rac07Base, 4);
	new	TEdit(this, Rac08Base, 4);
	new	TEdit(this, Rac09Base, 4);
	new	TEdit(this, Rac10Base, 4);
	new	TEdit(this, Rac11Base, 4);
	new	TEdit(this, Rac01Planet, 4);
	new	TEdit(this, Rac02Planet, 4);
	new	TEdit(this, Rac03Planet, 4);
	new	TEdit(this, Rac04Planet, 4);
	new	TEdit(this, Rac05Planet, 4);
	new	TEdit(this, Rac06Planet, 4);
	new	TEdit(this, Rac07Planet, 4);
	new	TEdit(this, Rac08Planet, 4);
	new	TEdit(this, Rac09Planet, 4);
	new	TEdit(this, Rac10Planet, 4);
	new	TEdit(this, Rac11Planet, 4);
	new	TEdit(this, Rac01WShip, 4);
	new	TEdit(this, Rac02WShip, 4);
	new	TEdit(this, Rac03WShip, 4);
	new	TEdit(this, Rac04WShip, 4);
	new	TEdit(this, Rac05WShip, 4);
	new	TEdit(this, Rac06WShip, 4);
	new	TEdit(this, Rac07WShip, 4);
	new	TEdit(this, Rac08WShip, 4);
	new	TEdit(this, Rac09WShip, 4);
	new	TEdit(this, Rac10WShip, 4);
	new	TEdit(this, Rac11WShip, 4);
	new	TEdit(this, Rac01CShip, 4);
	new	TEdit(this, Rac02CShip, 4);
	new	TEdit(this, Rac03CShip, 4);
	new	TEdit(this, Rac04CShip, 4);
	new	TEdit(this, Rac05CShip, 4);
	new	TEdit(this, Rac06CShip, 4);
	new	TEdit(this, Rac07CShip, 4);
	new	TEdit(this, Rac08CShip, 4);
	new	TEdit(this, Rac09CShip, 4);
	new	TEdit(this, Rac10CShip, 4);
	new	TEdit(this, Rac11CShip, 4);

	TransferBuffer = (void far *) &((TMainWindow *)Parent)->Pisteet;
}

TMFieldListDlg::TMFieldListDlg(PTWindowsObject AParent, LPSTR AResource)
		:TDialog(AParent, AResource)
{
	MFieldLst = new TListBox(this, MFIELDLIST);
}

void TMFieldListDlg::SetupWindow()
{
	TDialog::SetupWindow();

	int i;
    char szBuff[80], szRaceNM[50];

	for(i=0; i<((TSpaceWindow *)Parent)->mfieldKpl; i++) {
		racenmAdjective(((TSpaceWindow *)Parent)->mfield[i].owner, szRaceNM, sizeof(szRaceNM));
		wsprintf(szBuff, "#%d (%4d, %4d) %ld %s mines", ((TSpaceWindow *)Parent)->mfield[i].id, ((TSpaceWindow *)Parent)->mfield[i].x, ((TSpaceWindow *)Parent)->mfield[i].y, ((TSpaceWindow *)Parent)->mfield[i].units, szRaceNM);
		MFieldLst->AddString(szBuff);
	}
	MFieldLst->SetSelIndex(0);
}

void TMFieldListDlg::WMAddMField(RTMessage)
{
	char szBuff[80], szRaceNM[50];
	int i, v;

	wsprintf(Kentat.szO, "%2d", ((TSpaceWindow *)Parent)->Player);
	wsprintf(Kentat.szI, "0", ((TSpaceWindow *)Parent)->mfieldKpl+1);
	wsprintf(Kentat.szX, "2000");
	wsprintf(Kentat.szY, "2000");
	wsprintf(Kentat.szU, "0");

	if(((TSpaceWindow *)Parent)->mfieldKpl<100) {
		if(GetModule()->ExecDialog(new TMFieldEditDlg(this, LPSTR MAKEINTRESOURCE(EditMField))) == IDOK)
		{
			if(atol(Kentat.szU) > 0)
	        {
				i = ((TSpaceWindow *)Parent)->mfieldKpl;
				v = atoi(Kentat.szO);
            	if(v < 1 || v > 11) v = 0;
				((TSpaceWindow *)Parent)->mfield[i].owner = v;
				((TSpaceWindow *)Parent)->mfield[i].id = atoi(Kentat.szI);
				((TSpaceWindow *)Parent)->mfield[i].x = atoi(Kentat.szX);
				((TSpaceWindow *)Parent)->mfield[i].y = atoi(Kentat.szY);
				((TSpaceWindow *)Parent)->mfield[i].units = atol(Kentat.szU);
				racenmAdjective(((TSpaceWindow *)Parent)->mfield[i].owner, szRaceNM, sizeof(szRaceNM));
				wsprintf(szBuff, "#%d (%4d, %4d) %ld %s mines", ((TSpaceWindow *)Parent)->mfield[i].id, ((TSpaceWindow *)Parent)->mfield[i].x, ((TSpaceWindow *)Parent)->mfield[i].y, ((TSpaceWindow *)Parent)->mfield[i].units, szRaceNM);
				MFieldLst->AddString(szBuff);
				((TSpaceWindow *)Parent)->mfieldKpl = i + 1;
				((TSpaceWindow *)Parent)->mfieldModified = TRUE;
			}
		}
	}
}

void TMFieldListDlg::HandleLBNs(RTMessage Msg)
{
	if(Msg.LP.Hi == LBN_DBLCLK) WMModMField(Msg);
}

void TMFieldListDlg::WMModMField(RTMessage)
{
	char szBuff[80], szRaceNM[50];
	int i, v;

	i = MFieldLst->GetSelIndex();

    if(i>-1) {
		wsprintf(Kentat.szO, "%2d", ((TSpaceWindow *)Parent)->mfield[i].owner);
		wsprintf(Kentat.szI, "%3d", ((TSpaceWindow *)Parent)->mfield[i].id);
		wsprintf(Kentat.szX, "%4d", ((TSpaceWindow *)Parent)->mfield[i].x);
		wsprintf(Kentat.szY, "%4d", ((TSpaceWindow *)Parent)->mfield[i].y);
		wsprintf(Kentat.szU, "%6ld", ((TSpaceWindow *)Parent)->mfield[i].units);

		if(GetModule()->ExecDialog(new TMFieldEditDlg(this, LPSTR MAKEINTRESOURCE(EditMField))) == IDOK)
		{
			v = atoi(Kentat.szO);
            if(v < 1 || v > 11) v = 0;
			((TSpaceWindow *)Parent)->mfield[i].owner = v;
			((TSpaceWindow *)Parent)->mfield[i].id = atoi(Kentat.szI);
			((TSpaceWindow *)Parent)->mfield[i].x = atoi(Kentat.szX);
			((TSpaceWindow *)Parent)->mfield[i].y = atoi(Kentat.szY);
			((TSpaceWindow *)Parent)->mfield[i].units = atol(Kentat.szU);

			MFieldLst->DeleteString(i);
			racenmAdjective(((TSpaceWindow *)Parent)->mfield[i].owner, szRaceNM, sizeof(szRaceNM));
			wsprintf(szBuff, "#%d (%4d, %4d) %ld %s mines", ((TSpaceWindow *)Parent)->mfield[i].id, ((TSpaceWindow *)Parent)->mfield[i].x, ((TSpaceWindow *)Parent)->mfield[i].y, ((TSpaceWindow *)Parent)->mfield[i].units, szRaceNM);
			MFieldLst->InsertString(szBuff, i);
			((TSpaceWindow *)Parent)->mfieldModified = TRUE;
		}
	} else MessageBeep(0);
}

void TMFieldListDlg::WMDelMField(RTMessage)
{
	char szBuff[80], szRaceNM[50];
	int i, j, k;

	j = ((TSpaceWindow *)Parent)->mfieldKpl;
	i = MFieldLst->GetSelIndex();
	if(i>-1) {
		racenmAdjective(((TSpaceWindow *)Parent)->mfield[i].owner, szRaceNM, sizeof(szRaceNM));
		wsprintf(szBuff, "#%d (%4d, %4d) %ld %s mines", ((TSpaceWindow *)Parent)->mfield[i].id, ((TSpaceWindow *)Parent)->mfield[i].x, ((TSpaceWindow *)Parent)->mfield[i].y, ((TSpaceWindow *)Parent)->mfield[i].units, szRaceNM);
		for(k = i; k<(j-1); k++)
		{
			((TSpaceWindow *)Parent)->mfield[k].owner = ((TSpaceWindow *)Parent)->mfield[k+1].owner;
			((TSpaceWindow *)Parent)->mfield[k].id = ((TSpaceWindow *)Parent)->mfield[k+1].id;
			((TSpaceWindow *)Parent)->mfield[k].x = ((TSpaceWindow *)Parent)->mfield[k+1].x;
			((TSpaceWindow *)Parent)->mfield[k].y = ((TSpaceWindow *)Parent)->mfield[k+1].y;
			((TSpaceWindow *)Parent)->mfield[k].units = ((TSpaceWindow *)Parent)->mfield[k+1].units;
		}
		MFieldLst->DeleteString(i);
		((TSpaceWindow *)Parent)->mfieldKpl = j - 1;
		((TSpaceWindow *)Parent)->mfieldModified = TRUE;
	} else MessageBeep(0);
}

TMFieldEditDlg::TMFieldEditDlg(PTWindowsObject AParent, LPSTR AResource)
		:TDialog(AParent, AResource)
{
	new TEdit(this, EditMFieldOwner, 3);
	new TEdit(this, EditMFieldId, 4);
	new TEdit(this, EditMFieldX, 5);
	new TEdit(this, EditMFieldY, 5);
	new TEdit(this, EditMFieldU, 7);

    TransferBuffer = (void far *) &((TMFieldListDlg *)Parent)->Kentat;
}

void TMFieldEditDlg::SetupWindow()
{
	TDialog::SetupWindow();
}

TInfoListDlg::TInfoListDlg(PTWindowsObject AParent, LPSTR AResource)
		:TDialog(AParent, AResource)
{
	InfoLst = new TListBox(this, INFOLIST);
}

void TInfoListDlg::DetailPlanet(int Index)
{
	char		szNat[50], szGov[50];
	long		positio;
    int			sbas;

	fstream		dbv;
	planetfile	ptietue;
	header		fheader;

	dbv.open("planet.dbv", ios::binary | ios::in | ios::out | ios::ate);
    if(dbv) {
		dbv.seekg(0L);
		dbv.read((char *) &fheader, sizeof(fheader));
		positio = sizeof(fheader) + (long(Index) * long(sizeof(ptietue)));
		dbv.seekg(positio);
		dbv.read((char *) &ptietue, sizeof(ptietue));

		strcpy(szNat, "No natives");
		strcpy(szGov, "");
		switch(ptietue.native_race) {
        	case 1: strcpy(szNat, "Humanoid [hull 10]"); break;
			case 2: strcpy(szNat, "Bovinoid [supply]"); break;
			case 3: strcpy(szNat, "Reptian [mining x2]"); break;
			case 4: strcpy(szNat, "Avian [overtax]"); break;
			case 5: strcpy(szNat, "Amorphous [killers]"); break;
			case 6: strcpy(szNat, "Insectoid [credit x2]"); break;
			case 7: strcpy(szNat, "Amphibian [beam 10]"); break;
			case 8: strcpy(szNat, "Ghipsodal [engine 10]"); break;
			case 9: strcpy(szNat, "Siliconoid [torpedo 10]"); break;
		}
		switch(ptietue.native_gov) {
			case 0: strcpy(szGov,"None [0%]"); break;
			case 1: strcpy(szGov,"Anarchy [20%]"); break;
			case 2: strcpy(szGov,"Pre-Tribal [40%]"); break;
			case 3: strcpy(szGov,"Early-Tribal [60%]"); break;
			case 4: strcpy(szGov,"Tribal [80%]"); break;
			case 5: strcpy(szGov,"Feudal [100%]"); break;
			case 6: strcpy(szGov,"Monarchy [120%]"); break;
			case 7: strcpy(szGov,"Representative [140%]"); break;
			case 8: strcpy(szGov,"Participatory [160%]"); break;
			case 9: strcpy(szGov,"Unity [180%]"); break;
		}
		niceint(Planu.szTu, "%3d", ptietue.turn);
		niceint(Planu.szId, "%4d", ptietue.id);
		wsprintf(Planu.szNa, "%s", ptietue.name);
		niceint(Planu.szOw, "%2d", ptietue.owner);
		wsprintf(Planu.szFC, "[%s]", ptietue.fcode);
		nicelong(Planu.szCl, "%3ld C", ptietue.temperature);
		nicestru(Planu.szMi, 1, ptietue.mines, ptietue.colonist);
		nicestru(Planu.szFa, 2, ptietue.factories, ptietue.colonist);
		nicestru(Planu.szDe, 3, ptietue.defences, ptietue.colonist);
		nicelong(Planu.szCo, "%7ld", ptietue.colonist);
		nicetax(Planu.szCT, ptietue.tax_col, 5, ptietue.colonist, ptietue.colonist);
		nicefeel(Planu.szCF, ptietue.feel_col, ptietue.colonist);
		nicelong(Planu.szMo, "%5ld", ptietue.money);
		nicelong(Planu.szSu, "%5ld", ptietue.supply);
		wsprintf(Planu.szNR, "%s", szNat);
		wsprintf(Planu.szNG, "%s", szGov);
		nicelong(Planu.szNv, "%7ld", ptietue.natives);
		nicetax(Planu.szNT, ptietue.tax_nat, ptietue.native_gov, ptietue.natives, ptietue.colonist);
		nicefeel(Planu.szNF, ptietue.feel_nat, ptietue.natives);
		nicelong(Planu.szSN, "%5ld", ptietue.stock_fuel);
		nicelong(Planu.szGN, "%5ld", ptietue.ground_fuel);
		niceint(Planu.szRN, "%3d%%", ptietue.rate_fuel);
		nicelong(Planu.szST, "%5ld", ptietue.stock_tr);
		nicelong(Planu.szGT, "%5ld", ptietue.ground_tr);
		niceint(Planu.szRT, "%3d%%", ptietue.rate_tr);
		nicelong(Planu.szSD, "%5ld", ptietue.stock_dr);
		nicelong(Planu.szGD, "%5ld", ptietue.ground_dr);
		niceint(Planu.szRD, "%3d%%", ptietue.rate_dr);
		nicelong(Planu.szSM, "%5ld", ptietue.stock_mb);
		nicelong(Planu.szGM, "%5ld", ptietue.ground_mb);
		niceint(Planu.szRM, "%3d%%", ptietue.rate_mb);

		sbas = ((TSpaceWindow *)Parent)->planut[Index]->starbase;
		
		if(sbas && sbas != 1000) {
			wsprintf(Planu.szB1, "There is a starbase with %d defenceposts and %d fighters.",
								((TSpaceWindow *)Parent)->base[sbas]->defence,
								((TSpaceWindow *)Parent)->base[sbas]->fighters);
			wsprintf(Planu.szB2, "TechLevels are: Engines %d, Hulls %d, Weapons %d and Torpedos %d.",
								((TSpaceWindow *)Parent)->base[sbas]->etech,
								((TSpaceWindow *)Parent)->base[sbas]->htech,
								((TSpaceWindow *)Parent)->base[sbas]->wtech,
								((TSpaceWindow *)Parent)->base[sbas]->ttech);

		} else {
			wsprintf(Planu.szB1, "No starbase.");
			if(sbas == 1000) wsprintf(Planu.szB1, "No starbase, but enough everyting to build one!");
			wsprintf(Planu.szB2, "");
		}
		if(GetModule()->ExecDialog(new TPlanetInfoDlg(this, LPSTR MAKEINTRESOURCE(ShowPlanet))) == IDOK)
		{
			if(atoi(Planu.szOw) != ptietue.owner) {
				ptietue.owner = atoi(Planu.szOw);
				if(ptietue.owner >= 0 && ptietue.owner <= 11)
				{ 
					((TSpaceWindow *)Parent)->planut[ptietue.id - 1]->owner = ptietue.owner;
					dbv.seekg(positio);
					dbv.write((char *) &ptietue, sizeof(ptietue));
                }
            }
		}
		dbv.close();
    }
}

void TInfoListDlg::DetailShip(int Index)
{
	long		positio;
	int			i, ly, zx, zy;

	fstream		dbv;
	shipfile    ftietue;
	header		fheader;

	dbv.open("ship.dbv", ios::binary | ios::in | ios::out | ios::ate);
	if(dbv) {
		dbv.seekg(0L);
		dbv.read((char *) &fheader, sizeof(fheader));
		positio = sizeof(fheader) + (long(Index) * long(sizeof(ftietue)));
		dbv.seekg(positio);
		dbv.read((char *) &ftietue, sizeof(ftietue));

		niceint(Alu.szId, "%3d", ftietue.id);
		niceint(Alu.szLV, "%3d", ftietue.lastvisual);
		niceint(Alu.szLS, "%3d", ftietue.lastseen);
		hullName(ftietue.type, Alu.szHu, sizeof(Alu.szHu));

		racenmLongName(ftietue.owner[0], Alu.szRa, sizeof(Alu.szRa));

		niceint(Alu.szDa[0], "%4d", hullTritanium(ftietue.type));
		niceint(Alu.szDa[1], "%4d", hullDuranium(ftietue.type));
		niceint(Alu.szDa[2], "%4d", hullMolybdenum(ftietue.type));
		niceint(Alu.szDa[3], "%4d", hullFuelTankSize(ftietue.type));
		niceint(Alu.szDa[4], "%4d", hullCrewSize(ftietue.type));
		niceint(Alu.szDa[5], "%4d", hullEngines(ftietue.type));
		niceint(Alu.szDa[6], "%4d", hullMass(ftietue.type));
		niceint(Alu.szDa[7], "%4d", hullTechLevel(ftietue.type));
		niceint(Alu.szDa[8], "%4d", hullCargoSize(ftietue.type));
		niceint(Alu.szDa[9], "%4d", hullTubes(ftietue.type));
		niceint(Alu.szDa[10], "%4d", hullBays(ftietue.type));
		niceint(Alu.szDa[11], "%4d", hullBeams(ftietue.type));
		niceint(Alu.szDa[12], "%4d", hullMoney(ftietue.type));

		wsprintf(Alu.szNa, "%s", ftietue.name);
		niceint(Alu.szWa, "%1d", ftietue.warp);
		niceint(Alu.szCo, "%3d", ftietue.course);
		zx = zy = ly = 0;
		for(i=7; i>=0; i--) {
			wsprintf(Alu.szHi[i], "");
			if(ftietue.turn[i] > 0) {
				if(zx>0) ly = int(sqrt(pow((zx - ftietue.x[i]),2) + pow((zy - ftietue.y[i]),2)));
				wsprintf(Alu.szHi[i], "%d: (%4d, %4d) %3dly (%d KT) [%d]", ftietue.turn[i], ftietue.x[i], ftietue.y[i], ly, ftietue.w[i], ftietue.owner[i]);
				zx = ftietue.x[i];
				zy = ftietue.y[i];
			}
        }
		if(GetModule()->ExecDialog(new TShipInfoDlg(this, LPSTR MAKEINTRESOURCE(ShowShip))) == IDOK);

		dbv.close();
    }
}

void TInfoListDlg::WMDetails(RTMessage)
{
	int		l;

	l = InfoLst->GetSelIndex();
	if(l>-1) {
		if(Lista[l] > 3000) DetailShip(Lista[l] - 3001);
        else if(Lista[l] > 1000) DetailPlanet(Lista[l] - 1001);
    	
    }
}

void TInfoListDlg::HandleLBNs(RTMessage Msg)
{
	int		l;

    if(Msg.LP.Hi == LBN_DBLCLK) {
		l = InfoLst->GetSelIndex();
		if(l>-1) {
			if(Lista[l] > 3000) DetailShip(Lista[l] - 3001);
        	else if(Lista[l] > 1000) DetailPlanet(Lista[l] - 1001);
    	}	
	}
}

BOOL TInfoListDlg::CanClose()
{
	int			l, p;
	long		positio;

	fstream		dbv;
	planetfile	ptietue;
	shipfile    ftietue;

	((TSpaceWindow *)Parent)->SiirtoS =
	((TSpaceWindow *)Parent)->SiirtoX =
	((TSpaceWindow *)Parent)->SiirtoY =
	((TSpaceWindow *)Parent)->Siirto  =
	((TSpaceWindow *)Parent)->SiirtoT = -1L;

	l = InfoLst->GetSelIndex();
	if(l>-1) {
		if(Lista[l] > 3000) {
			p = Lista[l] - 3001;
			dbv.open("ship.dbv", ios::binary | ios::in | ios::out | ios::ate);
			if(dbv) {
				positio = sizeof(header) + (long(p) * long(sizeof(ftietue)));
				dbv.seekg(positio);
				dbv.read((char *) &ftietue, sizeof(ftietue));
				((TSpaceWindow *)Parent)->SiirtoS = long(ftietue.id);
				((TSpaceWindow *)Parent)->SiirtoX = long(ftietue.x[0]);
				((TSpaceWindow *)Parent)->SiirtoY = long(ftietue.y[0]);
    			if(ftietue.lastvisual == ftietue.turn[0]) {
					((TSpaceWindow *)Parent)->Siirto  = long(ftietue.warp + (ftietue.course * 10));
					((TSpaceWindow *)Parent)->SiirtoT = long(ftietue.type);
                }
				strncpy(((TSpaceWindow *)Parent)->stickyT, ftietue.name, 20); ((TSpaceWindow *)Parent)->stickyT[20] = 0;
				dbv.close();
			}
		}
		else if(Lista[l] > 1000) {
			p = Lista[l] - 1001;
			dbv.open("planet.dbv", ios::binary | ios::in | ios::out | ios::ate);
		    if(dbv) {
				positio = sizeof(header) + (long(p) * long(sizeof(ptietue)));
				dbv.seekg(positio);
				dbv.read((char *) &ptietue, sizeof(ptietue));
				((TSpaceWindow *)Parent)->SiirtoX = long(ptietue.x);
				((TSpaceWindow *)Parent)->SiirtoY = long(ptietue.y);
				strncpy(((TSpaceWindow *)Parent)->stickyT, ptietue.name, 20); ((TSpaceWindow *)Parent)->stickyT[20] = 0;
				dbv.close();
			}
		}
    	
    }

	return TRUE;
}

void TInfoListDlg::SetupWindow()
{
	TDialog::SetupWindow();

	char 	szBuff[80], szHelper[40], szRaceNM[50];
	long 	Ux, Uy, i, j, l, r, eka, vika, epa;
    int		m;

	Ux = ((TSpaceWindow *)Parent)->SiirtoX;
	Uy = ((TSpaceWindow *)Parent)->SiirtoY;
	j  = ((TSpaceWindow *)Parent)->Siirto;

    m = 0;  
	if(j > 2000) m = 1;
	if(j < -2000) { j = abs(j); m = -1; }

    l = 0;
	for(i=0; m >= 0 && i<500; i++) {
		if((((TSpaceWindow *)Parent)->planut[i]->x > (Ux - j)) && (((TSpaceWindow *)Parent)->planut[i]->x < (Ux + j)) && (((TSpaceWindow *)Parent)->planut[i]->y > (Uy - j)) && (((TSpaceWindow *)Parent)->planut[i]->y < (Uy + j)))
		{
			if(l<505) {
            	Lista[l] = 1001 + i;
				if(((TSpaceWindow *)Parent)->planut[i]->starbase && ((TSpaceWindow *)Parent)->planut[i]->starbase != 1000) wsprintf(szHelper, "<planet & starbase>");
				else wsprintf(szHelper, "<planet>");
				wsprintf(szBuff, "(%4d,%4d) #%ld %s %s", ((TSpaceWindow *)Parent)->planut[i]->x, ((TSpaceWindow *)Parent)->planut[i]->y, i+1, szHelper, ((TSpaceWindow *)Parent)->planut[i]->name);
				InfoLst->AddString(szBuff);
				l++;
            }
		}
	}

	eka = 0; vika = ((TSpaceWindow *)Parent)->shipKpl;
	for(r = 1; r < 12; r++) {
     	epa = eka;
		for(i = eka; m <= 0 && i < vika; i++) 
			if((((TSpaceWindow *)Parent)->ships[i]->turn[0] == ((TSpaceWindow *)Parent)->Kierros) || ((TSpaceWindow *)Parent)->Shows[9])
				if((((TSpaceWindow *)Parent)->ships[i]->x[0] > (Ux - j))
					&& (((TSpaceWindow *)Parent)->ships[i]->x[0] < (Ux + j))
					&& (((TSpaceWindow *)Parent)->ships[i]->y[0] > (Uy - j))
					&& (((TSpaceWindow *)Parent)->ships[i]->y[0] < (Uy + j))
					&& (((TSpaceWindow *)Parent)->ships[i]->owner[0] == r)) {
                    if(i == (eka + 1)) eka = i;
					if(l<505) {
						Lista[l] = 3000 + ((TSpaceWindow *)Parent)->ships[i]->id;
						racenmAdjective(((TSpaceWindow *)Parent)->ships[i]->owner[0], szRaceNM, sizeof(szRaceNM));
						wsprintf(szBuff, "(%4d,%4d) #%d %s - %s", ((TSpaceWindow *)Parent)->ships[i]->x[0], ((TSpaceWindow *)Parent)->ships[i]->y[0], ((TSpaceWindow *)Parent)->ships[i]->id, szRaceNM,  ((TSpaceWindow *)Parent)->ships[i]->name);
						InfoLst->AddString(szBuff);
						l++;
                	}
				} else if(((TSpaceWindow *)Parent)->ships[i]->owner[0] != 0) epa = i;
		vika = epa + 1;
    }
    if(l == 0) CloseWindow();
	else {
		InfoLst->SetSelIndex(0);
		if(l == 1) {
			if(Lista[0] > 3000) DetailShip(Lista[0] - 3001);
    	    else if(Lista[0] > 1000) DetailPlanet(Lista[0] - 1001);
        	CanClose();
			CloseWindow();
		}
	}
}

TPlanetInfoDlg::TPlanetInfoDlg(PTWindowsObject AParent, LPSTR AResource)
		:TDialog(AParent, AResource)
{
	new TEdit(this, PlaTurn, 4);
	new TEdit(this, PlaId, 5);
	new TEdit(this, PlaName, 21);
	new TEdit(this, PlaOwner, 3);
	new TEdit(this, PlaFCode, 6);
	new TEdit(this, PlaCli, 7);
	new TEdit(this, PlaMines, 12);
	new TEdit(this, PlaFact, 12);
	new TEdit(this, PlaDef, 12);
	new TEdit(this, PlaCol, 8);
	new TEdit(this, PlaCTax, 20);
	new TEdit(this, PlaCFeel, 20);
	new TEdit(this, PlaMoney, 7);
	new TEdit(this, PlaSupply, 7);
	new	TEdit(this, PlaNRace, 22);
	new	TEdit(this, PlaNGov, 22);
	new	TEdit(this, PlaNat, 8);
	new	TEdit(this, PlaNTax, 20);
	new	TEdit(this, PlaNFeel, 20);
	new	TEdit(this, PlaStoNe, 6);
	new	TEdit(this, PlaGroNe, 6);
	new	TEdit(this, PlaRatNe, 5);
	new	TEdit(this, PlaStoTr, 6);
	new	TEdit(this, PlaGroTr, 6);
	new	TEdit(this, PlaRatTr, 5);
	new	TEdit(this, PlaStoDr, 6);
	new	TEdit(this, PlaGroDr, 6);
	new	TEdit(this, PlaRatDr, 5);
	new	TEdit(this, PlaStoMb, 6);
	new	TEdit(this, PlaGroMb, 6);
	new	TEdit(this, PlaRatMb, 5);
	new	TEdit(this, BaseI1, 80);
	new	TEdit(this, BaseI2, 80);


	TransferBuffer = (void far *) &((TInfoListDlg *)Parent)->Planu;
}

void TPlanetInfoDlg::SetupWindow()
{
	TDialog::SetupWindow();
}

TShipInfoDlg::TShipInfoDlg(PTWindowsObject AParent, LPSTR AResource)
		:TDialog(AParent, AResource)
{
	new	TEdit(this, ShiId, 4);
	new	TEdit(this, ShiLVisu, 4);
	new	TEdit(this, ShiLSeen, 4);
	new	TEdit(this, ShiHull, 32);
	new	TEdit(this, ShiName, 21);
	new	TEdit(this, ShiWarp, 2);
	new	TEdit(this, ShiCourse, 4);
	new	TEdit(this, ShiRac, 34);
	new	TEdit(this, ShiHist1, 80);
	new	TEdit(this, ShiHist2, 80);
	new	TEdit(this, ShiHist3, 80);
	new	TEdit(this, ShiHist4, 80);
	new	TEdit(this, ShiHist5, 80);
	new	TEdit(this, ShiHist6, 80);
	new	TEdit(this, ShiHist7, 80);
	new	TEdit(this, ShiHist8, 80);

	new	TEdit(this, ShiTR, 6);
	new	TEdit(this, ShiDR, 6);
	new	TEdit(this, ShiMB, 6);
	new	TEdit(this, ShiFU, 6);
	new	TEdit(this, ShiCrew, 6);
	new	TEdit(this, ShiEng, 6);
	new	TEdit(this, ShiWei, 6);
	new	TEdit(this, ShiTec, 6);
	new	TEdit(this, ShiCar, 6);
	new	TEdit(this, ShiTBa, 6);
	new	TEdit(this, ShiFBa, 6);
	new	TEdit(this, ShiBea, 6);
	new	TEdit(this, ShiMC, 6);

	TransferBuffer = (void far *) &((TInfoListDlg *)Parent)->Alu;
}

void TShipInfoDlg::SetupWindow()
{
	TDialog::SetupWindow();
}
