
#include <stdio.h>
#include <ctype.h>
#include "global.h"

#define D(A) A

extern int line_num;
extern int cur_type;

read_planet_data(cp_file)
char *cp_file;
{
  FILE *fp;
  char line[160];
  char *name, *produce;
  float x, y, size, res;
  int pop;
  float industry;
  float cap, mat, col;
  int who;
  int type;

  if ((fp = fopen(cp_file, "r")) == NULL)
  {
    perror(cp_file);
    return(-1);
  }
  line_num = 0;

  while (fgets(line, 160, fp) != NULL)
  {
    line_num++;

    if ((type = line_type(line)) == TYPE_INVALID)
      continue;

    break_up(line);

    switch (type)
    {
      case TYPE_YOUR_PLANETS :

	name = element_str(line, 0);
	x = element_float(line, 1);
	y = element_float(line, 2);
	size = element_float(line, 3);
	pop = element_int(line, 4);
	industry = element_float(line, 5);
	res = element_float(line, 6);
	produce = element_str(line, 7);
	cap = element_float(line, 8);
	mat = element_float(line, 9);
	col = element_float(line, 10);
	who = WHO_ME;

	set_planet_data(name, x, y, size, pop, industry, res, 
			produce, cap, mat, col, who); 

	break;

      case TYPE_PLANETS :

	name = element_str(line, 0);
	x = element_float(line, 1);
	y = element_float(line, 2);
	size = element_float(line, 3);
	pop = element_int(line, 4);
	industry = element_float(line, 5);
	res = element_float(line, 6);
	produce = element_str(line, 7);
	cap = element_float(line, 8);
	mat = element_float(line, 9);
	col = element_float(line, 10);
	who = WHO_FRIEND;

	set_planet_data(name, x, y, size, pop, industry, res, 
			produce, cap, mat, col, who); 

	break;

      case TYPE_UNIDENTIFIED :

	name = element_str(line, 0);
	x = element_float(line, 1);
	y = element_float(line, 2);
	size = 0;
	pop = 0;
	industry = 0;
	res = 0;
	produce = 0;
	cap = 0;
	mat = 0;
	col = 0;
	who = WHO_ALIEN;

	set_planet_data(name, x, y, size, pop, industry, res, 
			produce, cap, mat, col, who); 
	break;

      case TYPE_UNINHABITED :

	name = element_str(line, 0);
	x = element_float(line, 1);
	y = element_float(line, 2);
	size = element_float(line, 3);
	res = element_float(line, 4);
	pop = 0;
	industry = 0;
	produce = 0;
	cap = 0;
	mat = 0;
	col = 0;
	who = WHO_NOONE;

	set_planet_data(name, x, y, size, pop, industry, res, 
			produce, cap, mat, col, who); 
	break;
    }
  }
  fclose(fp);

  printf("Planets read from '%s'\n", cp_file);

  return(0);
}
