#include <stdio.h>
#include <ctype.h>
#include "global.h"
#include "planet.h"

#define ROUND(F) (((F) - ((int) (F))) >= 0.5 ? ((int) (F)) + 1.0 : ((int) (F)))

extern int line_num;

#define X_WIDTH 80
#define Y_WIDTH 40

static float g_center_x;
static float g_center_y;

show_planets(startx, starty, width, option, filename)
float startx, starty, width;
int option;
char *filename;
{
    FILE *fp;
    float x1, y1, x2, y2;
    float curx, cury;
    char map[Y_WIDTH][X_WIDTH+1];
    int x, y, p, i, j;
    int pass_two;

    if (filename == 0)
      fp = stdout;
    else if ((fp = fopen(filename, "w")) == NULL)
    {
      perror(filename);
      return;
    }
    line_num = 0;
    x1 = startx;
    y1 = starty;
    x2 = x1 + width;
    y2 = y1 + width;

    g_center_x = x1 + width/2;
    g_center_y = y1 + width/2;

    /* display axis labels */
    fprintf(fp, "%4.1f,%4.1f", x1, y1);
    for (i = 0; i < X_WIDTH - 8 * 2 - 2; i++)
      fputc(' ', fp);
    fprintf(fp, "%4.1f,%4.1f\n", x2, y1);

    if (fp == stdout) chk_more(1);

    /* display line */
    for (i = 0; i < X_WIDTH; i++)
      fputc('-', fp);

    fputc('\n', fp);
    if (fp == stdout) chk_more(1);
    /*
     *  Fill in character map.
     */
    for (y = 0; y < Y_WIDTH; y++)
    {
      for (x = 0; x < X_WIDTH; x++)
	map[y][x] = ' ';

      map[y][x] = '\0';
    }
    /*
     *  Pass 1: Fill map up with basics planet symbols.
     *  Pass 2: Overlay name, resources or sizes onto map.
     */
    pass_two = 0;
AGAIN:

    for (p = 0; p < NUM_PLANETS; p++)
    {
      if (planet[p].set)
      {
	if ((planet[p].x >= x1) && (planet[p].x <= x2) &&
	    (planet[p].y >= y1) && (planet[p].y <= y2))
	{
	  curx = ((planet[p].x - x1) / width) * (float) X_WIDTH;
	  cury = ((planet[p].y - y1) / width) * (float) Y_WIDTH;
	  x = ROUND(curx);
	  y = ROUND(cury);

	  if ((x >= 0) && (x < X_WIDTH) && (y >= 0) && (y < Y_WIDTH))
	  {
	    if (planet[p].who == WHO_ME)
	    {
	      if (pass_two)
	      {
		/* fill in planet # */
		fill_map(map, y, x, p, option);
	      }
	      else
		map[y][x] = '*';
	    }
	    else if ((planet[p].who == WHO_ALIEN) ||
		     (planet[p].who == WHO_FRIEND))
	    {
	      if (map[y][x] != '*')
	      {
		if (pass_two)
		{
		  /* fill in planet # */
		  fill_map(map, y, x, p, option);
		}
		else
		  map[y][x] = '+';
	      }
	    }
	    else if (map[y][x] != '*' && map[y][x] != '+')
	    {
	      if (pass_two)
	      {
		/* fill in planet # */
		fill_map(map, y, x, p, option);
	      }
	      else
		map[y][x] = 'o';
	    }
	  }
	}
      }
    }
    if (!pass_two)
    {
      pass_two = 1;
      goto AGAIN;
    }
    /*
     *  Display map.
     */
    for (y = 0; y < Y_WIDTH; y++)
    {
      fprintf(fp, "%s\n", map[y]);
      if (fp == stdout) chk_more(1);
    }

    /* display line */
    for (i = 0; i < X_WIDTH; i++)
      fputc('-', fp);

    fputc('\n', fp);
    if (fp == stdout) chk_more(1);

    /* display axis labels */
    fprintf(fp, "%4.1f,%4.1f", x1, y2);
    for (i = 0; i < X_WIDTH - 8 * 2 - 2; i++)
      fputc(' ', fp);
    fprintf(fp, "%4.1f,%4.1f\n", x2, y2);
    if (fp != stdout) 
    {
      fclose(fp);
      printf("Wrote to file '%s'\n", filename);
    }
}

fill_map(map, y, x, p, option)
char map[Y_WIDTH][X_WIDTH+1];
int y, x, p;
{
    double dist;
    char text[80];
    char name[80];
    int j;

    switch(option)
    {
      case OPT_PLANET_SIZE :
	if (planet[p].size == 0)
	  return;
	sprintf(text, "%d", (int) planet[p].size);
	break;
      case OPT_PLANET_RES :
	if (planet[p].res == 0)
	  return;
	if ((int) planet[p].res == planet[p].res)
	  sprintf(text, "%d", (int) planet[p].res);
	else
	  sprintf(text, "%3.1f", planet[p].res);
	break;
      /* show distance from center point of display */
      case OPT_PLANET_DIST :
	dist = planet_xy_dist(g_center_x, g_center_y, p);
	sprintf(text, "%.1f", (float) dist);
	break;
      default :
	strcpy(text, get_planet_name(p, 0));
	break;
    }
    for (j = 1; j <= strlen(text); j++)
    {
      if ((x+j >= X_WIDTH) || (map[y][x+j] != ' '))
	break;
      else
	map[y][x+j] = text[j-1];
    }
}
map_open(map, y, x, len)
char map[Y_WIDTH][X_WIDTH+1];
int y, x, len;
{
    int j;

    for (j = 1; j <= len; j++)
      if ((x+j >= X_WIDTH) || (map[y][x+j] != ' '))
	return(0);
    return(1);
}
