
#define VERSION "2.8"
/* -------------------------------------------------------
 *   The following set of defines control platform specific
 *   issues.
 */
/*
 *  On some systems, stty -raw and stty raw do not work.  All I needed
 *  that for was so I could get a more nifty 'more' ability when printing 
 *  out lines.  If you do not have stty ability uncomment the line below.
 *  What this will mean is that when you see the more prompt
 *       [---more---]<q><return><space>
 *  you need to hit <return> or 'q' followed by <return> or <space> followed 
 *  by return.
 */
/* #define NO_SYSTEM_STTY */

/* --------------------------------------------------------
 *   All other global defines
 */
#define COMPUTE_CARGO(c) (galaxy_version >= 3 ? ((c)+((c)*(c)/10.0)) : (c))

#define NUM_PLANETS 600
#define NUM_SHIPS 400
#define TEST_SLOT NUM_SHIPS
#define NUM_PLAYERS 24

#define IS_ERR -1
#define NEW -2
#define ERROR_NAME "??"
#define UNKNOWN_NAME "?"
#define NO_MATCH -1

#define RACE_ERR -2
#define RACE_ALL -1

#define TECH_ALL -1

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define CAPITAL_NAME      "Capital"
#define RAW_MAT_NAME      "Raw Materials"
#define RESEARCH_NAME     "Research"
#define SHIPS_NAME        "Ships"
#define TECH_LEVEL        "Tech Level"

#define YOUR_PLANETS "Your Planets"
#define PLANETS "Planets"
#define ALIEN_PLANETS "Unidentified Planets"
#define NEUTRAL_PLANETS "Uninhabited Planets"
#define SHIP_TYPES "Ship Types"
#define GROUPS "Groups"
#define YOUR "Your"
#define ABBR_GROUPS "List Of"
#define REPORT_TITLE "Report for"
#define YOUR_ROUTES "Your Routes"

#define CAPITAL   1
#define RAW_MAT   2
#define RESEARCH  3
#define SHIPS     4

#define WHO_NOID	0
#define WHO_ME		1
#define WHO_ALIEN	2
#define WHO_NOONE	3
#define WHO_FRIEND	4

#define TYPE_INVALID		0
#define TYPE_UNIDENTIFIED	1
#define TYPE_UNINHABITED	2
#define TYPE_SHIPS		3
#define TYPE_YOUR_PLANETS	4
#define TYPE_YOUR_GROUPS        5
#define TYPE_YOUR_ABBR_GROUPS	6
#define TYPE_ALIEN_GROUPS       7
#define TYPE_ALIEN_ABBR_GROUPS  8 
#define TYPE_PLANETS  		9 
#define TYPE_ROUTES  		10

#define OPT_PLANET_ID		0
#define OPT_PLANET_SIZE		1
#define OPT_PLANET_RES		2
#define OPT_PLANET_DIST		3

char *get_planet_name();
char *get_produce_name();
char *get_who_name();

double planet_dist();
double planet_xy_dist();
int element_int();
char *element_str();
char *get_ship_name();
char *get_planet_text_name();
float element_float();
float calc_num_ships();
float get_ship_mass();
float get_planet_x();
float get_planet_y();
char *get_ship_title();
float get_planet_res();
float get_planet_size();
char *getGroupSaveFile();
double get_ship_ly();
char *get_race_name();
