/*
 * File: simmain.c
 * Author: Douglas Selph
 * Date: Sep 1993
 * Purpose:
 */
#include <stdio.h>
#include <signal.h>
#include <assert.h>
#include "common.h"
#include "data.h"

void trapfunc();
static int g_seed;
extern int g_print_group_tech;

main (ac, av)
int ac;
char **av;
{
    g_seed = getpid();
    g_print_group_tech = 0;

    signal(SIGINT, trapfunc);

    check_args(ac, av);
    SRAND(g_seed);
    printf("Initial seed = %d\n", g_seed);

    check_version();
    init_ships();

    loop();
}

check_args(ac, av)
int ac;
char **av;
{
    int i, err;

    if (ac > 1)
    {
      for(i=1;i<ac;i++)
      {
	if (av[i][0]!='-')
	{
	  usage();	
	  exit(1);
	}
	switch(av[i][1])
	{
	  case 's' :
	    if (i+1 >= ac)
	    {
	      printf("Expected number following -s\n");
	      usage();
	      exit(1);
	    }
	    else if (strIsInt(av[i+1]))
	      g_seed = atoi(av[i+1]);
	    else
	    {
	      printf("Expected number following -s\n");
	      printf("  Found '%s'\n", av[i+1]);
	      usage();
	      exit(1);
	    }
	    break;
	  default:
	    usage();
	    exit(1);
	}
      }
    }
    return(DONE);
}

usage()
{
   fprintf(stderr,"Usage : battle [-s #]\n");
   fprintf(stderr,"  -s # : set starting random seed\n");
   return(DONE);
}

void trapfunc()
{
    printf("Quit\n");
    exit(1);
}

loop()
{
    char line[126];
    char *name, *s;
    int go, num_fights, i;

    for(go = 1; go;)
    {
      printf("Cmd> ");

      if (gets(line) == NULL)
	break;

      s = line;

      switch(*(s++))
      {
        case 'b' :
	  name = askstr("output filename");
	  if (strlen(name) == 0)
	    name = 0;
	  do_battle(name);
	  break;
        case 'B' :
	  num_fights = getd("Number of fights");
	  for (i = 0; i < num_fights; i++)
	  {
	    printf("Processing battle %d\n", i+1);
	    do_battle(0);
	  }
	  break;
	case 'p' :
	  write_battle_data(0);
	  break;
	case 'r' :
	  name = askstr("filename");
	  read_battle_data(name);
	  break;
	case 'w' :
	  name = askstr("filename");
	  write_battle_data(name);
	  break;
	case 'q' :
	  go = 0;
	  break;
	case 'g' :
          battle_init_groups();
	  write_all_races_groups(stdout);
	  break;
	case 's' :
	  write_all_races_ships(stdout);
	  break;
	case '?' :
	  printf(" b  - do battle\n"); 
	  printf(" B  - simulate N battles\n"); 
	  printf(" p  - print battle data\n"); 
	  printf(" r  - read battle data from file\n"); 
	  printf(" w  - write battle data to file\n"); 
	  printf(" g  - print battle data in group format\n");
	  printf(" s  - print ship data\n");
	  printf(" q  - quit\n"); 
	  break;
	default :
	  printf("Type '?' for a list of commands.\n");
      }
    }
    return(DONE);
}

abort_program(cp_msg)
char *cp_msg;
{
    strRmReturn(cp_msg);
    puts(cp_msg);
    exit(1);
}

message_print(cp_msg)
char *cp_msg;
{
    strRmReturn(cp_msg);
    puts(cp_msg);
}
