/*
 * File: route.c
 * Author: Douglas Selph
 * Date: Mar 1993
 * Purpose:
 */
#include <stdio.h>
#include "common.h"
#include "data.h"
/**
 **  Local Structures and Defines
 **/
extern int g_line_num;
extern int g_cur_type;
extern char g_msg[MAX_MSG];
/**
 ** Functions:
 **/
print_routes(outfp)
FILE *outfp;
{
    FILE *fp;
    char line[160];

    if ((fp = fopen(ROUTE_FILE, "r")) == NULL)
    {
      errnoMsg(g_msg, ROUTE_FILE);
      message_print(g_msg);
      return(FILEERR);
    }
    while (fgets(line, 160, fp) != NULL)
    {
      strExpandTab(line);
      fprintf(outfp, "%s", line);
    }
    fclose(fp);

    return(DONE);
}

/* print routes that involve the passed planet */
print_pl_routes(outfp, i_planet)
FILE *outfp;
int i_planet;
{
    FILE *fp;
    char line[160];
    char *name;
    int once;

    if (!route_has_planet(i_planet))
      return(IS_ERR);

    name = get_planet_name(i_planet);

    if ((fp = fopen(ROUTE_FILE, "r")) == NULL)
    {
      errnoMsg(g_msg, ROUTE_FILE);
      message_print(g_msg);
      return(FILEERR);
    }
    /* Print out first non-blank line (title) then any line with
     *  the planet name in it 
     */
    fprintf(outfp, "\n"); 
    once = 0;

    while (fgets(line, 160, fp))
    {
      strExpandTab(line);
      strRmReturn(line);

      if (line[0] == '\0')
	continue;

      if (!once || strLocate(line, name) >= 0)
      {
	fprintf(outfp, "%s\n", line); 
	once = 1;
      }
    }
    fclose(fp);
    return(DONE);
}


/* See if there is a route with this name */
route_has_planet(i_planet)
int i_planet;
{
    FILE *fp;
    char line[160];
    char *name;

    name = get_planet_name(i_planet);

    if ((fp = fopen(ROUTE_FILE, "r")) == NULL)
      return(0);

    while (fgets(line, 160, fp) != NULL)
    {
      if (strLocate(line, name) >= 0)
	return(1);
    }
    fclose(fp);

    return(0);
}
