#include <stdio.h>
#include "global.h"

#define ROUTE_FILE "save.routes"

extern int line_num;
extern int cur_type;

print_routes()
{
    FILE *fp;
    char line[160];

    if ((fp = fopen(ROUTE_FILE, "r")) == NULL)
    {
      perror(ROUTE_FILE);
      return;
    }
    while (fgets(line, 160, fp) != NULL)
    {
      printf("%s", line);
    }
    fclose(fp);
}

read_route_data(cp_file)
char *cp_file;
{
  FILE *fp;
  FILE *to;
  char line[160];
  int type;

  if ((to = fopen(ROUTE_FILE, "w")) == NULL)
  {
    perror(ROUTE_FILE);
    return(-1);
  }
  if ((fp = fopen(cp_file, "r")) == NULL)
  {
    perror(cp_file);
    return(-1);
  }
  line_num = 0;

  while (fgets(line, 160, fp) != NULL)
  {
    line_num++;

    if ((type = line_type(line)) == TYPE_INVALID)
      continue;

    switch (type)
    {
      case TYPE_ROUTES :

	fprintf(to, "%s\n", line);
	break;
    }
  }
  fclose(fp);
  fclose(to);

  printf("Routes read from '%s'\n", cp_file);

  return(0);
}

/* print routes that involve the passed planet */
print_pl_routes(i_planet)
int i_planet;
{
    FILE *fp;
    char line[160];
    char *name;
    int once;

    if (!route_has_planet(i_planet))
      return;

    name = get_planet_name(i_planet, 0);

    if ((fp = fopen(ROUTE_FILE, "r")) == NULL)
    {
      perror(ROUTE_FILE);
      return;
    }
    /* Print out first non-blank line (title) then any line with
     *  the planet name in it 
     */
    printf("\n"); chk_more(1);
    once = 0;

    while (fgets(line, 160, fp) != NULL)
    {
      strRmReturn(line);
      strStripSpaces(line);

      if (line[0] == '\0')
	continue;

      if (!once || strLocate(line, name) >= 0)
      {
	printf("%s\n", line); chk_more(1);
	once = 1;
      }
    }
    fclose(fp);
}


/* See if there is a route with this name */
route_has_planet(i_planet)
int i_planet;
{
    FILE *fp;
    char line[160];
    char *name;

    name = get_planet_name(i_planet, 0);

    if ((fp = fopen(ROUTE_FILE, "r")) == NULL)
      return(0);

    while (fgets(line, 160, fp) != NULL)
    {
      if (strLocate(line, name) >= 0)
	return(1);
    }
    fclose(fp);

    return(0);
}

