
#include <stdio.h>
#include <ctype.h>
#include "global.h"

extern int line_num;
extern int cur_type;
extern int g_race_id;
extern int g_your_race_id;

/* read ship data from turn report */
read_ship_data(cp_file)
char *cp_file;
{
  FILE *fp;
  char line[160];
  char *s;
  char *name;
  float cargo, drive, weapon, shield;
  int type, attacks;

  if ((fp = fopen(cp_file, "r")) == NULL)
  {
    perror(cp_file);
    return;
  }
  line_num = 0;

  while (fgets(line, 160, fp) != NULL)
  {
    line_num++;

    strStripSpaces(line);

    if ((type = line_type(line)) == TYPE_INVALID)
      continue;

    break_up(line);

    switch (type)
    {
      /* Sample: Daddy_Long_LegB   7.0  0   0   0.0  8.0   */
      case TYPE_SHIPS :

	name = element_str(line, 0);

	if (!strcmp(name, "Tech"))
	{
	  name = element_str(line, 1);
	  drive = element_float(s, 2);
	  weapon = element_float(s, 3);
	  shield = element_float(s, 4);
	  cargo = element_float(s, 5);

	  new_tech_level(g_race_id, drive, weapon, shield, cargo);
	}
	else
	{
	  drive = element_float(line, 1);
	  attacks = element_int(line, 2);
	  weapon = element_float(line, 3);
	  shield = element_float(line, 4);
	  cargo = element_float(line, 5);

	  new_ship_data(name, drive, attacks, weapon, shield, cargo, g_race_id);
	}
	break;
    }
  }
  fclose(fp);
  printf("Ships read from '%s'\n", cp_file);
  sort_ships();
}
