
#include <stdio.h>
#include <ctype.h>
#include "global.h"

#define D(A) A

extern int line_num;
extern int cur_type;
extern int g_race_id;
extern int g_your_race_id;

read_group_data(cp_file)
char *cp_file;
{
  FILE *fp;
  char line[160], save[160];
  char *shipname, *planetname;
  char *start;
  char *what;
  float dist;
  float drive, weapon, shield, cargo, quantity;
  int i;
  int groupid;
  int num_ships;
  int ready;
  int type;
  int race;
  int did_clear, did_your_clear;

  if ((fp = fopen(cp_file, "r")) == NULL)
  {
    perror(cp_file);
    return(-1);
  }

  clear_groups(RACE_ALL);
  did_clear = TRUE;
  did_your_clear = TRUE;
  /*
  did_clear = FALSE;
  did_your_clear = FALSE;
  */

  line_num = 0;
  ready = 0;

  while (fgets(line, 160, fp) != NULL)
  {
    line_num++;

    strcpy(save, line);

    strStripSpaces(line);

    if ((type = line_type(line)) == TYPE_INVALID)
      continue;

    break_up(line);

    switch (type)
    {
      case TYPE_UNIDENTIFIED :
      case TYPE_UNINHABITED :
	
	ready = 1;
	break;

      case TYPE_YOUR_ABBR_GROUPS :
	/* 
	 * If we are reading from the save.groups file then
	 * we should clear out the groups before continuing 
	 */
	if (!did_clear)
	{
	  clear_groups(RACE_ALL);
	  did_clear = TRUE;
	}
	race = g_your_race_id;
	groupid = element_int(line, 0);
	num_ships = element_int(line, 1);
	shipname = element_str(line, 2);
	planetname = element_str(line, 3);
	dist = element_float(line, 4);
	drive = element_float(line, 5);
	weapon = element_float(line, 6);
	shield = element_float(line, 7);
	cargo = element_float(line, 8);
	what = element_str(line, 9);
	quantity = element_float(line, 10);

	set_group_data(race, groupid, num_ships, shipname, planetname, dist,
		drive, weapon, shield, cargo, what, quantity);
	break;

      case TYPE_YOUR_GROUPS :

	if (!ready)
	  break; /* wait until after planets read */

	if (!did_clear && !did_your_clear)
	{
	  clear_groups(g_your_race_id);
	  did_your_clear = TRUE;
	}
	race = g_your_race_id;
	groupid = element_int(line, 0);
	num_ships = element_int(line, 1);
	shipname = element_str(line, 2);
	drive = element_float(line, 3);		/* Drive Tech */
	weapon = element_float(line, 4);	/* Weapon Tech */
	shield = element_float(line, 5);	/* Shield Tech */
	cargo = element_float(line, 6);		/* Cargo Tech */
	what = element_str(line, 7);
	quantity = element_float(line, 8);
	planetname = element_str(line, 9);
	dist = element_float(line, 10);

	set_group_data(race, groupid, num_ships, shipname, planetname, dist,
	 drive, weapon, shield, cargo, what, quantity);
	break;

      case TYPE_ALIEN_ABBR_GROUPS :

	if (g_race_id == RACE_ERR)
	  break;	/* unknown race */

	/* if we are reading from the save.groups file then
	 * we should clear out the groups before continuing */
	if (!did_clear)
	{
	  clear_groups(RACE_ALL);
	  did_clear = TRUE;
	}
	race = g_race_id;
	groupid = element_int(line, 0);
	num_ships = element_int(line, 1);
	shipname = element_str(line, 2);
	planetname = element_str(line, 3);
	dist = element_float(line, 4);
	drive = element_float(line, 5);
	weapon = element_float(line, 6);
	shield = element_float(line, 7);
	cargo = element_float(line, 8);
	what = element_str(line, 9);
	quantity = element_float(line, 10);

	new_alien_group_data(race, groupid, num_ships, shipname, planetname, 
		dist, drive, weapon, shield, cargo, what, quantity);
	break;

      case TYPE_ALIEN_GROUPS :

	if (!ready)
	  break; /* wait until after planets read */
	if (g_race_id == RACE_ERR)
	  break;	/* unknown race */

	race = g_race_id;
	num_ships = element_int(line, 0);
	shipname = element_str(line, 1);
	drive = element_float(line, 2);		/* Drive Tech */
	weapon = element_float(line, 3);	/* Weap Tech */
	shield = element_float(line, 4);	/* Shield Tech */
	cargo = element_float(line, 5);		/* Cargo Tech */
	what = element_str(line, 6);		/* Type */
	quantity = element_float(line, 7);	/* Quantity */
	planetname = element_str(line, 8);
	dist = element_float(line, 9);

	new_alien_group_data(race, 0, num_ships, shipname, planetname, dist,
		drive, weapon, shield, cargo, what, quantity);
	break;
    }
  }
  fclose(fp);

  printf("Groups read from '%s'\n", cp_file);

  return(0);
}

/* 
 * read send orders from a file and apply then
 * to owned groups.
 */
read_send_orders(cp_filename)
char *cp_filename;
{
    FILE *fp;
    char line[256];
    int num_ships;
    int groupid;
    int pl_id;
    char *planetname;

    if ((fp = fopen(cp_filename, "r")) == NULL)
    {
      perror(cp_filename);
      return(-1);
    }
    line_num = 0;
    while (fgets(line, 160, fp) != NULL)
    {
      line_num++;
      strStripSpaces(line);
      strRmReturn(line);
      break_up(line);

      /* send */
      if ((line[0] == 's') || (line[0] == 'S'))
      {
	groupid = element_int(line, 1);
	num_ships = element_int(line, 2);
	planetname = element_str(line, 3);

	if (planetname == 0)
	{
	  printf("Malformed send line, %d: %s\n", line_num, line);
	}
	else
	{
	  if ((pl_id = translate_planet(planetname)) >= 0)
	    send_group(groupid, num_ships, pl_id);
	}
      }
      /* break */
      else if ((line[0] == 'b') || (line[0] == 'B'))
      {
	groupid = element_int(line, 1);
	num_ships = element_int(line, 2);

	if (break_off_group(groupid, num_ships) == IS_ERR)
	{
	  printf("Malformed break line, %d: %s\n", line_num, line);
	}
      }
    }
    fclose(fp);

    printf("Send orders read from %s\n", cp_filename);
    printf("  Ship groups have now changed.\n");
    printf("  %s will not be rewritten on quit.\n", getGroupSaveFile());

    return(0);
}
