#include <stdio.h>
#include <ctype.h>
#include "global.h"
#define DEF
#include "planet.h"

#define SAVE_FILE "save.planets"

extern int line_num;
extern int do_more;

init_planets()
{
   read_planet_data(SAVE_FILE);
}

save_planets()
{
   do_more = 0;
   write_planet_data(SAVE_FILE);
   do_more = 1;
}

write_planet_data(cp_file)
char *cp_file;
{
  FILE *fp;

  if ((fp = fopen(cp_file, "w")) == NULL)
  {
    perror(cp_file);
    return;
  }
  write_all_planets(fp);

  printf("Wrote %s\n", cp_file);

  fclose(fp);
}


print_your_planets()
{
  line_num = 0;
  write_planet_type(stdout, WHO_ME, YOUR_PLANETS);
}

print_planets()
{
  write_all_planets(stdout);
}

write_all_planets(fp)
FILE *fp;
{
  line_num = 0;
  write_planet_type(fp, WHO_ME, YOUR_PLANETS);
  if (has_one_ptype(WHO_FRIEND))
  {
    fprintf(fp, "\n"); chk_more(1);
    write_planet_type(fp, WHO_FRIEND, PLANETS);
  }
  if (has_one_ptype(WHO_ALIEN))
  {
    fprintf(fp, "\n"); chk_more(1);
    write_planet_type(fp, WHO_ALIEN, ALIEN_PLANETS);
  }
  if (has_one_ptype(WHO_NOONE))
  {
    fprintf(fp, "\n"); chk_more(1);
    write_planet_type(fp, WHO_NOONE, NEUTRAL_PLANETS);
  }
}

write_planet_type(fp, who, str)
FILE *fp;
int who;
char *str;
{
  int i;

  if (str != 0)
  {
    fprintf(fp, "\t\t%s\n\n", str); chk_more(2);
  }
  switch(who)
  {
    case WHO_FRIEND :
    case WHO_ME :

      fprintf(fp, "Name         X      Y      Size    Pop  Indu   Res   Produce  Cap    Mat  Col\n"); chk_more(1);

      for (i = 0; i < NUM_PLANETS; i++)
      {
	if (planet[i].set && (planet[i].who == who))
	{
	  fprintf(fp, "%-12s %-6.2f %-6.2f %-7.2f %-4d %-6.1f %-5.2f %-8s %-6.2f %-4.2f %-5.2f\n",
	    get_planet_name(i,fp!=stdout), 
	    planet[i].x, planet[i].y,
	    planet[i].size, planet[i].pop, planet[i].industry,
	    planet[i].res,
	    get_produce_name(i),
	    planet[i].cap, planet[i].mat, planet[i].col);
	  chk_more(1);
	}
      }
      break;

    case WHO_ALIEN :

      fprintf(fp, "Name            X      Y\n"); chk_more(1);

      for (i = 0; i < NUM_PLANETS; i++)
      {
	if ((planet[i].set) && (planet[i].who == who))
	{
	  fprintf(fp, "%-15s %-6.2f %-6.2f\n",
	    get_planet_name(i,fp!=stdout), 
	    planet[i].x, planet[i].y);
	  chk_more(1);
	}
      }
      break;

    case WHO_NOONE :

      fprintf(fp, "Name            X      Y      Size    Res\n"); chk_more(1);

      for (i = 0; i < NUM_PLANETS; i++)
      {
	if ((planet[i].set) && (planet[i].who == who))
	{
	  fprintf(fp, "%-15s %-6.2f %-6.2f %-7.2f %-5.2f\n",
	    get_planet_name(i,fp!=stdout), 
	    planet[i].x, planet[i].y,
	    planet[i].size, planet[i].res);
	  chk_more(1);
	}
      }
      break;
  }
}

write_single_planet(fp, i)
FILE *fp;
int i;
{
  if (!planet[i].set)
    return;

  switch(planet[i].who)
  {
    case WHO_FRIEND :
    case WHO_ME :

      fprintf(fp, "Name         X      Y      Size    Pop  Indu   Res   Produce  Cap    Mat  Col\n"); chk_more(1);

      fprintf(fp, "%-12s %-6.2f %-6.2f %-7.2f %-4d %-6.1f %-5.2f %-8s %-6.2f %-4.2f %-5.2f\n",
	get_planet_name(i,fp!=stdout), 
	planet[i].x, planet[i].y,
	planet[i].size, planet[i].pop, planet[i].industry,
	planet[i].res,
	get_produce_name(i),
	planet[i].cap, planet[i].mat, planet[i].col);
      chk_more(1);
      break;

    case WHO_ALIEN :

      fprintf(fp, "Name            X      Y\n"); chk_more(1);

      fprintf(fp, "%-15s %-6.2f %-6.2f\n",
	get_planet_name(i,fp!=stdout), 
	planet[i].x, planet[i].y);
      chk_more(1);
      break;

    case WHO_NOONE :

      fprintf(fp, "Name            X      Y      Size    Res\n"); chk_more(1);

      fprintf(fp, "%-15s %-6.2f %-6.2f %-7.2f %-5.2f\n",
	get_planet_name(i,fp!=stdout), 
	planet[i].x, planet[i].y,
	planet[i].size, planet[i].res);
      chk_more(1);
      break;
  }
}

has_one_ptype(who)
int who;
{
    int i;

    for (i = 0; i < NUM_PLANETS; i++)
    {
      if (planet[i].set && (planet[i].who == who))
	return (1);
    }
    return(0);
}
legal_planet(id)
int id;
{
  if ((id >= 0) && (id < NUM_PLANETS))
    return(planet[id].set);

  return(0);
}


translate_planet(cp_name)
char *cp_name;
{
    int val;

    if ((val = decode_planet_name(cp_name)) == NEW)
    {
      /* find a new position */
      printf("translate_planet(), line %d : Illegal planet name: '%s'\n", 
	  line_num, cp_name);

      return(IS_ERR);
    }
    return(val);
}


decode_planet_name(cp_name)
char *cp_name;
{
    char *s, *strchr();
    int val;
    int i;

    if (is_number(cp_name))
    {
      /* allow entry form: "number:name" */
      if ((s = strchr(cp_name, ':')) != NULL)
      {
	*s = '\0';
	val = atoi(cp_name);
	strcpy(cp_name, s+1);
      }
      else
      {
	val = atoi(cp_name);
      }
      if ((val < 0) || (val >= NUM_PLANETS))
      {
	printf("decode_planet_name(), line %d : Illegal planet number: %s\n", 
		line_num, cp_name);
	return(IS_ERR);
      }
      return(val);
    }
    else
    {
      for (i = 0; i < NUM_PLANETS; i++)
	if (planet[i].name != NULL)
	  if (!strcmp(planet[i].name, cp_name))
	    return(i);
    }
    return(NEW);
}

locate_planet(x, y)
float x, y;
{
    int i;

    for (i = 0; i < NUM_PLANETS; i++)
      if (planet[i].set)
	if (planet[i].x == x && planet[i].y == y)
	  return(i);

    return(IS_ERR);
}

is_number(cp_name)
char *cp_name;
{
    return isdigit(cp_name[0]);
}
/*
 * If i_full is set, then possibly do form %d:%s
 */
char *get_planet_name(id, i_full)
int id;
int i_full;
{
    static char text[256];

    if ((id < 0) || (id >= NUM_PLANETS))
    {
      printf("get_planet_name(), line %d : Illegal planet number: %d\n",
	line_num, id);
      exit(1);
    }
    if (planet[id].name != NULL)
    {
      if (i_full && !planet[id].floater)
      {
	sprintf(text, "%d:%s", id, planet[id].name);
	return(text);
      }
      return planet[id].name;
    }
    sprintf(text, "%d", id);

    return(text);
}
char *get_produce_name(id)
int id;
{
    static char text[128];

    if ((id < 0) || (id >= NUM_PLANETS))
    {
      printf("get_produce_name(), line %d : Illegal planet number: %d\n",
	line_num, id);
      exit(1);
    }
    if (planet[id].produce == NULL)
      return "<none>";

    strncpy(text, planet[id].produce, 8);
    text[8] = '\0';

    return(text);
}



set_planet_data(cp_name, x, y, size, pop, industry, res, cp_produce, cap, mat, col, who)
char *cp_name;
float x, y, size, res;
int pop;
float industry;
char *cp_produce;
float cap, mat, col;
int who;
{
    int id, new_id, chk_id;
    int floater = 0;
    int reset = 0;
    /* 
     * if we get the form, just "name" then
     * we don't mind where we put it
     */
    if (!is_number(cp_name))
    {
      floater = 1;
    }
    if ((id = locate_planet(x, y)) >= 0)
    {
      reset = 1;

      if ((chk_id = decode_planet_name(cp_name)) >= 0)
      {
	if (id != chk_id)
	{
	  printf("Warning: Planet %d location does not match name %s(%d)\n",
		id, cp_name, chk_id);
	}
      }
    } else {
      if ((id = decode_planet_name(cp_name)) == IS_ERR)
	return(IS_ERR);
    }
    if (id == NEW)
    {
      id = get_new_planet_id();
      floater = 1;
    }
    if ((id < 0) || (id >= NUM_PLANETS))
    {
      printf("set_planet_data(), line %d : Illegal planet number: %d\n",
	line_num, id);
      return;
    }
    if (planet[id].set)
    {
       /* 
	* if we were specifying a specific planet,
	* and the current planet is a floater, then
	* move the planet.
	*/
      if (!reset && isdigit(cp_name[0]) && planet[id].floater)
      {
	new_id = get_new_planet_id();
	copy_planet(id, new_id);
      }
      else
      {
	/*  ** Too noisy **
	printf("Warning, line %d: overwriting planet %d\n", line_num, id);
	*/
      }
    }
    if (is_number(cp_name)) {
      zrealloc_cpy(&(planet[id].name), 0);
    } else {
      zrealloc_cpy(&(planet[id].name), cp_name);
    }
    planet[id].set = 1;
    planet[id].floater = floater;
    planet[id].x = x;
    planet[id].y = y;
    if(size != 0)
      planet[id].size = size;
    if (pop != 0)
      planet[id].pop = pop;
    if (industry != 0)
      planet[id].industry = industry;
    if(res != 0)
      planet[id].res = res;
    zrealloc_cpy(&(planet[id].produce), cp_produce);
    planet[id].cap = cap;
    planet[id].mat = mat;
    planet[id].col = col;
    planet[id].who = who;
}

copy_planet(from, to)
int from, to;
{
    planet[to].set = planet[from].set;
    planet[to].floater = planet[from].floater;
    planet[to].x = planet[from].x;
    planet[to].y = planet[from].y;
    planet[to].size = planet[from].size;
    planet[to].pop = planet[from].pop;
    planet[to].industry = planet[from].industry;
    planet[to].res = planet[from].res;
    planet[to].produce = planet[from].produce;
    planet[to].cap = planet[from].cap;
    planet[to].mat = planet[from].mat;
    planet[to].col = planet[from].col;
    planet[to].who = planet[from].who;
    planet[to].name = planet[from].name;
    planet[from].name = 0;
    planet[from].produce = 0;
    planet[from].size = 0;
    planet[from].pop = 0;
    planet[from].industry = 0;
    planet[from].res = 0;
    planet[from].cap = 0;
    planet[from].mat = 0;
    planet[from].col = 0;
    planet[from].who = 0;
}


get_new_planet_id()
{
    int id;

    for (id = 0; id < NUM_PLANETS; id++)
    {
      if (!planet[id].set)
      {
	return(id);
      }
    }
    return(IS_ERR);
}

double planet_dist(pl_1, pl_2)
int pl_1, pl_2;
{
    if ((pl_1 < 0) || (pl_1 >= NUM_PLANETS))
    {
      printf("planet_dist() : Illegal planet#1 number : %d\n", pl_1);
      return(IS_ERR);
    }
    return planet_xy_dist(planet[pl_1].x, planet[pl_1].y, pl_2);
}

double planet_xy_dist(x, y, pl)
float x, y;
int pl;
{
    double dist;
    double hypot();

    if ((pl < 0) || (pl >= NUM_PLANETS))
    {
      printf("planet_dist() : Illegal planet#2 number : %d\n", pl);
      return(IS_ERR);
    }
    dist = hypot((double) x - (double) planet[pl].x,
                 (double) y - (double) planet[pl].y);
    return(dist);
}

/* 
 *  Calculate the number of ships that the specified
 *  planet could make if the cost of the ship were
 *  as passed.
 *
 *    Formula:
 *	usable prod = Planet Ind * 0.75 + Pop * 0.25 - Spent + InProgress
 *    For simplicity we take off 'spent' and 'InProgress'.
 *
 *    So the number of ships would be :
 *	nships = usable prod / mass / 10
 *
 *    Modifier:
 *	matdemand = nships * mass
 *	If matdemant > planet Mat
 *	   nships *= Planet Mat / Matdemand
 */
float calc_num_ships(pl, mass)
int pl;
float mass;
{
    float mat, pop, res, industry, num;
    float usable, matdemand;

    num = 0.0;

    industry = planet[pl].industry; 
    res = planet[pl].res; 
    mat = planet[pl].mat;
    pop = planet[pl].pop;
    printf("Industry=%.1f, Pop=%.1f, Res=%.1f, Mat=%.1f\n",
	industry, pop, res, mat);
   
    usable = industry * 0.75 + pop * 0.25;
    printf("Usable production = %.3f\n", usable);

    num = usable / mass / 10.0;
    printf("  Raw %.3f ships.\n", num);

    matdemand = num * mass;
    if (matdemand > mat)
    {
      usable -= (matdemand - mat) / res;
      num = usable / mass / 10.0;
      printf("  Adjusted to %.3f\n", num);
    }
    else {
      printf("Planet has usable stockpile.\n");
    }
    return(num);
}

#ifdef OLD_WAY
/* 
 *  Calculate the number of ships that the specified
 *  planet could make if the cost of the ship were
 *  as passed.
 *
 *    Formula:
 *	usable prod = cap - (((pop * .1/8) * (5 + (0.5/R)))
 *    If we have a stockpile then the formula is:
 *	usable prod = cap - (((pop * .1/8) * 5))
 *
 *    So the number of ships would be :
 *	usable_prod / mass_of_ship
 *
 *  The above did
 */
float calc_num_ships(pl, mass)
int pl;
float mass;
{
    float mat, pop, res, industry, num;
    float usable;

    num = 0.0;

    industry = planet[pl].industry; 
    res = planet[pl].res; 
    mat = planet[pl].mat;
    pop = planet[pl].pop;
    printf("Industry=%.1f, Pop=%.1f, Res=%.1f, Mat=%.1f\n",
	industry, pop, res, mat);

    if (mat > 0)
    {
      if (mat > mass)
      {
	printf("Planet has more than %.2f amount of stored materials.\n", 
		mass);
	 /* usable prod = cap - (((pop * .1/8) * 5)) */
	usable = industry - ((pop *.1/8.0) * 5);
      }
      else /* ?? */
      {
	printf("Planet has %.1f amount of stored materials, which is\n",
	  mat);
	printf(" more than zero but less than %.2f: ignored(?)\n", mass);
	usable = industry - ((pop *.1/8.0) * (5 + (0.5/res)));
      }
    }
    else
    {
      printf("Planet has no stockpile\n");
        /* usable prod = cap - (((pop * .1/8.0) * (5 + (0.5/R))) */
      usable = industry - ((pop *.1/8.0) * (5 + (0.5/res)));
    }
    num = usable/(mass*10);

    printf("Usable production = %.3f\n", usable);
    printf("  Would produce %.3f ships.\n", num);

    return(num);
}
#endif

float get_planet_x(id)
int id;
{
  return planet[id].x;
}
float get_planet_y(id)
int id;
{
  return planet[id].y;
}
int get_who(id)
int id;
{
  return planet[id].who;
}
char *get_planet_text_name(id)
int id;
{
  return planet[id].name;
}
float get_planet_res(id)
int id;
{
  return planet[id].res;
}
float get_planet_size(id)
int id;
{
  return planet[id].size;
}
