#include <stdio.h>
#include <ctype.h>
#include "global.h"
#define DEF
#include "planet.h"


struct pp_list {
  float d1;
  float d2;
  int pl;
};


/*
 * Function: 
 *
 *   Calculate a path from start_planet to
 *   end_planet going through one intermediate
 *   planet where the distance of a single jump
 *   is not more than jump_max.
 *
 *   The result is printed out.
 */
planet_path_1(start_planet, end_planet, jump_max)
int start_planet;
int end_planet;
float jump_max;
{
    struct pp_list list[NUM_PLANETS];
    int num_found;
    int i;
    double d1, d2;
    char name1[80], name2[80];

    num_found = 0;

    strcpy(name1, get_planet_name(start_planet, 0));
    strcpy(name2, get_planet_name(end_planet, 0));

    if ((d1 = planet_dist(start_planet, end_planet)) <= jump_max)
    {
      printf("Error: Planet %s and %s are %5.2f light years apart\n",
	name1, name2, (float) d1);
      return(1);
    }

    for (i = 0; i < NUM_PLANETS; i++)
    {
      d1 = planet_dist(start_planet, i);
      d2 = planet_dist(end_planet, i);

      if ((d1 <= jump_max) && (d2 <= jump_max))
      {
	list[num_found].d1 = d1;
	list[num_found].d2 = d2;
	list[num_found].pl = i;
	num_found++;
      }
    }

    printf("Start planet %s, End Planet %s\n", name1, name2);

    if (num_found == 0)
    {
      printf("  No possible path.\n");
    }
    else
    {
      for (i = 0; i < num_found; i++)
      {
	strcpy(name1, get_planet_name(list[i].pl, 0));

	printf("  Start --> %5.2f ly --> Planet %s --> %5.2f ly --> End\n",
		list[i].d1, name1, list[i].d2);
      }
    }
    return(0);
}
