
#include <ctype.h>
#include "global.h"

#define D(A) A
#define MORE_MAX 22

int line_num;
int cur_type;
int do_more=1;
int read_one;
int more_flag;
char *malloc();
char *extract_race_name();
char *extract_race_name_from_title();
static int raw_flag;
int g_race_id;
int g_your_race_id;
int galaxy_version;
int g_show_eff;

/* skip lines that do not begin with a simple number */
line_type(line)
char *line;
{
    char *s;

    strRmTab(line);

    if (strLocate(line, TECH_LEVEL) >= 0)
    {
      return(cur_type);
    }
    /* 
     * if a blank line and we read one, then
     * turn off current type 
     */
    if (line_is_empty(line) && read_one)
    {
      cur_type = TYPE_INVALID;
      read_one = 0;
      return TYPE_INVALID;
    }
    if (strLocate(line, REPORT_TITLE) >= 0)
    {
      char *name;

      if ((g_your_race_id = find_race_id(
		name = extract_race_name_from_title(line))) == RACE_ERR)
	if ((g_your_race_id = new_race_name(name)) == RACE_ERR)
	  g_your_race_id = 0;

      cur_type = TYPE_INVALID;
      read_one = 0;
      return TYPE_INVALID;
    }
    if (strLocate(line, YOUR_ROUTES) >= 0)
    {
      cur_type = TYPE_ROUTES;
      read_one = 0;
      return TYPE_INVALID;
    }
    if (strLocate(line, YOUR_PLANETS) >= 0)
    {
      cur_type = TYPE_YOUR_PLANETS;
      read_one = 0;
      return TYPE_INVALID;
    }
    if (strLocate(line, ALIEN_PLANETS) >= 0)
    {
      cur_type = TYPE_UNIDENTIFIED;
      read_one = 0;
      return TYPE_INVALID;
    }
    if (strLocate(line, NEUTRAL_PLANETS) >= 0)
    {
      cur_type = TYPE_UNINHABITED;
      read_one = 0;
      return TYPE_INVALID;
    }
    if (strLocate(line, PLANETS) >= 0)
    {
      cur_type = TYPE_PLANETS;
      read_one = 0;
      return TYPE_INVALID;
    }
    if (strLocate(line, SHIP_TYPES) >= 0)
    {
      if (strLocate(line, YOUR) >= 0)
	g_race_id = g_your_race_id;
      else if ((g_race_id = find_race_id(line)) == RACE_ERR)
	g_race_id = new_race_name(extract_race_name(line));

      cur_type = TYPE_SHIPS;
      read_one = 0;
      return TYPE_INVALID;
    }
    if (strLocate(line, GROUPS) >= 0)
    {
      if (strLocate(line, YOUR) >= 0)
      {
	g_race_id = g_your_race_id;

	if (strLocate(line, ABBR_GROUPS) >= 0)
	{
	  cur_type = TYPE_YOUR_ABBR_GROUPS;
	  read_one = 0;
	  return TYPE_INVALID;
	}
	else
	{
	  cur_type = TYPE_YOUR_GROUPS;
	  read_one = 0;
	  return TYPE_INVALID;
	}
      }
      else
      {
        if ((g_race_id = find_race_id(line)) == RACE_ERR)
	  g_race_id = new_race_name(extract_race_name(line));

	if (strLocate(line, ABBR_GROUPS) >= 0)
	{
	  cur_type = TYPE_ALIEN_ABBR_GROUPS;
	  read_one = 0;
	  return TYPE_INVALID;
	}
	else
	{
	  cur_type = TYPE_ALIEN_GROUPS;
	  read_one = 0;
	  return TYPE_INVALID;
	}
      }
    }
    if (cur_type != TYPE_ROUTES)
      if (!start_number(line))
      {
	if (!start_legal_name(line))
	  return(TYPE_INVALID);
      }
    read_one = 1;
    return(cur_type);
}

start_number(line)
char *line;
{
    char *s;
    int one = 0;

    for (s = line; *s != '\0'; s++)
    {
      if ((*s == ' ') || (*s == ':'))
	break;
      if (!isdigit(*s))
	return(0);
      one = 1;
    }
    return(one);
}

#define LOOK_NAME 0
#define LOOK_SPACE 1
#define LOOK_NUM 2
#define LOOK_STOP 3

/* must find a name followed by at least one number */
start_legal_name(line)
char *line;
{
    char *s;
    int one = 0;
    int what = LOOK_NAME;

    for (s = line; (*s != '\0') && (what != LOOK_STOP); s++)
    {
      switch(what)
      {
	case LOOK_SPACE :
	  if (!isspace(*s))
	  {
	    what = LOOK_NUM;
	    s--;
	  }
	  break;
	case LOOK_NUM :
	  if (isspace(*s) || (*s == '.'))
	    what = LOOK_STOP;
	  else
	  {
	    if (!isdigit(*s))
	    {
	      return(0);
	    }
	    one = 1;
	  }
	  break;
	case LOOK_NAME :
	  if (isspace(*s))
	  {
	    if (one)
	    {
	      one = 0;
	      what = LOOK_SPACE;
	      s--;
	    }
	    else
	    {
	      return(0);
	    }
	  }
	  else if (isalnum(*s) || (*s == '_') || (*s == '-') ||
		   (*s == '.') || (*s == '\''))
	  {
	    one = 1;
	  }
	  else
	  {
	    return(0);
	  }
	  break;
      }
    }
    return(one);
}

/*
 * Break up the line into a lot of individual strings.
 * Elements are separated by spaces.
 * Wierdity: the word 'Research' will belong to the previous word.
 * Also: will break up the form '[#,#,#,#]' into 4 individual string,
 */
break_up(cp_line)
char *cp_line;
{
    char *s, *last;
    char *l;

    for (s = cp_line; *s != '\0'; s++)
      if ((*s == '[') || (*s == ',') || (*s == ']'))
	*s = ' ';

    s = cp_line;

    while (*s != '\0')
    {
      last = s;

      /* skip to the end of the current word */
      while (!isspace(*s))
      {
	if (*s == '\0')
	  goto EXIT;

	s++;
      }
      /* 
       * Handle Drive Research, Cargo Research, etc.
       * by deleting word 'Research'.  That is, if Research
       * is the word, all we do this pass is delete it.
       */
      if (!strncmp(last, "Research", 8))
      {
	for (l = last; !isspace(*l); l++)
	  *l = ' ';
      }
      /* terminate word converting into string */
      else
	*s = '\0';

      s++;

      while (isspace(*s))
      {
	if (*s == '\0')
	  goto EXIT;

	s++;
      }
    }
EXIT :
    *(s+1) = '\0';
}

char *element_str(cp_line, top)
char *cp_line;
int top;
{
    char *s;
    int e;

    s = cp_line;

    for (e = 0; e < top; e++)
    {
      while (*s != '\0')
	s++;

      s++;

      while (isspace(*s))
	s++;

      if (*s == '\0')
	return(0);	/* end of line */
    }
    return(s);
}

element_int(cp_line, e)
char *cp_line;
int e;
{
    char *s;

    if ((s = element_str(cp_line, e)) == 0)
      return(0);

    return atoi(s);
}


float element_float(cp_line, e)
char *cp_line;
int e;
{
    float d;
    double atof();
    char *s;

    if ((s = element_str(cp_line, e)) == 0)
      return(0);

    d = atof(s);

    return (float) d;
}

raw_on()
{
  /* slow, but fast to implement and reliable */
#ifndef NO_SYSTEM_STTY
  system("stty raw");
#endif
  raw_flag = 1;
}

raw_off()
{
  if (raw_flag)	/* ^C -- this doesn't work, oh well */
  {
#ifndef NO_SYSTEM_STTY
    system("stty -raw");
#endif
    raw_flag = 0;
  }
}

#define MORE_PROMPT "[--more--][<q><return><space>]"

chk_more(add)
int add;
{
  char line[80];
  char ch;
  int i;
  line_num += add;

  if (!more_flag)
    return;

  if (do_more)
  {
    if (line_num+1 > MORE_MAX)
    {
      line_num = 0;
      raw_on();
      printf(MORE_PROMPT);

      while (1)
      {
	ch = getchar();

	if (ch == 13)
	{
	  line_num = MORE_MAX-1;
	  break;
	}
	else if ((ch == ' ') || (ch == 'q'))
	{
	  line_num = 0;
	  break;
	}
	else
	{
	  putchar('');
	}
      }
      raw_off();

      for (i = 0; i < strlen(MORE_PROMPT)+2; i++)
	putchar('');
      if (ch == 'q')
      {
	printf("\n");
	go_home();
      }
    }  
  }
}

line_is_empty(s)
char *s;
{
  for (;*s != '\0';s++)
    if (!isspace(*s))
      return(0);
  return(1);
}

/* Understands: "Draconians Report for Galaxy Turn 0" */
/* Understands: "Galaxy Game 5 Turn 46 Report for Dhelynitas" */
char *extract_race_name_from_title(cp)
char *cp;
{
    static char line[80];
    char *s;

    strcpy(line, cp);

    /* get first word */
    strStripSpaces(line);
    break_up(line);
    s = element_str(line, 0);

    if (!strcmp(s, "Galaxy"))
    {
      s = element_str(line, 7);

      if (s == 0)
      {
	printf("Error: could not find your race name in title line\n");
	printf("  Line: %s\n", cp);
	return(YOUR);
      } 
    }
    strcpy(line, s);
    return(line);
}

char *extract_race_name(s)
char *s;
{
    static char line[80];
    int p, i;

    strcpy(line, s);

    if ((p=strLocate(line, GROUPS)) >= 0)
      line[p] = '\0';
    else if ((p=strLocate(line, SHIP_TYPES)) >= 0)
      line[p] = '\0';

    strRmWord(line, ABBR_GROUPS);
    strStripSpaces(line);
    strRmReturn(line);

    return(line);
}
